<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%! 
static final int NUM_USERS_ADD_AT_ONCE=10;
%>

<%


String[] usernames=new String[NUM_USERS_ADD_AT_ONCE];
String[] fullnames=new String[NUM_USERS_ADD_AT_ONCE];
String[] emailAddresses=new String[NUM_USERS_ADD_AT_ONCE];
String[] passwords=new String[NUM_USERS_ADD_AT_ONCE];
boolean[] actives=new boolean[NUM_USERS_ADD_AT_ONCE];
boolean[] superUsers=new boolean[NUM_USERS_ADD_AT_ONCE];


for (int i=0; i<NUM_USERS_ADD_AT_ONCE; i++)
{
	usernames[i]="";
	fullnames[i]="";
	emailAddresses[i]="";
	passwords[i]="";
	actives[i]=true;
	superUsers[i]=false;
}

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>

<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>

<script language="JavaScript">

var existingNumActiveUsers=<%=Manager.countActiveUsers()%>
var maxAllowedActiveUsers=<%=controller.getCurrentInstallationConfig().getMaxNumUsers()%>

var NUM_USERS_ADD_AT_ONCE=<%=NUM_USERS_ADD_AT_ONCE%>
var doNotifications=<%=(controller.getCurrentInstallationConfig().isDoNotifications()?"true":"false")%>
<% pageContext.include("includes/writeAllUsernamesArray.jsp?jsVarName=allUsernames"); %>

<% pageContext.include("includes/writeAllFullnamesArray.jsp?jsVarName=allFullnames"); %>

function isValidForm(formObj)
{
	if (noUsersEntered(formObj,NUM_USERS_ADD_AT_ONCE))
	{
		return false
	}
	var els=formObj.elements
	// we have at least one user; make sure that all users entered have all fields entered:
	var activeUsersAdded=0;
	for (var i=0; i<NUM_USERS_ADD_AT_ONCE; i++)
	{
		if (trim(els["username"+i].value).length>0)
		{ 
			var username=trim(els["username"+i].value)
			if (trim(els["fullname"+i].value).length==0)
			{
				errorAlert("You have not entered a full name for username '"+username+"'; please fix and try again.",els["fullname"+i])
				return false
			}
			if (trim(els["emailAddress"+i].value).length==0)
			{
				errorAlert("You have not entered an e-mail address for username '"+username+"'. Please fix and try again. (If you don't currently know this user's e-mail address, please enter your own and change it later.)",els["emailAddress"+i])
				return false
			}
			if (trim(els["password"+i].value).length==0)
			{
				errorAlert("You have not entered a password for username '"+username+"'; please fix and try again.",els["password"+i])
				return false
			}
			if (radioGroupValue(formObj,"active"+i)=="true")
			{
				activeUsersAdded++
			}
		}
	}
	if (maxAllowedActiveUsers>-1 && maxAllowedActiveUsers<(existingNumActiveUsers+activeUsersAdded))
	{
	
		var upgradeLink="<%=controller.getUpgradeLink()%>"
		alertConfirm("You are trying to add "+(activeUsersAdded>1?""+activeUsersAdded+" active users":"an active user")+" (an active user is a user whose \"Yes\" button is checked in the \"Is active\" column), but you already have "+(existingNumActiveUsers>1?""+existingNumActiveUsers+" active users":"an active user")+" in your WorkRoll database, and your WorkRoll license only allows you to have "+maxAllowedActiveUsers+" active users at one time (an unlimited number of inactive users is allowed). Please <a style=\"color:#870000; text-decoration:underline;\" href=\"#\" onclick=\"top.window.open('"+upgradeLink+"');top.close()\">upgrade</a> your WorkRoll license or deactivate some existing users.", true, true, 300)
		return false
	}
	// user tried to add a username that was already in the db:
	if (duplicateUsernameFound(formObj,NUM_USERS_ADD_AT_ONCE))
	{
		return false
	}
	// user tried to add two users with the same username:
	if (duplicateUsernamesInForm(formObj,NUM_USERS_ADD_AT_ONCE))
	{
		return false
	}	
	// user tried to add a full name that was already in the db:
	if (duplicateFullnameFound(formObj,NUM_USERS_ADD_AT_ONCE))
	{
		return false
	}
	// user tried to add two users with the same full name:
	if (duplicateFullnamesInForm(formObj,NUM_USERS_ADD_AT_ONCE))
	{
		return false
	}	
	if (badUsernameFound(formObj,NUM_USERS_ADD_AT_ONCE))
	{
		return false
	}
	if (badPasswordFound(formObj,NUM_USERS_ADD_AT_ONCE))
	{
		return false
	}
	if (badEmailFound(formObj,NUM_USERS_ADD_AT_ONCE))
	{
		return false
	}
	hidePageAndShowPleaseWait()
	return true
}

<% pageContext.include("js/js.jsp"); %>
</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>

<form action=processAddUsers.jsp method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>
<input type=hidden name=numUsers id=numUsers value="<%=usernames.length%>">
<font class=bodyFont> 
<span class=standardTextBlockWidth>
<span class=firstSentenceFont>Add users here<%=HelpManager.helpLink("user",request)%>.</span>You may add up to <%=NUM_USERS_ADD_AT_ONCE%> users at a time. If you need to add fewer than that, leave the unneeded user rows blank. When you're read to add the users, make sure you've made note of the passwords you've assigned, then click the "add" button. If you've changed your mind and don't want to add any users right now, click the "cancel" button below.</span><%=HtmlUtils.doubleLB(request)%><BR>

<table border=0 cellspacing=0 cellpadding=0>
<%@ include file="usersTableHeaderRow.jsp" %>


<% 

for (int i=0; i<NUM_USERS_ADD_AT_ONCE; i++)
{
	%>
	<tr class=<%=((((double)i/2)==(double)((int)(i/2)))?"evenDataRow":"oddDataRow")%> height=24>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=text size=10 name=username<%=i%> id=username<%=i%> value="<%=usernames[i]%>"><BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=text size=25 name=fullname<%=i%> id=fullname<%=i%> value="<%=fullnames[i]%>"><BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=text size=35 name=emailAddress<%=i%> id=emailAddress<%=i%> value="<%=emailAddresses[i]%>"><BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=password size=10 name=password<%=i%> id=password<%=i%> value="<%=passwords[i]%>">&nbsp;<BR></font></td>
	<td align=center><font class=columnDataFont><%=HtmlUtils.getYesNoRadios(actives[i],"active"+i)%><BR></font></td>
	<td align=center><font class=columnDataFont><%=HtmlUtils.getYesNoRadios(superUsers[i],"superUser"+i)%><BR></font></td>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	</tr>
	<%=HtmlUtils.getHorizRuleTr(8, request)%>
	<%
}

%>

</table><BR>

<input  class=formButton type=submit value=add> <input  class=formButton type=button value=cancel onclick="location.href='menu.jsp'"><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>





<% PageUtils.jspEnd(request); %>

