VERSION 5.00
Object = "{FBFD55C6-C23C-11D3-B65D-004005E66149}#1.0#0"; "SWIFTPRINT.OCX"
Begin VB.Form frmSamplePP 
   Caption         =   "SamplePP"
   ClientHeight    =   5115
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4590
   LinkTopic       =   "Form1"
   ScaleHeight     =   5115
   ScaleWidth      =   4590
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton btnNewDoc 
      Caption         =   "New Document"
      Height          =   375
      Left            =   120
      TabIndex        =   7
      Top             =   960
      Width           =   1695
   End
   Begin VB.CommandButton btnDraw 
      Caption         =   "Draw Page Items"
      Enabled         =   0   'False
      Height          =   375
      Left            =   120
      TabIndex        =   6
      Top             =   1440
      Width           =   1695
   End
   Begin VB.CommandButton btnNewPage 
      Caption         =   "New Page"
      Enabled         =   0   'False
      Height          =   375
      Left            =   120
      TabIndex        =   5
      Top             =   1920
      Width           =   1695
   End
   Begin VB.CommandButton btnPreview 
      Caption         =   "Preview Document"
      Enabled         =   0   'False
      Height          =   375
      Left            =   120
      TabIndex        =   4
      Top             =   2880
      Width           =   1695
   End
   Begin VB.CommandButton btnClose 
      Cancel          =   -1  'True
      Caption         =   "Close"
      Height          =   375
      Left            =   120
      TabIndex        =   3
      Top             =   4560
      Width           =   1695
   End
   Begin VB.CommandButton btnSetup 
      Caption         =   "Printer Setup"
      Height          =   375
      Left            =   120
      TabIndex        =   2
      Top             =   3960
      Width           =   1695
   End
   Begin VB.CommandButton btnEndDoc 
      Caption         =   "End Document"
      Enabled         =   0   'False
      Height          =   375
      Left            =   120
      TabIndex        =   1
      Top             =   2400
      Width           =   1695
   End
   Begin VB.CommandButton btnPrint 
      Caption         =   "Print Document"
      Enabled         =   0   'False
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   3360
      Width           =   1695
   End
   Begin SwiftPrintLib.SwiftPrint spDoc 
      Left            =   2880
      Top             =   4680
      _Version        =   65536
      _ExtentX        =   2778
      _ExtentY        =   450
      _StockProps     =   0
   End
   Begin VB.Label Label8 
      Caption         =   $"frmSamplePP.frx":0000
      Height          =   615
      Left            =   120
      TabIndex        =   15
      Top             =   120
      Width           =   4335
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Step 1: create a new document"
      Height          =   195
      Left            =   2040
      TabIndex        =   14
      Top             =   1050
      Width           =   2235
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Step 2a: draw items on a page"
      Height          =   195
      Left            =   2040
      TabIndex        =   13
      Top             =   1530
      Width           =   2160
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Step 2b: start a new page"
      Height          =   195
      Left            =   2040
      TabIndex        =   12
      Top             =   2010
      Width           =   1830
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Step 4: preview && print"
      Height          =   195
      Left            =   2040
      TabIndex        =   11
      Top             =   2970
      Width           =   1590
   End
   Begin VB.Label Label5 
      Caption         =   "At any time, printer setup dialog may be shown"
      Height          =   435
      Left            =   2040
      TabIndex        =   10
      Top             =   3930
      Width           =   2175
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "Step 3: end the document"
      Height          =   195
      Left            =   2040
      TabIndex        =   9
      Top             =   2490
      Width           =   1845
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "Step 4 (alternate): print document with no preview"
      Height          =   390
      Left            =   2040
      TabIndex        =   8
      Top             =   3360
      Width           =   2310
      WordWrap        =   -1  'True
   End
End
Attribute VB_Name = "frmSamplePP"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'This example is of most use to developers moving to SwiftPrint after having
'already used PreviewPrint, the first version of SwiftPrint.  This is the
'sample application created to demo PreviewPrint which has been converted to
'work with SwiftPrint instead.
'
'The following list is all of the changes that I needed to make in order to
'port code written for PreviewPrint across to SwiftPrint.  The changes required
'are large.  I purposefully decided to abandon backward compatibility with
'PreviewPrint in order to try and make the interface more consistent.
'I am sorry for the headache that it causes for you who are wishing to convert
'across to using SwiftPrint.
'
'Changes I made to this code:
'
'* removed the timer (not required now)
'* removed "Dim spDoc As PreviewPrint.Document" from the form code
'* removed instantiation of PreviewPrint object (eg. Set spDoc = New PreviewPrint.Document)
'* removed code setting the ppDoc variable to nothing
'* added SwiftPrint control to the main form and called it spDoc
'* renamed all references to ppDoc to spDoc
'* changed all calls to BeginDoc to use the new method DocBegin
'* added a line to specifically set the units to lometric (the units that PreviewPrint
'  always used.  (eg. spDoc.Units = SPUN_LOMETRIC)
'* changed all calls to Set/GetTextColor to use the ForeColor property
'* changed all constants to use the new constant names
'* added SPFS_POINTS or SPFS_UNITS to calls to SetFont and changed all sizes
'  to positive (negative sizes were taken to mean SPFS_UNITS in PreviewPrint)
'* changed all calls to Set/GetTextAlign to use the TextAlign property
'* changed all calls to SetLineStyle to call SetPen instead
'* removed all calls to EndDoc (not required now)
'* changed all calls to SetTitle to use the WindowTitle property
'* changed all references to StartPage to use the renamed 'FirstPage' property
'* removed all references to the method 'NewPage' and replaced it with an
'  increment to the Page property (eg. spDoc.Page = spDoc.Page + 1)
'* removed all code to hide/unhide and otherwise deal with setting and recovering
'  from showing the preview, print or print setup windows
'* added the standard event handler for the ChangeStage event thrown by SwiftPrint
'* removed all calls to the KillDoc method as it is not necessary
'* changed all references to the property hwndOwner to use the new name of WindowOwner
'* changed all references to the property Orientation to use the new name of PageOrientation
'* moved any code setting the page orientation until after the document has been
'  created using the DocBegin method
'* changed all variables used with SwiftPrint methods to be of type Long rather than Integer


'Dim ppDoc As PreviewPrint.Document
Dim nPage As Integer

Private Sub btnClose_Click()
    Form_Unload False
    End
End Sub

Private Sub btnDraw_Click()
    'Dim nCentre As Integer
    Dim nCentre As Long
    
    'get the page center
    nCentre = spDoc.PageWidth / 2
    
    'draw the page title in black arial 24pt bold underline,
    'centred and starting 25mm down from the page top
    'spDoc.SetTextColor vbBlack
    spDoc.ForeColor = vbBlack
    'spDoc.SetFont "Arial", 240, PPF_BOLD + PPF_UNDERLINE, 0
    spDoc.SetFont "Arial", 240, SPFS_POINTS + SPFO_BOLD + SPFO_UNDERLINE, 0
    'spDoc.SetTextAlign PPA_NOUPDATECP + PPA_CENTER + PPA_TOP
    spDoc.TextAlign = SPTA_NOUPDATECP + SPTA_CENTER + SPTA_TOP
    spDoc.TextOut nCentre, 250, "PreviewPrint: demo page " & nPage
    
    'Dim nY As Integer, nSize As Integer
    'Dim nWidth As Integer, nHeight As Integer
    Dim nY As Long, nSize As Long
    Dim nWidth As Long, nHeight As Long
    nY = 520
    nSize = 50
    
    'draw text in different colours inside this boxed area
    'Dim nColor As Integer
    Dim nColor As Long
    For nColor = 0 To 27
        'spDoc.SetTextColor RGB((nColor / 9) * 128, ((nColor / 3) Mod 3) * 128, (nColor Mod 3) * 128)
        spDoc.ForeColor = RGB((nColor / 9) * 128, ((nColor / 3) Mod 3) * 128, (nColor Mod 3) * 128)
        'spDoc.SetFont "Arial", nSize, 0, 0
        spDoc.SetFont "Arial", nSize, SPFS_POINTS, 0
        'spDoc.TextOut nCentre, nY, "Arial, " & (nSize / 10) & " pt, color " & spDoc.GetTextColor
        spDoc.TextOut nCentre, nY, "Arial, " & (nSize / 10) & " pt, color " & spDoc.ForeColor
        spDoc.GetTextExtent "abc", nWidth, nHeight
        nY = nY + nHeight + 20
        nSize = nSize + 2
    Next
    
    'draw a box surrounding the area that we will show different
    'text colours, do the lines in different colors and styles
    spDoc.MoveTo 500, 500
    'spDoc.SetLineStyle PPL_DASHDOTDOT, 0, vbYellow
    spDoc.SetPen SPPN_DASHDOT, 0, vbYellow
    spDoc.LineTo spDoc.PageWidth - 500, 500
    'spDoc.SetLineStyle PPL_DASH, 0, vbRed
    spDoc.SetPen SPPN_DASH, 0, vbRed
    spDoc.LineTo spDoc.PageWidth - 500, nY
    'spDoc.SetLineStyle PPL_DOT, 0, vbBlue
    spDoc.SetPen SPPN_DOT, 0, vbBlue
    spDoc.LineTo 500, nY
    'spDoc.SetLineStyle PPL_DASHDOT, 0, vbGreen
    spDoc.SetPen SPPN_DASHDOT, 0, vbGreen
    spDoc.LineTo 500, 500
    
    'demonstrate a clipped text output, draw the clipping rectangle
    'spDoc.SetLineStyle PPL_SOLID, 10, vbBlack
    spDoc.SetPen SPPN_SOLID, 10, vbBlack
    spDoc.MoveTo 250, nY + 100
    spDoc.LineTo nCentre - 125, nY + 100
    spDoc.LineTo nCentre - 125, nY + 400
    spDoc.LineTo 250, nY + 400
    spDoc.LineTo 250, nY + 100
    
    'output clipped text
    'spDoc.SetTextColor vbBlue
    spDoc.ForeColor = vbBlue
    'spDoc.SetFont "Arial", 1200, PPF_BOLD, 0
    spDoc.SetFont "Arial", 1200, SPFS_POINTS + SPFO_BOLD, 0
    'spDoc.SetTextAlign PPA_NOUPDATECP + PPA_LEFT + PPA_BASELINE
    spDoc.TextAlign = SPTA_NOUPDATECP + SPTA_LEFT + SPTA_BASELINE
    spDoc.TextOutClip 250, nY + 400, "Clipped", _
        250, nY + 100, nCentre - 125, nY + 400

    'demonstrate a clipped text output, draw the clipping rectangle
    spDoc.MoveTo nCentre + 125, nY + 100
    spDoc.LineTo spDoc.PageWidth - 250, nY + 100
    spDoc.LineTo spDoc.PageWidth - 250, nY + 400
    spDoc.LineTo nCentre + 125, nY + 400
    spDoc.LineTo nCentre + 125, nY + 100
    
    'output clipped text
    'spDoc.SetTextColor RGB(0, 128, 0)
    spDoc.ForeColor = RGB(0, 128, 0)
    'spDoc.SetFont "Arial", 120, PPF_BOLD, 0
    spDoc.SetFont "Arial", 120, SPFS_POINTS + SPFO_BOLD, 0
    'spDoc.SetTextAlign PPA_NOUPDATECP + PPA_CENTER + PPA_TOP
    spDoc.TextAlign = SPTA_NOUPDATECP + SPTA_CENTER + SPTA_TOP
    spDoc.TextOutClip (3 * nCentre) / 2, nY + 150, _
        "Clipped Text Example With Long Text To Be Clipped Off Each End", _
        nCentre + 125, nY + 100, spDoc.PageWidth - 250, nY + 400
End Sub

Private Sub btnEndDoc_Click()
    'end the document
    'spDoc.EndDoc
    
    'buttons
    btnNewDoc.Enabled = True
    btnNewPage.Enabled = False
    btnDraw.Enabled = False
    btnEndDoc.Enabled = False
    btnPreview.Enabled = True
    btnPrint.Enabled = True
End Sub

Private Sub btnNewDoc_Click()
    'begin a new document
    'spDoc.BeginDoc
    spDoc.DocBegin
    'spDoc.SetTitle "Sample PreviewPrint Document", "PreviewPrintSample"
    spDoc.WindowTitle = "Sample PreviewPrint Document - PreviewPrintSample"
    'spDoc.StartPage = 1
    spDoc.FirstPage = 1
    'spDoc.Orientation = PPO_PORTRAIT
    spDoc.PageOrientation = SPOR_PORTRAIT
    
    spDoc.Units = SPUN_LOMETRIC
    
    'buttons
    btnNewDoc.Enabled = False
    btnNewPage.Enabled = True
    btnDraw.Enabled = True
    btnEndDoc.Enabled = True
    btnPreview.Enabled = False
    btnPrint.Enabled = False
    
    nPage = 1
End Sub

Private Sub btnNewPage_Click()
    'start a new page now
    'spDoc.NewPage
    spDoc.Page = spDoc.Page + 1
    nPage = nPage + 1
End Sub

Private Sub btnPreview_Click()
    'hide ourselves while the preview window is shown
    'Me.Hide
    
    'show the preview window and start the timer which will
    'check to see when we should show ourselves again
    'spDoc.ShowPreview
    spDoc.DoPrintPreview
End Sub

Private Sub btnPrint_Click()
    'show the print window
    'spDoc.ShowPrint
    spDoc.DoPrint
End Sub

Private Sub btnSetup_Click()
    'show the printer setup
    'spDoc.ShowPrintSetup
    spDoc.DoPrintSetup
End Sub

Private Sub Form_Load()
    On Error GoTo errLoad
    
    'ensure that we show ourselves before we load the
    'previewprint object, show the hourglass while we do so
    Me.Show
    Screen.MousePointer = vbHourglass
    DoEvents
    
    'create the ole automation server object, we will use this
    'object to draw all of our pages and never touch the VB
    'printer object again
    'Set spDoc = New PreviewPrint.Document
    Screen.MousePointer = vbDefault
    
    'set the initial values
    'spDoc.hwndOwner = Me.hWnd
    spDoc.WindowOwner = Me.hWnd
    Exit Sub
    
errLoad:
    Screen.MousePointer = vbDefault
    MsgBox _
        "Unable to create the PreviewPrint object. " _
        & "Ensure it has been registered by running the program once. " _
        & Err.Description
    End
End Sub

Private Sub Form_Unload(Cancel As Integer)
    'destroy the ole automation server object
    'spDoc.KillDoc   'not strictly necessary
    'Set spDoc = Nothing
End Sub

Private Sub spDoc_StateChange(ByVal NewState As Long)
    Select Case NewState
    Case SP_IDLE
        Me.Enabled = True
        Me.Visible = True
        Me.ZOrder
        Me.SetFocus
    Case SP_PRINTPREVIEW
        Me.Enabled = False
        Me.Visible = False
    Case SP_PRINTSETUP, SP_PRINT, SP_PRINTING
        Me.Enabled = False
        Me.Visible = True
    End Select
End Sub

'Private Sub Timer_Timer()
'    Dim nState As Integer
'
'    'while we are still in the preview state, do nothing
'    nState = spDoc.PreviewPrintState
'    If nState <> PPS_PREVIEW Then
'
'        'we've stopped previewing, so now we are either printing
'        'or we have cancelled the print/preview and are returned
'        'to our main app.  Cancel the timer and make ourselves
'        'visible
'        Timer.Enabled = False
'        Me.Visible = True
'
'        'if we are about to print, then we need to set our zorder
'        'so that we are behind the print dialog, otherwise if we
'        'are idle again then we want to move to the front of the zorder
'        'and get the focus again
'        If nState = PPS_PRINT Then
'            Me.ZOrder 1
'        Else
'            Me.ZOrder
'            Me.SetFocus
'        End If
'    End If
'End Sub



