// InterfaceConstants.h: interface for the CInterfaceConstants class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_INTERFACECONSTANTS_H__AFF12C45_CBC1_11D1_8FE9_E4CD05C10000__INCLUDED_)
#define AFX_INTERFACECONSTANTS_H__AFF12C45_CBC1_11D1_8FE9_E4CD05C10000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


#include "winerror.h"

enum _InterfaceErrorConstants_ {
	
	//Interface Errors 

	ERR_OFFSET = 0x0200, 
	FATAL_ERROR = 0x9000,
	ERR_CONNECTION_NOT_OPENED = FATAL_ERROR+1,
	ERR_LOCAL_CALL_ERR = FATAL_ERROR+2,
	ERR_REMOTE_CALL_ERR = FATAL_ERROR+3,
	ERR_TYPE_MISMACTH = FATAL_ERROR+4,
	ERR_BUILDING_ARRAY = FATAL_ERROR+5,
		
	//Modbus class Comm Errors 

	ERR_OK =    0,   // OK
	ERR_TIMEOUT=1,   // TIMEOUT
	ERR_INV_RESP=2,   // Invalid Response 
	ERR_CRC=    3,   // CRC Error
	ERR_WR_PORT= 8,   // Write Comm Error
	ERR_RD_PORT= 9,   // Read Comm Error
	ERR_NOT_INT=10,  // Open Comm error
	ERR_LOCK_TIME_OUT=11,  // Open Comm error
	ERR_EXCPTION_CODE=0x8000,   //8001->Exp. code 1 8002->excep. code 2 

	ERR_BUFFER_OVERFLOW=1000,
    ERR_SOCKET_ERROR=1001,
	ERR_WR_SOCK_ERROR=1002,
	ERR_RD_SOCK_ERROR=1003,
	ERR_SOCK_NOT_CONNECTED=1004,
	
	//Interface Erros when raise error is enanabled  

	_ERR_TIMEOUT_ = MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,(ERR_OFFSET+ERR_TIMEOUT)), 
	_ERR_INV_RESP_ = MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,(ERR_OFFSET+ERR_INV_RESP)) ,	
	_ERR_CRC_ = MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,(ERR_OFFSET+ERR_CRC)) ,		
	_ERR_WR_PORT_ = MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,(ERR_OFFSET+ERR_WR_PORT)),		
	_ERR_RD_PORT_ = MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,(ERR_OFFSET+ERR_RD_PORT)),
	_ERR_NOT_INT_ = MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,(ERR_OFFSET+ERR_NOT_INT)),
	_ERR_EXCPTION_CODE_ = MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,(ERR_OFFSET+ERR_EXCPTION_CODE)),
	
	_ERR_BUFFER_OVERFLOW_ = MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,(ERR_OFFSET+ERR_BUFFER_OVERFLOW)),
	_ERR_SOCKET_ERROR_ = MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,(ERR_OFFSET+ERR_SOCKET_ERROR)),
	_ERR_WR_SOCK_ERROR_ = MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,(ERR_OFFSET+ERR_WR_SOCK_ERROR)),
	_ERR_RD_SOCK_ERROR_ = MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,(ERR_OFFSET+ERR_RD_SOCK_ERROR)),
	_ERR_SOCK_NOT_CONNECTED_ = MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,(ERR_OFFSET+ERR_SOCK_NOT_CONNECTED))
};


#endif // !defined(AFX_INTERFACECONSTANTS_H__AFF12C45_CBC1_11D1_8FE9_E4CD05C10000__INCLUDED_)
