/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import stec.ss.ssException;
import stec.ss.ssToken;

class ssValue {
    private int type;
    private String sValue;
    private double dValue;
    private int iValue;
    private long lValue;
    private Object oValue;

    protected ssValue(Object oVal) {
        this.type = oVal == null ? 700 : 600;
        this.oValue = oVal;
    }

    protected ssValue(String sVal) {
        if (sVal == null) {
            this.type = 700;
            this.sValue = sVal;
        } else {
            this.type = 200;
            this.sValue = new String(sVal);
        }
    }

    protected ssValue(double dVal) {
        this.type = 500;
        this.dValue = dVal;
    }

    protected ssValue(int iVal) {
        this.type = 300;
        this.iValue = iVal;
    }

    protected ssValue(long lVal) {
        this.type = 400;
        this.lValue = lVal;
    }

    protected ssValue(ssValue oVal) throws Exception {
        this.type = oVal.getType();
        switch (this.type) {
            case 600: {
                this.oValue = oVal.getObjectValue();
                break;
            }
            case 200: {
                this.sValue = oVal.getStringValue();
                break;
            }
            case 500: {
                this.dValue = oVal.getDoubleValue();
                break;
            }
            case 300: {
                this.iValue = oVal.getIntegerValue();
                break;
            }
            case 400: {
                this.lValue = oVal.getLongValue();
                break;
            }
            case 700: {
                this.oValue = null;
                break;
            }
            default: {
                throw new ssException(8, "value type", oVal.getTypeString());
            }
        }
    }

    protected ssValue(boolean bVal) {
        this.type = 300;
        this.iValue = bVal ? 1 : 0;
    }

    protected ssValue(Object oVal, boolean isConst) {
        this.type = 600;
        this.oValue = oVal;
    }

    protected ssValue(String sVal, boolean isConst) {
        this.type = 200;
        this.sValue = new String(sVal);
    }

    protected ssValue(double dVal, boolean isConst) {
        this.type = 500;
        this.dValue = dVal;
    }

    protected ssValue(int iVal, boolean isConst) {
        this.type = 300;
        this.iValue = iVal;
    }

    protected ssValue(long lVal, boolean isConst) {
        this.type = 400;
        this.lValue = lVal;
    }

    protected ssValue(ssValue oVal, boolean isConst) throws Exception {
        this.type = oVal.getType();
        switch (this.type) {
            case 600: {
                this.oValue = oVal.getObjectValue();
                break;
            }
            case 200: {
                this.sValue = oVal.getStringValue();
                break;
            }
            case 500: {
                this.dValue = oVal.getDoubleValue();
                break;
            }
            case 300: {
                this.iValue = oVal.getIntegerValue();
                break;
            }
            case 400: {
                this.lValue = oVal.getLongValue();
                break;
            }
            case 700: {
                this.oValue = null;
                break;
            }
            default: {
                throw new ssException(8, "value type", oVal.getTypeString());
            }
        }
    }

    protected ssValue(boolean bVal, boolean isConst) {
        this.type = 200;
        this.iValue = bVal ? 1 : 0;
    }

    protected static final ssValue copy(ssValue oVal) throws Exception {
        switch (oVal.getType()) {
            case 600: {
                return new ssValue(oVal.getObjectValue());
            }
            case 200: {
                return new ssValue(oVal.getStringValue());
            }
            case 300: {
                return new ssValue(oVal.getIntegerValue());
            }
            case 400: {
                return new ssValue(oVal.getLongValue());
            }
            case 500: {
                return new ssValue(oVal.getDoubleValue());
            }
        }
        throw new ssException(8, "value type", oVal.getTypeString());
    }

    protected static final ssValue copy(ssValue oVal, boolean isConst) throws Exception {
        switch (oVal.getType()) {
            case 600: {
                return new ssValue(oVal.getObjectValue(), isConst);
            }
            case 200: {
                return new ssValue(oVal.getStringValue(), isConst);
            }
            case 300: {
                return new ssValue(oVal.getIntegerValue(), isConst);
            }
            case 400: {
                return new ssValue(oVal.getLongValue(), isConst);
            }
            case 500: {
                return new ssValue(oVal.getDoubleValue(), isConst);
            }
        }
        throw new ssException(8, "value type", oVal.getTypeString());
    }

    protected final Object getObjectValue() throws Exception {
        switch (this.type) {
            case 200: {
                return new String(this.sValue);
            }
            case 500: {
                return new Double(this.dValue);
            }
            case 300: {
                return new Integer(this.iValue);
            }
            case 400: {
                return new Long(this.lValue);
            }
            case 600: {
                return this.oValue;
            }
        }
        throw new ssException(8, "value type", this.getTypeString());
    }

    protected final String getStringValue() throws Exception {
        switch (this.type) {
            case 200: {
                return this.sValue;
            }
            case 500: {
                return String.valueOf(this.dValue);
            }
            case 300: {
                return String.valueOf(this.iValue);
            }
            case 400: {
                return String.valueOf(this.lValue);
            }
            case 600: {
                return String.valueOf(this.oValue);
            }
        }
        throw new ssException(8, "value type", this.getTypeString());
    }

    protected final int getIntegerValue() throws Exception {
        switch (this.type) {
            case 200: {
                return Integer.parseInt(this.sValue);
            }
            case 500: {
                return new Double(this.dValue).intValue();
            }
            case 300: {
                return this.iValue;
            }
            case 400: {
                return (int)this.lValue;
            }
        }
        throw new ssException(8, "value type", this.getTypeString());
    }

    protected final long getLongValue() throws Exception {
        switch (this.type) {
            case 200: {
                return Long.parseLong(this.sValue);
            }
            case 500: {
                return new Double(this.dValue).longValue();
            }
            case 300: {
                return this.iValue;
            }
            case 400: {
                return this.lValue;
            }
        }
        throw new ssException(8, "value type", this.getTypeString());
    }

    protected final double getDoubleValue() throws Exception {
        switch (this.type) {
            case 200: {
                return Double.valueOf(this.sValue);
            }
            case 500: {
                return this.dValue;
            }
            case 300: {
                return this.iValue;
            }
            case 400: {
                return this.lValue;
            }
        }
        throw new ssException(8, "value type", this.getTypeString());
    }

    protected static final ssValue evaluateBinary(byte op, ssValue v1, ssValue v2) throws Exception {
        if (v1.isNull() || v2.isNull()) {
            return ssValue.evaluateBinaryNull(op, v1, v2);
        }
        if (v1.isString() || v2.isString()) {
            return ssValue.evaluateBinaryString(op, v1.getStringValue(), v2.getStringValue());
        }
        switch (v1.getType()) {
            case 500: {
                return ssValue.evaluateBinaryDouble(op, v1.getDoubleValue(), v2.getDoubleValue());
            }
            case 300: {
                switch (v1.getType()) {
                    case 500: {
                        return ssValue.evaluateBinaryDouble(op, v1.getDoubleValue(), v2.getDoubleValue());
                    }
                    case 300: {
                        return ssValue.evaluateBinaryInteger(op, v1.getIntegerValue(), v2.getIntegerValue());
                    }
                    case 400: {
                        return ssValue.evaluateBinaryLong(op, v1.getLongValue(), v2.getLongValue());
                    }
                }
                throw new ssException(8, "value type", v2.getTypeString());
            }
            case 400: {
                switch (v1.getType()) {
                    case 500: {
                        return ssValue.evaluateBinaryDouble(op, v1.getDoubleValue(), v2.getDoubleValue());
                    }
                    case 300: {
                        return ssValue.evaluateBinaryLong(op, v1.getLongValue(), v2.getLongValue());
                    }
                    case 400: {
                        return ssValue.evaluateBinaryLong(op, v1.getLongValue(), v2.getLongValue());
                    }
                }
                throw new ssException(8, "value type", v2.getTypeString());
            }
        }
        throw new ssException(8, "value type", v1.getTypeString());
    }

    private static final ssValue evaluateBinaryString(byte op, String v1, String v2) throws Exception {
        switch (op) {
            case 61: {
                return new ssValue(v1.compareTo(v2) == 0);
            }
            case 53: {
                return new ssValue(v1.compareTo(v2) != 0);
            }
            case 60: {
                return new ssValue(v1.compareTo(v2) < 0);
            }
            case 54: {
                return new ssValue(v1.compareTo(v2) <= 0);
            }
            case 62: {
                return new ssValue(v1.compareTo(v2) > 0);
            }
            case 55: {
                return new ssValue(v1.compareTo(v2) >= 0);
            }
            case 56: {
                return new ssValue(v1.length() != 0 && v2.length() != 0);
            }
            case 57: {
                return new ssValue(v1.length() != 0 || v2.length() != 0);
            }
            case 43: {
                return new ssValue(v1.concat(v2));
            }
        }
        throw new ssException(24, "operation", ssToken.sToken(op), "String");
    }

    private static final ssValue evaluateBinaryDouble(byte op, double v1, double v2) throws Exception {
        switch (op) {
            case 61: {
                return new ssValue(v1 == v2);
            }
            case 53: {
                return new ssValue(v1 != v2);
            }
            case 60: {
                return new ssValue(v1 < v2);
            }
            case 54: {
                return new ssValue(v1 <= v2);
            }
            case 62: {
                return new ssValue(v1 > v2);
            }
            case 55: {
                return new ssValue(v1 >= v2);
            }
            case 56: {
                return new ssValue(v1 != 0.0 && v2 != 0.0);
            }
            case 57: {
                return new ssValue(v1 != 0.0 || v2 != 0.0);
            }
            case 43: {
                return new ssValue(v1 + v2);
            }
            case 45: {
                return new ssValue(v1 - v2);
            }
            case 42: {
                return new ssValue(v1 * v2);
            }
            case 47: {
                return new ssValue(v1 / v2);
            }
        }
        throw new ssException(24, "operation", ssToken.sToken(op), "Double");
    }

    private static final ssValue evaluateBinaryInteger(byte op, int v1, int v2) throws Exception {
        switch (op) {
            case 61: {
                return new ssValue(v1 == v2);
            }
            case 53: {
                return new ssValue(v1 != v2);
            }
            case 60: {
                return new ssValue(v1 < v2);
            }
            case 54: {
                return new ssValue(v1 <= v2);
            }
            case 62: {
                return new ssValue(v1 > v2);
            }
            case 55: {
                return new ssValue(v1 >= v2);
            }
            case 56: {
                return new ssValue(v1 != 0 && v2 != 0);
            }
            case 57: {
                return new ssValue(v1 != 0 || v2 != 0);
            }
            case 38: {
                return new ssValue(v1 & v2);
            }
            case 124: {
                return new ssValue(v1 | v2);
            }
            case 94: {
                return new ssValue(v1 ^ v2);
            }
            case 43: {
                return new ssValue(v1 + v2);
            }
            case 45: {
                return new ssValue(v1 - v2);
            }
            case 42: {
                return new ssValue(v1 * v2);
            }
            case 47: {
                return new ssValue(v1 / v2);
            }
        }
        throw new ssException(24, "operation", ssToken.sToken(op), "Integer");
    }

    private static final ssValue evaluateBinaryLong(byte op, long v1, long v2) throws Exception {
        switch (op) {
            case 61: {
                return new ssValue(v1 == v2);
            }
            case 53: {
                return new ssValue(v1 != v2);
            }
            case 60: {
                return new ssValue(v1 < v2);
            }
            case 54: {
                return new ssValue(v1 <= v2);
            }
            case 62: {
                return new ssValue(v1 > v2);
            }
            case 55: {
                return new ssValue(v1 >= v2);
            }
            case 56: {
                return new ssValue(v1 != (long)0 && v2 != (long)0);
            }
            case 57: {
                return new ssValue(v1 != (long)0 || v2 != (long)0);
            }
            case 38: {
                return new ssValue(v1 & v2);
            }
            case 124: {
                return new ssValue(v1 | v2);
            }
            case 94: {
                return new ssValue(v1 ^ v2);
            }
            case 43: {
                return new ssValue(v1 + v2);
            }
            case 45: {
                return new ssValue(v1 - v2);
            }
            case 42: {
                return new ssValue(v1 * v2);
            }
            case 47: {
                return new ssValue(v1 / v2);
            }
        }
        throw new ssException(24, "operation", ssToken.sToken(op), "Long");
    }

    private static final ssValue evaluateBinaryNull(byte op, ssValue v1, ssValue v2) throws Exception {
        switch (op) {
            case 61: {
                return new ssValue(v1.isNull() == v2.isNull());
            }
            case 53: {
                return new ssValue(v1.isNull() != v2.isNull());
            }
            case 56: {
                return new ssValue(v1.isNull() && v2.isNull());
            }
            case 57: {
                return new ssValue(v1.isNull() || v2.isNull());
            }
        }
        throw new ssException(25, "operation", v1.getTypeString(), ssToken.sToken(op), v1.getTypeString());
    }

    protected static final ssValue evaluateUnary(byte op, ssValue v1) throws Exception {
        switch (v1.getType()) {
            case 700: {
                return ssValue.evaluateUnaryNull(op, v1);
            }
            case 200: {
                return ssValue.evaluateUnaryString(op, v1.getStringValue());
            }
            case 500: {
                return ssValue.evaluateUnaryDouble(op, v1.getDoubleValue());
            }
            case 300: {
                return ssValue.evaluateUnaryInteger(op, v1.getIntegerValue());
            }
            case 400: {
                return ssValue.evaluateUnaryLong(op, v1.getLongValue());
            }
        }
        throw new ssException(26, "operation", ssToken.sToken(op), v1.getTypeString());
    }

    private static final ssValue evaluateUnaryString(byte op, String v1) throws Exception {
        switch (op) {
            case 61: {
                return new ssValue(v1);
            }
            case 33: {
                return new ssValue(v1.length() == 0);
            }
        }
        throw new ssException(26, "operation", ssToken.sToken(op), "String");
    }

    private static final ssValue evaluateUnaryDouble(byte op, double v1) throws Exception {
        switch (op) {
            case 61: {
                return new ssValue(v1);
            }
            case 33: {
                return new ssValue(v1 == 0.0);
            }
            case 45: {
                return new ssValue(-v1);
            }
            case 43: {
                return new ssValue(v1);
            }
        }
        throw new ssException(26, "operation", ssToken.sToken(op), "Double");
    }

    private static final ssValue evaluateUnaryInteger(byte op, int v1) throws Exception {
        switch (op) {
            case 61: {
                return new ssValue(v1);
            }
            case 33: {
                return new ssValue(v1 == 0);
            }
            case 45: {
                return new ssValue(-v1);
            }
            case 43: {
                return new ssValue(v1);
            }
        }
        throw new ssException(26, "operation", ssToken.sToken(op), "Integer");
    }

    private static final ssValue evaluateUnaryLong(byte op, long v1) throws Exception {
        switch (op) {
            case 61: {
                return new ssValue(v1);
            }
            case 33: {
                return new ssValue(v1 == (long)0);
            }
            case 45: {
                return new ssValue(-v1);
            }
            case 43: {
                return new ssValue(v1);
            }
        }
        throw new ssException(26, "operation", ssToken.sToken(op), "Long");
    }

    private static final ssValue evaluateUnaryNull(byte op, ssValue v) throws Exception {
        if (op == 61) {
            return new ssValue(v);
        }
        throw new ssException(26, "operation", ssToken.sToken(op), v.getTypeString());
    }

    protected final int getType() {
        return this.type;
    }

    protected final String getTypeString() {
        switch (this.type) {
            case 600: {
                return "object";
            }
            case 200: {
                return "string";
            }
            case 500: {
                return "double";
            }
            case 300: {
                return "integer";
            }
            case 400: {
                return "long";
            }
            case 700: {
                return "null";
            }
        }
        return Integer.toString(this.type);
    }

    protected final boolean isObject() {
        return this.type == 600;
    }

    protected final boolean isString() {
        return this.type == 200;
    }

    protected final boolean isNumeric() {
        switch (this.type) {
            case 300: 
            case 400: 
            case 500: {
                return true;
            }
            case 200: {
                try {
                    Double.valueOf(this.sValue).doubleValue();
                    boolean bl = true;
                    return bl;
                }
                catch (NumberFormatException e) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return false;
    }

    protected final boolean isDouble() {
        return this.type == 500;
    }

    protected final boolean isInteger() {
        return this.type == 300;
    }

    protected final boolean isLong() {
        return this.type == 400;
    }

    protected final boolean isNull() {
        return this.type == 700;
    }

    protected final boolean isTrue() throws Exception {
        switch (this.type) {
            case 200: {
                return this.sValue.length() != 0;
            }
            case 500: {
                return this.dValue != 0.0;
            }
            case 300: {
                return this.iValue != 0;
            }
            case 400: {
                return this.lValue != (long)0;
            }
        }
        throw new ssException(8, "value type", this.getTypeString());
    }

    protected final boolean isFalse() throws Exception {
        return !this.isTrue();
    }
}

