/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import stec.ss.ssByteArray;

final class ssBuffer
extends ssByteArray {
    private int length;
    private int index;
    private int mark;

    protected ssBuffer() {
        this(32);
    }

    protected ssBuffer(int _size) {
        super(_size);
        this.length = 0;
        this.index = 0;
        this.mark = 0;
    }

    protected ssBuffer(byte[] _bArray) {
        super(_bArray);
        this.index = this.length = _bArray.length;
        this.mark = 0;
    }

    protected ssBuffer(byte[] _bArray, int _index, int _length) {
        super(_bArray, _index, _length);
        this.index = this.length = _bArray.length - this.index;
        this.mark = 0;
    }

    protected ssBuffer(ssBuffer _buffer) {
        this(_buffer.getBuffer());
    }

    protected ssBuffer(ssBuffer _buffer, int _index, int _length) {
        this(_buffer.getBuffer(), _index, _length);
    }

    protected ssBuffer(String _str) {
        this(_str.getBytes());
    }

    protected ssBuffer(String _str, int _index, int _length) {
        this(_str.getBytes(), _index, _length);
    }

    protected final void clear() {
        this.length = 0;
        this.index = 0;
        this.mark = 0;
    }

    protected final int length() {
        return this.length;
    }

    protected final void setLength(int _length) {
        this.ensureCapacity(_length);
        if (this.length < _length) {
            while (this.length < _length) {
                super.setByteAt(this.length, (byte)0);
                ++this.length;
            }
        }
        this.length = _length;
    }

    protected final int capacity() {
        return super.length();
    }

    protected final void ensureCapacity(int _length) {
        if (_length > super.length()) {
            _length = Math.max(super.length() << 1, _length);
            byte[] tbuffer = new byte[_length];
            System.arraycopy(super.getByteArray(), 0, tbuffer, 0, this.length);
            super.setByteArray(tbuffer);
        }
    }

    protected final int mark() {
        this.mark = this.index;
        return this.mark;
    }

    protected final int reset() {
        this.index = this.mark;
        this.mark = 0;
        return this.index;
    }

    protected final int reset(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.length) {
            n = this.length;
        }
        this.index = n;
        this.mark = 0;
        return this.index;
    }

    protected final int skip(int n) {
        if (n <= 0) {
            return 0;
        }
        if (this.index + n > this.length) {
            n = this.length - this.index;
        }
        this.index += n;
        return n;
    }

    protected final int pushBack(int n) {
        if (n <= 0) {
            return 0;
        }
        if (n > this.index) {
            n = this.index;
        }
        this.index -= n;
        return n;
    }

    protected final int seek(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.length) {
            n = this.length;
        }
        this.index = n;
        return n;
    }

    protected final int available() {
        return this.length - this.index;
    }

    protected final int getIndex() {
        return this.index;
    }

    protected final int setIndex(int _index) {
        this.index = _index;
        return this.index;
    }

    protected final byte[] getBuffer() {
        return super.getByteArray();
    }

    protected final void setBuffer(byte[] _bArray) {
        super.setByteArray(_bArray);
        this.index = this.length = _bArray.length;
        this.mark = 0;
    }

    protected final byte[] toByteArray() {
        byte[] tbuffer = new byte[this.length];
        System.arraycopy(super.getByteArray(), 0, tbuffer, 0, this.length);
        return tbuffer;
    }

    public final String toString() {
        return new String(super.getByteArray(), 0, this.length);
    }

    protected final byte read() {
        return this.index < this.length ? super.getByteAt(this.index++) : (byte)-1;
    }

    protected final int read(byte[] bArray, int _index, int _length) {
        if (_length <= 0) {
            return 0;
        }
        if (this.index >= this.length) {
            return -1;
        }
        if (this.index + _length > this.length) {
            _length = this.length - this.index;
        }
        System.arraycopy(super.getByteArray(), this.index, bArray, _index, _length);
        this.index += _length;
        return _length;
    }

    protected final String getString(int _length) throws IOException {
        if (_length <= 0) {
            return "";
        }
        if (this.index + _length > this.length) {
            throw new EOFException();
        }
        if (this.index + _length > this.length) {
            _length = this.length - this.index;
        }
        String str = new String(super.getByteArray(), this.index, _length);
        this.index += _length;
        return str;
    }

    protected final int readInt() throws IOException {
        if (this.index + 4 > this.length) {
            throw new EOFException();
        }
        int i = super.getIntAt(this.index);
        this.index += 4;
        return i;
    }

    protected final long readLong() throws IOException {
        if (this.index + 8 > this.length) {
            throw new EOFException();
        }
        long l = super.getLongAt(this.index);
        this.index += 8;
        return l;
    }

    protected final double readDouble() throws IOException {
        if (this.index + 8 > this.length) {
            throw new EOFException();
        }
        double d = super.getDoubleAt(this.index);
        this.index += 8;
        return d;
    }

    protected final boolean readBoolean() throws IOException {
        if (this.index + 1 > this.length) {
            throw new EOFException();
        }
        boolean b = super.getBooleanAt(this.index);
        ++this.index;
        return b;
    }

    protected final byte readByte() throws IOException {
        if (this.index + 1 > this.length) {
            throw new EOFException();
        }
        byte b = super.getByteAt(this.index);
        ++this.index;
        return b;
    }

    protected final char readChar() throws IOException {
        if (this.index + 2 > this.length) {
            throw new EOFException();
        }
        char c = super.getCharAt(this.index);
        this.index += 2;
        return c;
    }

    protected final void write(byte b) {
        int tindex = this.index + 1;
        this.ensureCapacity(tindex);
        super.setByteAt(this.index, b);
        this.index = tindex;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void write(byte[] bArray, int _index, int _length) {
        int tindex = this.index + _length;
        this.ensureCapacity(tindex);
        super.setBytes(this.index, bArray, _index, _length);
        this.index = tindex;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeString(String str) {
        int tindex = this.index + str.length();
        this.ensureCapacity(tindex);
        super.setBytes(this.index, str.getBytes(), 0, str.length());
        this.index = tindex;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeInt(int i) {
        int tindex = this.index + 4;
        this.ensureCapacity(tindex);
        super.setIntAt(this.index, i);
        this.index = tindex;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeLong(long l) {
        int tindex = this.index + 8;
        this.ensureCapacity(tindex);
        super.setLongAt(this.index, l);
        this.index = tindex;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeDouble(double d) {
        int tindex = this.index + 8;
        this.ensureCapacity(tindex);
        super.setDoubleAt(this.index, d);
        this.index = tindex;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeBoolean(boolean b) {
        int tindex = this.index + 1;
        this.ensureCapacity(tindex);
        super.setBooleanAt(this.index, b);
        this.index = tindex;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeByte(byte b) {
        int tindex = this.index + 1;
        this.ensureCapacity(tindex);
        super.setByteAt(this.index, b);
        this.index = tindex;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeChar(char c) {
        int tindex = this.index + 2;
        this.ensureCapacity(tindex);
        super.setCharAt(this.index, c);
        this.index = tindex;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeTo(OutputStream out) throws IOException {
        out.write(super.getByteArray(), 0, this.length);
    }

    protected final byte peek() throws IOException {
        if (this.index + 1 > this.length) {
            throw new EOFException();
        }
        return super.getByteAt(this.index);
    }
}

