/*
 * Decompiled with CFR 0.152.
 */
package stec.lang;

public final class DString {
    public static final int count(String string, String delimiter) {
        int count = 0;
        int offset = 0;
        int str_length = string.length();
        if (str_length == 0) {
            return 0;
        }
        int delimiter_length = delimiter.length();
        while (offset < str_length) {
            if (string.startsWith(delimiter, offset)) {
                ++count;
                offset += delimiter_length;
                continue;
            }
            ++offset;
        }
        return count;
    }

    public static final int count(String string, char delimiter) {
        int count = 0;
        int offset = 0;
        int length = string.length();
        if (length == 0) {
            return 0;
        }
        while (offset < length) {
            if (string.charAt(offset) == delimiter) {
                ++count;
                ++offset;
                continue;
            }
            ++offset;
        }
        return count;
    }

    public static final int dcount(String string, String delimiter) {
        int count = DString.count(string, delimiter);
        if (count != 0 || string.length() != 0) {
            ++count;
        }
        return count;
    }

    public static final int dcount(String string, char delimiter) {
        int count = DString.count(string, delimiter);
        if (count != 0 || string.length() != 0) {
            ++count;
        }
        return count;
    }

    public static final String extract(String string, String delimiter, int offset) {
        int sOffset = 0;
        int delimiter_length = delimiter.length();
        for (int i = 0; i < offset && (sOffset = string.indexOf(delimiter, sOffset)) != -1; ++i) {
            sOffset += delimiter_length;
        }
        if (sOffset == -1) {
            return null;
        }
        int eOffset = string.indexOf(delimiter, sOffset);
        if (eOffset == -1) {
            return string.substring(sOffset, string.length());
        }
        return string.substring(sOffset, eOffset);
    }

    public static final String extract(String string, char delimiter, int offset) {
        int sOffset = 0;
        for (int i = 0; i < offset && (sOffset = string.indexOf(delimiter, sOffset)) != -1; ++i) {
            ++sOffset;
        }
        if (sOffset == -1) {
            return null;
        }
        int eOffset = string.indexOf(delimiter, sOffset);
        if (eOffset == -1) {
            return string.substring(sOffset, string.length());
        }
        return string.substring(sOffset, eOffset);
    }

    public static final String replace(String string, String old_string, String new_string) {
        int len = new_string.length();
        int oldLen = old_string.length();
        int offset = string.indexOf(old_string);
        StringBuffer sb = new StringBuffer();
        while (offset != -1) {
            sb.append(string.substring(0, offset));
            sb.append(new_string);
            sb.append(string.substring(offset + oldLen));
            string = sb.toString();
            sb.setLength(0);
            offset = string.indexOf(old_string, offset + len);
        }
        return string;
    }

    public static final String change(String string, String old_string, String new_string) {
        return DString.change(string, old_string, new_string, 0, 0);
    }

    public static final String change(String string, String old_string, String new_string, int sindex, int eindex) {
        if (eindex > sindex) {
            throw new IllegalArgumentException("Ending index exceeds starting index.");
        }
        int olength = old_string.length();
        int offset = 0;
        for (int i = 0; i < sindex; ++i) {
            if ((offset = string.indexOf(old_string, offset)) == -1) {
                return string;
            }
            offset += olength;
        }
        if ((offset = string.indexOf(old_string, offset)) == -1) {
            return string;
        }
        StringBuffer sb = new StringBuffer(string.substring(0, offset));
        offset += olength;
        int count = eindex - sindex + 1;
        for (int i = 0; i < count; ++i) {
            sb.append(new_string);
            int toffset = string.indexOf(old_string, offset);
            if (toffset == -1) break;
            offset = toffset + olength;
        }
        sb.append(string.substring(offset));
        return sb.toString();
    }

    public static final String pad(String string, String delimiter, int size, char justification) {
        StringBuffer paddedStr = new StringBuffer(string);
        justification = Character.toLowerCase(justification);
        while (paddedStr.length() < size) {
            if (justification == 'r') {
                paddedStr.insert(0, delimiter);
                continue;
            }
            paddedStr.append(delimiter);
        }
        if (justification == 'r') {
            return paddedStr.toString().substring(paddedStr.length() - size, paddedStr.length());
        }
        return paddedStr.toString().substring(0, size);
    }

    public static final String pad(String string, char delimiter, int size, char justification) {
        StringBuffer paddedStr = new StringBuffer(string);
        justification = Character.toLowerCase(justification);
        while (paddedStr.length() < size) {
            if (justification == 'r') {
                paddedStr.insert(0, delimiter);
                continue;
            }
            paddedStr.append(delimiter);
        }
        if (justification == 'r') {
            return paddedStr.toString().substring(paddedStr.length() - size, paddedStr.length());
        }
        return paddedStr.toString().substring(0, size);
    }

    public static final String trim(String string) {
        int eOffset;
        int sOffset;
        int length = string.length();
        if (length == 0) {
            return string;
        }
        for (sOffset = 0; sOffset < length && string.charAt(sOffset) == ' '; ++sOffset) {
        }
        for (eOffset = length - 1; eOffset >= sOffset && string.charAt(eOffset) == ' '; --eOffset) {
        }
        StringBuffer sb = new StringBuffer();
        boolean found = false;
        for (int i = sOffset; i <= eOffset; ++i) {
            char chr = string.charAt(i);
            if (chr == ' ') {
                if (found) continue;
                found = true;
                sb.append(chr);
                continue;
            }
            found = false;
            sb.append(chr);
        }
        return sb.toString();
    }

    public static final int find(String string, String delimiter, String substring) {
        return DString.find(string, delimiter, 0, substring);
    }

    public static final int find(String string, char delimiter, String substring) {
        return DString.find(string, delimiter, 0, substring);
    }

    public static final int find(String string, String delimiter, int offset, String substring) {
        int size = DString.dcount(string, delimiter);
        for (int i = offset; i < size; ++i) {
            if (!DString.extract(string, delimiter, i).equals(substring)) continue;
            return i;
        }
        return -1;
    }

    public static final int find(String string, char delimiter, int offset, String substring) {
        int count = DString.dcount(string, delimiter);
        for (int i = offset; i < count; ++i) {
            if (!DString.extract(string, delimiter, i).equals(substring)) continue;
            return i;
        }
        return -1;
    }

    public static final int findIgnoreCase(String string, String delimiter, String substring) {
        return DString.findIgnoreCase(string, delimiter, 0, substring);
    }

    public static final int findIgnoreCase(String string, char delimiter, String substring) {
        return DString.findIgnoreCase(string, delimiter, 0, substring);
    }

    public static final int findIgnoreCase(String string, String delimiter, int offset, String substring) {
        int size = DString.dcount(string, delimiter);
        for (int i = offset; i < size; ++i) {
            if (!DString.extract(string, delimiter, i).equalsIgnoreCase(substring)) continue;
            return i;
        }
        return -1;
    }

    public static final int findIgnoreCase(String string, char delimiter, int offset, String substring) {
        int count = DString.dcount(string, delimiter);
        for (int i = offset; i < count; ++i) {
            if (!DString.extract(string, delimiter, i).equalsIgnoreCase(substring)) continue;
            return i;
        }
        return -1;
    }

    public static final String trimT(String string) {
        int offset;
        int length = string.length();
        if (length == 0) {
            return string;
        }
        for (offset = length - 1; offset >= 0 && string.charAt(offset) == ' '; --offset) {
        }
        return string.substring(0, offset + 1);
    }

    public static final String trimL(String string) {
        int offset;
        int length = string.length();
        if (length == 0) {
            return string;
        }
        for (offset = 0; offset < length && string.charAt(offset) == ' '; ++offset) {
        }
        return string.substring(offset, length);
    }

    public static final String trimB(String string) {
        int eOffset;
        int sOffset;
        int length = string.length();
        if (length == 0) {
            return string;
        }
        for (sOffset = 0; sOffset < length && string.charAt(sOffset) == ' '; ++sOffset) {
        }
        for (eOffset = length - 1; eOffset >= sOffset && string.charAt(eOffset) == ' '; --eOffset) {
        }
        return string.substring(sOffset, eOffset + 1);
    }

    public static final String[] split(String string, char delimiter) {
        int soffset = 0;
        int count = DString.dcount(string, delimiter);
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            int eoffset = string.indexOf(delimiter, soffset);
            strings[i] = eoffset == -1 ? string.substring(soffset) : string.substring(soffset, eoffset);
            soffset = eoffset + 1;
        }
        return strings;
    }

    public static final String[] split(String string, String delimiter) {
        int soffset = 0;
        int delimiter_length = delimiter.length();
        int count = DString.dcount(string, delimiter);
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            int eoffset = string.indexOf(delimiter, soffset);
            strings[i] = eoffset == -1 ? string.substring(soffset) : string.substring(soffset, eoffset);
            soffset = eoffset + delimiter_length;
        }
        return strings;
    }

    public static final String join(String[] strings, char delimiter) {
        StringBuffer sb = new StringBuffer();
        int count = strings.length;
        for (int i = 0; i < count; ++i) {
            sb.append(strings[i]);
            sb.append(delimiter);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static final String join(String[] strings, String delimiter) {
        StringBuffer sb = new StringBuffer();
        int count = strings.length;
        for (int i = 0; i < count; ++i) {
            sb.append(strings[i]);
            sb.append(delimiter);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - delimiter.length());
        }
        return sb.toString();
    }

    public static final String extract(String string, String[] delimiters, int[] offsets) {
        int delimiter_count = delimiters.length;
        int offset_count = offsets.length;
        String result = string;
        for (int i = 0; i < delimiter_count && (result = DString.extract(result, delimiters[i], offsets[i])) != null; ++i) {
        }
        return result;
    }

    public static final String extract(String string, char[] delimiters, int[] offsets) {
        int delimiter_count = delimiters.length;
        int offset_count = offsets.length;
        String result = string;
        for (int i = 0; i < delimiter_count && (result = DString.extract(result, delimiters[i], offsets[i])) != null; ++i) {
        }
        return result;
    }
}

