// TransparentFlashPlayerControlWnd.cpp : implementation file
//

#include "stdafx.h"
#include "Sample4_Translucency.h"
#include "TransparentFlashPlayerControlWnd.h"
#include ".\transparentflashplayercontrolwnd.h"


// CTransparentFlashPlayerControlWnd

IMPLEMENT_DYNAMIC(CTransparentFlashPlayerControlWnd, CWnd)
CTransparentFlashPlayerControlWnd::CTransparentFlashPlayerControlWnd() : 
	m_bCaptured(FALSE)
{
}

CTransparentFlashPlayerControlWnd::~CTransparentFlashPlayerControlWnd()
{
}

BEGIN_MESSAGE_MAP(CTransparentFlashPlayerControlWnd, CWnd)
	ON_COMMAND(ID_CLOSE, OnClose)
	ON_COMMAND(ID_MINIMIZE, OnMinimize)
	ON_COMMAND(ID_FORUM, OnForum)
	ON_COMMAND(ID_ORDER, OnOrder)
	ON_COMMAND(ID_SITE, OnSite)
END_MESSAGE_MAP()

// CTransparentFlashPlayerControlWnd message handlers

void CTransparentFlashPlayerControlWnd::PostNcDestroy()
{
	CWnd::PostNcDestroy();

	delete this;
}

LRESULT CTransparentFlashPlayerControlWnd::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_LBUTTONDOWN:
		{
			POINT pt;
			GetCursorPos(&pt);

			m_ptStart.x = pt.x;
			m_ptStart.y = pt.y;

			RECT rc;
			::GetWindowRect(m_hWnd, &rc);

			m_ptLeftTop.x = rc.left;
			m_ptLeftTop.y = rc.top;

			m_bCaptured = TRUE;

			::SetCapture(m_hWnd);

			int nWidth = rc.right - rc.left;
			int nHeight = rc.bottom - rc.top;

			break;
		}

		case WM_LBUTTONUP:
		{
			m_bCaptured = FALSE;
			::ReleaseCapture();
			return 1;
		}

		case WM_MOUSEMOVE:
		{
			if (m_bCaptured)
			{
				POINT pt;
				GetCursorPos(&pt);

				POINT ptDelta = { pt.x - m_ptStart.x, pt.y - m_ptStart.y };

				RECT rc;
				::GetWindowRect(m_hWnd, &rc);

				int nWidth = rc.right - rc.left;
				int nHeight = rc.bottom - rc.top;

				rc.left = m_ptLeftTop.x + ptDelta.x;
				rc.top = m_ptLeftTop.y + ptDelta.y;
				rc.right = rc.left + nWidth;
				rc.bottom = rc.top + nHeight;

				::MoveWindow(m_hWnd, rc.left, rc.top, nWidth, nHeight, TRUE);

				return 1;
			}

			break;
		}

		case WM_RBUTTONUP:
		{
			HMENU hMenu = LoadMenu(0, MAKEINTRESOURCE(IDR_CONTEXT_MENU));
			HMENU hContextMenu = GetSubMenu(hMenu, 0);

			POINT pt;
			GetCursorPos(&pt);
			TrackPopupMenu(hContextMenu, TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, 0, m_hWnd, NULL);

			DestroyMenu(hMenu);

			break;
		}

		default:
		{
		}
	}

	return CWnd::WindowProc(message, wParam, lParam);
}

void CTransparentFlashPlayerControlWnd::OnClose()
{
	DestroyWindow();
}

void CTransparentFlashPlayerControlWnd::OnMinimize()
{
	CloseWindow();
}

void CTransparentFlashPlayerControlWnd::OnForum()
{
	ShellExecute(m_hWnd, NULL, _T("http://www.flashplayercontrol.com/forum/"), NULL, NULL, SW_SHOW);
}

void CTransparentFlashPlayerControlWnd::OnOrder()
{
	ShellExecute(m_hWnd, NULL, _T("http://www.flashplayercontrol.com/dll/order.html"), NULL, NULL, SW_SHOW);
}

void CTransparentFlashPlayerControlWnd::OnSite()
{
	ShellExecute(m_hWnd, NULL, _T("http://www.flashplayercontrol.com/dll/"), NULL, NULL, SW_SHOW);
}
