package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Shippers<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class ShippersBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected int ShipperID;
    protected int old_ShipperID; // Old value of the key is kept too
    protected String CompanyName;
    protected String Phone;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected ShippersBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public ShippersBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Get from primary key(s), queries the database
     */
    public ShippersBase(CS cs, int ShipperID) throws SQLException {
        this.cs = cs;

        CallableStatement cc = null;
        ResultSet rs = null;

        try {
            cc = cs.allocCS("SELECT_ShippersBase");

            cc.setInt(1, ShipperID);

            rs = cc.executeQuery();
            rs.next();
            setFromRs(rs);
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public ShippersBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        ShipperID = old_ShipperID = rs.getInt("ShipperID");
        CompanyName = rs.getString("CompanyName");
        Phone = rs.getString("Phone");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for ShipperID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getShipperID() {
        return ShipperID;
    }

    /**
     * Setter for ShipperID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    protected void setShipperID(int value) {
        this.ShipperID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ShippersBase's by querying table field ShipperID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfShipperID(
        int maxResults) throws SQLException {
        return getResultSetWithShipperIDValueOf(cs, getShipperID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ShippersBase's by querying table field ShipperID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithShipperIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ShippersBase_ShipperID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ShippersBase's by querying table field ShipperID
     * for equality with the same ShipperID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipperID(int maxResults)
        throws SQLException {
        return getLinkedListWithShipperIDValueOf(cs, getShipperID(), maxResults);
    }

    /**
     * Gets a LinkedList of ShippersBase's by querying table field ShipperID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipperIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipperIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ShippersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ShippersBase's by querying table field ShipperID
     * for equality with the same ShipperID as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipperID(int maxResults)
        throws SQLException {
        return getIteratorWithShipperIDValueOf(cs, getShipperID(), maxResults);
    }

    /**
     * Gets an Iterator of ShippersBase's by querying table field ShipperID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipperIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithShipperIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for CompanyName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCompanyName() {
        return CompanyName;
    }

    /**
     * Setter for CompanyName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCompanyName(String value) {
        this.CompanyName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ShippersBase's by querying table field CompanyName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCompanyName(
        int maxResults) throws SQLException {
        return getResultSetWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ShippersBase's by querying table field CompanyName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ShippersBase_CompanyName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ShippersBase's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ShippersBase's by querying table field CompanyName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCompanyNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ShippersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ShippersBase's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public Iterator getIteratorWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getIteratorWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets an Iterator of ShippersBase's by querying table field CompanyName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Phone.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getPhone() {
        return Phone;
    }

    /**
     * Setter for Phone.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setPhone(String value) {
        this.Phone = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ShippersBase's by querying table field Phone
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfPhone(int maxResults)
        throws SQLException {
        return getResultSetWithPhoneValueOf(cs, getPhone(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of ShippersBase's by querying table field Phone
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithPhoneValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_ShippersBase_Phone");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of ShippersBase's by querying table field Phone
     * for equality with the same Phone as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfPhone(int maxResults)
        throws SQLException {
        return getLinkedListWithPhoneValueOf(cs, getPhone(), maxResults);
    }

    /**
     * Gets a LinkedList of ShippersBase's by querying table field Phone
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithPhoneValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithPhoneValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ShippersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ShippersBase's by querying table field Phone
     * for equality with the same Phone as this instance.
     */
    public Iterator getIteratorWithSameValueOfPhone(int maxResults)
        throws SQLException {
        return getIteratorWithPhoneValueOf(cs, getPhone(), maxResults);
    }

    /**
     * Gets an Iterator of ShippersBase's by querying table field Phone
     * for equality with the "value".
     */
    public static Iterator getIteratorWithPhoneValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithPhoneValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return ShippersBase.delete(cs, ShipperID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int ShipperID) throws SQLException {
        CallableStatement cc = null;
        int res = 0;

        try {
            cc = cs.allocCS("DELETE_ShippersBase");

            cc.setInt(1, ShipperID);

            res = cc.executeUpdate();
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
        return res;
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATE_ShippersBase");

                cc.setString(1, getCompanyName());

                cc.setString(2, getPhone());

                cc.setInt(3, getShipperID());

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            return res;
        }

        return -1;
    }

    private void updateOldKeys() {
        // update the old_x old key values
        old_ShipperID = ShipperID;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        ResultSet rs = null;

        try {
            cc = cs.allocCS("INSERT_ShippersBase");

            cc.setString(1, getCompanyName());

            cc.setString(2, getPhone());

            rs = cc.executeQuery();
            rs.next();

            setShipperID(rs.getInt(1));

            updateOldKeys();

            isDirty = false;
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "ShipperID:" + getShipperID());

        System.out.println(prefix + "CompanyName:" + getCompanyName());

        System.out.println(prefix + "Phone:" + getPhone());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(ShipperID);
        sb.append(",");
        sb.append(CompanyName);
        sb.append(",");
        sb.append(Phone);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
