package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Products Above Average Price<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class Products_Above_Average_PriceBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected String ProductName;
    protected Double UnitPrice;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected Products_Above_Average_PriceBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public Products_Above_Average_PriceBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public Products_Above_Average_PriceBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        ProductName = rs.getString("ProductName");
        UnitPrice = new Double(rs.getDouble("UnitPrice"));

        if (rs.wasNull()) {
            UnitPrice = null;
        }

        ;
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for ProductName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getProductName() {
        return ProductName;
    }

    /**
     * Setter for ProductName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setProductName(String value) {
        this.ProductName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_Above_Average_PriceBase's by querying table field ProductName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfProductName(
        int maxResults) throws SQLException {
        return getResultSetWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_Above_Average_PriceBase's by querying table field ProductName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Products_Above_Average_PriceBase_ProductName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Products_Above_Average_PriceBase's by querying table field ProductName
     * for equality with the same ProductName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfProductName(int maxResults)
        throws SQLException {
        return getLinkedListWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Products_Above_Average_PriceBase's by querying table field ProductName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithProductNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Products_Above_Average_PriceBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Products_Above_Average_PriceBase's by querying table field ProductName
     * for equality with the same ProductName as this instance.
     */
    public Iterator getIteratorWithSameValueOfProductName(int maxResults)
        throws SQLException {
        return getIteratorWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets an Iterator of Products_Above_Average_PriceBase's by querying table field ProductName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithProductNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for UnitPrice.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Double getUnitPrice() {
        return UnitPrice;
    }

    /**
     * Setter for UnitPrice.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setUnitPrice(Double value) {
        this.UnitPrice = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_Above_Average_PriceBase's by querying table field UnitPrice
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfUnitPrice(
        int maxResults) throws SQLException {
        return getResultSetWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_Above_Average_PriceBase's by querying table field UnitPrice
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithUnitPriceValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Products_Above_Average_PriceBase_UnitPrice");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.NUMERIC);
            } else {
                cc.setDouble(1, value.doubleValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Products_Above_Average_PriceBase's by querying table field UnitPrice
     * for equality with the same UnitPrice as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfUnitPrice(int maxResults)
        throws SQLException {
        return getLinkedListWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets a LinkedList of Products_Above_Average_PriceBase's by querying table field UnitPrice
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithUnitPriceValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithUnitPriceValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Products_Above_Average_PriceBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Products_Above_Average_PriceBase's by querying table field UnitPrice
     * for equality with the same UnitPrice as this instance.
     */
    public Iterator getIteratorWithSameValueOfUnitPrice(int maxResults)
        throws SQLException {
        return getIteratorWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets an Iterator of Products_Above_Average_PriceBase's by querying table field UnitPrice
     * for equality with the "value".
     */
    public static Iterator getIteratorWithUnitPriceValueOf(CS cs, Double value,
        int maxResults) throws SQLException {
        return getLinkedListWithUnitPriceValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        try {
            cc = cs.allocCS("INSERT_Products_Above_Average_PriceBase");

            cc.setString(1, getProductName());

            if (UnitPrice == null) {
                cc.setNull(2, java.sql.Types.NUMERIC);
            } else {
                cc.setDouble(2, getUnitPrice().doubleValue());
            }

            cc.executeUpdate();

            isDirty = false;
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "ProductName:" + getProductName());

        System.out.println(prefix + "UnitPrice:" + getUnitPrice());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(ProductName);
        sb.append(",");
        sb.append(UnitPrice);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
