package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Employees<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class EmployeesBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected int EmployeeID;
    protected int old_EmployeeID; // Old value of the key is kept too
    protected String LastName;
    protected String FirstName;
    protected String Title;
    protected String TitleOfCourtesy;
    protected java.sql.Date BirthDate;
    protected java.sql.Date HireDate;
    protected String Address;
    protected String City;
    protected String Region;
    protected String PostalCode;
    protected String Country;
    protected String HomePhone;
    protected String Extension;
    protected java.io.InputStream Photo;

    // length of this binary stream
    protected int PhotoLen;
    protected String Notes;
    protected Integer ReportsTo;
    protected String PhotoPath;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected EmployeesBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public EmployeesBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Get from primary key(s), queries the database
     */
    public EmployeesBase(CS cs, int EmployeeID) throws SQLException {
        this.cs = cs;

        CallableStatement cc = null;
        ResultSet rs = null;

        try {
            cc = cs.allocCS("SELECT_EmployeesBase");

            cc.setInt(1, EmployeeID);

            rs = cc.executeQuery();
            rs.next();
            setFromRs(rs);
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public EmployeesBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        EmployeeID = old_EmployeeID = rs.getInt("EmployeeID");
        LastName = rs.getString("LastName");
        FirstName = rs.getString("FirstName");
        Title = rs.getString("Title");
        TitleOfCourtesy = rs.getString("TitleOfCourtesy");
        BirthDate = rs.getDate("BirthDate");
        HireDate = rs.getDate("HireDate");
        Address = rs.getString("Address");
        City = rs.getString("City");
        Region = rs.getString("Region");
        PostalCode = rs.getString("PostalCode");
        Country = rs.getString("Country");
        HomePhone = rs.getString("HomePhone");
        Extension = rs.getString("Extension");
        Notes = rs.getString("Notes");
        ReportsTo = new Integer(rs.getInt("ReportsTo"));

        if (rs.wasNull()) {
            ReportsTo = null;
        }

        ;
        PhotoPath = rs.getString("PhotoPath");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for EmployeeID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getEmployeeID() {
        return EmployeeID;
    }

    /**
     * Setter for EmployeeID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    protected void setEmployeeID(int value) {
        this.EmployeeID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field EmployeeID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfEmployeeID(
        int maxResults) throws SQLException {
        return getResultSetWithEmployeeIDValueOf(cs, getEmployeeID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field EmployeeID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithEmployeeIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_EmployeeID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field EmployeeID
     * for equality with the same EmployeeID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfEmployeeID(int maxResults)
        throws SQLException {
        return getLinkedListWithEmployeeIDValueOf(cs, getEmployeeID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field EmployeeID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithEmployeeIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithEmployeeIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field EmployeeID
     * for equality with the same EmployeeID as this instance.
     */
    public Iterator getIteratorWithSameValueOfEmployeeID(int maxResults)
        throws SQLException {
        return getIteratorWithEmployeeIDValueOf(cs, getEmployeeID(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field EmployeeID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithEmployeeIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithEmployeeIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for LastName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getLastName() {
        return LastName;
    }

    /**
     * Setter for LastName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setLastName(String value) {
        this.LastName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field LastName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfLastName(int maxResults)
        throws SQLException {
        return getResultSetWithLastNameValueOf(cs, getLastName(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field LastName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithLastNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_LastName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field LastName
     * for equality with the same LastName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfLastName(int maxResults)
        throws SQLException {
        return getLinkedListWithLastNameValueOf(cs, getLastName(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field LastName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithLastNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithLastNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field LastName
     * for equality with the same LastName as this instance.
     */
    public Iterator getIteratorWithSameValueOfLastName(int maxResults)
        throws SQLException {
        return getIteratorWithLastNameValueOf(cs, getLastName(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field LastName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithLastNameValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithLastNameValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for FirstName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getFirstName() {
        return FirstName;
    }

    /**
     * Setter for FirstName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setFirstName(String value) {
        this.FirstName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field FirstName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfFirstName(
        int maxResults) throws SQLException {
        return getResultSetWithFirstNameValueOf(cs, getFirstName(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field FirstName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithFirstNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_FirstName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field FirstName
     * for equality with the same FirstName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfFirstName(int maxResults)
        throws SQLException {
        return getLinkedListWithFirstNameValueOf(cs, getFirstName(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field FirstName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithFirstNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithFirstNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field FirstName
     * for equality with the same FirstName as this instance.
     */
    public Iterator getIteratorWithSameValueOfFirstName(int maxResults)
        throws SQLException {
        return getIteratorWithFirstNameValueOf(cs, getFirstName(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field FirstName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithFirstNameValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithFirstNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Title.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getTitle() {
        return Title;
    }

    /**
     * Setter for Title.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setTitle(String value) {
        this.Title = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field Title
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfTitle(int maxResults)
        throws SQLException {
        return getResultSetWithTitleValueOf(cs, getTitle(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field Title
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithTitleValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_Title");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field Title
     * for equality with the same Title as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfTitle(int maxResults)
        throws SQLException {
        return getLinkedListWithTitleValueOf(cs, getTitle(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field Title
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithTitleValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithTitleValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field Title
     * for equality with the same Title as this instance.
     */
    public Iterator getIteratorWithSameValueOfTitle(int maxResults)
        throws SQLException {
        return getIteratorWithTitleValueOf(cs, getTitle(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field Title
     * for equality with the "value".
     */
    public static Iterator getIteratorWithTitleValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithTitleValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for TitleOfCourtesy.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getTitleOfCourtesy() {
        return TitleOfCourtesy;
    }

    /**
     * Setter for TitleOfCourtesy.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setTitleOfCourtesy(String value) {
        this.TitleOfCourtesy = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field TitleOfCourtesy
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfTitleOfCourtesy(
        int maxResults) throws SQLException {
        return getResultSetWithTitleOfCourtesyValueOf(cs, getTitleOfCourtesy(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field TitleOfCourtesy
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithTitleOfCourtesyValueOf(
        CS cs, String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_EmployeesBase_TitleOfCourtesy");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field TitleOfCourtesy
     * for equality with the same TitleOfCourtesy as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfTitleOfCourtesy(
        int maxResults) throws SQLException {
        return getLinkedListWithTitleOfCourtesyValueOf(cs,
            getTitleOfCourtesy(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field TitleOfCourtesy
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithTitleOfCourtesyValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithTitleOfCourtesyValueOf(cs,
                value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field TitleOfCourtesy
     * for equality with the same TitleOfCourtesy as this instance.
     */
    public Iterator getIteratorWithSameValueOfTitleOfCourtesy(int maxResults)
        throws SQLException {
        return getIteratorWithTitleOfCourtesyValueOf(cs, getTitleOfCourtesy(),
            maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field TitleOfCourtesy
     * for equality with the "value".
     */
    public static Iterator getIteratorWithTitleOfCourtesyValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithTitleOfCourtesyValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for BirthDate.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public java.sql.Date getBirthDate() {
        return BirthDate;
    }

    /**
     * Setter for BirthDate.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setBirthDate(java.sql.Date value) {
        this.BirthDate = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field BirthDate
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfBirthDate(
        int maxResults) throws SQLException {
        return getResultSetWithBirthDateValueOf(cs, getBirthDate(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field BirthDate
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithBirthDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_BirthDate");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.DATE);
            } else {
                cc.setDate(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field BirthDate
     * for equality with the same BirthDate as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfBirthDate(int maxResults)
        throws SQLException {
        return getLinkedListWithBirthDateValueOf(cs, getBirthDate(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field BirthDate
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithBirthDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithBirthDateValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field BirthDate
     * for equality with the same BirthDate as this instance.
     */
    public Iterator getIteratorWithSameValueOfBirthDate(int maxResults)
        throws SQLException {
        return getIteratorWithBirthDateValueOf(cs, getBirthDate(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field BirthDate
     * for equality with the "value".
     */
    public static Iterator getIteratorWithBirthDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        return getLinkedListWithBirthDateValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for HireDate.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public java.sql.Date getHireDate() {
        return HireDate;
    }

    /**
     * Setter for HireDate.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setHireDate(java.sql.Date value) {
        this.HireDate = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field HireDate
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfHireDate(int maxResults)
        throws SQLException {
        return getResultSetWithHireDateValueOf(cs, getHireDate(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field HireDate
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithHireDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_HireDate");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.DATE);
            } else {
                cc.setDate(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field HireDate
     * for equality with the same HireDate as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfHireDate(int maxResults)
        throws SQLException {
        return getLinkedListWithHireDateValueOf(cs, getHireDate(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field HireDate
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithHireDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithHireDateValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field HireDate
     * for equality with the same HireDate as this instance.
     */
    public Iterator getIteratorWithSameValueOfHireDate(int maxResults)
        throws SQLException {
        return getIteratorWithHireDateValueOf(cs, getHireDate(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field HireDate
     * for equality with the "value".
     */
    public static Iterator getIteratorWithHireDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        return getLinkedListWithHireDateValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for Address.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getAddress() {
        return Address;
    }

    /**
     * Setter for Address.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setAddress(String value) {
        this.Address = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field Address
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getResultSetWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field Address
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_Address");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field Address
     * for equality with the same Address as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getLinkedListWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field Address
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithAddressValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field Address
     * for equality with the same Address as this instance.
     */
    public Iterator getIteratorWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getIteratorWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field Address
     * for equality with the "value".
     */
    public static Iterator getIteratorWithAddressValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithAddressValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for City.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCity() {
        return City;
    }

    /**
     * Setter for City.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCity(String value) {
        this.City = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field City
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getResultSetWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field City
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCityValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_City");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field City
     * for equality with the same City as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getLinkedListWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field City
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCityValueOf(cs, value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field City
     * for equality with the same City as this instance.
     */
    public Iterator getIteratorWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getIteratorWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field City
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCityValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for Region.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getRegion() {
        return Region;
    }

    /**
     * Setter for Region.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setRegion(String value) {
        this.Region = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field Region
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getResultSetWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field Region
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_Region");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field Region
     * for equality with the same Region as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getLinkedListWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field Region
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRegionValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field Region
     * for equality with the same Region as this instance.
     */
    public Iterator getIteratorWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getIteratorWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field Region
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRegionValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithRegionValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for PostalCode.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getPostalCode() {
        return PostalCode;
    }

    /**
     * Setter for PostalCode.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setPostalCode(String value) {
        this.PostalCode = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field PostalCode
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfPostalCode(
        int maxResults) throws SQLException {
        return getResultSetWithPostalCodeValueOf(cs, getPostalCode(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field PostalCode
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_PostalCode");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field PostalCode
     * for equality with the same PostalCode as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfPostalCode(int maxResults)
        throws SQLException {
        return getLinkedListWithPostalCodeValueOf(cs, getPostalCode(),
            maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field PostalCode
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithPostalCodeValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field PostalCode
     * for equality with the same PostalCode as this instance.
     */
    public Iterator getIteratorWithSameValueOfPostalCode(int maxResults)
        throws SQLException {
        return getIteratorWithPostalCodeValueOf(cs, getPostalCode(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field PostalCode
     * for equality with the "value".
     */
    public static Iterator getIteratorWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithPostalCodeValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Country.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCountry() {
        return Country;
    }

    /**
     * Setter for Country.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCountry(String value) {
        this.Country = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field Country
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getResultSetWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field Country
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_Country");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field Country
     * for equality with the same Country as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getLinkedListWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field Country
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCountryValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field Country
     * for equality with the same Country as this instance.
     */
    public Iterator getIteratorWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getIteratorWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field Country
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCountryValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCountryValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for HomePhone.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getHomePhone() {
        return HomePhone;
    }

    /**
     * Setter for HomePhone.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setHomePhone(String value) {
        this.HomePhone = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field HomePhone
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfHomePhone(
        int maxResults) throws SQLException {
        return getResultSetWithHomePhoneValueOf(cs, getHomePhone(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field HomePhone
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithHomePhoneValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_HomePhone");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field HomePhone
     * for equality with the same HomePhone as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfHomePhone(int maxResults)
        throws SQLException {
        return getLinkedListWithHomePhoneValueOf(cs, getHomePhone(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field HomePhone
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithHomePhoneValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithHomePhoneValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field HomePhone
     * for equality with the same HomePhone as this instance.
     */
    public Iterator getIteratorWithSameValueOfHomePhone(int maxResults)
        throws SQLException {
        return getIteratorWithHomePhoneValueOf(cs, getHomePhone(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field HomePhone
     * for equality with the "value".
     */
    public static Iterator getIteratorWithHomePhoneValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithHomePhoneValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Extension.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getExtension() {
        return Extension;
    }

    /**
     * Setter for Extension.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setExtension(String value) {
        this.Extension = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field Extension
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfExtension(
        int maxResults) throws SQLException {
        return getResultSetWithExtensionValueOf(cs, getExtension(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field Extension
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithExtensionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_Extension");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field Extension
     * for equality with the same Extension as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfExtension(int maxResults)
        throws SQLException {
        return getLinkedListWithExtensionValueOf(cs, getExtension(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field Extension
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithExtensionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithExtensionValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field Extension
     * for equality with the same Extension as this instance.
     */
    public Iterator getIteratorWithSameValueOfExtension(int maxResults)
        throws SQLException {
        return getIteratorWithExtensionValueOf(cs, getExtension(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field Extension
     * for equality with the "value".
     */
    public static Iterator getIteratorWithExtensionValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithExtensionValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Photo.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    protected java.io.InputStream getPhoto() {
        return Photo;
    }

    /**
     * Setter for Photo.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setPhoto(java.io.InputStream stream, int length) {
        this.Photo = stream;
        this.PhotoLen = length;
        isDirty = true;
    }

    /**
     * Getter for Notes.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getNotes() {
        return Notes;
    }

    /**
     * Setter for Notes.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setNotes(String value) {
        this.Notes = value;
        isDirty = true;
    }

    /**
     * Getter for ReportsTo.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Integer getReportsTo() {
        return ReportsTo;
    }

    /**
     * Setter for ReportsTo.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setReportsTo(Integer value) {
        this.ReportsTo = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field ReportsTo
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfReportsTo(
        int maxResults) throws SQLException {
        return getResultSetWithReportsToValueOf(cs, getReportsTo(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field ReportsTo
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithReportsToValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_ReportsTo");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.INTEGER);
            } else {
                cc.setInt(1, value.intValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field ReportsTo
     * for equality with the same ReportsTo as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfReportsTo(int maxResults)
        throws SQLException {
        return getLinkedListWithReportsToValueOf(cs, getReportsTo(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field ReportsTo
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithReportsToValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithReportsToValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field ReportsTo
     * for equality with the same ReportsTo as this instance.
     */
    public Iterator getIteratorWithSameValueOfReportsTo(int maxResults)
        throws SQLException {
        return getIteratorWithReportsToValueOf(cs, getReportsTo(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field ReportsTo
     * for equality with the "value".
     */
    public static Iterator getIteratorWithReportsToValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        return getLinkedListWithReportsToValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for PhotoPath.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getPhotoPath() {
        return PhotoPath;
    }

    /**
     * Setter for PhotoPath.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setPhotoPath(String value) {
        this.PhotoPath = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field PhotoPath
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfPhotoPath(
        int maxResults) throws SQLException {
        return getResultSetWithPhotoPathValueOf(cs, getPhotoPath(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of EmployeesBase's by querying table field PhotoPath
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithPhotoPathValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_EmployeesBase_PhotoPath");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field PhotoPath
     * for equality with the same PhotoPath as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfPhotoPath(int maxResults)
        throws SQLException {
        return getLinkedListWithPhotoPathValueOf(cs, getPhotoPath(), maxResults);
    }

    /**
     * Gets a LinkedList of EmployeesBase's by querying table field PhotoPath
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithPhotoPathValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithPhotoPathValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field PhotoPath
     * for equality with the same PhotoPath as this instance.
     */
    public Iterator getIteratorWithSameValueOfPhotoPath(int maxResults)
        throws SQLException {
        return getIteratorWithPhotoPathValueOf(cs, getPhotoPath(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeesBase's by querying table field PhotoPath
     * for equality with the "value".
     */
    public static Iterator getIteratorWithPhotoPathValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithPhotoPathValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return EmployeesBase.delete(cs, EmployeeID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int EmployeeID) throws SQLException {
        CallableStatement cc = null;
        int res = 0;

        try {
            cc = cs.allocCS("DELETE_EmployeesBase");

            cc.setInt(1, EmployeeID);

            res = cc.executeUpdate();
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
        return res;
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATE_EmployeesBase");

                cc.setString(1, getLastName());

                cc.setString(2, getFirstName());

                cc.setString(3, getTitle());

                cc.setString(4, getTitleOfCourtesy());

                cc.setDate(5, getBirthDate());

                cc.setDate(6, getHireDate());

                cc.setString(7, getAddress());

                cc.setString(8, getCity());

                cc.setString(9, getRegion());

                cc.setString(10, getPostalCode());

                cc.setString(11, getCountry());

                cc.setString(12, getHomePhone());

                cc.setString(13, getExtension());

                cc.setBinaryStream(14, getPhoto(), 0);

                cc.setString(15, getNotes());

                if (ReportsTo == null) {
                    cc.setNull(16, java.sql.Types.INTEGER);
                } else {
                    cc.setInt(16, getReportsTo().intValue());
                }

                cc.setString(17, getPhotoPath());

                cc.setInt(18, getEmployeeID());

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            return res;
        }

        return -1;
    }

    private void updateOldKeys() {
        // update the old_x old key values
        old_EmployeeID = EmployeeID;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        ResultSet rs = null;

        try {
            cc = cs.allocCS("INSERT_EmployeesBase");

            cc.setString(1, getLastName());

            cc.setString(2, getFirstName());

            cc.setString(3, getTitle());

            cc.setString(4, getTitleOfCourtesy());

            cc.setDate(5, getBirthDate());

            cc.setDate(6, getHireDate());

            cc.setString(7, getAddress());

            cc.setString(8, getCity());

            cc.setString(9, getRegion());

            cc.setString(10, getPostalCode());

            cc.setString(11, getCountry());

            cc.setString(12, getHomePhone());

            cc.setString(13, getExtension());

            cc.setBinaryStream(14, getPhoto(), PhotoLen);

            cc.setString(15, getNotes());

            if (ReportsTo == null) {
                cc.setNull(16, java.sql.Types.INTEGER);
            } else {
                cc.setInt(16, getReportsTo().intValue());
            }

            cc.setString(17, getPhotoPath());

            rs = cc.executeQuery();
            rs.next();

            setEmployeeID(rs.getInt(1));

            updateOldKeys();

            isDirty = false;
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "EmployeeID:" + getEmployeeID());

        System.out.println(prefix + "LastName:" + getLastName());

        System.out.println(prefix + "FirstName:" + getFirstName());

        System.out.println(prefix + "Title:" + getTitle());

        System.out.println(prefix + "TitleOfCourtesy:" + getTitleOfCourtesy());

        System.out.println(prefix + "BirthDate:" + getBirthDate());

        System.out.println(prefix + "HireDate:" + getHireDate());

        System.out.println(prefix + "Address:" + getAddress());

        System.out.println(prefix + "City:" + getCity());

        System.out.println(prefix + "Region:" + getRegion());

        System.out.println(prefix + "PostalCode:" + getPostalCode());

        System.out.println(prefix + "Country:" + getCountry());

        System.out.println(prefix + "HomePhone:" + getHomePhone());

        System.out.println(prefix + "Extension:" + getExtension());

        System.out.println(prefix + "Notes:" + getNotes());

        System.out.println(prefix + "ReportsTo:" + getReportsTo());

        System.out.println(prefix + "PhotoPath:" + getPhotoPath());
    }

    public void dump() {
        dump("");
    }

    /**
     * Gets a ResultSet (CallableStatement.getResultSet()) of EmployeesBase's
     */
    public static CallableStatement getPostalCodeAndCountryResultSet(CS cs,
        String p1, String p2) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SQC_EmployeesBase_PostalCodeAndCountry");

        try {
            cc.setString(1, p1);

            cc.setString(2, p2);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        }

        // template/debug was set to >0 during conversion
        return cc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(EmployeeID);
        sb.append(",");
        sb.append(LastName);
        sb.append(",");
        sb.append(FirstName);
        sb.append(",");
        sb.append(Title);
        sb.append(",");
        sb.append(TitleOfCourtesy);
        sb.append(",");
        sb.append(BirthDate);
        sb.append(",");
        sb.append(HireDate);
        sb.append(",");
        sb.append(Address);
        sb.append(",");
        sb.append(City);
        sb.append(",");
        sb.append(Region);
        sb.append(",");
        sb.append(PostalCode);
        sb.append(",");
        sb.append(Country);
        sb.append(",");
        sb.append(HomePhone);
        sb.append(",");
        sb.append(Extension);
        sb.append(",");
        sb.append(Photo);
        sb.append(",");
        sb.append(Notes);
        sb.append(",");
        sb.append(ReportsTo);
        sb.append(",");
        sb.append(PhotoPath);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
