/*
 * Created on 12 Αυγ 2004
 *
 * By Konstantine Kougios
 */
package def;

import globals.Cache;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;

import org.aris.hldb.CS;
import org.aris.hldb.Sql;
import org.aris.hldb.pools.ConnectionPoolProvider;
import org.aris.hldb.servers.SqlServer;

import test.db.___aaaHolder;
import threads.NorthwindT;
//import threads.TestDBT;

/**
 * Stretch test for OODB and Universal Cache. 
 * @author Aris, 12 Αυγ 2004, 6:36:15 πμ, for OODBFrameworkTest project
 *  
 */
public class StretchTest
{
	public static int numOfThreads = 100;
	public static volatile boolean	exit	= false;

	/**
	 * Compiles the callable statements and otionally creates the stored
	 * procedures. This is a utility function, in order to make the example use
	 * of hldb easier.
	 * 
	 * @param dbName
	 *            The database name
	 * @param is
	 *            The .sql file containing the queries that hldb will compile
	 * @return the CS callable statement cache.
	 * @throws FileNotFoundException -
	 * @throws IOException -
	 * @throws Exception -
	 */
	public static CS compile(String dbName, InputStream is) throws FileNotFoundException, IOException, Exception
	{
		ConnectionPoolProvider cpp = new ConnectionPoolProvider("jdbc:microsoft:sqlserver://localhost:1433;DatabaseName=" + dbName + ";User=aris;Password=apistefto101", 5);
		CS cs = new CS(cpp);
		Sql sql = new Sql(cs, SqlServer.class);
		sql.Add(new InputStreamReader(is), ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY, 100);
		return cs;
	}

	/**
	 * Does the tests.
	 * 
	 * @param args
	 */
	public static void main(String[] args)
	{
		int totalNorthwindCount=0;
		int totalTestCount=0;
		try
		{
			// initialize database driver
			Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
//			CS csTest = compile("test", ___aaaHolder.class.getResourceAsStream("queryTest.sql"));
			//CS csAspNet = compile("aspnet", ___aaaHolder.class.getResourceAsStream("queryAspNet.sql"));
			CS csNorthwind = compile("Northwind", ___aaaHolder.class.getResourceAsStream("queryNorthwind.sql"));

			// tests:

//			// testDB check
//			new NavigateTestDB(csTest, 50);
//			// test northwind example
//			new NavigateNorthwind(csNorthwind, false);

			NorthwindT[] northwindt=new NorthwindT[numOfThreads];
//			TestDBT[] testdbt=new TestDBT[numOfThreads];
			System.gc();
			for (int i = 0; i < numOfThreads; i++)
			{
				northwindt[i]=new NorthwindT(csNorthwind,i);
				northwindt[i].start();
//				testdbt[i]=new TestDBT(csTest,i);
//				testdbt[i].start();
			}
			System.out.println("==== Main: threads started...");
			Thread.sleep(1500000);
			System.out.println("==== Main: trying to exit...");
			exit = true;
			boolean canexit=false;
			while (!canexit)
			{
				canexit=true;
				totalNorthwindCount=0;
				totalTestCount=0;
				for (int i=0;i<numOfThreads;i++)
				{
					canexit=canexit && northwindt[i].isDone();
//					canexit=canexit && testdbt[i].isDone();
					totalNorthwindCount+=northwindt[i].getCount();
//					totalTestCount+=testdbt[i].getCount();
				}
				Thread.sleep(100);
			}
			//Cache.getCache().dump(true);


		} catch (Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("Cache hits/misses    : "+Cache.getCache().getHits()+"/"+Cache.getCache().getMisses());
		System.out.println("Northwind iterations : "+totalNorthwindCount);
		System.out.println("TestDB iterations    : "+totalTestCount);
		System.out.println("===== tester done =======");
	}
}