/*
 * Decompiled with CFR 0.152.
 */
package org.aris.maps.lists;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.aris.maps.lists.LinkedListExEntry;

public class LinkedListEx
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    protected transient LinkedListExEntry header = new LinkedListExEntry(null, null, null);
    protected transient int size = 0;
    private static final long serialVersionUID = 876323262645176354L;

    public LinkedListEx() {
        this.header.next = this.header.previous = this.header;
    }

    public LinkedListEx(Collection c) {
        this();
        this.addAll(c);
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.element;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    public Object removeFirst() {
        Object first = this.header.next.element;
        this.remove(this.header.next);
        return first;
    }

    public Object removeLast() {
        Object last = this.header.previous.element;
        this.remove(this.header.previous);
        return last;
    }

    public LinkedListExEntry addFirst(Object o) {
        return this.addBefore(o, this.header.next);
    }

    public LinkedListExEntry addLast(Object o) {
        return this.addBefore(o, this.header);
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public int size() {
        return this.size;
    }

    public boolean add(Object o) {
        this.addBefore(o, this.header);
        return true;
    }

    public boolean remove(Object o) {
        if (o == null) {
            LinkedListExEntry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    this.remove(e);
                    return true;
                }
                e = e.next;
            }
        } else {
            LinkedListExEntry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    this.remove(e);
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public boolean addAll(int index, Collection c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        ++this.modCount;
        LinkedListExEntry successor = index == this.size ? this.header : this.entry(index);
        LinkedListExEntry predecessor = successor.previous;
        int i = 0;
        while (i < numNew) {
            LinkedListExEntry e;
            predecessor.next = e = new LinkedListExEntry(a[i], successor, predecessor);
            predecessor = e;
            ++i;
        }
        successor.previous = predecessor;
        this.size += numNew;
        return true;
    }

    public void clear() {
        ++this.modCount;
        this.header.next = this.header.previous = this.header;
        this.size = 0;
    }

    public Object get(int index) {
        return this.entry((int)index).element;
    }

    public Object set(int index, Object element) {
        LinkedListExEntry e = this.entry(index);
        Object oldVal = e.element;
        e.element = element;
        return oldVal;
    }

    public void add(int index, Object element) {
        this.addBefore(element, index == this.size ? this.header : this.entry(index));
    }

    public Object remove(int index) {
        LinkedListExEntry e = this.entry(index);
        this.remove(e);
        return e.element;
    }

    private LinkedListExEntry entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        LinkedListExEntry e = this.header;
        if (index < this.size >> 1) {
            int i = 0;
            while (i <= index) {
                e = e.next;
                ++i;
            }
        } else {
            int i = this.size;
            while (i > index) {
                e = e.previous;
                --i;
            }
        }
        return e;
    }

    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            LinkedListExEntry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        } else {
            LinkedListExEntry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        int index = this.size;
        if (o == null) {
            LinkedListExEntry e = this.header.previous;
            while (e != this.header) {
                --index;
                if (e.element == null) {
                    return index;
                }
                e = e.previous;
            }
        } else {
            LinkedListExEntry e = this.header.previous;
            while (e != this.header) {
                --index;
                if (o.equals(e.element)) {
                    return index;
                }
                e = e.previous;
            }
        }
        return -1;
    }

    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    public LinkedListExEntry addBefore(Object o, LinkedListExEntry e) {
        LinkedListExEntry newEntry;
        newEntry.previous.next = newEntry = new LinkedListExEntry(o, e, e.previous);
        newEntry.next.previous = newEntry;
        ++this.size;
        ++this.modCount;
        return newEntry;
    }

    public void remove(LinkedListExEntry e) {
        if (e == this.header) {
            throw new NoSuchElementException();
        }
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this.size;
        ++this.modCount;
    }

    public Object clone() {
        LinkedListEx clone = null;
        try {
            clone = (LinkedListEx)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.header.next = clone.header.previous = (clone.header = new LinkedListExEntry(null, null, null));
        clone.size = 0;
        clone.modCount = 0;
        LinkedListExEntry e = this.header.next;
        while (e != this.header) {
            clone.add(e.element);
            e = e.next;
        }
        return clone;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        LinkedListExEntry e = this.header.next;
        while (e != this.header) {
            result[i++] = e.element;
            e = e.next;
        }
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int i = 0;
        LinkedListExEntry e = this.header.next;
        while (e != this.header) {
            a[i++] = e.element;
            e = e.next;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        LinkedListExEntry e = this.header.next;
        while (e != this.header) {
            s.writeObject(e.element);
            e = e.next;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.header.next = this.header.previous = (this.header = new LinkedListExEntry(null, null, null));
        int i = 0;
        while (i < size) {
            this.add(s.readObject());
            ++i;
        }
    }

    private class ListItr
    implements ListIterator {
        private LinkedListExEntry lastReturned;
        private LinkedListExEntry next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int index) {
            this.lastReturned = LinkedListEx.this.header;
            this.expectedModCount = LinkedListEx.this.modCount;
            if (index < 0 || index > LinkedListEx.this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + LinkedListEx.this.size);
            }
            if (index < LinkedListEx.this.size >> 1) {
                this.next = LinkedListEx.this.header.next;
                this.nextIndex = 0;
                while (this.nextIndex < index) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
            } else {
                this.next = LinkedListEx.this.header;
                this.nextIndex = LinkedListEx.this.size;
                while (this.nextIndex > index) {
                    this.next = this.next.previous;
                    --this.nextIndex;
                }
            }
        }

        public boolean hasNext() {
            return this.nextIndex != LinkedListEx.this.size;
        }

        public Object next() {
            this.checkForComodification();
            if (this.nextIndex == LinkedListEx.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.element;
        }

        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        public Object previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next = this.next.previous;
            --this.nextIndex;
            this.checkForComodification();
            return this.lastReturned.element;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public void remove() {
            this.checkForComodification();
            try {
                LinkedListEx.this.remove(this.lastReturned);
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException();
            }
            if (this.next == this.lastReturned) {
                this.next = this.lastReturned.next;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = LinkedListEx.this.header;
            ++this.expectedModCount;
        }

        public void set(Object o) {
            if (this.lastReturned == LinkedListEx.this.header) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.element = o;
        }

        public void add(Object o) {
            this.checkForComodification();
            this.lastReturned = LinkedListEx.this.header;
            LinkedListEx.this.addBefore(o, this.next);
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (LinkedListEx.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

