// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H__1E4CD94D_CB6E_4FAD_9DDE_3E2B96D11CE2__INCLUDED_)
#define AFX_MAINFRM_H__1E4CD94D_CB6E_4FAD_9DDE_3E2B96D11CE2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define CMDIFrameWnd CBCGPMDIFrameWnd

#include "WatchBar.h"
#include "ClassViewBar.h"
#include "ResourceView.h"
#include "FileViewBar.h"
#include "OutputView.h"
#include "DynamicHelpView.h"
#include "PropertiesViewBar.h"
#include "InfoBar.h"
#include "ToolBox.h"

class CMainFrame : public CMDIFrameWnd
{
	DECLARE_DYNAMIC(CMainFrame)
public:
	CMainFrame();

// Attributes
public:
	bool IsFullScreen() const { return m_bFullScreen; }

protected:
	bool	m_bFullScreen;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL LoadFrame(UINT nIDResource, DWORD dwDefaultStyle = WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, CWnd* pParentWnd = NULL, CCreateContext* pContext = NULL);
	protected:
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

	virtual BOOL OnShowPopupMenu (CBCGPPopupMenu* pMenuPopup);

// Implementation
public:
	BOOL SetDefaultFont(CFont& Font, CWnd* pWnd /* = NULL */);
	static CBCGPToolbarComboBoxButton* GetFindCombo();
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CBCGPMenuBar			m_wndMenuBar;
	CBCGPStatusBar			m_wndStatusBar;
	CBCGPToolBar			m_wndToolBar;
	CBCGPToolBar			m_wndToolbarBuild;
	CBCGPToolBar			m_wndToolbarEdit;
	CBCGPDropDownToolBar	m_wndToolbarResource;

	CClassViewBar			m_wndClassView;
	CResourceViewBar		m_wndResourceView;
	CFileViewBar			m_wndFileView;

	CDynamicHelpViewBar		m_wndDynamicHelpView;
	COutputViewBar			m_wndOutputView;
	CPropertiesViewBar		m_wndPropertiesBar;

	CInfoBar				m_wndInfoBar;
	CToolBoxBar				m_wndToolBoxBar;

	CWatchBar				m_wndWatchBar;

	CBCGPToolBarImages		m_UserImages;

private:
	WINDOWPLACEMENT			m_wpPrev;
	CRect					m_rectFullScreenWindow;
	CBCGPToolBar*			m_pwndFullScreenBar;


// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnViewOutput();
	afx_msg void OnUpdateViewOutput(CCmdUI* pCmdUI);
	afx_msg void OnViewBuildToolbar();
	afx_msg void OnUpdateViewBuildToolbar(CCmdUI* pCmdUI);
	afx_msg void OnViewWatch();
	afx_msg void OnUpdateViewWatch(CCmdUI* pCmdUI);
	afx_msg void OnWindowManager();
	afx_msg void OnHelpKeyboardmap();
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnViewClass();
	afx_msg void OnUpdateViewClass(CCmdUI* pCmdUI);
	afx_msg void OnViewResource();
	afx_msg void OnUpdateViewResource(CCmdUI* pCmdUI);
	afx_msg void OnViewFile();
	afx_msg void OnUpdateViewFile(CCmdUI* pCmdUI);
	afx_msg void OnViewDynamichelp();
	afx_msg void OnUpdateViewDynamichelp(CCmdUI* pCmdUI);
	afx_msg void OnFileNewProject();
	afx_msg void OnFileNewBlankSolution();
	afx_msg void OnFileOpenSolution();
	afx_msg void OnFileCloseSolution();
	afx_msg void OnFileSaveAll();
	afx_msg void OnViewProperties();
	afx_msg void OnUpdateViewProperties(CCmdUI* pCmdUI);
	afx_msg void OnViewRefresh();
	afx_msg void OnToolsConnectToDatabase();
	afx_msg void OnToolsDebugProcesses();
	afx_msg void OnClose();
	afx_msg void OnViewFullScreen();
	afx_msg void OnGetMinMaxInfo(MINMAXINFO* lpMMI);
	afx_msg void OnViewToolbox();
	afx_msg void OnUpdateViewToolbox(CCmdUI* pCmdUI);
	afx_msg void OnViewInfobar();
	afx_msg void OnUpdateViewInfobar(CCmdUI* pCmdUI);
	afx_msg void OnViewEditToolbar();
	afx_msg void OnUpdateViewEditToolbar(CCmdUI* pCmdUI);
	afx_msg void OnToolsOptions();
	//}}AFX_MSG
	afx_msg void OnViewCustomize();
	afx_msg LRESULT OnToolbarReset(WPARAM,LPARAM);
	void OnToolsViewUserToolbar (UINT id);
	void OnUpdateToolsViewUserToolbar (CCmdUI* pCmdUI);
	afx_msg LRESULT OnToolbarContextMenu(WPARAM,LPARAM);
	afx_msg LRESULT OnHelpCustomizeToolbars(WPARAM wp, LPARAM lp);
	LRESULT OnToolbarCreateNew(WPARAM wp,LPARAM lp);
	afx_msg void OnToolBox();
	DECLARE_MESSAGE_MAP()

	BOOL CreateDockingBars ();
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__1E4CD94D_CB6E_4FAD_9DDE_3E2B96D11CE2__INCLUDED_)
