@Echo Off
REM This is a slave file to be started automatically in each machine
REM that runs simulations.
REM
REM This file just runs once when the slave is started (eg on reboot).
REM
REM It restarts an in-progress simulation or starts an infinite monitoring
REM process.

if %computername%=='' goto abort

Call SetPaths.bat
Call cdd %SlavePath%
@Echo off
dirc *.* %Masterpath% copy2 newer2

REM Make sure the control directory exists on the slave.
ExistDir %SlavePath%
if errorlevel 1 mkdir %SlavePath%

REM Check for a simulation already in progress.
If Not Exist %SlavePath%\go.bat goto CheckAssigned
REM Yes, there is a simulation in progress, so restart it.
Call SlaveRun.bat
REM OK, that existing simulation is done, so carry on.

:CheckAssigned
REM Check for a task already assigned by the master but not yet started.
If Exist %MasterPath%\%ComputerName%.bat Goto end
REM The master has not assigned a task to this slave, so make sure the
REM master knows it is ready.

REM Tell the master this slave is ready for a new task.
Call SlaveReady.bat

:end
SlaveLoop

:abort
Echo This slave cannot be started because "ComputerName" is not defined.
Echo To assign it a name, look in Control Panel / System
Echo Then look at the "Computer Name" tab, and click "Change" to
Echo assign a "full computer name".  Then try again.
