/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.EscapeProcessor;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class Statement {
    protected Connection _conn = null;
    protected int _resultSetType = 0;
    protected int _resultSetConcurrency = 0;
    protected Vector _batchedArgs;
    ResultSet _results = null;
    ResultSet _nextResults = null;
    SQLWarning _warnings = null;
    int _timeout = 0;
    boolean _escapeProcessing = true;
    EscapeProcessor _escaper = null;
    int _maxFieldSize = MysqlIO.MAXBUF;
    int _maxRows = -1;
    long _updateCount = -1L;
    long _lastInsertId = -1L;
    String _catalog = null;

    public Statement(Connection connection, String string) {
        this._conn = connection;
        this._escaper = new EscapeProcessor();
        this._catalog = string;
        if (this._conn != null) {
            this._maxFieldSize = this._conn.getMaxAllowedPacket();
        }
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        if (this._escapeProcessing) {
            string = this._escaper.escapeSQL(string);
        }
        if (this._results != null) {
            this._results.close();
        }
        Object object = this._conn.getMutex();
        synchronized (object) {
            String string2 = null;
            if (!this._conn.getCatalog().equals(this._catalog)) {
                string2 = this._conn.getCatalog();
                this._conn.setCatalog(this._catalog);
            }
            if (this._conn.useMaxRows()) {
                if (string.toUpperCase().indexOf("LIMIT") != -1) {
                    this._results = this._conn.execSQL(string, this._maxRows);
                } else {
                    if (this._maxRows <= 0) {
                        this._conn.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
                    } else {
                        this._conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this._maxRows, -1);
                    }
                    this._results = this._conn.execSQL(string, -1);
                    if (string2 != null) {
                        this._conn.setCatalog(string2);
                    }
                }
            } else {
                this._results = this._conn.execSQL(string, -1);
            }
            if (string2 != null) {
                this._conn.setCatalog(string2);
            }
        }
        this._lastInsertId = this._results.getUpdateID();
        this._nextResults = this._results;
        this._results.setConnection(this._conn);
        this._results.setResultSetType(this._resultSetType);
        this._results.setResultSetConcurrency(this._resultSetConcurrency);
        this._results.setStatement(this);
        return (java.sql.ResultSet)((Object)this._results);
    }

    public int executeUpdate(String string) throws SQLException {
        if (this._escapeProcessing) {
            string = this._escaper.escapeSQL(string);
        }
        ResultSet resultSet = null;
        Object object = this._conn.getMutex();
        synchronized (object) {
            String string2 = null;
            if (!this._conn.getCatalog().equals(this._catalog)) {
                string2 = this._conn.getCatalog();
                this._conn.setCatalog(this._catalog);
            }
            if (this._conn.useMaxRows()) {
                this._conn.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
            }
            resultSet = this._conn.execSQL(string, -1);
            resultSet.setConnection(this._conn);
            if (string2 != null) {
                this._conn.setCatalog(string2);
            }
        }
        if (resultSet.reallyResult()) {
            throw new SQLException("Results returned for UPDATE ONLY.", "01S03");
        }
        this._updateCount = resultSet.getUpdateCount();
        int n = 0;
        n = this._updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._updateCount;
        this._lastInsertId = resultSet.getUpdateID();
        return n;
    }

    public void close() throws SQLException {
        if (this._results != null) {
            try {
                this._results.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._results = null;
        this._conn = null;
        this._warnings = null;
        this._escaper = null;
    }

    public int getMaxFieldSize() throws SQLException {
        return this._maxFieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        int n2;
        int n3 = n2 = this._conn != null ? this._conn.getMaxAllowedPacket() : MysqlIO.MAXBUF;
        if (n > n2) {
            throw new SQLException("Can not set max field size > max allowed packet: " + n2, "S1009");
        }
        this._maxFieldSize = n;
    }

    public int getMaxRows() throws SQLException {
        if (this._maxRows <= 0) {
            return 0;
        }
        return this._maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        if (n > 50000000) {
            throw new SQLException("setMaxRows() out of range. " + n + " > " + 50000000 + ".", "S1009");
        }
        if (n == 0) {
            n = -1;
        }
        this._maxRows = n;
        this._conn.maxRowsChanged();
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this._escapeProcessing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        return this._timeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this._timeout = n;
    }

    public void cancel() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._warnings;
    }

    public void clearWarnings() throws SQLException {
        this._warnings = null;
    }

    public void setCursorName(String string) throws SQLException {
    }

    public boolean execute(String string) throws SQLException {
        if (this._escapeProcessing) {
            string = this._escaper.escapeSQL(string);
        }
        if (this._results != null) {
            this._results.close();
        }
        ResultSet resultSet = null;
        Object object = this._conn.getMutex();
        synchronized (object) {
            String string2 = null;
            if (!this._conn.getCatalog().equals(this._catalog)) {
                string2 = this._conn.getCatalog();
                this._conn.setCatalog(this._catalog);
            }
            if (this._conn.useMaxRows()) {
                char c = Character.toUpperCase(string.charAt(0));
                if (c == 'S') {
                    if (string.toUpperCase().indexOf("LIMIT") != -1) {
                        resultSet = this._conn.execSQL(string, this._maxRows);
                    } else if (this._maxRows <= 0) {
                        this._conn.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
                    } else {
                        this._conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this._maxRows, -1);
                    }
                } else {
                    this._conn.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
                }
                resultSet = this._conn.execSQL(string, -1);
            } else {
                resultSet = this._conn.execSQL(string, -1);
            }
            if (string2 != null) {
                this._conn.setCatalog(string2);
            }
        }
        this._lastInsertId = resultSet.getUpdateID();
        if (resultSet != null) {
            this._results = resultSet;
        }
        resultSet.setConnection(this._conn);
        resultSet.setResultSetType(this._resultSetType);
        resultSet.setResultSetConcurrency(this._resultSetConcurrency);
        return resultSet != null && resultSet.reallyResult();
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        return this._results != null && this._results.reallyResult() ? (java.sql.ResultSet)((Object)this._results) : null;
    }

    public int getUpdateCount() throws SQLException {
        if (this._results == null) {
            return -1;
        }
        if (this._results.reallyResult()) {
            return -1;
        }
        int n = 0;
        n = this._results.getUpdateCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._results.getUpdateCount();
        return n;
    }

    public long getLongUpdateCount() {
        if (this._results == null) {
            return -1L;
        }
        if (this._results.reallyResult()) {
            return -1L;
        }
        return this._updateCount;
    }

    public long getLastInsertID() {
        return this._lastInsertId;
    }

    public boolean getMoreResults() throws SQLException {
        if (this._results != null) {
            this._results.close();
        }
        this._results = this._nextResults;
        this._nextResults = null;
        return this._results != null && this._results.reallyResult();
    }

    public void setFetchDirection(int n) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 0;
    }

    public void setFetchSize(int n) throws SQLException {
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this._resultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this._resultSetType;
    }

    public void addBatch(String string) throws SQLException {
        if (this._batchedArgs == null) {
            this._batchedArgs = new Vector();
        }
        if (string != null) {
            this._batchedArgs.addElement(string);
        }
    }

    public void clearBatch() throws SQLException {
        if (this._batchedArgs != null) {
            this._batchedArgs.setSize(0);
        }
    }

    public java.sql.Connection getConnection() throws SQLException {
        return (java.sql.Connection)((Object)this._conn);
    }
}

