/*
 * Decompiled with CFR 0.152.
 */
package javak.bo;

import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javak.exception.BOjavakException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigData {
    Document configdata = null;
    CachedXPathAPI cxp_api = null;

    public ConfigData(Document document) {
        this.configdata = document;
        this.cxp_api = new CachedXPathAPI();
    }

    private Vector getList(String string, String string2) throws BOjavakException {
        NodeList nodeList = null;
        try {
            nodeList = this.cxp_api.selectNodeList((Node)this.configdata, string);
        }
        catch (Exception exception) {
            throw new BOjavakException(exception, "Error at querying configdata for xpath '" + string + "'");
        }
        int n = nodeList.getLength();
        Vector<String> vector = new Vector<String>(n, 1);
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(nodeList.item(n2).getNodeValue());
            ++n2;
        }
        if (n == 0) {
            vector.addElement(string2);
        }
        return vector;
    }

    private String getValue(String string, String string2) throws BOjavakException {
        try {
            Node node = this.cxp_api.selectSingleNode((Node)this.configdata, string);
            if (node == null) {
                return string2;
            }
            return node.getNodeValue();
        }
        catch (Exception exception) {
            throw new BOjavakException(exception, "Error at querying configdata for value with xpath '" + string + "'");
        }
    }

    public Vector getDriverClasses() throws BOjavakException {
        return this.getList("/data/display/default/driverclasslist/driverclass/text()", "sun.jdbc.odbc.JdbcOdbcDriver");
    }

    public String getDriverClass(String string) throws BOjavakException {
        String string2 = "/data/display/preconfigured/config[name='" + string + "']/driverclass/text()";
        String string3 = "/data/display/default/driverclasslist/driverclass[@name=" + string2 + "]/text()";
        return this.getValue(string3, "sun.jdbc.odbc.JdbcOdbcDriver");
    }

    public Vector getProtocols() throws BOjavakException {
        return this.getList("/data/display/default/protocollist/protocol/text()", "jdbc:odbc:");
    }

    public String getProtocol(String string) throws BOjavakException {
        String string2 = "/data/display/preconfigured/config[name='" + string + "']/protocol/text()";
        String string3 = "/data/display/default/protocollist/protocol[@name=" + string2 + "]/text()";
        return this.getValue(string3, "jdbc:odbc:");
    }

    public Vector getDatabases() throws BOjavakException {
        return this.getList("/data/display/default/dbhostportlist/dbhostport/text()", "Testdatenbank");
    }

    public String getDatabase(String string) throws BOjavakException {
        String string2 = "/data/display/preconfigured/config[name='" + string + "']/dbhostport/text()";
        String string3 = "/data/display/default/dbhostportlist/dbhostport[@name=" + string2 + "]/text()";
        return this.getValue(string3, "");
    }

    public String getLogin(String string) throws BOjavakException {
        String string2 = "/data/display/preconfigured/config[name='" + string + "']/login/text()";
        return this.getValue(string2, this.getDefaultLogin());
    }

    public String getRMI(String string) throws BOjavakException {
        String string2 = "/data/display/preconfigured/config[name='" + string + "']/rmi/text()";
        return this.getValue(string2, "");
    }

    public Vector getPreconfiguredProfileNames() throws BOjavakException {
        Vector vector = this.getList("/data/display/preconfigured/config/name/text()", "");
        vector.add(0, "");
        return vector;
    }

    public String getDefaultLogin() throws BOjavakException {
        return this.getValue("/data/display/default/login/text()", "");
    }

    public String getPathIniWindows() throws BOjavakException {
        return this.getValue("/data/display/default/pathtoodbcini/text()", "");
    }

    private String dump(Node node) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(node), new StreamResult(byteArrayOutputStream));
        }
        catch (Exception exception) {
            return "Exception occurred in dump!!!";
        }
        return byteArrayOutputStream.toString();
    }
}

