/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.dtd;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.impl.dv.dtd.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.dtd.DatatypeValidator;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.dtd.StatefullDatatypeValidator;
import org.apache.xerces.util.XMLChar;

public class IDREFDatatypeValidator
extends AbstractDatatypeValidator
implements StatefullDatatypeValidator {
    private DatatypeValidator fBaseValidator = null;
    private Hashtable fTableOfId = null;
    private Hashtable fTableIDRefs = null;
    private Object fNullValue = null;
    private Locale fLocale = null;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();

    public IDREFDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public IDREFDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
    }

    public void validate(String string, Object object) throws InvalidDatatypeValueException {
        if (!XMLChar.isValidName(string)) {
            InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException(string);
            invalidDatatypeValueException.setKeyIntoReporter("IDREFInvalid");
            throw invalidDatatypeValueException;
        }
        this.addIdRef(string, object);
    }

    public void validate() throws InvalidDatatypeValueException {
        this.checkIdRefs();
    }

    public void initialize(Object object) {
        if (this.fTableIDRefs != null) {
            this.fTableIDRefs.clear();
        } else {
            this.fTableIDRefs = new Hashtable();
        }
        this.fTableOfId = (Hashtable)object;
    }

    public int compare(String string, String string2) {
        return -1;
    }

    public Hashtable getFacets() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    private void addIdRef(String string, Object object) {
        if (this.fTableOfId != null && this.fTableOfId.containsKey(string)) {
            return;
        }
        if (this.fTableIDRefs == null) {
            this.fTableIDRefs = new Hashtable();
        } else if (this.fTableIDRefs.containsKey(string)) {
            return;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        try {
            this.fTableIDRefs.put(string, this.fNullValue);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Out of Memory: Hashtable of ID's has " + this.fTableIDRefs.size() + " Elements");
            outOfMemoryError.printStackTrace();
        }
    }

    private void checkIdRefs() throws InvalidDatatypeValueException {
        if (this.fTableIDRefs == null) {
            return;
        }
        Enumeration enumeration = this.fTableIDRefs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.fTableOfId != null && this.fTableOfId.containsKey(string)) continue;
            InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException(string);
            invalidDatatypeValueException.setKeyIntoReporter("MSG_ELEMENT_WITH_ID_REQUIRED");
            throw invalidDatatypeValueException;
        }
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Object getInternalStateInformation() {
        return null;
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        return this.fMessageProvider.formatMessage(this.fLocale, null, null);
    }
}

