/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.File;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.URI;

public class SystemIDResolver {
    public static String getAbsoluteURI(String url) throws TransformerException {
        if (url.startsWith("..")) {
            url = new File(url).getAbsolutePath();
        }
        if (url.startsWith(File.separator)) {
            url = "file://" + url;
        } else if (url.indexOf(58) < 0) {
            url = SystemIDResolver.getAbsoluteURIFromRelative(url);
        }
        return url;
    }

    public static String getAbsoluteURI(String urlString, String base) throws TransformerException {
        URI uri;
        boolean isAbsouteUrl = false;
        boolean needToResolve = false;
        if (urlString.indexOf(58) > 0) {
            isAbsouteUrl = true;
        } else if (urlString.startsWith(File.separator)) {
            urlString = "file://" + urlString;
            isAbsouteUrl = true;
        }
        if (!(isAbsouteUrl || base != null && base.indexOf(58) >= 0)) {
            base = base != null && base.startsWith(File.separator) ? "file://" + base : SystemIDResolver.getAbsoluteURIFromRelative(base);
        }
        if (base != null && needToResolve) {
            if (base.equals(urlString)) {
                base = "";
            } else {
                urlString = urlString.substring(5);
                isAbsouteUrl = false;
            }
        }
        if (base != null && base.indexOf(92) > -1) {
            base = base.replace('\\', '/');
        }
        if (urlString != null && urlString.indexOf(92) > -1) {
            urlString = urlString.replace('\\', '/');
        }
        try {
            if (base == null || base.length() == 0 || isAbsouteUrl) {
                uri = new URI(urlString);
            } else {
                URI baseURI = new URI(base);
                uri = new URI(baseURI, urlString);
            }
        }
        catch (URI.MalformedURIException mue) {
            throw new TransformerException(mue);
        }
        String uriStr = uri.toString();
        return uriStr;
    }

    public static String getAbsoluteURIFromRelative(String uri) {
        String curdir = "";
        try {
            curdir = System.getProperty("user.dir");
        }
        catch (SecurityException securityException) {}
        if (curdir != null) {
            String base = curdir.startsWith(File.separator) ? "file://" + curdir : "file:///" + curdir;
            uri = uri != null ? String.valueOf(base) + System.getProperty("file.separator") + uri : String.valueOf(base) + System.getProperty("file.separator");
        }
        if (uri != null && uri.indexOf(92) > -1) {
            uri = uri.replace('\\', '/');
        }
        return uri;
    }
}

