/* animtest.t, by Gabriel McKean
	created: 4-16-00
	This is a simple file to test animation.t.  The images were created by
	POV-RAY (www.povray.org).
*/

#define USE_HTML_STATUS
#define USE_HTML_PROMPT

#include <adv.t>
#include "animate.t"

#pragma C+

commonInit: function
{
	"\H+"; // enable HTML
}

init: function
{
#ifdef USE_HTML_STATUS
    /* 
     *   We're using the adv.t HTML-style status line - make sure the
     *   run-time version is recent enough to support this code.  (The
     *   status line code uses systemInfo to detect whether the run-time
     *   is HTML-enabled or not, which doesn't work properly before
     *   version 2.2.4.)  
     */
    if (systemInfo(__SYSINFO_SYSINFO) != true
        || systemInfo(__SYSINFO_VERSION) < '2.2.4')
    {
        "\b\b\(WARNING! This game requires the TADS run-time version
        2.2.4 or higher.  You appear to be using an older version of the
        TADS run-time.  You can still attempt to run this game, but the
        game's screen display may not work properly.  If you experience
        any problems, you should try upgrading to the latest version of
        the TADS run-time.\)\b\b";
    }
#endif

	/* perform common initializations */
	commonInit();
	parserGetMe().location = startroom;

	// display text
	"<B>Animate!</B>";
	inputkey(); // wait for key press

	// define the animation banner
	"<BANNER ID=anim><BODY BGCOLOR=\"black\"><CENTER>
	<IMG SRC=\"anim01.jpg\"></CENTER></BANNER>";

	animate('anim', ['anim02.jpg' 'anim03.jpg' 'anim04.jpg' 'anim05.jpg'
	'anim06.jpg' 'anim07.jpg' 'anim08.jpg' 'anim09.jpg' 'anim10.jpg'],
	50, '', 'BGCOLOR=\"black\"');

	inputkey();
	"<BANNER ID=anim REMOVE>"; // remove the banner
	inputkey();
	quit();
}

// turn off the status line in the startroom
startroom: room
	statusLine = {}
;

// required definitions that aren't really used in this example
Me: basicMe;
numObj: basicNumObj;
strObj: basicStrObj;
global: object;
version: object;
pardon: function {}
darkTravel: function {}
scoreRank: function {}
terminate: function {}
goToSleep: function{}
