
#ifndef h_adapter_h
#define h_adapter_h

/* Since Magnetic assumes things like the presence of the Standard C library,
 * we need to wrap up Palm OS functions to look like them, or take them out
 * altogether. Rather than wreck all the Magnetic code, we'll opt for the
 * wrapper method.
 *
 * GOAL: Ease and speed of port; its a little hackish here, but I needed to
 * get it done fast or it would never get done (very limited time). And wanted
 * to play the games.. I'd been meaning to do this port since 1997 :)
 *
 */

/* externs
 */
extern UInt32 g_current_pic;
extern UInt8 g_current_pic_mode;
extern char g_gamename [ 20 ];
extern char g_gfxname [ 20 ];
extern char g_savedir [ 20 ];
extern UInt32 g_features;
extern UInt16 g_clie_refnum;
extern char g_last_loaded_file [ 40 ];
extern UInt8 g_waiting_for_key;
extern MemHandle h_crlf, h_bat1, h_bat2, h_bat3, h_bat4, h_thinking;
extern BitmapPtr b_crlf, b_bat1, b_bat2, b_bat3, b_bat4, b_thinking;

/* features
 */
#define F_OS5HIGHRES 1
#define F_COLOUR     2
#define F_OLDCLIEHR  4  /* only set if an old Clie, pre OS5 */
#define F_TINYFONT   8  /* only set if OS5highres is also true! */
#define F_MEDFONT   16  /* add to TINYFONT or OLDCLIEHR for medium font */
#define F_MAPPER    32  /* add support for mapper; eats RAM! */

/* types
 */
typedef UInt32 size_t;
typedef UInt32 time_t;
#define TRUE 1
#define FALSE 0 
#define FILENAME_MAX 123

/* signals
 */
#define SIGINT 42
#define SIGQUIT 43
#define SIGTSTP 44
#define SIG_IGN 0

/* memory/misc functions
 */
#define malloc(x) MemPtrNewL(x)
void *realloc ( void *ptr, UInt32 size );
#define free(x) MemPtrFreeL(x)
#define memcpy(t,f,s) MemMove(t,f,s)
#define time(x) TimGetSeconds()
#define strcasecmp StrCaselessCompare
#define strncasecmp StrNCaselessCompare
#define strcmp StrCompare
#define strchr(s,c) StrChr ( s, c )
#define isspace TxtCharIsSpace
#define strncpy StrNCopy
#define strncmp StrNCompare
#define toupper(x) (x>='a' && x<='z' ? (x - ('a'-'A')) : (x))
#define tolower(x) (x>='A' && x<='Z' ? (x + ('a'-'A')) : (x))
#define strcpy(t,s) StrCopy ( t, s )
#define strerror(e) "Error"
#define sprintf StrPrintF
#define memset(s,c,n) MemSet(s,n,c)
#define islower(c) TxtCharIsLower(c)
#define isupper(c) TxtCharIsUpper(c)
#define strlen(c) StrLen(c)
#define atoi(a) StrAToI(a)
#define atof(a) 1
#define strcat(s,a) StrCat(s,a)
#define memmove(d,s,z) MemMove(d,s,z)

/* directory listing
 */
typedef struct _dirent_t {
  char filename [ 32 ];
  struct _dirent_t *next;
} dirent_t;

extern dirent_t *dirlist;

void dirlist_build ( void );
char *dirlist_lookup ( UInt16 entry );

/*
 * Palm OS utility functions
 */

/* memory alloc
 */
#define memNewChunkFlagNonMovable    0x0200
#define memNewChunkFlagAllowLarge    0x1000  // this is not in the sdk *g*
SysAppInfoPtr 
SysGetAppInfo(SysAppInfoPtr *uiAppPP, SysAppInfoPtr *actionCodeAppPP)
  SYS_TRAP(sysTrapSysGetAppInfo); 

void *MemPtrNewL ( UInt32 size );
void MemPtrFreeL ( void *ptr );
UInt32 query_heap_free ( void );

/* VFS filesystem utility
 */
UInt16 palm_vfs_count ( void );
UInt16 palm_vfs_iter ( void );
UInt16 palm_save_count ( UInt16 entry, char *r_filename );
UInt16 palm_game_count ( UInt16 entry, char *r_filename );
UInt8 palm_file_exists ( char *name );

/* event loop for custom modal
 */
void palm_event_loop ( void );
Boolean AppHandleEvent ( EventPtr eventP );

/* object referential
 */
void *GetObjectPtr ( UInt16 objectID );
FieldPtr GetFocusObjectPtr ( void );

/* gadgets
 */
int update_field ( FormPtr f, int obid, char *newtext );
void cache_bitmaps ( void );
void dump_bitmaps ( void );
void draw_battery ( void );
void draw_progress_bar ( UInt8 perc );
void draw_thinking ( void );
void erase_thinking ( void );
void draw_controls ( void );
void display_scroll_up ( void );
void display_scroll_down ( void );
void ms_statuschar_string ( char *s );

/* OS dependant schmutz
 */
UInt8 clie_startup_highres ( void );
void clie_shutdown_highres ( void );

/* debugging and special alerts
 */

#define DEBUGC(x) FrmCustomAlert ( MessageAlert, x, NULL, NULL );

#define DEBUGU8(x) {                                   \
  char buffer [ 200 ];                                 \
  StrPrintF ( buffer, "%u", x );                       \
  FrmCustomAlert ( MessageAlert, buffer, NULL, NULL ); \
}

#define DEBUGU32(x) {                                  \
  char buffer [ 200 ];                                 \
  StrPrintF ( buffer, "%lu", x );                      \
  FrmCustomAlert ( MessageAlert, buffer, NULL, NULL ); \
}

#define DEBUGS(s) {                                    \
  FrmCustomAlert ( MessageAlert, s, NULL, NULL );      \
}

#endif
