//---------------------------------------------------------------------------
#include <vcl.h>

#pragma hdrstop

#include "grid.h"
#include "Main.h"
#include "glkthread.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

extern GLK *glk;

TEXTGRID::TEXTGRID(TComponent *Owner,int tag) : TPaintBox(Owner)
{
Parent=MainForm;
bitmap=new Graphics::TBitmap();
Tag=tag;
mouse_event=false;
OnClick=OnFocus;
OnMouseMove=CheckHyper;
OnPaint=Painted;
cursor.x=0;
cursor.y=0;
fill_rect.left=0;
fill_rect.top=0;
hyper_count=0;
hyper_active=false;
changed=true;
};
//----------------------------------------------------------------------------

__fastcall TEXTGRID::~TEXTGRID()
{
delete bitmap;
};
//----------------------------------------------------------------------------

void __fastcall TEXTGRID::OnFocus(TObject *Sender)
{
glk->check_focus(Tag);

if (!hyper_active&&!mouse_event)
  return;

TPoint pos;
GetCursorPos(&pos);
pos=ScreenToClient(pos);
//pos=ScreenToClient(Mouse->CursorPos);

if (hyper_active){
  for (int i=0;i<hyper_count;i++){
    if (pos.x>=hyperlink[i].coords.left&&pos.x<=hyperlink[i].coords.right&&pos.y>=hyperlink[i].coords.top&&pos.y<=hyperlink[i].coords.bottom){
      hyper_active=false;
      Cursor=crDefault;
      glk->ProcessHyper(Tag-1,hyperlink[i].linkval);
      return;};};};

if (mouse_event){
  glk->ProcessMouse(Tag-1,pos);
  mouse_event=false;};
};
//----------------------------------------------------------------------------

void __fastcall TEXTGRID::Painted(TObject *Sender)
{
Canvas->Lock();
Canvas->Draw(0,0,bitmap);
Canvas->Unlock();
};                                      
//----------------------------------------------------------------------------

void __fastcall TEXTGRID::post_output()
{
Repaint();
changed=false;
};
//----------------------------------------------------------------------------

void __fastcall TEXTGRID::clear()
{
changed=true;
bitmap->Canvas->Lock();
bitmap->Canvas->FillRect(fill_rect);
bitmap->Canvas->Unlock();
cursor.x=0;
cursor.y=0;
hyper_count=0;
};
//----------------------------------------------------------------------------

void __fastcall TEXTGRID::CheckHyper(TObject *Sender,TShiftState Shift,int X,int Y)
{
if (hyper_active){
  for (int i=0;i<hyper_count;i++){
    if (X>=hyperlink[i].coords.left&&X<=hyperlink[i].coords.right&&Y>=hyperlink[i].coords.top&&Y<=hyperlink[i].coords.bottom){
      Cursor=crHandPoint;
      return;};};
  Cursor=crDefault;};
};


