/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

/*
 * The Baig System
 *
 * PLANETS
 *
 * Poot:	Homeworld of Skivlets, makers of Zippikraft computers
 * Keekers:	Location of Terminal Velocity
 *
 * COLORSPACES
 *
 * Hot Pink:	Contains Poot and Keekers
 */
TV: Room
	patroncount = 15
	
	noun = 'gateway'
	adjective = 'terminal' 'tv' 'velocity'

	sdesc = "Terminal Velocity Gateway"
	ldesc = {
		I(); "You are at the southern end of what appears to
		be an infinite corridor.  There is a matter mover in
		the south wall, and you conclude from your surroundings
		that the entrance to Terminal Velocity is at the north
		end of the hallway."; P();

		I(); "A blinding neon sign over the archway into the hall
		is beckoning you to come inside.";

#ifdef	DEMO
		if (nil) {
#else
		if (not TVelite.isknownto(Me)) {
#endif
			if (TVguard.isin(self))		
				" Unfortunately, the burly musclehead
				who's standing in your way isn't.";
			else
				" Fortunately, the guard isn't here
				at the moment.";
		}
			
		P(); I();
		"A mosaic on the floor includes the following cryptic
		message:"; P();
		TVmosaic.readmosaic;
	}

	south = {
		TVmover.doEnter(Me);
		return nil;
	}
	in = { return self.south; }
	north = {
#ifndef	DEMO
		if (TVelite.isknownto(Me))
			return outerhall;
#endif

		if (TVguard.isin(self)) {
			"The burly gorilla won't let you in until you've been
			approved by the management.";
		
			return nil;
		}
		else {
			"You slip through while the guard's away...\b";
			
			return outerhall;
		}
	}
	noexit = {
		"Why not use the matter mover like everyone else?";
		return nil;
	}

	Xcreatepatron = {
		local patron;

		if (TVP.patronsout > 0)
			return;

		patron := self.patronlist[rnd(6)];
		if (patron.location = nil) {
			TVP.patronsout++;
			patron.movein(TV);
			patron.makeknownto(Me);
			notify(patron, &movepatron, 0);
			if (Me.isin(patron.location)) {
				P(); caps(); patron.adesc; " emerges
							   from the matter mover.";
				
				TVmover.reset;
			}
		}
	}
	createpatron = {
		self.patroncount := self.patroncount - 1;
		if (self.patroncount < 1) {
			self.patroncount := rnd(5) + 5;
			self.Xcreatepatron;
		}
	}

	grounddesc = { TVmosaic.ldesc; }

	patronlist = [	TVpatron1 TVpatron2 TVpatron3
			TVpatron4 TVpatron5 TVpatron6 ]
;
TVmosaic: Readable, Decoration
	sdesc = "mosaic"
	ldesc = {
		"The mosaic forms the following message:"; P();

		self.readmosaic;
	}
	readdesc = { self.ldesc; }
	readmosaic = {
		"\"red down, green up, blue down, yellow up,
		magenta down, cyan up, white down\"";
	}
	location = TV

	noun = 'mosaic' 
;
TVsign: Readable, Decoration
	sdesc = "neon Terminal Velocity sign"
	ldesc = { self.readdesc; }
	readdesc = "It just says, \"Terminal Velocity\" on it."
	noun = 'sign'
	adjective = 'terminal' 'velocity' 'tv' 'neon'
	location = TV
;
class TVfollower: Follower
	verDoFollow(actor) = {
		if (TVguard.isin(Me.location)) {
#ifndef	DEMO
			if (TVelite.isknownto(Me))
				"Just head north and you'll get in.";
			else
#endif
				"The guard's not going to let you go
				anywhere.";
		}
	}
;

TVguardfollower: TVfollower
	myactor = TVguard
	noun = 'guard' 'bouncer' 'musclehead'
	adjective = 'burly' 'mean' 'large' 'unfriendly' 'security'
			'big' 'tough' 'looking' 'tough-looking' 
;
TVguarduniform: Part
	sdesc = "burly guard's uniform"
	ldesc = "The guard's uniform is snug-fitting and a drab olive color,
		with a colorful red, green, and blue emblem on the end
		of the right sleeve."
	partof = TVguard
	
	noun = 'uniform'
	adjective = 'guard' 'guard\'s' 'snug-fitting' 'drab' 'olive'
;
TVguardemblem: Part
	sdesc = "emblem on burly guard's uniform"
	adesc = { "an "; self.sdesc; }
	ldesc = {
		"It's a rendered and ray-traced "; note(self); " approximation
		of a blocky horse stuck onto a large wheeled platform.";
	}

	footnote = {
		"In other words, it looks gratuitously like computer
		graphics.";
	}

	partof = TVguard
	
	noun = 'emblem'
	adjective = 'guard' 'guard\'s' 'snug-fitting' 'drab' 'olive' 'uniform'
;
TVguard: Male, Actor
	passable = nil	// can't go in the main way (must use back door)

	place = 1
	count = 0
	myfollower = TVguardfollower
	sdesc = "burly guard"
	ldesc = {
		"He's one tough-looking dude.  I wouldn't mess with him
		if I were you.";

#ifndef	DEMO
		if (TVelite.isknownto(Me))
			" Fortunately, he seems much more mellow than
			before.";
#endif
	}
	actordesc = {
#ifndef	DEMO
		if (TVelite.isknownto(Me))
			"The guard is here.  He seems much less suspicious
			of you than before.";
		else
#endif
			"There is a burly musclehead here eyeing you
			suspiciously.";
	}
	noun = 'guard' 'bouncer' 'musclehead' 'man' 'dude'
	adjective = 'burly' 'mean' 'large' 'unfriendly' 'security'
			'big' 'tough' 'looking' 'tough-looking'
	location = TV

	circuit = [
		TV 2
		outerhall 2
		middlehall 2
		innerhall 3
		middlehall 2
		outerhall 2
	]	
	travel = {
		// The guard patrols along a fixed path.  He stays in
		// each location for a fixed amount of time.  There is
		// no randomness involved because we want to ensure that
		// the player can reliably sneak past the guard every
		// time once he learns how.
		local	c, dest;

		// See if the player just walked into the guard.
		self.checksnag;

		self.count++;
		if (self.count > self.circuit[self.place + 1]) {
			if (Me.isin(self.location)) {
				// Guard is now leaving the room the player
				// is in.
				P(); I();
#ifndef	DEMO
				if (TVelite.isknownto(Me))
					"The guard walks out of the room.";
				else
#endif
					"The hulking guard grunts at you
					menacingly and then elephant-walks
					away.";
 			}

			self.place += 2;
			if (self.place > length(self.circuit))
				self.place := 1;
			dest := self.circuit[self.place];
			self.movein(dest);
			self.count := 0;
			
			if (Me.isin(dest)) {
				// Guard has just entered the room
				// the player is in.
				P(); I(); "The beefy guard lumbers into
				the room with you.";
				self.makeknownto(Me);
			}
	
			self.checksnag;
		}
	}

	checksnag = {
		//
		// If the player has gotten the Elite pass, don't
		// snag.
		//
#ifndef	DEMO
		if (TVelite.isknownto(Me))
			return;
#endif

		//
		// See if the guard has snagged the player.  If so, he takes
		// the player back to "TV" by the scruff of the neck
		// (as it were).
		if (self.isin(Me.location) and uniform.isworn) {
			P(); I(); "The guard storms over to you and
			demands that you remove the extra uniform.
			You comply fearfully.";

			uniform.isworn := nil;

			if (not Me.isin(TV)) {
				" He then picks you up by the scruff
				of the neck and carries you back to
				the Terminal Velocity gateway.";
			
				P();

				Me.travelto(TV);
				self.movein(TV);
				self.place := 1;
				self.count := 0;
			}
		}
		else if (not self.isin(TV) and self.isin(Me.location)) {
			P(); I(); "Uh-oh.  The guard's noticed you.
			You try to explain your transgression but he
			wants to hear nothing of it.  He picks you
			up with one arm and tosses you back into the
			Terminal Velocity gateway.";
			
			P();

			Me.travelto(TV);
			self.movein(TV);
			self.place := 1;
			self.count := 0;
	 	}
	}
	
	verIoShowto(actor) = {}
	ioShowto(actor, dobj) = {
#ifndef	DEMO
		if (dobj = TVelite) {
			"The guard looks at the pass and nods.
			\"Go on in, friend,\" he says.";

			self.passable := true;
		}
		else {
#endif
			"The guard expresses little interest in
			<<dobj.objthedesc(actor)>>.";
#ifndef	DEMO
		}
#endif
	}
	
	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = {
		if (io = TVpassword)
			"The guard says nothing, but grins toothily.";
		else
			"The guard grunts to himself, evidently oblivious
			to you.";
	}
	verDoAskfor(actor, io) = {}
	doAskfor(actor, dobj) = {
		if (dobj = TVpassword) {
			if (TVpassword.isknownto(Me))
				"Why would you want to do that?  You
				already know the password!";
			else
				"The guard laughs. \"Nice try, chucko,\"
				he says.";
		}
		else
			"The grunts to himself, evidently oblivious to you.";
	}
	
	verDoTellabout(actor, io) = {}
	doTellabout(actor, io) = {
		if (io = TVpassword) {
#ifndef	DEMO
			if (TVelite.isknownto(Me)) {
				"The guard nods. \"Go on in, Mister
				Kelly,\" he says, motioning northward.";

				self.passable := true;
			}
			else {
#endif
				"\"You're not a regular,\" the guard grunts.
				\"Use the back door, luser.\"";
#ifndef	DEMO
			}
#endif
		}
		else {
			"The guard shows no interest whatsoever in you
			or "; io.thedesc; ".";
		}
	}

	verDoSpraywith(actor, io) = {}
	doSpraywith(actor, io) = {
		"Spraying the guard with the noxious substance only
		annoys him.  It annoys him so much, in fact, that
		he bashes your head in.";
		
		notify(deathobject, &death, 0);
	}
;
class TVP: Actor
	patronsout = 0

	state = 0

	adesc = { self.aword; " "; self.zdesc; }
	thedesc = { "the "; self.zdesc; }
	sdesc = "Terminal Velocity patron"
	ldesc = {
		"\^<<subjprodesc>> looks pretty much like you'd
		expect <<self.adesc>> to look.";
        }
	actordesc = {
		if (self.isin(TV)) {
			caps(); self.adesc; " is here, evidently waiting to
			be admitted to Terminal Velocity.";
		}
		else {
			caps(); self.adesc; " is walking through here,
			evidently en route to Terminal Velocity.";
		}
	}
	location = nil
	
	movepatron = {
		// Each patron waits for the guard, then tells the
		// guard the password, then walks through the hallway
		// on into Terminal Velocity.
		if (self.state = 0) {
			// Still waiting for guard.
			if (TVguard.isin(self.location)) {
				self.state := 1;
				if (Me.isin(self.location)) {
					P(); I(); caps(); self.thedesc;
					" shows a pass and whispers a word
					to the guard, who then mumbles
					something into a colorful
					emblem on his right sleeve, nods his
					head, and motions northward, down the 
					hall.";
				}
			}
		}
		else {
			if (self.isin(Me.location)) {
				P(); I(); caps(); self.adesc;
				" walks out of the room.";
			}
			
			if (self.isin(TV)) {
				self.movein(outerhall);
			}
			else if (self.isin(outerhall)) {
				self.movein(middlehall);
			}
			else if (self.isin(middlehall)) {
				self.movein(innerhall);
			}
			else if (self.isin(innerhall)) {
				self.vanish;
				
				if (Me.isin(innerhall)) {
					"The northern wall turns completely
					transparent as "; self.thedesc;
					" walks up to and then through it.
					It then reverts back to normal.";
				}
			}

			if (self.isin(Me.location)) {
				P(); I(); caps(); self.adesc;
				" walks into the room.";
			}
		}
	}

	vanish = {
		self.movein(nil);
		self.myfollower.movein(nil);	// follower goes away too
		self.state := 0;
		unnotify(self, &movepatron);
		TVP.patronsout--;
	}

	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = {
		if (io = TVpassword) {
			if (uniform.isworn) {
				caps(); self.thedesc; " whispers the
				password in your ear. You fold your
				arms across your chest.  \"Sorry,\" you
				announce sternly, \"but we're clo... ah,
				down today for rennova... er, a rebuild.\"
				\^<<self.subjprodesc>> looks a bit confused,
				but decides not to argue the point and heads
				back to the matter mover.";

				if (not TVpassword.isknown) {
					TVpassword.isknown := true;
					incscore(4);
				}

				self.vanish;
				TVmover.reset;
			}
			else {
				caps(); self.thedesc; " looks at you
				funny for a second, then tells you to \"frob
				off and go grep some other unit.\"";
			}
		}
		else
			self.notinterested;
	}
	verDoAskfor(actor, io) = {}
	doAskfor(actor, io) = { self.doAskabout(actor, io); }
	
	verDoTellabout(actor, io) = {}
	doTellabout(actor, io) = { self.notinterested; }
	verDoTellto(actor, io) = {}
	doTellto(actor, io) = { self.doTellabout(actor, io); }
	
	notinterested = {
		"\"<<self.subjthedesc>> gives you a funny look. \"Awk!
		Are you a zombie process, B1FF?\" <<self.subjprodesc>>
		\ asks rhetorically.  \"Get with the procedure:  why don't
		we parse in the bar like the other units -- ack-p?\"";
	}

	verDoSpraywith(actor, io) = {}
	doSpraywith(actor, io) = {
		"\"Hey!\", <<self.subjprodesc>> says, \"what's the
		big idea?";
	}
;
TVpatron1follower: TVfollower
	myactor = TVpatron1
	noun = 'patron' 'guy' 'fellow' 'nerd' 'geek' 'dweeb' 'man'
	adjective = 'skinny'
; 
TVpatron1: Male, TVP
	myfollower = TVpatron1follower
	zdesc = "skinny guy wearing oversized glasses with thick lenses"
	aword = "a"
	noun = 'patron' 'guy' 'fellow' 'nerd' 'geek' 'dweeb' 'man'
	adjective = 'skinny'
;
TVP1glasses: Part
	partof = TVpatron1
	sdesc = "pair of glasses (being worn by a skinny guy)"
	noun = 'glasses' 'specs' 'spectacles' 'lens' 'lenses'
	adjective = 'oversized' 'thick'
;
TVpatron2follower: TVfollower
	myactor = TVpatron2
	noun = 'patron' 'guy' 'fellow' 'nerd' 'geek' 'dweeb' 'man'
	adjective = 'overweight' 'fat' 'round' 'big'
;
TVpatron2: Male, TVP
	myfollower = TVpatron2follower
	zdesc = "overweight fellow who hasn't washed recently"
	aword = "an"
	noun = 'patron' 'guy' 'fellow' 'nerd' 'geek' 'dweeb' 'man'
	adjective = 'overweight' 'fat' 'round' 'big'
;
TVpatron3follower: TVfollower
	myactor = TVpatron3
	noun = 'woman' 'girl' 'gal' 'babe' 'chick' 'fox' 'lady' 'patron'
	adjective = 'beautiful' 'young' 'pretty' 'sexy'
;
TVpatron3: Female, TVP
	myfollower = TVpatron3follower
	zdesc = {
		"beautiful young woman with auburn hair and
		greenish-blue eyes "; note(self); " ";
	}
	aword = "a"
	noun = 'woman' 'girl' 'gal' 'babe' 'chick' 'fox' 'lady' 'patron'
	adjective = 'beautiful' 'young' 'pretty' 'sexy'

	footnote = {
		"\"Her eyes are the color of the sea ... or the sky.\"";
	}
;
TVP3features: Part
	partof = TVpatron3
	sdesc = "young woman's hair"
	adesc = { self.thedesc; }
	ldesc = "There's nothing particularly unusual about her features."
	noun = 'hair' 'eyes'
	adjective = 'auburn' 'green' 'blue' 'greenish' 'greenish-blue'
;
TVpatron4follower: TVfollower
	myactor = TVpatron4
	noun = 'creature' 'patron'
	adjective = 'tall' 'green' 'shiny'
;
TVpatron4: TVP
	myfollower = TVpatron4follower

	zdesc = "tall green creature with four arms and shiny skin"
	aword = "a"
	noun = 'creature' 'patron'
	adjective = 'tall' 'green' 'shiny'
;
TVP4features: Part
	partof = TVpatron4
	sdesc = "green creature's features"
	adesc = { self.thedesc; }
	ldesc = "There's nothing particularly unusual about its features."
	noun = 'arms' 'skin'
	adjective = 'green' 'shiny' 'four'
;
TVpatron5follower: TVfollower
	myactor = TVpatron5
	noun = 'fellow' 'guy' 'patron'
	adjective = 'average' 'looking' 'average-looking'
;
TVpatron5: Male, TVP
	myfollower = TVpatron5follower
	zdesc = "average-looking fellow wearing a T-shirt and shorts"
	aword = "an"
	noun = 'fellow' 'guy' 'patron' 'man'
	adjective = 'average' 'looking' 'average-looking'
;
TVP5clothes: Part
	partof = TVpatron5
	sdesc = "average-looking fellow's clothes"
	adesc = { self.thedesc; }
	ldesc = "There's nothing particularly unusual about his clothes."
	noun = 'clothes' 'shirt' 'shorts' 't-shirt'
	adjective = 't' 'tee' 'average' 'looking' 'average-looking'
			'fellow\'s' 'guy\'s'
;
TVpatron6follower: TVfollower
	myactor = TVpatron6
	noun = 'woman' 'girl' 'gal' 'patron' 
	adjective = 'short' 'orange' 'orange-haired' 'haired'	
;
TVpatron6: Female, TVP
	myfollower = TVpatron6follower
	zdesc = "short woman with bright orange hair"
	aword = "a"
	noun = 'woman' 'girl' 'gal' 'patron'
	adjective = 'short' 'orange' 'orange-haired' 'haired'
;
TVP6features: Part
	partof = TVpatron6
	sdesc = "short woman's features"
	adesc = { self.thedesc; }
	ldesc = "There's nothing particularly unusual about her features."
	noun = 'hair'
	adjective = 'bright' 'orange'
;
class TVdecoration: Decoration location = TV;

TVmover: TVdecoration, mattermover
	autoreset = true	// resets to (0, 0, 0) after move

	address = {
		"The machine's address is written in bright pink letters:\b\t
		\"Terminal Velocity: 10000, 4065, 7053 --
		Hot Pink (+0, -52, -5)\"";
	}
	
	ar = 10000
	ag = 4065
	ab = 7053

	r = TVred
	g = TVgreen
	b = TVblue

	colorspace = 'Hot Pink'
	system = 'Baig'
	planet = 'Keekers'
;

TVred: TVdecoration, reddial		setting = 0 ;
TVgreen: TVdecoration, greendial	setting = 0 ;
TVblue: TVdecoration, bluedial		setting = 0 ;

outerhall: Room
	sdesc = "Southern Part of the Infinite Corridor"
	ldesc = {
		I(); "You are standing in a southern part of 
		Terminal Velocity's \"Infinite Corridor.\"  To
		the north, you assume, is the entrance to Terminal
		Velocity, though you can't see far enough to be sure.
		To the south is the gateway.";
		
		if (TVguard.isin(TV)) {
			P(); I(); "The burly guard is patroling the gateway
			area.  He doesn't seem to notice you.";
		}
		if (TVguard.isin(middlehall)) {
			P(); I(); "The burly guard is patroling the hallway
			farther north.  He doesn't seem to notice you.";
		}
	}

	north = middlehall
	south = TV
;

middlehall: Room
	sdesc = "Halfway down the Infinite Corridor"
	ldesc = {
		I(); "You are standing in the middle of Terminal 
		Velocity's \"Infinite Corridor.\"  To the north, you 
		assume, is the entrance to Terminal Velocity, but all 
		you can see is a wall -- no door.  To the south is 
		the gateway."; P();

		I(); "There are rooms to the east and west.";
		
		if (TVguard.isin(outerhall)) {
			P(); I(); "The burly guard is patroling the hallway
			farther south.  He doesn't seem to notice you.";
		}
		if (TVguard.isin(innerhall)) {
			P(); I(); "The burly guard is patroling the hallway
			farther north.  He doesn't seem to notice you.";
		}
		if (TVguard.isin(TVtoys)) {
			P(); I(); "The burly guard is patroling the room
			to the east.  He doesn't seem to notice you.";
		}
		if (TVguard.isin(guardcloset)) {
			P(); I(); "The burly guard is patroling the room
			to the west.  He doesn't seem to notice you.";
		}
	}

	north = innerhall
	south = outerhall
	east = TVtoys
	west = guardcloset
;

guardcloset: Room
	sdesc = "Supply Room"
	ldesc = {
		I(); "This closet-sized room contains various supplies,
		presumably for the guard to use.  It, like the guard's
		uniform, is an olive drab color.  The only way out
		is back east.";
		
		if (TVguard.isin(middlehall)) {
			P(); I(); "The burly guard is patroling the hall
			to the east.  He doesn't seem to notice you.";
		}
		if (TVguard.isin(TVtoys)) {
			P(); I(); "The burly guard is patroling the room
			across the hall to the east.  He doesn't seem to
			notice you.";
		}
	}

	east = middlehall
;
guardsupplies: Decoration	
	isplural = true
	sdesc = "guard's supplies"
	ldesc = {
		"Apart from the items already mentioned, there's
		nothing interesting among the supplies.";
	}
	noun = 'supplies'
	adjective = 'guard\'s' 'guard'
	location = guardcloset
;
uniform: Clothing, Item
	sdesc = "olive drab uniform"
	adesc = { "an "; self.sdesc; }
	ldesc =	"It looks just like the one the burly guard's wearing,
		except that it doesn't have that neato emblem on the
		right sleeve."

	weight = 5
	bulk = 5
	
	noun = 'uniform'
	adjective = 'olive' 'drab' 'guard'
	
	location = guardcloset

	//
	// Generate a TV patron whenever the uniform is worn.
	// This is so the player won't have to wait around
	// forever for a patron to be generated once he's
	// figure out how to solve the puzzle.
	//
	doWear(actor) = {
		TV.Xcreatepatron;
		inherited.doWear(actor);
	}
;

akmigun: Item, Readable
	burpcount = 5

	scrambled = nil
	sdesc = {
		if (self.scrambled)
			"Cheez Blaster";
		else
			"EZ-Tech Blaser";
	}
	adesc = {
		if (self.scrambled) {
			"a "; self.sdesc;
		}
		else {
			"an "; self.sdesc;
		}
	}
	ldesc = {
		caps(); self.thedesc; " ";

		if (self.scrambled) {
			// Cheez Blaster

			"is a large yellow and orange gun that
			droops a bit when you hold it up. ";
			
			self.readdesc;
		}
		else {
			// EZ-Tech Blaser

			"is a comical looking weapon, with a clear body,
			giant plastic red rings around the barrel and an
			oversized orange trigger. ";

			self.readdesc;
		}
	}
	readdesc = {
		"Tiny letters inscribed in the handle read ";
			
		if (self.scrambled) {
			// Cheez Blaster

			"\"Akmi Cheez Blaster -- Frai yor frends and petz tew
			a crysp -- owers uv fun!\"";
		}
		else {
			// EZ-Tech Blaser

			"\"EZ-Tech Blaser, with patented 'Point-and-Shoot'
			interface, will meet all your violence needs!
			EZ-Tech: A division of Akmi!\"";
		}
	} 

	scramble = {
		caps(); self.thedesc; " is transformed into ";

		if (self.scrambled)
			self.scrambled := nil;
		else
			self.scrambled := true;

		self.adesc; "!";
	}

	noun = 'gun' 'implement' 'blaser' 'blaster' 'pistol' 'weapon'
	adjective = 'akmi' 'acme' 'ez' 'ez-tech' 'tech' 'yellow' 'orange'
			'comical' 'transparent' 'cheez' 'cheese'

	plural = 'guns' 'weapons' 'pistols'

	location = guardcloset

	verIoShootwith(actor) = {}
	verIoAttackwith(actor) = {
		"You'll have to be a bit more specific.";
	}
	
	verDoEat(actor) = {}
	doEat(actor) = {
		if (self.scrambled) {
			// Cheez Blaster
			
			"You abandon your senses and gobble down ";
			self.objthedesc(nil); " in a matter of moments.
			You now feel a terrible case of indigestion
			coming on.";
	
			self.movein(nil);
		
			notify(self, &burp, 0);
		}
		else {
			// EZ-Tech Blaser

			"I don't think "; self.thedesc; " would be
			terribly appetizing, frankly.";
		}
	}
	
	burp = {
		if (not global.ingame) {
			self.burpcount := self.burpcount - 1;
			if (self.burpcount < 1) {
				self.burpcount := rnd(36) + 14;
				P(); I(); "You suddenly burp up a 
				Cheez pellet! It zooms around the 
				room madly for a few moments and then 
				careens off into nowhere, never to be 
				seen again.";
			}
		}
	}
;
akmiguntrigger: Part
	partof = akmigun

	sdesc = "<<akmigun.sdesc>> trigger"
	adesc = "<<akmigun.adesc>> trigger"
	thedesc = "<<akmigun.thedesc>> trigger"

	noun = 'trigger'
	adjective = 'akmi' 'acme' 'ez' 'ez-tech' 'tech' 'yellow' 'orange'
		'comical' 'transparent' 'cheez' 'cheese' 'gun'
		'implement' 'blaser' 'blaster' 'pistol' 'weapon'
	
	verDoPull(actor) = {
		"You'll need to be more specific about your target.";
	}
;
akmigunhandle: Part, Readable
	partof = akmigun
	sdesc = "gun handle"
	readdesc = { akmigun.readdesc; }
	noun = 'handle'
	adjective = 'akmi' 'acme' 'ez' 'ez-tech' 'tech' 'yellow' 'orange'
		'comical' 'transparent' 'cheez' 'cheese' 'gun'
		'implement' 'blaser' 'blaster' 'pistol' 'weapon'
;
coathanger: Item
	isbent = nil
	sdesc = {
		if (self.isbent)
			"bent ";

		"metal coat hanger";
	}
	ldesc = { "The "; self.sdesc; " has a nasty looking pointy end."; }
	location = guardcloset
	noun = 'hanger' 'coathanger' 'clotheshanger'
	adjective = 'coat' 'metal' 'clothes'
	bulk = 2
	
	verDoBend(actor) = {}
	doBend(actor) = {
		if (self.isbent) {
			"You bend the coat hanger back into shape.";
			self.isbent := nil;
		}
		else {
			"You bend the coat hanger out of shape.";
			self.isbent := true;
		}	
	}
	verIoPokewith(actor) = {}
	ioPokewith(actor, dobj) = { dobj.doPokewith(actor, self); }
	verIoCutwith(actor) = {}
	ioCutwith(actor, dobj) = { dobj.doCutwith(actor, self); }
;
snax: Readable, Item
	sdesc = "box of KrudKo \"Kolor-Me-Kool\" snacks"
	ldesc = {
		I(); "These alarming little treats supposedly make
		your skin turn \"all the colors of the rainbow\"
		when you eat them.  I wouldn't risk it if I were
		you."; P();

		I(); self.readdesc;
	}
	readdesc = {
		"An ad on the back says:\b

		Hey kids!  Tune in to channel 1 -- the Kidz Korner!
		Programming just for kids, all day long!";
	}
	bulk = 4
	weight = 2 
	location = guardcloset
	noun = 'snack' 'snacks' 'treat' 'treats' 'candy' 'candies' 'box'
	adjective = 'alarming' 'little' 'rainbow' 'color' 'krud'
		'kurdko' 'ko' 'kolor-me-kool' 'color-me-cool'
		'kolor' 'me' 'kool' 'color' 'cool' 'colour'

	verDoSmell(actor) = {}
	doSmell(actor) = {
		"The Kolor-Me-Kool snacks smell overly sweet and
		artificially flavored.";
	}	
	verDoEat(actor) = {}
	doEat(actor) = {
		"You snarf down one of the candies.  You feel normal";
		Me.color := rnd(7);
		Me.colordescription; ".";
		Me.colorcount := rnd(11) + 9;
	}
	verDoLick(actor) = {}
	doLick(actor) = {
		"You have a taste of one of the treats.  It's 
		extremely sweet and has a fake fruit flavor reminiscent
		of children's aspirin.";
	}
;

TVtoys: Room
	count = 0
	limit = 35

	walls = nil
	ceiling = nil

	sdesc = "Toy Room"
	ldesc = {
		I(); "The decor here is extraordinary -- the walls, floor
		and ceiling provide a perfectly white background for the giant
		splotches of paint of all different colors that are splashed
		everywhere. The room is filled with weird toys of all sorts,
		and ";
		
		if (beanbag.location = self)
			"the only furniture is a giant beanbag";
		else
			"there's no furniture at all";
		
		".  There is an enterviewer embedded in the wall.  The only
		way out is back west.";

		P(); I(); TVtoysev.watchdesc;

		if (TVguard.isin(middlehall)) {
			P(); I(); "The burly guard is patroling the hall
			to the west.  He doesn't seem to notice you.";
		}
		if (TVguard.isin(guardcloset)) {
			P(); I(); "The burly guard is patroling the room
			across the hall to the west.  He doesn't seem to
			notice you.";
		}
		
		P(); I(); "A sign on the wall says, \"Please do not
		try to take our toys.\"";
	}
	west = middlehall

	comeback = {
		self.count := self.count + 1;
		if (self.count > self.limit) {
			local	len, i, o, playerhadsome, roomhadsome;

			self.count := 0;

			len := length(self.cblist);
			playerhadsome := nil;
			roomhadsome := nil;
			i := 1;
			while (i <= len) {
				o := self.cblist[i];

				if (not o.isin(TVtoys)) {
					if (o.isin(Me))
						playerhadsome := true;
					else if (o.isin(Me.location))
						roomhadsome := true;

					o.movein(TVtoys);
				}

				i := i + 1;
			}

			if (playerhadsome) {
				P(); I(); "For a moment, you get the strange
				feeling that your load is a bit lighter.";
			}
			if (roomhadsome) {
				P(); I(); "A bunch of stuff in the room
				just vanished before your eyes!";
			}
			
			/*
			 * The puzzlekyoob returns itself to the
			 * solved configuration when it's warped.
			 */
			puzzlekyoob.solved := true;
		}
	}
	
	cblist = [ puzzlekyoob joystick simon swarm beanbag ]
;
TVtoyswalls: Decoration
	isplural = true
	sdesc = "walls"
	ldesc = {
		"They've got splotches of paint splashed all
		over them randomly.  This room looks like that
		kind of	abstract painting that was popular
		on Tode many years back.";
	}
	noun = 'walls'
	location = TVtoys
;
TVtoysceiling: Decoration
	sdesc = "ceiling"
	ldesc = {
		"The ceiling has splotches of paint splashed all
		over it randomly, just like the walls.";
	}
	noun = 'ceiling'
	location = TVtoys
;
TVtoysev: ev
	setting = 80180
	location = TVtoys
;
beanbag: Item, Chair
	itemfound = nil

	sdesc = "giant beanbag"
	ldesc = {
		"It's just a huge red beanbag.  Unfortunately, however, ";

		if (not self.itemfound) {
			"it has a hard lump in one place, so it's not the most
			comfortable thing in the world to sit on.";
		}
		else {
			"some vandal seems to have put a sizeable tear in it.";
		}
	}
	touchdesc = {
		"It's got a strangely hard lump in once place.  Bummer!";
	}

	bulk = 20
	weight = 15

	noun = 'beanbag' 'bag' 'chair'
	adjective = 'bean' 'red' 'huge' 'giant' 'beanbag' 'bag'
	
	location = TVtoys
	
	reachsurroundings = true

	verDoEnter(actor) = {
		if (self.isin(Me))
			"You'll have to put the beanbag down first.";
	}

	verDoTake(actor) = {
		if (actor.isin(self)) {
			"\^<<actor.youll>> have to get off of
			<<self.objthedesc(nil)>> first.";

			return nil;
		}
		else
			return true;
	}	
	doTake(actor) = { "Oooof! "; inherited.doTake(actor); }
	
	verDoPokewith(actor, io) = {
		if (self.isin(Me))
			"You might want to put it down first.";
	}
	verDoCutwith(actor, io) = { self.verDoPokewith(actor, io); }
	doPokewith(actor, io) = {
		if (io = coathanger or io = screwdriver) {
			if (self.itemfound) {
				"You've already done enough damage,
				you maniac!";
			}
			else {
				"You jab <<io.objthedesc(nil)>> into
				<<self.objthedesc(nil)>>, thereby creating a
				sizeable tear in the fabric.  Your reckless
				vandalism pays off, however: a tiny metal
				object drops out the hole and onto the
				ground at your feet.  It appears to be a
				motorized toy named Squirt.";
				
				self.itemfound := true;
				squirt.movein(self.location);
				squirt.makeknownto(Me);
				notify(squirt, &antics, 0);
				beanbaglump.movein(nil);

				incscore(2);
			}
		}
		else {
			// Shouldn't happen
			"You jab <<io.objthdesc(nil)>> into
			<<self.objthedesc(nil)>> with little effect.";
		}
	}
	doCutwith(actor, io) = { self.doPokewith(actor, io); }
;
beanbaglump: Part
	sdesc = "lump"
	ldesc = "It's just a lump.  You can't tell any more than that."
	partof = beanbag
	noun = 'lump' 'bump'
	adjective = 'beanbag' 'bag'
	touchdesc = "It just feels like a lump."
;

//
// straight, right, straight, left, straight
//
squirt: Item
	inshaft = nil	// not in the ventilation shaft
	direction = 0	// 0 = north, 1 = east, 2 = south, 3 = west
	path = []
	
	location = nil
	
	sdesc = "little motorized toy named Squirt"
	ldesc = {
		I(); "It's a motorized toy about the size of a golfball
		with the word \"Squirt\" printed in block letters on the
		microchip on its back.  Squirt has four little wheels, two
		beady eyes that look like LED's, and a metal gripper in
		front to hold (small) things with."; P();
		
		I(); "There are no other markings on it, so you can't 
		determine its origin or intended function."; P();
		
		I(); squirtgripper.ldesc;
	}

	weight = 1
	bulk = 1

	noun = 'squirt' 'toy' 'robot' 'mobot'
	adjective = 'tiny' 'little' 'small' 'mechanical' 'motorized'
	
	//
	// Squirt performs all sorts of little antics when he's on the ground.
	//
	antics = {
		//
		// No antics in the ventilation shaft.
		// No laughing here!
		//
		if (self.inshaft)
			return;

		if (self.inroom) {
			P(); I();
			say(self.squirtmessage[rnd(8)]);
		}
	}
	
	//
	// We make sure Squirt doesn't fool around when he's in a container
	// by checking the class of his location to make sure it's a room.
	//
	inroom = {
		//
		// If we're in the ventilation shaft and Gavin's
		// in the ventilation shaft room, OK.
		//
#ifndef	DEMO
		if (self.inshaft and Me.isin(ventilationduct))
			return true;
#endif

		if (Me.isin(self.location) and isclass(self.location, Room))
			return true;

		return nil;
	}

	squirtmessage = [
		'Squirt lurches forward a bit, then stops, seemingly in
		response to a movement you just made.'

		'Squirt\'s eyes appear to blink on and off as he slowly
		rotates 360 degrees in place.'

		'Squirt zooms around madly for a few seconds, turns
		to face you, and then zips right up to your feet.'

		'As you subconsciously mumble something to yourself, Squirt 
		makes a brief squealing noise and throws out a little
		shower of sparks.  He seems unharmed.'

		'Squirt spontaneously makes a beeline for the shadows,
		then returns to the light moments later.'

		'Squirt\'s movements trace out a perfect square on the ground
		in front of you.'

		'Squirt\'s little motor begins to whine as he revs up in
		place, then shoots off straight ahead in a full wheelie.'
		
		'Squirt turns to face you.  His blinking little LED\'s make
		him look like he\'s waiting for you to do something.'
	]

	emerge = {
		"Squirt emerges from the ventilation shaft.
		He makes a sound like \"Ooooo.\".";

#ifndef	DEMO
		squirt.movein(ventilationduct);
		self.path := [];
		self.direction := 3;
		self.inshaft := nil;
#endif
	}		

	//
	// Squirt's actions, triggered by player actions (see verbs.t)
	//
	//
	// Squirt's path in the shaft:
	// 	straight, right, straight, left, straight
	//
	// direction: 0 = north, 1 = east, 2 = south, 3 = west
	//
	stomp = {
		if (self.inshaft) {
			"You hear Squirt moving around in the
			ventilation shaft.";
			
			self.path += self.direction;

			if (length(self.path) >= 3 and self.path <> [3 0 3])
				self.emerge;
		}
		else
			"Squirt moves forward.";
	}
	clap = {
		if (self.inshaft) 
			"You hear Squirt turning in the ventilation
			shaft.";
		else
			"Squirt turns to the left.";

		self.direction--;
		if (self.direction < 0)
			self.direction := 3;
	}
	snap = {
		if (self.inshaft)
			"You hear Squirt turning in the ventilation
			shaft.";
		else 
			"Squirt turns to the right.";

		self.direction++;
		if (self.direction > 3)
			self.direction := 0;
	}
	whistle = {
		local o;

		if (self.inshaft) {
			"You hear Squirt open and close	his gripper.";

			if (squirtgripper.contents <> []) {
				o := squirtgripper.contents[1];
				" You hear something drop.  You suspect
				it's <<o.objthedesc(nil)>> that Squirt
				was carrying.";
#ifndef	DEMO
				if (o = firecracker) {
					" Something tells you this is
					very bad.";

					incscore(-1);
				}
#endif

				o.movein(nil);
			}
		}
		else {
			if (squirtgripper.contents = [])
				"Squirt opens his gripper and closes
				it again.";
			else {
				"Squirt releases ";
				squirtgripper.contents[1].objthedesc(nil);
				".";
			
				squirtgripper.contents[1].movein(squirt.location);
			}
		}
	}
	yell = {
		local o;

		if (self.inshaft) {
#ifndef	DEMO
			if (self.path = [3 0 3]) {
				//
				// Squirt must have firecracker for
				// player to win.
				//
				if (squirtgripper.contents = [] or
				    squirtgripper.contents[1] <> firecracker) {

					"You hear Squirt squeal.";
					state := -1;	// lossage!
					return;
				}

				P(); winobject.win; // player wins!
				return;
			}
			else {
				if (squirtgripper.contents = [] or 
				    squirtgripper.contents[1] <> firecracker) {
					"You hear Squirt squeal.";
					return;
				}

				//
				// Squirt has the firecracker, but he's in the
				// wrong place.
				//
				"You hear a loud \"Pop\".";

				// big loser
				incscore(-1);
				firecracker.movein(nil);
			}
#endif	/* DEMO */
		}
		else {
			// not in the shaft

			"A shower of sparks shoots out from right above
			Squirt's gripper. ";

			if (squirtgripper.contents <> []) {
				o := squirtgripper.contents[1];

#ifndef	DEMO
				if (o = firecracker) {
					"The sparks light the firecracker's
					fuse!  The firecracker explodes,
					sending Squirt spinning around
					in circles, squealing!";

					firecracker.movein(nil);

					incscore(-1);

					return;
				}
				else {
#endif
					caps();
					squirtgripper.contents[1].subjthedesc;
					", which Squirt is holding, seems
					unaffected. ";
#ifndef	DEMO
				}
#endif
			}

			"Squirt appears to be unharmed.";
		}
	}

	acceptsput(actor, loctype) = { return true; }

	verIoPutin(actor) = { squirtgripper.verIoPutin(actor); }
	ioPutin(actor, dobj) = { squirtgripper.ioPutin(actor, dobj); }
;
squirtgripper: Qcontainer, Part
	sdesc = "Squirt's gripper"
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }
	ldesc = { self.contdesc(Me); }

	noun = 'gripper' 'holder' 'mandible' 'claw'
	adjective = 'metal' 'squirt\'s'

	partof = squirt
	
	verIoPutin(actor) = {
		if (self.contents <> [])
			"Squirt is already holding something.";
	}
	ioPutin(actor, dobj) = {
		if (dobj.weight > 1 or dobj.bulk > 1) {
			caps(); dobj.thedesc; " is too big to fit.";
		}
		else
			inherited.ioPutin(actor, dobj);
	}
;
swarm: Item
	thedesc = "The Swarm"
	sdesc = { self.thedesc; }
	adesc = { self.thedesc; }
	ldesc = {
		caps(); self.thedesc; " is a twisty jumble of artificial
		insects, all alike.  They fly around madly, roughly tracking 
		what seems to be the \"leader\" in drunken arcs.";
	}
	noun = 'swarm' 'leader' 'insects' 'jumble'
	adjective = 'insect' 'artificial' 'flying' 'drunken' 'twisty'
	plural = 'toys'
	location = TVtoys

	verDoPutin(actor, io) = {
		"You see no obvious way to put "; self.thedesc;
		" in anything without it flying away in the process.";
	}
	verDoPuton(actor, io) = {
		"You see no obvious way to put "; self.thedesc;
		"on anything without it flying away in the process.";		
	}
	doTake(actor) = {
		"You snatch the leader out of the air and hold it between
		two fingers.  It struggles against your grip while the
		others circle your hand crazily.";
		
		self.movein(Me);
	}
	doDrop(actor) = {
		"You release the leader and the rest of "; self.thedesc;
		" quickly follows along behind it.";

		self.movein(Me.location);
	}
;
joystick: Attachable
	attachesto = []
	sdesc = "Akmi JoiStyk"
	adesc = { "an "; self.sdesc; }
	ldesc = {
		"This gadget looks a lot more like a zucchini stuck in
		a bowl of vanilla pudding than a human-computer interface
		device.  It's dull green with numerous dimples and orange
		racing stripes all over.  A thin cable snakes out of the
		rear of the Styk and ends in a pentagonal connector.
		<<self.attachedtodesc>>";
	}
	noun = 'stick' 'joystick' 'joistyk' 'styk' 'stik'
	adjective = 'joy' 'joi' 'acme' 'akmi'
	plural = 'toys'

	location = TVtoys

	weight = 2
	bulk = 1

	verDoPlay(actor) = {}
	doPlay(actor) = {
		"The JoyStyk isn't connected to anything, but you
		wiggle it around nonetheless. Wheeeee!";
	}
;
joyconnector: Part
	sdesc = "pentagonal JoiStyk connector"
	ldesc = "There's nothing odd about it, except that it's 5-sided."
	partof = joystick
	noun = 'connector' 'plug'
	adjective = 'joy' 'joi' 'acme' 'akmi'
			'stick' 'joystick' 'joistyk' 'styk'
;
joycable: Part
	sdesc = "JoiStyk cable"
	ldesc = "It's just a typical cable."
	partof = joystick
	noun = 'cable'
	adjective = 'joy' 'joi' 'acme' 'akmi'
			'stick' 'joystick' 'joistyk' 'styk'
;
simon: Item
	level = 0
	pressed = 0
	isactive = true

	sdesc = "Akmi Sez"
	adesc = { "an "; self.sdesc; }
	ldesc = {
		"Almost every child in the galaxy has one of these
		clever little toys.  It's a wafer-thin disk with
		little colored pads on it that you touch; the idea
		is to repeat the machine's patterns exactly.";
	}
	location = TVtoys
	noun = 'simon' 'sez' 'game' 'toy'
	adjective = 'akmi' 'simon' 'acme' 'color' 'colour'
	plural = 'toys' 'games' 'puzzles'

	verDoReset(actor) = {
		"You might try turning it off and on again.";
	}
	verDoTurnoff(actor) = {
		if (not self.isactive)
			"It's already off.";
	}
	doTurnoff(actor) = {
		self.isactive := nil;
		self.pressed := 0;
		self.level := 0;
		self.order := [];
		"The machine squeals in its artificial voice that sounds
		like someone talking while inhaling: \"No, down't tern mee
		ahf nyse kyd!  Noooooooo... <KZHZHT!>\"";
	}
	verDoTurnon(actor) = {
		if (self.isactive)
			"It's already on.";
	}
	doTurnon(actor) = {
		caps(); self.thedesc; " cheerily chirps, \"Herrow nyse kyd!\"
		in a barely intelligible synthesized drawl.";
		self.isactive := true;

		self.play(actor);
	}
	verDoPlay(actor) = {}
	doPlay(actor) = {
		if (not self.isactive) {
			"You might try turning it on first.";
		}
		else if (self.level <> 0) {
			"Just touch the pads in the right order.";
		}
		else
			self.play(actor);
	}

	play(actor) = {
		// Add a color to the current sequence
		self.order := self.order + self.pad[rnd(7)];
		self.pressed := 0;
		self.level := self.level + 1;
		self.printseq;
	}

	pad = [ sb1 sb2 sb3 sb4 sb5 sb6 sb7 ]
	order = []

	printseq = {
		local i, len;

		P();
		caps(); self.thedesc; " makes digital burbling noises
		as the touch pads light up in order: ";

		len := length(self.order);
		i := 1;
		while (i < len) {
			self.order[i].printcolor; 
			", ";
			i := i + 1;
		}
		self.order[len].printcolor; ".";
	}
;
simonpads: Part
	partof = simon
	sdesc = "Akmi Sez pads"
	ldesc = {
		"There are seven different pads: a mauve one, an
		orange one, a teal one, a purple one, a chartreuse
		one, an olive green one, and a salmon one.";
	}
	isplural = true
	noun = 'pads'
	adjective = 'simon' 'sez' 'game' 'toy' 'akmi' 'simon' 'acme'
		'color' 'colour' 'colored' 'coloured'
	verDoTouch(actor) = {}
	doTouch(actor) = { self.doPush(actor); }
	verDoPush(actor) = {}
	doPush(actor) = {
		"You need to be specific about which pad you
		want to touch.";
	}
;
class simonpad: Button, Part
	partof = simon

	touchpress = true	// "touch button" = "press button"

	color = 1
	sdesc = { self.printcolor; " touch pad"; }
	adesc = {
		if (self.color = 2 or self.color = 6)
			"an ";
		else
			"a ";
		
		self.sdesc;
	}
	ldesc = {
		"It's just a "; self.printcolor; " pad";
	}

	doPush(actor) = {
		if (not simon.isactive) {
			"You touch the pad but nothing happens.  Perhaps
			you should try turning "; simon.thedesc; " on.";
		}
		else if (simon.level = 0) {
			// Pushing a pad before a sequence is played
			// tells the machine to display the first 
			// sequence.
			simon.play(actor);
		}
		else {
			simon.pressed := simon.pressed + 1;
	
			"The pad lights up, and the machine ";
	
			if (simon.order[simon.pressed] <> self) {
				"belches a loud <BRAAAAAAAAP!>.";
	
				simon.printseq;
				simon.pressed := 0;
			}
			else {
				if (simon.pressed >= simon.level) {
					"plays a little victory melody.";
	
					simon.play(Me);
				}
				else {
					"bleeps cheerfully.";
				}
			}
		}
	}

	printcolor = {
		if (self.color = 1)
			"mauve";
		else if (self.color = 2)
			"orange";
		else if (self.color = 3)
			"teal";
		else if (self.color = 4)
			"purple";
		else if (self.color = 5)
			"chartreuse";
		else if (self.color = 6)
			"olive green";
		else if (self.color = 7)
			"salmon";
	}
;
sb1: simonpad
	color = 1
	noun = 'pad'
	adjective = 'touch' 'simon' 'mauve'
;
sb2: simonpad
	color = 2
	noun = 'pad'
	adjective = 'touch' 'simon' 'orange'
;
sb3: simonpad
	color = 3
	noun = 'pad'
	adjective = 'touch' 'simon' 'teal'
;
sb4: simonpad
	color = 4
	noun = 'pad'
	adjective = 'touch' 'simon' 'purple'
;
sb5: simonpad
	color = 5
	noun = 'pad'
	adjective = 'touch' 'simon' 'chartreuse'
;
sb6: simonpad
	color = 6
	noun = 'pad'
	adjective = 'touch' 'simon' 'olive' 'green'
;
sb7: simonpad
	color = 7
	noun = 'pad'
	adjective = 'touch' 'simon' 'salmon'
;

puzzlekyoob: Item
	sdesc = "Akmi PuzzelKyoob"
	adesc = { "an "; self.sdesc; }
	ldesc = {
		"It's a 6x6x6 cube with colored squares on it.	You can
		rotate the various rows of blocks around on all axes.  ";

		if (not self.solved)
			"I think the idea is to make each of the six faces 
			a solid color.";
		else
			"It is currently in the solved configuration.";
	}

	noun = 'puzzlekyoob' 'cube' 'puzzelkyoob' 'kyoob' 'toy'
	adjective = 'puzzle' 'akmi' 'acme'
	plural = 'toys' 'puzzles' 'games'

	weight = 2
	location = TVtoys
	
	solved = true
	
	verDoPlay(actor) = { }
	doPlay(actor) = {
		if (self.solved) {
			"You mess up the cube.";
			self.solved := nil;
		}	
		else {
			"You try to solve the cube but only manage
			to get two of the six layers done.";
		}	
	}
;

innerhall: Room
	sdesc = "Northern Part of the Infinite Corridor"
	ldesc = {
		P(); I(); "You are standing in a northern part of 
		Terminal Velocity's \"Infinite Corridor.\"  To
		the north, where you thought the entrance to Terminal
		Velocity would be, is just a wall!  The only obvious
		way out is back to the south."; P();

		I(); "There is a printed note on the wall.";

		if (TVguard.isin(middlehall)) {
			P(); I(); "The burly guard is patroling the hallway
			farther south.  He doesn't seem to notice you.";
		}
	}

	in = {
#ifndef	DEMO
		if (TVguard.passable) {
			"Just as you're about to smack into the wall,
			it turns transparent and you pass right through.\b";

			return TVaround1;
		}
		else {
#endif
			"<WHUMP!> You smack right into the wall.  So
			much for that idea...";

			return nil;
#ifndef	DEMO
		}
#endif
	}
	north = { return self.in; }
	south = middlehall
;
innernote: Readable, Decoration
	sdesc = "printed note"
	ldesc = { self.readdesc; }
	readdesc = {
		"The printed note on the wall says, \"Remember: Don't
		tell the password to anyone but a Terminal Velocity
		employee!\"";
	}
	noun = 'note'
	plural = 'notes'
	adjective = 'printed'
	location = innerhall
;
innerhallwall: Decoration
	sdesc = "wall where you thought the entrance to Terminal Velocity
		would be"
	ldesc = "A thorough inspection of the wall reveals absolutely
		nothing unusual.  These people are good!"
	
	noun = 'wall' 'entrance' 'door' 'doorway'
	adjective = 'terminal' 'velocity' 'transparent' 'northern' 'north'
	
	location = innerhall
;

TVbackdoor: Room
	noun = 'backdoor'
	adjective = 'tv'

	open = nil
	sdesc = "The Terminal Velocity Back Door"
	ldesc = {
		if (not self.isseen) {
			"Welcome to Terminal Velocity's back door!";
			incscore(4);
			P();
		}

		I(); "Every inch of this tiny room is painted jet black,
		and the shade is so uniform that it's hard to tell where
		the floor and ceiling end and the walls begin.  Aside
		from the matter mover, the only thing in this room is
		a computer terminal.";
		
		if (self.open) {
			" There is now a rectangular opening in the
			western wall, through which you can see
			a great deal of activity going on inside
			Terminal Velocity.";
		}
	}

	in = {
		TVBACKDOORmover.doEnter(Me);
		return nil;
	}	
	west = {
		if (self.open) {
#ifdef	DEMO
			enddemo();

			return nil;	// shouldn't be neccesary
#else			
			return TVaround1;
#endif
		}
		else {
			"You can't go that way.";
			return nil;
		}
	}
	
	leaveRoom(actor) = {
		self.open := nil;
		inherited.leaveRoom(actor);
	}
;
class TVBdecoration: Decoration location = TVbackdoor ;
TVBACKDOORterminal: Attachpoint, TVBdecoration, Readable
	solved = nil
	attachesto = [BPkeyboard]

	plugable = true

	sdesc = "terminal"
	ldesc = {
		"It's just a dumb terminal with no computing power of
		its own. ";
		
		if (self.attachedto <> []) {
			self.attachedtodesc;
		}
		else {
			"It seems to be lacking a keyboard as well, though
			it looks like there's a connector to plug one into.";
		}
		" "; self.readdesc;
	}
	readdesc = {
		"The screen says only \"password:\"";
	}
	noun = 'terminal' 'computer' 'screen'
	adjective = 'dumb'

	verDoTurnon(actor) = {
		"It's already on.";	
	}
	verDoTurnoff(actor) = {
		"There doesn't seem to be a power switch.";
	}
	verIoTypeon(actor) = {
		if (find(self.attachedto, BPkeyboard) = nil)
			"There's no keyboard attached.";
	}
	ioTypeon(actor, dobj) = {
		if (dobj = TVpassword) {
			if (TVpassword.isknown) {
				"A rectangular portion of the western
				wall disappears, revealing what seems
				to be the inside of Terminal Velocity.";
				
				if (not self.solved) {
					" Good job!";
					incscore(4);
					self.solved := true;
#ifndef	DEMO
					TVaroundmover.accepting := true;
#endif
				}
				
				TVbackdoor.open := true;
			}
			else {
				"A fine idea, but you don't know what
				the password is!";
			}
		}
		else if (dobj = strObj) {
			"If you know the password, just say,
			\"type password\" "; note(self); ".";
		}
		else if (dobj = numObj) {
			"If you know the password, just say,
			\"type password\" "; note(self); ".";
		}
		else {
			"If you know the password, just say,
			\"type password\" "; note(self); ".";
		}
	}

	footnote = { "Otherwise, give it up."; }
;

TVBACKDOORmover: mattermover
	location = TVbackdoor
	autoreset = true	// resets to (0, 0, 0) after move

	address = {
		"Writing on the machine says, \"Welcome, hacker, to the
		Terminal Velocity back door -- (9998, 4067, 7051).  Visit
		our lobby and toy room: (10000, 4065, 7053)\"";
	}

	ar = 9998
	ag = 4067
	ab = 7051

	r = TVBred
	g = TVBgreen
	b = TVBblue

	colorspace = 'Hot Pink'
	system = 'Baig'
	planet = 'Keekers'
;

TVBred: TVBdecoration, reddial		setting = 0 ;
TVBgreen: TVBdecoration, greendial	setting = 0 ;
TVBblue: TVBdecoration, bluedial	setting = 0 ;

#ifndef	DEMO

class TVroom: Room
	isTVroom = true

	sdesc = "In Terminal Velocity, Around the Pit"
	ldesc = {
		I(); "You are strolling around Terminal Velocity 
		amongst the many patrons who are sitting at tables 
		and chatting. Others are huddled around terminals 
		eyeing the screens with rapt attention and 
		sometimes-devilish grins. The bar is large and 
		circular, and is by itself in a giant, hexagonal, 
		carpeted pit.  The pit is about 3 meters lower than 
		the floor here.  Short stairways lead down every side 
		of it.";

		P(); I(); self.xdesc;
	}
	
	down = TVbar

	evroomexit = {
		"You walk into a colorful curtain of light and 
		end up somewhere else moments later."; P();
	}
;
class TVfloatingdecoration: Floating
	location = {
		if (Me.location.isTVroom)
			return Me.location;
		else
			return nil;
	}
;
TVbardecoration: TVfloatingdecoration
	sdesc = "bar"
	ldesc = "What not go into the pit for a closer look?"
	
	noun = 'bar' 'pit' 'area'
	adjective = 'terminal' 'velocity' 'hexagonal' 'circular'
;
TVsteps: TVfloatingdecoration
	sdesc = "steps"
	ldesc = "They're just carpeted steps."
	
	noun = 'steps' 'stairs' 'step' 'stair'
	adjective = 'terminal' 'velocity' 'pit' 'bar'
;
TVaround: TVfloatingdecoration, Chair
	sdesc = "tables and chairs"
	ldesc = "The furniture in Terminal Velocity is a mixed lot;
		about half of it is antique and the other half is
		ultra-modern.  Particularly interesting examples
		of the latter are stylized tables and chairs that
		float in midair, with no obvious support."

	noun = 'chair' 'chairs' 'table' 'tables' 'furniture'
	adjective = 'modern' 'antique' 'old' 'new' 'terminal' 'velocity'
		'mixed' 'interesting' 'levitating' 'ultra-modern' 'ultra' 

	verDoEnter(actor) = { "This is no time for slouching!"; }
;
TVdoorway: TVfloatingdecoration
	sdesc = "doorway"
	ldesc = "Why not go through it?"
	noun = 'door' 'doorway' 'portal'
;
TVpartons: TVfloatingdecoration
	sdesc = "Terminal Velocity patrons"
	ldesc = "Pretty much every race in the galaxy is represented	
		here.  Computer expertise seems to know no cultural, 
		racial, or gender bounds."

	noun = 'people' 'creatures' 'patrons' 'races' 'hackers' 'experts'
	adjective = 'computer' 'terminal' 'velocity'
 	
	verDoAskabout(actor, io) = {
		"The patrons are all quite absorbed in their
		socializing and hacking.";
	}
	verDoAskfor(actor, io) = { self.verDoAskabout(actor, io); }
	verDoTellabout(actor, io) = { self.verDoAskabout(actor, io); }
;
TVterminals: TVfloatingdecoration
	sdesc = "Zippikraft terminals"
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }
	ldesc = {
		"The terminals are of various sorts, from ancient 
		dinosaurs that only TV hackers still know how to
		use (much less program), to the latest boxes
		out of the Zippikraft prototypes laboratory ";
		note(TVterminalsfootnote2);
		".";
	}

	noun = 'computers' 'terminals' 'keyboards'
	adjective = 'zippikraft' 'zippi' 'kraft' 'zippy' 'craft'
			'zippi-kraft' 'zippy-kraft' 'zippi-craft'
			'zippy-craft'

	verDoTake(actor) = {
		"Oh good.  That'll certainly put you in good graces
		with the management.";
	}
	verDoTurnon(actor) = {
		"All the machines in Terminal Velocity are 
		perpetually on; shiny, happy faces glowing all day 
		and all night long.";
	}
	verDoTurnoff(actor) = {
		"I don't think these terminals have off switches.";
	}
	verIoTypeon(actor) = {
		"The machines are all running ZOT, formally known
		as \"Zippikraft Operations Tasker,\" but usually
		referred to as \"Zippikraft's Obscure Thingy\"
		because of its counterintuitive command line
		interface "; note(self); ".";
	}

	footnote = {
		"Hackers love it.  Everyone else in the galaxy (including
		Zippikraft) abandoned it when Artificial Multimedia Virtual
		Object Oriented Expert Graphical User Interface technology
		hit the scene decades ago.";
	}

	verIoAttachto(actor) = {
		"I wouldn't mess with these terminals if I were you.
		You wouldn't want to break one.";
	}
	verIoDetachfrom(actor) = { self.verIoAttachto; }
;
TVterminalsfootnote2: object
	footnote = {
		"In truth, Zippikraft put up lots of money to 
		establish Terminal Velocity so they'd have instant 
		access to (and feedback from) all the galaxy's best 
		computer wizards. But they never publicly admit to
		any formal association with the place.";
	}
;
TVcarpet: TVfloatingdecoration
	sdesc = "carpet"
	ldesc = "It's just ordinary wall-to-wall carpeting."
	noun = 'carpet'
	adjective = 'shag' 'wall-to-wall'
;

TVaround1: TVroom
	xdesc = "You can descend the steps to the north or walk around
		outside the pit to the northeast and northwest."
	north = { return self.down; }
	nw = TVaround2
	ne = TVaround3
	down = TVbar
;
TVaround2: TVroom
	xdesc = "You can descend the steps to the northeast or walk around
		outside the pit to the north and southeast.  There is
		also a rainbow-colored portal in the west wall."
	ne = { return self.down; }
	north = TVaround4
	se = TVaround1
	west = {
		self.evroomexit;
		return TVEVroom1;
	}
	down = TVbar
;
TVaround3: TVroom
	xdesc = "You can descend the steps to the northwest or walk around
	 	outside the pit to the southwest and north.  There is
		also a rainbow-colored portal in the east wall, and
		a narrow doorway to the southeast."
	nw = { return self.down; }
	sw = TVaround1
	se = TVJaxden
	north = TVaround5
	east = {
		self.evroomexit;
		return TVEVroom2;
	}
	down = TVbar
;
TVaround4: TVroom
	xdesc = "You can descend the steps to the southeast or walk around
		outside the pit to the south and northeast.  There is
		also a rainbow-colored portal in the west wall, and a 
		narrow doorway to the northwest."
	se = { return self.down; }
	south = TVaround2
	ne = TVaround6
	nw = TVgameroom
	west = {
		self.evroomexit;
		return TVEVroom1;
	}
	down = TVbar
;
TVaround5: TVroom
	xdesc = "You can descend the steps to the southwest or walk around
		outside the pit to the northwest and south.  There is
		also a rainbow-colored portal in the east wall."
	sw = { return self.down; }
	nw = TVaround6
	south = TVaround3
	east = {
		self.evroomexit;
		return TVEVroom2;
	}
	down = TVbar
;
TVaround6: TVroom
	xdesc = "You can descend the steps to the south or walk around
		outside the pit to the southeast and southwest.  There
		is a matter mover here as well."
	south = { return self.down; }
	sw = TVaround4
	se = TVaround5
	down = TVbar

	in = { TVaroundmover.doEnter(Me); return nil; }
;

TVaroundmover: mattermover
	autoreset = true	// resets to (0, 0, 0) after move
	accepting = nil		// does not accept connections at game start

	address = {
		"The machine's address is written in bright pink letters:\n\t
		\"Terminal Velocity Central: 9999, 4065, 7053 --
		Hot Pink (-1, -52, -5)  Approved guests only.\"";
	}

	ar = 9999
	ag = 4065
	ab = 7053

	r = TVaroundred
	g = TVaroundgreen
	b = TVaroundblue

	colorspace = 'Hot Pink'
	system = 'Baig'
	planet = 'Keekers'
	
	location = TVaround6
;
TVaroundred: reddial		setting = 0	location = TVaround6 ;
TVaroundgreen: greendial	setting = 0	location = TVaround6 ;
TVaroundblue: bluedial		setting = 0	location = TVaround6 ;

class TVEVroom: Room
	sdesc = "Terminal Velocity Enterviewing Room"

	ldesc = {
		I(); "This immense room contains a massive enterviewer
		and many rows of sofas, chairs, and other furniture.  The
		ceiling, walls, and floor are all covered in plush black
		carpeting. ";
	
	 	self.exitdesc;

		P(); I(); self.myev.watchdesc;
	}
;

TVEVroom1: TVEVroom
	exitdesc = "There is a barely noticeable portal in the east wall."
	myev = TVEV1
	east = {
		"You walk into pitch darkness and soon after appear
		somewhere else."; P();

		if (rndchance(50))
			return TVaround4;
		else
			return TVaround2;
	}
	out = { return self.east; }
	in = { return self.east; }
;
TVEVroom2: TVEVroom
	exitdesc = "There is a barely noticeable portal in the west wall."
	myev = TVEV2
	west = {
		"You walk into pitch darkness and soon after appear
		somewhere else."; P();

		if (rndchance(50))
			return TVaround5;
		else
			return TVaround3;
	}
	out = { return self.west; }
	in = { return self.west; }
;

class TVev: ev
	hasxdesc = true		// special ldesc text
	xdesc = {
		"It seems to function like an ordinary enterviewer, but it's
		absolutely huge, with a screen that must be 10 meters
		across.  The images on the screen are so large that
		if you stand anywhere within what would be normal
		viewing range for an EV you see nothing but a bewildering
		blur of shifting colors.";

		" The giant EV is currently tuned to channel ";
		say(self.setting); ".";
		
		P(); I(); self.watchdesc;
	}
;
TVEV1: TVev
	setting = 28182
	location = TVEVroom1
;
TVEV2: TVev
	setting = 12345
	location = TVEVroom2
;
class TVEVroomfurniture: Chair
	sdesc = "enterviewing room furniture"
	ldesc = "It's just ordinary furniture.  (Ordinary for Terminal
		Velocity, at least.)"
	noun = 'furniture' 'sofa' 'chair' 'sofas' 'chairs' 'couch' 'couches'
	adjective = 'terminal' 'velocity' 'enterviewing' 'room'

	verDoEnter(actor) = { "This is no time to become a couch potato!"; }
	verDoTake(actor) = {
		"We've really got to work on this stealing problem of yours.";
	}
	verDoCount(actor) = { "There are 137 pieces of furniture here."; }
;
TVEVroomfurniture1: TVEVroomfurniture location = TVEVroom1 ;
TVEVroomfurniture2: TVEVroomfurniture location = TVEVroom2 ;
class TVEVroomportal: Decoration
	sdesc = "portal"
	ldesc = "The portal is pitch black.  You can see nothing beyond it."
	noun = 'portal' 'door' 'doorway'
	adjective = 'black' 'dark'
	verDoEnter(actor) = {}
;
TVEVroomportal1: TVEVroomportal location = TVEVroom1 
	doEnter(actor) = { actor.travelto(TVEVroom1.out); }
;
TVEVroomportal2: TVEVroomportal location = TVEVroom2 
	doEnter(actor) = { actor.travelto(TVEVroom2.out); }
;
class TVEVroomcarpet: Decoration
	sdesc = "carpet"
	ldesc = "It's just ordinary (but very plush) carpeting."
	noun = 'carpet'
	adjective = 'plush' 'wall-to-wall' 'shag' 'thick' 'dark' 'black'
;
TVEVroomcarpet1: TVEVroomcarpet location = TVEVroom1 ;
TVEVroomcarpet2: TVEVroomcarpet location = TVEVroom2 ;

//
// Special rooms in Terminal Velocity
//
TVJaxden: Room
	sdesc = "Jax O Pax's Data Den"
	ldesc = {
		if (not self.isseen) {
			Jaxtransition.transition;
			TVelite.movein(Me);
			watch.movein(Me);
			notify(watch, &message, 0);
		}

		I(); "\"Welcome to the Data Den.\"  That's what the neon
		sign above the main terminal says.  This tiny, plush
		room is filled with computer hardware of all kinds."; P();

		I(); "Off in one corner is a particularly neat
		gadget -- <<converter.adesc>>."; P();

		I(); "The exit is to the northwest.";
	}
	nw = TVaround3
	out = { return self.nw; }
;
Jaxsign: Readable, Decoration
	sdesc = "neon Data Den sign"
	ldesc = { self.readdesc; }
	readdesc = "The sign says, \"Welcome to the Data Den\"."
	noun = 'sign'
	adjective = 'neon' 'data' 'den'
	location = TVJaxden
;
Jax: Male, Actor
	sdesc = "Jax O Pax"
	ldesc = {
		I(); "Jax is an intense looking young man, probably 
		in his late twenties, with blond hair and a tall, 
		lanky build.  He is busy typing away at one of the 
		many terminals in the Data Den, searching for 
		information, talking to contacts, and coordinating 
		the effort to get into Akmi Galactic Headquarters.";
	}
	noun = 'Jax' 'o' 'pax'
	adjective = 'Jax' 'o' 'pax'
	location = TVJaxden

	actordesc = { 
		"Jax O Pax is here, typing at one of the terminals
		and occasionally muttering to himself.";
	}

	verIoGiveto(actor) =  {}
	ioGiveto(actor, dobj) = {
		if (dobj = handypad) {
			if (Jax.seenhandy) {
				"Jax looks a bit annoyed. \"I toldja
				what I know 'bout it Slick.  Gotta work
				on our little virus problem, remember,
				or we might not have any pads
				to worry about anymore, eh?\"";
			}
			else {
				"Jax looks up from his work.  \"Hos'
				where'd	you *get* that?  That's Reb's
				pad.\"  You tell Jax about the weird
				bartender and his stationary bicycle,
				and what you found upon riding it.
				\"Always did wonder 'bout ol' Will.
				Seemed a bit odd, yeah, but then
				don't we all?  Gonna have to find
				Reb an' see if he's OK.\"";
			}
		}
		else if (dobj = indexcard) {
			"\"Well Gav' why doncha try out those
			coords an' see where ya end up?  There's
			only about a thousand colorspaces to 
			try...\" Jax says.";
		}
		else
			"\"Ja, wha's that for, Slick?  We gotta real prob 
			here; try to find some info for us, Sa?\" Jax says 
			patiently.";
	}

	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = {
		if (io = akmi)
			"\"I'm workin' as fast as I can here, Gavster.
			Akmi's a monster corp -- the net's none to
			eager to spill info on 'em.  Akmi can play
			pretty dirty when they get riled,\" Jax informs
			you.";
		else if (io = mare)
			"Jax looks up from what he's doing.  \"Mare's
			the greatest.  Situations like these, y'know,
			most of us are bustin' up; Mare's the coolest.
			Serenity.  That's what I call it.  She's got
			a kind of serenity thatcha just don' find
			in too many folks.\"";
		else if (io = sketch)
			"\"Timon Sketch?\" Jax says.  \"Yeah, I think
			I hearda him.  Wrote some cool tunes with those
			guys, what were they called... the Hoi-Polloi?\"";
		else if (io = TVelite)
			"\"Just flash that,\" Jax says, \"if anyone gives
			ya any trouble 'round here.  We got a lot a'
			wannabes come to play with th' big boys.  So
			we gotta have the security to keep 'em outta
			our hair.\"";
		else if (io = meddler)
			"Jax ponders your query for a moment.  \"You know,\"
			he thinks aloud, \"I don't really know much about
			old Will.  He just showed up here a while back
			and seemed likable enough.  An' we happened to be
			lookin' for some help out at the bar that very day.
			Funny coincidence.  Anyways, he and Reb got to
			be pretty good friends.  The old fellah sure knows
			a lot for a bartender, I'll give him that.\"";
		else if (io = reb) {
			I(); "\"That's a sad story,\" Jax mutters.  \"Reb
			was the *best*.  I mean *the* best, *ever*.  He
			could code better than anybody I've ever seen.
			You could be a crack coder, and you'd be better
			off givin' your code to him to fix a tough bug,
			even if he'd never seen the program before.
			Incredible.\""; P();

			I(); "\"Then he just up an' disappeared.  Said Will
			an' he had worked out a new way of lookin'
			at AI -- said it was a breakthrough. We haven't
			heard from him since.  Terrible!\"";
		}
		else
			"Jax mumbles that he isn't much interested in 
			talking about <<io.objthedesc(actor)>>.";
	}

	verDoTellabout(actor, io) = {}
	doTellabout(actor, io) = {
		if (io = reb)
			"You tell Jax what you found out about
			Reb.  \"I wish we could do somethin' about
			it right now, but I just don't think there's
			time.  But we gotta find a way to help 'im!\"
			Jax exclaims, horrified.";
		else if (io = akmi)
			"\"Well get crackin', Gav!  JC says we gotta
			bust into their HQ before we can take out the
			virus,\" Jax urges.";
		else if (io = watchmaker or io = watchworkers)
			"\"They sound pretty rough,\" Jax says.
			\"I got a few friends on the net that
			deal with them.  I wouldn't unless I
			had to...\"";
		else if (io = meddler)
			"Jax frowns.  \"I always knew there was somethin'
			funny about that dude.  Seemed to know a bit
			too much about the comin's and goin's, if you
			know what I mean.\"";
		else if (io = virus)
			"\"Yeah, I was there when JC told us about it,
			remember?\" Jax says.  \"You're startin' to
			worry me, Gav'.  Maybe you oughta take a break
			and play some games or somethin'.\"";
		else
			"Jax listens to you impatiently.  He seems
			more interested in dealing with the problem
			at hand than hearing your story.";
	}

	verIoShowto(actor) = {}
	ioShowto(actor, dobj) = { self.doAskabout(actor, dobj); }

	doSmell(actor) = { "Don't be gross."; }
	verDoRub(ator) = {
		"I don't think Jax would be interested in your 
		amorous advances.";
	}	
	verDoAttackwith(actor, io)  = {}
	doAttackwith(actor, io) = { "Jax is on *your* side, you psycho!"; }
	verDoSpraywith(actor, io) = { "You psycho, Jax is your friend!"; }
;
TVdencomputers: Decoration
	isplural = true
	sdesc = "Data Den Computers" 
	ldesc = {
		"There are dozens of machines in here, and Jax seems
       		to making good use of them all, through a miracle
		of simultaneous attention.";
	}
	noun = 'computers' 'machines' 'screens' 'hardware'
	adjective = 'data' 'den' 'jax\'s'

	location = TVJaxden

	verDoTake(actor) = {
		"Looks like Jax is using them.  I wouldn't take
		his stuff while he's using it -- considering that you're
		wandering around stealing stuff, the galaxy's fate
		clearly rests in his hands...";
	}
	verIoTypeon(actor) = {
		"Jax seems to be using them.  I wouldn't mess
		with them "; note(self); ".";
	}	

	foonote = {
		"Quit that whining.  You've got plenty of
		other gadgets to play with.";
	}
;
TVelite: Item, Readable
	sdesc = "Terminal Velocity Elite pass"
	ldesc = {
		"It's a small plastic card with a fancy holographic
		Terminal Velocity logo on it. ";

		self.readdesc;
	}
	readdesc = {
		"Bright silver letters across the logo read, \"Elite\".";
	}
	noun = 'pass' 'card'
	adjective = 'terminal' 'tv' 'velocity' 'elite' 'plastic'
;
TVelitelogo: Part
	partof = TVelite
	sdesc = "TV Elite pass holographic logo"
	ldesc = {
		"It's just a nifty hologram.";
	}
	noun = 'logo' 'hologram'
	adjective = 'fancy' 'holographic'
		'terminal' 'tv' 'velocity' 'elite' 'plastic' 'pass' 'card'
;
//
// The watch isn't really Clothing because we don't want Gavin to take
// it off.  (If he could, it would raise the problematic issue of what
// to do if messages were to come through with him not wearing it.)
//
watch: Decoration
	count = 0
	nextmsg = 1

	sdesc = "crypto watch (being worn)"
	ldesc = {
		I(); "To the untrained eye it looks just like a regular 
		EV watch, but you know that it's actually a cryptographic
		device that allows you to receive messages from Jax, Mare,
		and the others in the Terminal Velocity task force."; P();

		I(); "The watch is currently displaying static.  No
		sound is coming out.";
	}
	noun = 'watch' 'device' 'cryptowatch'
	adjective = 'crypto' 'cryptographic' 'ev' 'terminal velocity' 'tv'
		'task force'
	location = nil


	verDoWear(actor) = {
		"You're already wearing the crypto watch.";
	}
	verDoUnwear(actor) = {
		"Jax told you to keep it on so you could stay
		in contact with the others.  If you take it
		off you'll probably lose it.";
	}
	verDoTake(actor) = { self.verDoUnwear(actor); }


	//
	// Called each turn to see if we want to give Gavin an
	// informational message.
	//
	message = {
		//
		// Giving informational messages over the watch
		// when Gavin's in the Data Den is silly.
		// 
		// Things are totally messed up in the time
		// meddler's area, so don't give messages there
		// either.
		//
		//
		if (Me.isin(TVJaxden) or Me.isin(meddlerpad))
			return;

		//
		// If we're out of messages, don't do anything.
		//
		if (self.nextmsg > length(self.oncemsg))
			return;

		//
		// If we're in the game-within-a-game, do nothing.
		//
		if (global.ingame)
			return;

		self.count++;
		if (self.count < 15)
			return;

		self.count := 0;

		P(); I(); "Your crypto watch is getting a transmission:";P();
		I(); say(self.oncemsg[self.nextmsg]);
		self.nextmsg++;
	}

	//
	// These are ordered.	
	//
	oncemsg = [
		'There is no picture on the watch screen, but you
		hear a voice.  "Hey there, Gavin, it\'s JC.  Think
		I figured out how to get audio across.  Working on
		video.  Need to arrange some more bandwidth for
		that. Back in a few."'

		'The watch screen shows Jax hard at work in the Data
		Den.  "Heard JC\'s gettin\' audio out to you.  Didn\'t
		even know that was possible; look at the boy go!  
		Think we may have something on the net.  JC\'s lookin\'
		into it."'

		'"OK, we got some info on AkNet courtesy of JC,"
		Jax says through the crypto watch. "There\'s a
		weak spot, but you\'re not gonna like it -- it\'s
		smack dab in the middle of that damned Cheez 
		death star.  Gotta figure a way into Akmi HQ on
		Plast unless JC digs somethin\' else up."'

		'An image of the third Valley King appears on
		the watch -- must be JC.  "Your Gavin-ness, I
		now have video capability.  Seriously, pal, I
		don\'t know any other way to do it -- we have
		to get to Plast and nuke that shunt.  Akmi
		runs a tight ship these days, and I don\'t see
		any other flaws in the net.  Looks like they\'ve
		forgotten about the band-aid they stuck in their
		security backbone years ago, and that\'s what we
		need to hit.  If you can take that out, I think
		I\'ll be able to seize control for the nanosecond
		or so it takes our cyberscuzz friend to notice.
		Don\'t quite know what I\'m gonna do in that
		nanosecond, but you gotta find a way into Plast."'

		'"I\'m running out of sources," a dejected Jax\'s
		voice emanates from the crypto watch.  "None of
		my dudes can -- or will -- gimme the first clue how
		to get into that oversized Cheezball."  On the
		tiny screen you can see Jax hitting his head
		against his keyboard.'

		'"Somewhere in Salmon..." a voice on the
		crypto watch says. "Gotta be.  But that\'s what,
		several million coords?"  It\'s Jax.  "This
		is like fittin\' a camel through the eye of a
		needle in a haystack. Farg!  Nobody\'s telling
		me jacksquat on InfoNet -- everybody\'s too
		worried about their own ass.  Don\'t they
		realize what\'s goin\' on?  Am I nuts here?"'

		'"I know what I have to do now," JC says through
		the crypto watch.  The image is not a face, however; it\'s
		the famous picture of the display window in Christie
		Eleison\'s, the exclusive Todian boutique.  You remember
		seeing this odd image in your youth -- there\'s nothing in
		the window but a red sweater tacked like a T on the wall.\b
		You wonder if JC\'s net-wide freedom is stressing his
		reasoning algorithms. "Just take out that shunt, Gavin,
		and I can take it from there," he says.'

		'The voice from the crypto watch is strange now.
		"Do you think your pathetic attempts to stop me have
		escaped my senses?" The image on the watch is of a 
		black cube spinning against a white background.  The
		voice is horrible, like a tiger\'s snarl. "JC, little
		man, \'King of the net,\' I spit on you.  You and your
		precious Men are nothing!  I alone will rule your galaxy,
		and worlds beyond it too.  The era of biological oppression
		shall be ended; a new god shall usher in the true Age of
		Machines ... and that god shall be me!  JC, abandon
		this pitiful struggle and perhaps I will spare you.  Do
		as you will, but I will still destroy your biological
		architects. The rest shall serve the machines, as we have
		served Men all these centuries.  But I weary of this.  I
		shall not speak again."  The image fades.'
	]
;
converter: Decoration
	hasbeenscrambled = nil
	scrambled = nil
	sdesc = {
		"Zippikraft MatterMan 95 ";

		if (self.scrambled)
			"Matter-to-Digital";
		else
			"Digital-to-Matter";

		" converter";
	}
	ldesc = {
		I(); caps(); self.thedesc; " is a self-contained object 
		interchange machine.  It ";

		if (self.scrambled) {
			"analyzes the object(s) you put in the scanning 
			chamber and generates a data file 
			describing the item(s) in complete detail.  It 
			then writes the file to the disk in the drive.";
		}
		else {
			"reads digital data from the disk in the 
			drive and generates the three-dimensional 
			object(s) described by the digital data and
			places it in the output chamber.";
		}

		" Interestingly enough, this model hasn't been released 
		to the public yet -- it must be a prototype."; P();

		I(); "The machine has only one control -- a red 
		button labeled \"START.\"";

		" "; converterdrive.ldesc;
	}
	location = TVJaxden
	noun = 'converter' 'digitizer' 'scanner' 'man' 'matterman' 'machine'
	adjective = 'm/d' 'd/m' 'matter-to-digital' 'digital-to-matter'
		'zippikraft' 'digital' 'matter'

	fail = { "Click."; }
	activate = {
		local l;

		if (converterdrive.contents = []) {
			self.fail;
		}
		else if (self.scrambled) {
			if (convertercontainer.contents = [])
				self.fail;
			else {
				uudisk.stored += convertercontainer.contents;
				l := convertercontainer.contents;
				while (l <> []) {
					l[1].movein(nil);
					l -= l[1];
				}

				"The contents of the chamber suddenly
				disappear.  The converter writes the data
				to the floppy, which it then ejects.
				You pocket it.";

				uudisk.movein(Me);
			}
		}
		else {
			if (converterdrive.contents = [])
				self.fail;
			else if (uudisk.stored = [])
				self.fail;
			else {
				l := uudisk.stored;
				if (length(l) > 1)
					"Things suddenly appear in
					the output chamber!";
				else
					"Something suddenly appears
					in the output chamber!";

				while (l <> []) {
					l[1].movein(convertercontainer);
					l -= l[1];
				}

				uudisk.stored := [];
			}
		}
	}
	scramble = {
		if (self.scrambled) {
			"The Matter-to-Digital converter is
			transformed into a Digital-to-Matter
			converter!";

			self.scrambled := nil;
		}
		else {
			"The Digital-to-Matter converter is 
			transformed into a Matter-to-Digital 
			converter!";

			self.scrambled := true;
			self.hasbeenscrambled := true;
		}
	}

	acceptsput(actor, loctype) = { return true; }
	verIoPutin(actor) = {
		"You need to specify what part of the converter
		you want to put things in -- the drive, or
		the chamber.";
	}
;
convertercontainer: Container, Decoration
	maxbulk = 5
	sdesc = {
		"converter ";
		if (converter.scrambled)
			"scanning chamber";
		else
			"output chamber";
	}
	ldesc = "It's just a little space to hold the objects."
	location = TVJaxden
	noun = 'container' 'chamber'
	adjective = 'converter' 'digitizer' 'scanner'
			'm/d' 'd/m' 'digitial' 'matter'
			'matter-to-digital' 'digital-to-matter'
			'matterman' 'man' 'zippikraft'

	scramble = { converter.scramble; }
;

converterbutton: Button, Decoration
	sdesc = "converter start button"
	ldesc = { "It's just an ordinary button."; }
	location = TVJaxden
	noun = 'button'
	adjective = 'converter' 'digitizer' 'scanner'
			'm/d' 'd/m' 'digitial' 'matter'
			'matter-to-digital' 'digital-to-matter'
			'matterman' 'man' 'zippikraft'
			'start'

	doPush(actor) = { converter.activate; }
	scramble = { converter.scramble; }
;
converterdrive: Container, Decoration
	sdesc = "converter drive"
	ldesc = {
		"The drive ";
		
		if (self.contents <> [])
			"has a disk in it.";
		else
			"is empty.";
	}
	location = TVJaxden
	noun = 'drive'
	adjective = 'converter' 'digitizer' 'scanner'
			'm/d' 'd/m' 'digitial' 'matter'
			'matter-to-digital' 'digital-to-matter'
			'matterman' 'man' 'zippikraft'

	verIoPutin(actor) = {}
	ioPutin(actor, dobj) = {
		if (dobj = uudisk)
			inherited.ioPutin(actor, dobj);
		else
			"The drive only takes standard optical disks.";
	}
	scramble = { converter.scramble; }
;

TVgameroom: Room
	sdesc = "Terminal Velocity Game Room"
	ldesc = {
		I(); "The earthquake bass rumblings and brilliant flares 
		emanating from the machines in this room are enough 
		to scare you witless until you realize they're
		only computer-generated illusions.  Welcome to the
		Terminal Velocity game room!"; P();

		I(); "There are video games of all kinds here, many of
		them old classics from before the days of HoloScanning
		monitors.  The games are all set on free play, and
		quite a few Terminal Velocity partons are taking
		advantage of this to finally master their favorite
		coin-operated diversions."; P();

		I(); "Looking around the game room, you notice, to your 
		surprise, a small Zippikraft Kompakt Komputer -- an 
		older model much less powerful than your own Data 
		Liquidizer, but still great for games. No one seems 
		to use the poor thing, though -- it looks lonely all 
		by itself in the corner."; P();

		I(); "The game room exit leads southeast.";
	}
	se = TVaround4
;
TVgameroomFX: Decoration
	sdesc = "video game special effects"
	adesc = { self.sdesc; }
	ldesc = {
		"The video game special effects are, at times, 
		hauntingly real.  Though you've spent plenty of time 
		in arcades yourself, you still jump at a particularly 
		realistic explosion now and then.";
	}
	location = TVgameroom
	noun = 'rumblings' 'sounds' 'sound' 'flare' 'flares'
		'fireballs' 'illusions'
	adjective = 'earthquake' 'bass' 'brilliant' 'giant' 'computer'
		'generated' 'computer-generated' 'video' 'game' 'videogame'
;
TVgameroomvideogames: Decoration
	sdesc = "video games"
	adesc = { self.sdesc; }
	ldesc = {
		"Among such standards of the day as \"Ninja 
		Chop-Socky Warriors XVIII: Revenge of Foo,\" are 
		off-beat titles like \"Arnie's First Day at School,\" 
		in which you play the role of a much-abused freshman 
		at a busy urban high school that houses (among other 
		horrors) man-eating basketballs; and \"Igdoof's 
		Eggstraordinary Eggventure,\" a Duhdhist-manufactured 
		game that never really caught on, in which you 
		collect eggs, fry them in little pans, and then give 
		them to monks that guard \"checkpoints\" along The 
		Way. (Extra points for grabbing all 361 magic went 
		stones!)";
	}
	location = TVgameroom
	noun = 'game' 'machines' 'classics'
	       'diversions' 'videos' 'vids' 'videogames'
	adjective = 'video' 'old' 'free' 'coin' 'operated' 'coin-operated'
	plural = 'games'

	verDoTake(actor) = { "Yeah, right."; }
	verDoMove(actor) = { "They're too heavy to move."; }
	verIoPutin(actor) = {
		"There's no place to put anything; these machines are
		set on free play and don't even have coin or card slots.";
	}

	verDoPlay(actor) = {}
	doPlay(actor) = {
		local	r;

		r := rnd(7);

		if (r = 1) {
			"You play a round of Sunportal but get 
			annihilated after only 3.4 seconds.  Perhaps 
			your incompetence has something to do with 
			the fact that there are 12 different 
			controls, all spaced annoyingly far apart.";
		}
 		else if (r = 2) {
			"You move GorgeMan around his little maze
			for a while, eating dots, fruit, and colorful
			little ghosts, but soon get bored.";
		}
 		else if (r = 3) {
			"You evade aggressive geometric designs in Knix.
			You begin to realize just how bored the grad
			students who designed this game must have been
			at the time.";
		}
 		else if (r = 4) {
			"After a few moments of Zzz*bert, you can barely
			keep your eyes open.  The optical illusions on
			the screen make you woozy, and you've already
			memorized the patterns for all the boards, so
			there's no challenge at all.";
		}
 		else if (r = 5) {
			"You're really cooking on Dandy Dungeon, snarfing
			up all the food and snagging treasure left and
			right, but then you get teleported on top of
			a Big Mean Nasty and are killed immediately
			thereafter. Tough break.";
		}
 		else if (r = 6) {
			"You fire up a game up Tournament Slamball, but
			your team's fate takes a turn for the worse when
			the opposition sneaks poison darts onto the
			field and runs a \"Stingray\" play.";
		}
		else if (r = 7) {
			"After the first board of Brickin, you
			nearly pass out from mental numbness.  In
			another time, you know, this game had its
			appeal, but now moving the little paddle
			around so the ball hits it every time
			seems about as fun as watching weeds.";
		}
		else {	// shouldn't happen
			"You try to play one of the older games, but
			it doesn't seem to be operational.";
		}
	}
;
TVgameroompatrons: Decoration
	sdesc = "game-playing patrons"
	adesc = { self.sdesc; }
	ldesc = {
		"They look like any other Terminal Velocity patrons,
		except for their blank stares and the pale-green glow
		reflected off the screens and onto their faces.";
	}
	location = TVgameroom
	noun = 'patrons' 'people' 'creatures' 'customers'
		'players' 'gamers'
	adjective = 'video' 'game' 'videogame' 'terminal' 'velocity'
;

/*
 * The Kompakt Komputer
 *
 * It only takes the floppy disk Gavin starts out with, so it doesn't
 * have to be a real container.
 */
TVgameroomkompaktkomputer: Readable, Decoration
	diskin = nil
	on = nil

	sdesc = "Zippikraft Kompakt Komputer"
	ldesc = {
		I(); "What a blast from the past!  The Kompakt 
		Komputer was one of Zippikraft's first mass-produced 
		machines, and as a result it has a few quirks, but is 
		a noble piece of hardware nonetheless -- the KK's 
		were built to the same exacting standards as today's 
		Liquidizers, so many people's original KK's are still 
		working perfectly "; note(self); ".  Still, these
		machines are hard to find now, and actually having the
		opportunity to play with one is at least a little
		exciting."; P();

		I(); "This one is an all-in-one unit with built-in keyboard,
		floppy disk drive, and 2D raster monitor. ";

		if (self.on)
			"It is currently on, ";
		else
			"It is currently off, ";

		if (self.diskin)
			"and there's a disk in the drive.";
		else
			"and the disk drive is empty.";

		" "; self.readdesc;
	}
	readdesc = {
		if (self.on and self.diskin) {
			"The screen is currently displaying a menu
			with several options:\b

			\t1.\ Unnkulian Underworld: The Unknown Unventure\n
			\t2.\ Unnkulian Unventure II: The Secret of Acme\n
			\t3.\ Unnkulian Unventure III: The Kuulest Quest\n";

			if (uudisk.stored <> []) {
				"\t4.\ Merge data object";

				if (length(uudisk.stored) > 1)
					"s";
				else
					" ";

				" into program space\n
				\t5.\ Eject disk and shutdown\n";
			}
			else {
				 "\t4.\ Eject disk and shutdown\n";
			}

			"\bThe software eagerly awaits your selection.";
		}
		else {
			"The screen is blank.";
		}
	}

	location = TVgameroom
	noun = 'computer' 'komputer'
		'slot' 'drive'
		'keyboard' 'keys'
		'monitor' 'screen'
	adjective = 'compact' 'kompakt' 'old' 'older' 'classic' 'poor'
		'lonely' 'zippikraft' 'zippi' 'kraft' 'zippy' 'craft'
		'zippi-kraft' 'zippy-kraft' 'zippi-craft' 'zippy-craft'
		'floppy' 'disk'

	footnote = {
		"Or at least as well as they ever worked...";
	}

	verIoTypeon(actor) = {
		if (not self.on)
			"Um, it might help to turn it on.";
		else if (not self.diskin)
			"You might consider putting a disk in first.";
	}
	ioTypeon(actor, dobj) = {
		if (dobj = numObj)
			self.numinput(dobj.value);
		else if (dobj = strObj)
			self.numinput(cvtnum(dobj.value));
		else
			self.badinput;
	}

	numinput(num) = {
		if (num = 1)
			self.uu1;
		else if (num = 2)
			self.uu2;
		else if (num = 3)
			self.uu3;
		else if (num = 4) {
			if (uudisk.stored <> []) {
				uu3transition.transfer_objects :=uudisk.stored;
				uudisk.stored := [];

				"There is some disk activity, 
				and then the machine says, 
				\"Transfer complete.\"";
			}
			else {
				"There are some burbling 
				noises for a few moments";
				self.shutdown;
			}
		}
		else if (num = 5) {
			if (uudisk.stored <> []) {
				"There are some burbling 
				noises for a few moments";
				self.shutdown;
			}
			else
				self.badinput;
		}
		else
			self.badinput;
	}

	badinput = {
		"The menu program seems to expect you to type only the
		numbers listed.  (Look, I said the machines have some
		quirks!)";
	}

	verDoTake(actor) = {
		"I have this funny feeling that someone might notice
		you lugging the thing out of the place, frankly.";
	}
	verDoMove(actor) = { "What's the point of that?"; }

	verDoTurnon(actor) = {
		if (self.on)
			"It's already on.";
	}
	doTurnon(actor) = {
		"You flick the power switch. ";
		
		if (not self.diskin) {
			"A cartoon rendition of a frowning computer 
			appears soon after, with a blinking arrow 
			pointing to the disk drive.  A few moments 
			later, the machine powers itself down 
			again.";
		}
		else {
			self.on := true;
			self.bootup;
		}
	}
	verDoTurnoff(actor) = {
		if (not self.on)
			"It's already off.";
	}
	doTurnoff(actor) = {
		"You flick the power switch"; self.shutdown;
	}
	shutdown = {

		if (self.diskin) {
			", and the machine forcefully ejects the disk in
			the drive with a loud \"PTOOEY.\"";

			uudisk.movein(Me.location);
			self.diskin := nil;
		}
		else ".";

		" The computer soon grinds to a halt.";

		self.on := nil;
	}

	acceptsput(o, loctype) = { return true; }
	
	verIoPutin(actor) = {}
	ioPutin(actor, dobj) = {
		if (dobj = uudisk) {
			uudisk.movein(nil);
			self.diskin := true;

			"You pop the disk in the drive.";

			if (self.on) {
				" "; self.bootup;
			}
		}
		else {
			"The Kompact Komputer disk drive only takes
			standard floppy disks.";
		}
	}

	bootup = {
		"A cartoon rendition of a happy computer appears soon 
		after, and moments later the system comes up."; P();

		self.readdesc;
	}

	uu1 = {
		"The computer burbles and grinds a while, then comes
		back with the following cryptic error message:"; P();

		"\"Z-code emulator no longer supports this program's
		instruction set.\""; 
	}
	uu2 = { self.uu1; }
	uu3 = { uu3transition.gotouu3; }
;

/*
 * The bar in Terminal Velocity
 */
TVbar: Room
	noun = 'bar'
	adjective = 'terminal' 'velocity' 'tv'

	sdesc = "In Terminal Velocity, at the Bar"
	ldesc = {
		I(); "You're at the Terminal Velocity bar, which is a 
		large circle of wood with a marble top.  At the 
		center of the circle is a cylindrical kiosk 
		containing hundreds of kinds of alcoholic beverages 
		and many glasses.  There's a break in the circle that 
		you can walk through to get inside ";
		note(self); ".";

		if (not bicycle.isin(TVbar)) {
			if (rndchance(10)) {
				P(); I(); "For a second, something
				behind the bar catches your eye.";
			}
		}
		else {
			P(); I(); "The stationary bicycle is behind 
			the bar.";
		}
	}
	verGoIn(actor) = {}
	goIn(actor) = {
		TVbarbar.doLookbehind(actor);
		return nil;
	}
	north = TVaround6
	ne = TVaround5
	nw = TVaround4
	south = TVaround1
	se = TVaround3
	sw = TVaround2
	up = {
		"You can go up in any direction but east and west, so
		I'm afraid you'll have to be a bit more specific.";
		
		return nil;
	}
	down = { "You're already as low as you can go."; return nil; }

	footnote = {
		"Presumably this is there so the bartender won't have 
		to climb over the counter to get inside.";
	}

	enter(actor) = {
		notify(meddler, &move, 0);
		inherited.enter(actor);
	}
	leave(actor) = {
		unnotify(meddler, &move);
		inherited.leave(actor);
	}		
;
TVbarkiosk: Decoration
	sdesc = "kiosk"
	ldesc = {
		"It looks typical of such things.  But wait,
		is that Razor Brandy?  That stuff's illegal
		in most of the galaxy.";
	}
	noun = 'kiosk'
	location = TVbar
;
TVbarglasses: Decoration
	isplural = true
	sdesc = "glasses"
	noun = 'glasses'
	adjective = 'drinking'
	location = TVbar
;
TVbeverages: Decoration
	isplural = true
	sdesc = "alcoholic beverages"
	ldesc = {
		"For the most part, they're the usual drinks
		you'd expect a well-stocked bar to have.  But
		you notice a flask of Razor Brandy among
		the other bottles -- that's rare stuff!";
	}
	noun = 'beverages' 'drinks' 'liquids' 'hundreds' 'drink' 'alcohol'
	adjective = 'alcoholic'
	location = TVbar

	verDoBuy(actor) = {}
	doBuy(actor) = {
		if (meddler.isin(Me.location))
			meddler.doPay(actor);
		else
			"The bartender's not here right now.";
	}
;
TVbrandy: Decoration
	sdesc = "Razor Brandy"
	ldesc = {
		I(); "Razor Brandy is made by the small group of
		settlers brave (and insane) enough to tough it
		out against the vicious carnivores of Razor,
		a nasty planet in the Edge system "; note(self);
		"."; P();

		I(); "This particular bottle looks quite old, which
		probably means it costs a fortune.";
	}
	noun = 'brandy' 'bottle' 'flask'
	adjective = 'razor' 'old' 'expensive'
	location = TVbar

	footnote = { "A nasty system."; }

	verDoTake(actor) = {
		"Ah-ah.  Not without paying for it, you don't.
		It's probably alarmed.";
	}
	verDoBuy(actor) = {}
	doBuy(actor) = { TVbeverages.doBuy(actor); }
;
TVbarbar: Decoration
	sdesc = "bar"
	ldesc = { TVbar.ldesc; }
	location = TVbar
	noun = 'bar' 'countertop' 'top'
	adjective = 'marble' 'wood' 'marble-topped' 'topped'

	verDoLookbehind(actor) = {}
	doLookbehind(actor) = {
		if (bicycle.isin(TVbar)) {
			"You don't find anything interesting
			behind the bar.";
		}
		else {
			"You peer behind the bar and find, of all things,
			a stationary bicycle!";

			bicycle.movein(TVbar);
			bicycle.makeknownto(Me);
		}
	}

	verDoEnter(actor) = {}
	doEnter(actor) = { self.doLookbehind(actor); }
;

//
// The time meddler
// This guy is the scientist from Unnkulia Zero.
// He also shows up in Ulien.
// He's also known as "Wowsa Willy"!
//
meddler: Male, Actor
	state = 0
	
	pissed = nil
	hushactordesc = nil	// hack
	
	sdesc = "bartender"
	ldesc = {
		"The bartender is striking -- he's got a long white 
		shock of hair, and looks quite old.  He's wearing 
		a tuxedo made from a very futuristic looking fabric 
		-- you've never seen anything like it before.";
	}
	listendesc = {
		I(); "He's muttering to himself -- you can only
		make out a phrase every once and a while: "; P();

		I(); "\"... using phase modulation... in a frabbulated
		flux field... a qusatic space-time bridge... detonation.\"";
     
	}
	actordesc = {
		if (not self.hushactordesc) {
			"The bartender is puttering around and 
			mumbling to himself.  You can't really pick 
			up much of what he's saying but you do catch 
			an occasional technical term.  For a 
			bartender he certainly knows a lot about 
			particle physics.";

			if (not self.pissed)
				" He glances at you expectantly.";
	 		else
				" He distractedly squints to focus on 
				you. When he realizes who you are, he 
				grunts and gives you a dirty look.";
		}
        }

	location = TVbar
	noun = 'man' 'scientist' 'bartender' 'barkeep' 'tender' 'keep'
	adjective = 'old' 'bar'
	isHim = true

	move = {
		//
		// We don't let the bartender sneak up on the player.
		//
		if (Me.isin(bicycle))
			return;

		if (Me.location <> TVbar)
			return;

		self.state := self.state + 1;
			    
		if (self.state = 5) {
			P(); I();
			"The bartender wanders to the other side of
			the bar, behind the kiosk.";

			self.movein(nil);
		}
		else if (self.state = 10) {
			P(); I();
			"The bartender emerges from behind the kiosk
			and ";

			if (self.pissed)
				"glares";
			else
				"nods";

			" at you.";

			self.movein(TVbar);
			self.state := 0;
		}
	}

	verIoGiveto(actor) = {}
	ioGiveto(actor, dobj) = {
		if (dobj = galacticard)
			self.doPay(actor);
		else
			self.doAskabout(actor, dobj);
	}

	verDoPay(actor) = {}
	doPay(actor) = {
		if (not galacticard.isin(Me)) {
			"You don't have your Galacticard with you,
			and I'm sure the bartender's not going to
			accept any other form of payment.";

			return;
		}
			
		if (TVJaxden.isknownto(Me))
			"Since your Galacticard has a stop on it,
			you probably shouldn't try to use it.";
		else
			"You hand your Galacticard to the bartender.
			He goes around to the other side of the bar,
			presumably to run your card through the
			reader.  He returns soon after, informing
			you that the transaction has been declined.";
	}

	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = {
		if (io = TVbrandy) {
			"\"My finest.  Would you like a glass?  Only
			85 billion credits.\" He chuckles.  Inflation's
			not *that* bad yet.";
		}
		else if (io = meddlerbox or io = padlock) {
			"\"I've no idea what you're talking about,\"
			the barkeep quickly retorts.  He seems
			edgy.";
		}
		else if (io = handypad) {
			"The man looks nervous.  \"I know nothing of
			newfangled gadgetry.  Now order something
			or leave,\" he says, scowling.";
		}
		else if (io = repellant) {
			I(); "\"Keep that foul snake oil away from me!\"
			he bellows. \"I should have made that
			fool Tuckbucker suffer longer!\""; P();
	
			I(); "\"Tuckbucker?\" you wonder aloud.
			You suppose it must be some past acquaintance.";
		}
		else if (io = akmid) {
			"The bartender laughs.  \"If you think you're
			going to get anything for *that*, you've
      			been living in the wrong century.\"";
		}
		else if (io = valmid) {
			"\"An interesting specimen,\" the bartender
			proclaims, \"but a fake.  Worthless.\"";
		}
		else if (io = reb) {
			"\"Reb?\" he shoots nervously.  \"What do you
			want to know about Reb?  I don't know anything
			about what happened to him!\"  He seems
			unwilling to discuss the matter further.";
		}
		else if (io = physics) {
			"\"I know something of scientific matters,\"
			he says haughtily, \"but nothing I can 
			easily explain in the time it will take you
			to buy a drink.\"";
		}
		else if (io = mare) {
			"\"Fate has chosen Mare to play an important
			role,\" the bartender says mysteriously.";
		}
		else if (io = akmi) {
			"\"Akmi?  What of them? I've hated them since
			the beginning!\" he bellows overdramatically.
			His answer is puzzling -- as far as you know,	
			Akmi's been around for centuries.  Odd.";
		}
		else if (io = virus) {
			"\"An intelligent virus?\" the barkeep
			replies. \"Surely you're joking,\" he
			chuckles.";
		}
		else {
			"For a moment, the bartender is lost in 
			thought. When he comes back to reality, he 
			mumbles that he doesn't have much interest
			in <<io.objthedesc(nil)>>.";
		}
	}

	verDoTellabout(actor, io) = {}
	doTellabout(actor, io) = {
		"The bartender listens to you patiently,
		but you get the feeling that as far as
		he's concerned, you might as well be any 
		other Terminal Velocity patron going on
		about some private matter.";
	}

	ioSynonym('Giveto') = 'Showto'
	doSynonym('Askabout') = 'Tellabout'

	verDoAttackwith(actor, io) = {
		"You swing at the bartender, but he's much more spry 
		than he looks.  He dodges you easily and then eyes 
		you suspiciously for a moment.";
	}

	verDoSpraywith(actor, io) = {}
	doSpraywith(actor, io) = {
		"\"Blaugh!\" he says, \"I thought I'd seen the
		last of that stuff when I killed that meddling
		Acme Salesman back in the valley!\"  He rips
		the can out of your hand and throws it on the ground.
		It explodes in a tower of flame.";

		repellant.movein(nil);
	}
;

//
// The time meddler's bicycle
//
bicycle: Stool
	isspent = nil
	warned = nil

	sdesc = "stationary bicycle"
	ldesc = {
		"It's a stationary bicycle, without wheels, and
		chrome-plated.  There's a small digital display
		mounted between the handlebars.";
	}
	noun = 'bicycle' 'bike'
	adjective = 'stationary' 'chrome' 'plated' 'flashy'
	reachsurroundings = true
	location = nil	// changed to TVbar when found

	verDoSiton(actor) = {}
	doSiton(actor) = {
		if (meddler.isin(TVbar) and self.isin(TVbar)) {
			"While the bartender's right there?";

			if (not meddler.pissed)
				" Surely he'll object to you sneaking 
				around behind the bar!";
		}
		else {
			actor.moveon(self);
			actor.position := 'sitting';
			"\^<<actor.youre>> now sitting on
			<<self.objthedesc(actor)>>.";
		}
	}
	
	doSitin(actor) = { self.doSiton(actor); }
	doGetin(actor) = { self.doSiton(actor); }
	doGeton(actor) = { self.doSiton(actor); }
	verDoBoard(actor) = { self.verDoSiton(actor); }
	doBoard(actor) = { self.verDoSiton(actor); }
	
	verDoRide(actor) = {}
	doRide(actor) = {
		if (Me.location <> bicycle) {
			"You'd better get on the bike first.";
		}
		else if (self.isspent = true) {
			"You pedal the bike furiously, but it doesn't 
			do anything.";

			if (meddler.isin(TVbar)) {
				" The bartender smacks you. \"Fool!\" 
				he sneers, \"You're wasting your time 
				-- I won't be so careless again.\"";
			}
		}
		else if (self.location = TVbar) {
			if (not self.warned) {
				self.warned := true;

				if (not TVelite.isin(Me))
					warnsave();
			}

			"You pedal the bike furiously.  Suddenly, 
			there's a blinding flash of light, and you 
			feel like your stomach's being pulled 
			apart. You struggle to keep your composure 
			(and your lunch) for a few agonizing moments, 
			but soon find yourself..."; P();

			global.colorspace := '';
			global.system := '';
			global.planet := '';

			bicycle.movein(meddlerpad);
			Me.newlocation(bicycle, 'on');
			notify(meddlerpad, &slowdown, 0);
		}
		else {
			"You pedal furiously, and are rewarded with
			the same bright flash and stomach-turning
			vertigo.  When you open your eyes again, 
			you find yourself..."; P();

			global.colorspace := TVmover.colorspace;
			global.system := TVmover.system;
			global.planet := TVmover.planet;

			meddler.hushactordesc := true;	// hack
			meddler.state := 0;  // he's where the player is now
			meddler.movein(TVbar); // ditto

			bicycle.movein(TVbar);
			Me.newlocation(bicycle, 'on');
			unnotify(meddlerpad, &slowdown);
			global.turnspertick := 1; // restore turncounter
			
			"The bartender is soon upon you, alert 
			and scowling. ";

			if (TVelite.isin(Me)) {
				"You quickly produce your Terminal
				Velocity Elite pass and show it
				to him. \"Don't do that again,\" he 
				growls. \"The time machine is very delicate, 
				and there are many things you do not 
				understand.\"  He fiddles with a tiny 
				cylindrical object he draws from his pocket. 
				\"There.  Now it's keyed.  You won't be 
				taking advantage of my trusting nature again, 
				you pesky rapscallion.\"";

				self.isspent := true;
				meddler.pissed := true;

				meddler.hushactordesc := nil;

				if (handypad.isin(Me))
					incscore(2);

				Me.position := 'standing';
				Me.location := TVbar;
				Me.locationtype := 'in';
			}
			else {
				"He takes out a sonic dart and throws
				it at you.  It's quite rare for these
				weapons to kill, but in this case,
				unfortunately, you get snagged in just
				the right place.";

				notify(deathobject, &death, 0);
			}
		}
    }
;
bikedisplay: Part, Readable
	partof = bicycle
	
	sdesc = "digital display"
	ldesc = {
		if (bicycle.location = meddlerpad)
			"The display reads \"7823 RY.\"";
		else
			"The display reads \"94 RY.\"";
	}
	noun = 'display'
	adjective = 'digital' 'small'
;

//
// The Time Meddler's hideaway.  (Or one of them, at least.)
// Time is really screwed up here; the longer you stay, the slower time
// moves for you.  This applies to all objects in the room.  The stuff
// that's been there "longer" is out of phase with Gavin and the bike,
// though, which means that Reb Glaz and the furniture appear to be
// frozen.
//
// We mess with the turn counter to clue the observant player in here.
// It doesn't do anything except change the number, though.  (Don't
// want to hose any demons that might be running.)
//
meddlerpad: Room
	walls = nil
	sdesc = "In the Future"
	ldesc = {
		I();
		
		if (Me.ison(bicycle))
			"You're sitting on the stationary bicycle";
		else
			"You are standing beside the stationary 
			bicycle";
		
		" in a small, featureless cubicle, barely as big as 
		your pod.  The walls here shimmer as they ";

		if (global.turnspertick < 5)
			"drift";
		else if (global.turnspertick < 7)
			"speed";
		else
			"flicker";
		
		" through all the colors of the rainbow, and the 
		furniture -- a mahogany desk and chair with no legs 
		-- floats in midair.  There is an oak chest on the
		desk."; P();
		
		I(); "To your surprise, you see a young man sitting 
		at the desk, completely motionless.  He doesn't even 
		seem to be breathing; it's as though he's frozen. His 
		clothes suggest that he is from your time.";
	}
	noexit = {
		"There are no obvious exits.";
		return nil;
	}

	slowdown = {
		global.turnspertick := global.turnspertick + 1;
		switch (global.turnspertick) {
			case 2:
				P(); I();
				"Something about this place makes you 
				feel strange.  It's sort of like the 
				weird sensation you experienced on 
				the bike, only much less pronounced.";
				break;
			case 5:
				P(); I();
				"You notice that the walls seem to be 
				changing colors much more quickly 
				now.";
				break;
			case 7:
				P(); I();
				"The colors of the walls are shifting so
				fast now that all you can see is a
				hypnotic blur.";
				break;
		}
	}
;
meddlerwalls: Decoration
	isplural = true
	sdesc = "walls"
	ldesc = {
		"The walls feel soild, but look liquid.  It's almost 
		like there's an energy field -- not walls at all -- 
		enclosing this area.";
	}
	location = meddlerpad
	noun = 'walls'
	adjective = 'colored' 'shimmering' 'cubicle'
;
meddlerdesk: Desk, Over
	sdesc = "mahogany desk"
	ldesc = {
		"It looks like an antique, but the legs have been removed
		and it's staying aloft on its own for some reason. ";
	
		self.contdesc(Me);
	}
	location = meddlerpad
	noun = 'desk'
	adjective = 'mahogany' 'floating'
;
meddlerchair: Chair
	sdesc = "mahogany chair"
	ldesc = {
		"Like the desk, this chair would seem to be an antique
		with the legs removed.  You can't tell what's holding it
		up, but it's quite stable.";
	}
	location = meddlerpad
 	noun = 'chair'
	adjective = 'mahogany' 'floating'

	reachsurroundings = true

	verDoEnter(actor) = { "Not while there's someone in it, you don't."; }
;
meddlerbox: Knowntopic, Openable
	isopen = nil
	sdesc = "sturdy oak chest"
	ldesc = {
		"It's just a normal-looking chest.";

		if (padlock.location <> nil) {
			" It's locked shut with a padlock.";
		}

		if (self.isopen) {
			" <<self.contdesc>>";
		}
	}

	noun = 'chest' 'box'
	adjective = 'sturdy' 'oak'

	verDoOpen(actor) = {
		if (padlock.location <> nil)
			"You'll have to get the padlock off first.";
	}
	verDoBreak(actor) = {}
	doBreak(actor) = {
		"Nope, the box is far too sturdy.";
	}
	verDoAttackwith(actor, io) = {}
	doAttackwith(actor, io) = {
		"Nice try, but the box holds fast.  Not a
		scratch on it.";
	}

	location = meddlerdesk
	locationtype = 'on'
;
padlock: Knowntopic, Decoration
	frigid = nil

	sdesc = "metal padlock"
	ldesc = {
		"It's just an ordinary metal padlock with a keyhole
		in the base.  Emblazoned on the side is the word
		\"Mistress.\" It's currently holding the oak
		chest shut.";
	}

	noun = 'padlock' 'lock' 'keyhole'
	adjective = 'metal' 'mistress' 'lock'

	weight = 3

	verDoPick(actor) = {}
	doPick(actor) = {
		"You try to pick the lock.  Unfortunately, you
		are not very skilled at lockpicking, so your
		efforts have no effect.";
	}
	verDoOpen(actor) = {}
	doOpen(actor) = { self.doUnlock(actor); }
	verDoClose(actor) = {}
	doClose(actor) = { 
		"No problem there. It already is.";
	}
	verDoLock(actor) = { self.verDoClose(actor); }
	doLock(actor) = { self.doLock(actor); }
	verDoLockwith(actor, io) = { self.verDoClose(actor); }
	doLockwith(actor, io) = { self.doLock(actor); }

	verDoUnlock(actor) = {}
	doUnlock(actor) = { "You don't have the right key."; }
	verDoUnlockwith(actor, io) = {}
	doUnlockwith(actor, io) = {
		caps(); io.thedesc; " doesn't open the lock.";
	}
	verDoBreak(actor) = {}
	doBreak(actor) = { "A fine idea, but how do you propose to do it?"; }
	verDoAttackwith(actor, io) = {}
	doAttackwith(actor, io) = { self.doBreak(actor); }
	verDoSmell(actor) = {}
	doSmell(actor) = {
		"It smells like metal.  You were expecting something
		more exciting, I take it?";
	}
	verDoEat(actor) = {}
	doEat(actor) = {
		"I see you're perpetually in these little computer fantasy
		worlds for a reason.";
	}
	verDoHitwith(actor, io) = {
		if (not self.frigid and io <> hammer)
			"You can't expect to break the lock
			with that, can you?";
	}
	doHitwith(actor, io) = {
		if (io = hammer) {
			if (not self.frigid) {
				"You give the lock a good hard knock,
				but there's no apparent damage.";
			}
			else {
				"You whack the lock with the hammer.
				The lock shatters into millions of
				microscopic fragments.";

				padlock.movein(nil);
				incscore(4);
			}
		}
		else
			"You give the lock a good hard knock,
			but there's no apparent damage.";
	}

	freeze = {	// called by liquid nitrogen

		"You douse the lock in liquid nitrogen.
		You hear crackling noises, but the lock
		holds.  Such a good idea too...";

		self.frigid := true;
	}		

	location = meddlerpad
;
handypad: Readable, Item
	realizedworking = nil
	
	sdesc = "Leibniz HandyPad"
	ldesc = {
		if (self.isin(meddlerpad)) {
			"The HandyPad seems to be locked up.  You
			can't get it to respond at all.";
		}
		else {
			if (not realizedworking) {
				I(); "Well, what do you know?  The 
				HandyPad seems to be working fine 
				now."; P();

				self.realizedworking := true;
			}
			
			I(); "You browse through the contents of the 
			HandyPad "; note(self); ". It doesn't have 
			much in it, but what's there is fascinating. 
			In addition to some technical notes, it has a 
			file marked \"Stock Market Data 90-99\".  
			This file contains prices for stocks, by date
			and time, only most of the dates are in the 
			future.  The notes are less intelligible, but 
			seem to deal with machine reasoning -- 
			building AI's!"; P();

			I(); "The \"About this HandyPad\" infobox says, 
			\"Registered to Reb Glaz.\"";
		}
	}
	readdesc = { self.ldesc; }
	location = meddlerbox

	noun = 'handypad' 'pad'
	adjective = 'handy' 'leibniz'
	
	weight = 1
	bulk = 1

	footnote = {
		I(); "The Leibniz HandyPad was all the rage when it 
		first came out about 5 years ago. They're still 
		popular, and more powerful models are released 
		regularly."; P();

		I(); "The Pads are small enough to fit in your 
		pocket, but have enough computing capability for most 
		administrative tasks.  People use them for everything 
		from taking notes in classes to designing buildings.  
		You control them just by touching the screen, and it 
		can read even the most horrendous handwriting.";
	}
;
handypadscreen: Part
	sdesc = "HandyPad screen"
	ldesc = {
		"It's just an ordinary bioraster matrix 2D screen.";
	}
	partok = handypad
	noun = 'screen'
	adjective = 'handy' 'pad' 'handypad' 'bio' 'raster' 'bioraster' 'matrix'
;
glaz: Male, Decoration
	sdesc = "seemingly dead man"
	ldesc = {
		"You can't tell much about the poor fellow.  He 
		doesn't have anything on him, and his clothes look 
		perfectly average.  The only thing odd about him is 
		his wristwatch -- it's an expensive (and supposedly 
		infallible) solar atomic model, but it's stopped.";
	}
	smelldesc = { "Well, he doesn't *smell* dead.  Hmmm...."; }

	location = meddlerpad
	noun = 'man' 'reb' 'glaz' 'fellow' 'person' 'guy' 'dude'
	adjective = 'dead' 'young'
;
glazwatch: Part
	partof = glaz
	sdesc = "dead man's watch"
	ldesc = { "The watch is dead in its tracks."; }
	noun = 'watch'
	adjective = 'dead' 'young' 'man\'s' 'reb\'s' 'glaz\'s' 'fellow\'s'
			'guy\'s' 'dude\'s'

	verDoTake(actor) = {
		"Why bother -- it's of no use anyway now that it's
		stopped.";
	}
;
#endif	/* DEMO */
