function milpreve()
	clearText()

	image "milpreve"

	if not metMilpreve then
		jump "milpreve_firstMeeting"
	else
		text [[Milpreve doesn't look up from his work.]]
		text [["Yes? Is there something else?"]]
		jump("milpreve_hub", true)
	end
end

function milpreve_firstMeeting()
	metMilpreve = true
	text [[Seated at the desk is an enormous scaled creature – for a moment you think it must be a snake, until you notice it has arms. It seems to be busily engaged in writing something, and doesn't look up as you approach. It does, however, speak.]]

	text [["Yes? Is this about getting a lute-player's licence again? As I have already made clear–"]]

	text [[The creature turns to look at you and immediately stops mid-sentence. It regards you intently.]]

	text [["You aren't Hobson." His tone is accusatory.]]

	choice([[Try and think of a clever response.]], "milpreve_cleverResponse")
	choice([[Just let him talk.]], "milpreve_talk")
end

function milpreve_cleverResponse()
	text [[His lidless, bronze eyes are so present that you find yourself - oh, no, you are laughing. Not the laughter of humour, the laughter from when the schoolmistress would yell in your face.]]

	text [[Now you've really done it.]]

	text [["I'm sorry," you mumble.]]

	jump "milpreve_talk"
end

function milpreve_talk()
	text [["In fact, you aren't anyone," he says. He tilts his head from side to side, perhaps gauging the distance between the two of you to strike, before turning to search through the drawers of a large oak desk.]]

	choice([[Make an assumption. "Are you the Remembrancer I've heard about?"]], "milpreve_remembrancer")
end

function milpreve_remembrancer()
	text [["Yes. I am Milpreve. However, of you I'm afraid to say I have no record what-so-ever." The Remembrancer pulls a ledger from a secondary cabinet and places it on top of the document he was attending to. "Name?"]]

	choice([[(Tell the truth.) "Armeline Treffrey."]], "milpreve_treffrey")
	choice([[(Lie.) "Ar - er, Arwen… Cabinet."]], "milpreve_cabinet")
	choice([[(Lie with enthusiasm. Invent a better name.)]], "milpreve_bouffo")
end

function milpreve_treffrey()
	playerTitle = "Miss"
	playerName = "Armeline Treffrey"
	playerFirstName = "Armeline"
	playerLastName = "Treffrey"
	jump "milpreve_age"
end

function milpreve_cabinet()
	playerTitle = "Miss"
	playerName = "Arwen Cabinet"
	playerFirstName = "Arwen"
	playerLastName = "Cabinet"
	jump "milpreve_age"
end

function milpreve_bouffo()
	text [[It comes tumbling out of you before you can even stop it. "Viscountess Arc'hantael Le Bouffo. The Third."]]
	playerTitle = "Viscountess"
	playerName = "Viscountess Arc'hantael Le Bouffo The Third"
	playerFirstName = "Arc'hantael"
	playerLastName = "Le Bouffo The Third"
	jump "milpreve_age"
end

function milpreve_age()
	text [[Milpreve marks it down.]]

	text [["Age?"]]

	choice([[(Tell the truth.) "Sixteen."]], "milpreve_species")
	choice([[(Lie.) "Fifteen - too young to work or marry."]], "milpreve_species")
	choice([[(Lie.) "Twenty-four, which means that I'm fully grown and you have to take me seriously."]], "milpreve_species")
end

function milpreve_species()
	text [["Species?"]]
	choice([["I…human?"]], "milpreve_occupation")
end

function milpreve_occupation()
	text [[He turns to look at you for a second. "Oh. Yes, I see. Occupation?"]]
	choice([[(Tell the truth.) "I'm apprenticed to the apothecary. In Ruan-le-pentrith."]], "milpreve_representative")
	choice([[(Lie.) "I'm the village drunk. I collect coins in the gutters of Ruan-le-pentrith and have never worked a day in my life."]], "milpreve_representative")
	choice([[(Lie.) "I'm the most feared witchbandit of the Rescorla Province."]], "milpreve_representative")
end

function milpreve_representative()
	text [["I'm quite sure I don't know what or where that is. Do you have a legal representative?"]]
	choice([["Representative? For what?"]], "milpreve_representative2")
end

function milpreve_representative2()
	text [["For your hearing."]]
	choice([["I think it's those birds."]], "milpreve_vultures")
	choice([["I don't have one. I'll represent myself."]], "milpreve_proSe")
end

function milpreve_vultures()
	text [[He makes a note.]]
	jump "milpreve_hearing"
end

function milpreve_proSe()
	text [["Out of the question. You'll be assigned," – he traces his finger down a piece of paper ostentatiously – "Leofwine."]]
	jump "milpreve_proSeHub"
end

function milpreve_proSeHub()
	choiceOnce([[Look closer.]], "milpreve_proSeLook")
	choiceOnce([["Do I get a say in this?"]], "milpreve_proSeArgue")
	choice([[Accept the judgement.]], "milpreve_proSeAccept")
end

function milpreve_proSeLook()
	text [[The piece of paper only has one word on it. It says *Leofwine*.]]
	jump "milpreve_proSeHub"
end

function milpreve_proSeArgue()
	text [[His forked tongue flickers out from his mouth. "Don't be ridiculous. No."]]
	jump "milpreve_proSeHub"
end

function milpreve_proSeAccept()
	text [["All right," you say.]]
	jump "milpreve_hearing"
end

function milpreve_hearing()
	text [["Your case will be heard later today. At the hearing an assessment of your character will be conducted, with the aim of determining whether you are fit and proper to be declared a True Citizen."]]
	heardAboutTrueCitizens_Milpreve = true
	jump "milpreve_citizenHub"
end

function milpreve_citizenHub()
	if not milpreveAskedAboutRights then
		choiceOnce([["And then I can leave the city?"]], "milpreve_hearingLeave")
  end
	if heardAboutTrueCitizens_Hobson then
		choiceOnce([["And then I can play the lute?"]], "milpreve_hearingLute")
		choiceOnce([["And then I can borrow a horse?"]], "milpreve_hearingHorse")
	end
	choice([["What sort of person gets to be a True Citizen?"]], "milpreve_citizenReqs")
end

function milpreve_hearingLeave()
	text [[He laughs mirthlessly. "Oh, no. Many other questions would have to be resolved before that can be decided."]]
	milpreveAskedAboutRights = true
	jump "milpreve_citizenHub"
end

function milpreve_hearingLute()
	text [[He looks at you for a second before saying "Only subject to further assessment."]]
	milpreveAskedAboutRights = true
	jump "milpreve_citizenHub"
end

function milpreve_hearingHorse()
	text [["A what?"]]

	text [[You decide not to press the matter further.]]

	milpreveAskedAboutRights = true
	jump "milpreve_citizenHub"
end

function milpreve_citizenReqs()
	text [["A True Citizen of Gallos", he begins, as if reciting from memory, "must be acquainted with the particular duties and observances expected of all. Every True Citizen must pay due reverence to Her Serenity Queen Gwenhaela; every True Citizen must–"]]

	if heardAboutGwenhaela then
		choice([["Queen Gwenhaela - she runs the Citadel, doesn't she?"]], "milpreve_gwenhaela")
	else
		choice([["Wait. Who is Queen Gwenhaela?"]], "milpreve_gwenhaela")
	end
end

function milpreve_gwenhaela()
	text [["Her Serenity is the sovereign of the city of Gallos and surrounding lands. She is an enchantress of unmatched power and renown, who established this place as a shining beacon of enlightenment in a murky and decadent age.]]

	text [["To her do we owe the many wonders of the arcane art that render Gallos an unequalled paradise of tranquillity and learning. Brute labour and drudgery have been forever eliminated by the use of therianology and galatology, granting sapience to base animals and even creatures of living stone.]]

	text [["By such thaumatic feats are True Citizens emancipated from the meanness and poverty that once blighted humanity, allowing them to devote themselves fully to the life of the mind and achieve a euphoria of purpose."]]

	text [[He didn't once stop to breathe.]]

	choice([["Can I see her?"]], "milpreve_seeQueen")
end

function milpreve_seeQueen()
	text [["Out of the question. Her Serenity is indisposed due to pressing matters outside the city. In any case, True Citizenship is a prerequisite to requesting an audience."]]

	needToPayReverence = true

	jump "milpreve_hub"
end

function milpreve_hub(justEntered)
	if cheesePasty then
		choiceOnce([["Hobson told me I needed to speak to you if I want a cheese pasty."]], "milpreve_pasty")
	end
	if wontGrassHobson or mightGrassHobson then
		choiceOnce([[Inform Milpreve that Hobson has been playing the lute without a license.]], "milpreve_grass")
	end
	if needToPayReverence and shrineRoofBroken then
		choiceOnce([["May I visit the shrine of Her Serenity? To…pay reverence."]], "milpreve_shrine")
	end
	if justEntered then
		choice([["Oh…sorry, I forgot why I came in." (Return to the waterway.)]], "waterway")
	else
		choice([["I think that's everything I need for now." (Return to the waterway.)]], "waterway")
	end
end

function milpreve_pasty()
	text [["Hobson told you?" Milpreve says. "Whatever do you want that for?"]]

	choice([["I want to eat it."]], "milpreve_eatPasty")
end

function milpreve_eatPasty()
	text [["I'm sorry to hear that you still require food. There are no cheese pasties in Gallos.]]

	text [["The responsibility of distributing food is that of the marketicians on Wonder Lane, who administer various locations throughout the citadel which you can read about on this list."]]

	text [[Milpreve hands you a small square of paper, which you unfold. Inside is a list of arcane-looking addresses that you do not understand how to translate to places.]]

	choice([["But this is ridiculous! How can you have an entire city without cheese pasties?"]], "milpreve_howNoPasties")
	choice([[Drop the subject. (No cheese pasty.)]], "milpreve_hub")
end

function milpreve_howNoPasties()
	text [["Many cities do not have robust civic operational services delivered by uplifted animals either. I find that more remarkable."]]

	jump "milpreve_hub"
end

function milpreve_grass()
	text [[What an industrious little amateur-watchman you are! You straighten your skirt, preparing to enjoy the glow of your self-satisfaction.]]

	text [["Remembrancer, I would like to report a crime!"]]

	text [[Instantly, a terrible charge passes over Milpreve, lifting the very tip of every scale on his body; under his civilised clothing, he is no less a rope of muscle than a common adder, but expanded to the size of a human man. He tastes the air.]]

	text [["Lawbreakers must be punished. And if it is Hobson again, I swear this time I will have them strip his *animus* and let his bones rattle to the floor.]]

	text [["Who is the criminal?"]]

	choice([["It's Hobson."]], "milpreve_reportHobson")
	choice([["…It's me."]], "milpreve_reportArmeline")
end

function milpreve_reportHobson()
	text [[You try to tell him, but Milpreve's gaze turns the words in your mouth to dust.]]

	text [[You are distracted by a memory; you are sitting on your grandfather's knee as he lectures you that just because you can read in your head and the other children still have to sound out the letters does not mean that you are in charge of them.]]

	text [["I wish you were dead, Grandfather," you mumble, just as you'd said to him back then - the words you still regret when you wake in the night, even though you were a little child and did not know better.]]

	text [[Milpreve looks at you impassively.]]

	text [["I am not your grandfather," he responds. "If you are trying to make some sort of 'joke' or 'word-play', I appreciate it little and would ask you to desist."]]

	triedtograssHobs = true

	jump "milpreve_hub"
end

function milpreve_reportArmeline()
	text [[It is the only lie that comes to mind, and when you say it, it feels like the truth. What is coming over you that made you wish to betray Hobson?]]

	text [[You give Milpreve an impish smile and point your thumb at your face. He seems unmoved.]]

	text [["To establish that fact beyond doubt will be the purpose of your hearing. Nevertheless, to make an early confession of your criminal intent will be to your credit, if accompanied by an appropriate expression of contrition."]]

	jump "milpreve_hub"
end

function milpreve_shrine()
	text [[For some reason you keep talking. "Since it's the duty of a True Citizen, I thought I should do it as soon as possible. When I tried to go earlier there was a $(gargoyleName) that stopped me and asked for a pass, and it said I could only get one from the city authority, so I wondered if–"]]

	text [[Milpreve raises a hand. "Enough. Yes. You'll need this." He rummages through a drawer and produces a carved silver item, something like a paperweight. He hands it to you.]]

	haveGargoylePass = true

	jump "milpreve_hub"
end
