//
// note: This game uses modifications to Nate Cull's RAP 1.0 module,
// available at GMD. I have failed to include the modified RAP files.
//
// note also: This source code is an absolute mess. Sorry!
//
// Questions/comments: Peter Berman, pbmath@hotmail.com
// or try contacting mcp on the ifMUD.
//
// Peter Berman, Aug. 31, 2000
//

#include <adv.t>
#include <std.t>
#include "toast_rap10k.t"
#include "toast_rap10p.t"

modify thing
    verDoEat( actor ) = {"\bNope.\b";}
    verIoAskFor(actor) = {}
    ioAskFor(actor, dobj) = dobj.doAskFor(actor,self)
    itisdesc =
    {
        /* display "it's" if this is singular, "they're" otherwise */
        if (self.isThem)
            Me.fff ? "they will be" : "they're";
        else
            Me.fff ? "it will be" : "it's";
    }
    doesdesc =
    {
        /* display "does" if singular, "do" otherwise (it does, they do) */
        if (self.isThem)
            Me.fff? "will do":"do";
        else
            Me.fff? "will do" :"does";
    }
    isdesc =
    {
        /* display "is" if this is singular, "are" otherwise */
        if (self.isThem)
            Me.fff? "will be":"are";
        else
            Me.fff? "will be":"is";
    }
    isntdesc =
    {
        /* display "isn't" if this is singular, "aren't" otherwise */
        if (self.isThem)
            Me.fff? "won't be":"aren't";
        else
            Me.fff? "won't be":"isn't";
    }
;

modify Actor
  verDoAskFor(actor,iobj) = {}
  tofuture = {
    if ( Me.location = future ) {
      "\n<<self.sdesc>> will appear.\n";
    }
    if ( Me.location = startroom ) {
      "\n<<self.sdesc>> pulls the great lever, and vanishes.\n";
    }
  }
  topresent = {
    if ( Me.location = future ) {
      "\n<<self.sdesc>> will pull the greater lever, and vanish.\n";
    }
    if ( Me.location = startroom ) {
      "\n<<self.sdesc>> appears.\n";
    }
  }
;

modify movableActor
    actorDesc =
    {
        "\^<<self.adesc>> << self.isdesc >>  here. ";
    }
;

modify global
  maxscore = 0
;


myrand: function( n ) { // improved random-number generator
  local r, t, u, v, s, q;
  r := rand(n);
  t := rand(101);
  u := rand(103);
  v := rand(105);
  s := (t+u+v)*r;
  q := s/n;
  return( s - q*n );
}
;

forPrep: Prep
    preposition = 'for'
    sdesc = "for"
;

modify askVerb
    prepDefault = forPrep
    ioAction(forPrep) = 'AskFor'
;


modify Me
  fff = nil
  seenbread = nil
  seenadmin = nil
  will = Me.fff ? "will" : ""
  ldesc = {"You << Me.will >> look familiar.\n";
    if ( amulet.location = Me and amulet.isworn ) "\bYou
    << Me.fff ? "will be" : "are" >> fast, and fat.\n";
  }
    ioGiveTo(actor, dobj) =
    {
        "You << Me.will >> accept <<dobj.thedesc>> from <<actor.thedesc>>.";
        dobj.moveInto(parserGetMe());
    }

    // these properties are for the format strings
    fmtYoure = Me.fff ? "You'll be" : "you're"
    fmtYouve = Me.fff ? "You will have" : "you've"
    fmtHave = "<< Me.will >> have"
    fmtDo = "<< Me.will >> do"
    fmtAre = Me.fff ? "will be" : "are"
  tofuture = {
    "You reach for the lever and give it a single
      long proud pull";
    if ( Me.seenbread )
      " ...\b";
    else {
      ". You get the briefest of glimpses of
        bread descending ...\b";
      notify( Me, &admin, 4 );
      Me.seenbread := true;
    }
    "\bHit <enter>:\b";
    yorn();
    "... and you will arrive in the future.\b";
    future.lookAround(true);                      // show player where he is
    future.isseen := true;                  // note that we've seen the room
  }
  topresent = {
    "You will pull the greater lever ...\b";
    "\bHit <enter>:\b";
    yorn();
    "... and arrive in the present.\b";
    startroom.lookAround(true);                      // show player where he is
    startroom.isseen := true;                  // note that we've seen the room
  }
  admin = {
    Me.seenadmin := true;
    "\bAunt Krull will appear in the Future Plane before
      you, shimmering with a red glow. Aunt Krull
      will say to you: \"Os Esker will need
      your help, even though he will be too
      shy to ask for it. You will obtain, then
      give him, the Amulet of Rotund Quickness,
      which he will need to free this
      land from the Deity Plant. Get to work!\"\b\bHit <enter> ";
    yorn();
  }
  pirate = {
   local q;
   q := myrand( 100 );
   if ( q < 20 and Me.location = plidiland )
     "\bPlidi paces around the dry cavern, planning her next move.\n";
   if ( (20 < q and  q < 35) and Me.location = plidiland )
     "\bPlidi casts a spell to summon her daughter Kelci, who
       appears in a flash of pink light. They confer briefly,
       then Kelci vanishes.\n";
   if ( q < 15 and Me.location = future ) "\bThe plane will pulsate gently.\n";
   if ( (65 < q and q < 74) and Me.location = slot1 ) "\bAn enormous ant crawls
     across the sky, munching as it goes.\n";
   if ( (58 < q and q < 65) and Me.location = slot1 ) "\bSuddenly the earth 
       heaves and you are thrown to the ground. When you get up, you see
       that a bite has been taken out of the sky, several miles wide.\n";
   if ( q > 93 ) {
      "\bThe Carbohydrate Pirate << Me.fff ? "will walk " : "walks " >>
       through the room, muttering: \"Toast? Arrrrr!!!
       Toast? Arrrrr!!! Toast? Arrrrr!!!\" 
       He << Me.fff ? "will leave" : "leaves" >> as
       quickly as he << Me.fff ? "will come" : "came" >>.\b";
   if ( 40 < q and q < 50 ) {
     "You hear booming voices from far above, conversing
       about being \"out of butter.\"";
   }
   }
  }
;

sky: distantItem
  location = slot1
  noun = 'sky'
  sdesc = dial.shorteffect
  ldesc = "The << dial.shorteffect >> stands, huge and far
    above you, perfectly still."
;

slot: fixeditem
  location = slotsroom
  noun = 'slot' 'slots'
  adjective = 'eastern' 'western' 'east' 'west'
  sdesc = "pair of slots"
  ldesc = "Go west to enter the western slot, east to 
  enter the eastern slot.\n"
  verDoEnter( actor ) = self.ldesc
  verIoPutIn( actor ) = "You'll need to enter one of the slots by
    going east or west.\n"
;

aboutVerb: sysverb
  verb = 'about'
  sdesc= "about"
  action( actor ) = {
    "Entry in Mark Musante's toaster-comp. Comp specification:\b\b
     \"Make a game with a toaster.  The toaster should have a 
     lever for pushing the bread down and a slider or dial 
     for setting the darkness.\"\b\b
     This game uses the Reactive Agent Planner 1.0 module
      by Nate Cull.\b
      This game makes some references to the
      underrated game Detective, by Matt Barringer.
      In particular, it uses that author's device for
      surreal room topology.
      \bMany thanks to Neil deMause for beta testing
      on basically zero notice.
      \bThanks to Mark Musante for organizing
      Toaster Comp. He probably didn't envision this
      kind of game ...\b";
    abort;
  }
;


hintVerb: sysverb
  verb = 'hint'
  sdesc = "hint"
  action( actor ) = {
    "At the beginning of the game, pull the lever and 
      wait for Aunt Krull to give you your mission.\b
      You need to get items from characters in this game.
      Examine characters to see what they're carrying.
      If you see something you want, ASK [character] FOR
      [item]. If you have something that a character
      wants, then GIVE [item] TO [character]. For
      more hints, type HINT2.";
    abort;
  }
;

hint2verb: sysverb
  verb = 'hint2'
  sdesc = "hint2"
  action( actor ) = {
    "Krull tells you to give Os the amulet.
      If you examine Clebb, you'll see that he's
      wearing an amulet. Ask Clebb for the
      amulet, and he'll tell you what you need to
      give him before he'll give it to you.
      \bBe sure to examine Os and Plidi too.\b
      Clebb moves the fastest, but he stays on
      a track between his house and the Future Plane.
      Wait a few turns in one spot on this track, and
      he'll show up.\b
      For a complete solution, type HINT3.";
    abort;
  }
;


hint3verb: sysverb
  verb = 'hint3'
  sdesc = "hint3"
  action( actor ) = {
    "Pull the lever and wait for Aunt Krull to give
    you instructions. Find Os and ask him for the 
    square. Find Plidi and give her the square, then ask
    her for the staff. Find Clebb and give him the
    staff, then ask for the amulet. Give the
    amulet to Os.\b";
   abort;
  }
;

helpVerb: sysverb
  verb = 'help'
  sdesc = "help"
  action( actor ) = {
    version.sdesc;
    abort;
  }
;

commandsVerb: sysverb
  verb = 'commands'
  sdesc = "commands"
  action( actor ) = {
    "Key commands in this game are: \b  *** ASK [character] FOR [item]
      \b  *** GIVE [item] TO [character]";
    abort;
  }
;

rHappy: rCond
  sdesc = "rHappy"
  rTrue(a,p) = {
    a.param := p;
    return( a.mainGoal );
  }
  rPlans(a,p) = {
    a.param := p;
    return( a.mainPlans );
  }
;


modify rIn
 rPlans(actor, param) =   {
    return( param.toBeIn );
 }
;


replace init: function
{
    // this section here is cut straight from std.t

    "\b\b\(WARNING:\)  This game contains half-cooked imagery and 
      graphically absurd scenes. 
      Player discretion is advised.
      \b\bPress <enter> ";
    yorn();
    clearscreen();
    version.sdesc;                // display the game's name and version number

    setdaemon(turncount, nil);                 // start the turn counter daemon
    setdaemon(sleepDaemon, nil);                      // start the sleep daemon
    setdaemon(eatDaemon, nil);                       // start the hunger daemon
    parserGetMe().location := startroom;     // move player to initial location
    startroom.lookAround(true);                      // show player where he is
    startroom.isseen := true;                  // note that we've seen the room
    scoreStatus(0, 0);                          // initialize the score display

    // end of std.t section

    randomize();
    notify(Me,&pirate,0);
    notify(os,&animate,0);
    notify(clebb,&animate,0);
}
;


modify version
  sdesc = "\(This Is The Toaster alpha 1.0\)
          \ba TADS 2.4 game by Peter Berman
          \b\bType COMMANDS for key commands,
          ABOUT for game info, HINT for hint.\b"
;



replace die: function
{
  "\b \(*** You have died ***\) \b";
  wrapup();
}



wrapup: function
{
    "\bYou may restore a saved game, start over, quit, or undo
    the current command.\n";
    while (true)
    {
        local resp;

        "\nPlease enter RESTORE, RESTART, QUIT, or UNDO: >";
        resp := upper(input());
        if (resp = 'RESTORE')
        {
            resp := askfile('File to restore',
                            ASKFILE_PROMPT_OPEN, FILE_TYPE_SAVE);
            if (resp = nil)
                "Restore failed. ";
            else if (restore(resp))
                "Restore failed. ";
            else
            {
                parserGetMe().location.lookAround(true);
                scoreStatus(global.score, global.turnsofar);
                abort;
            }
        }
        else if (resp = 'RESTART')
        {
            scoreStatus(0, 0);
            restart();
        }
        else if (resp = 'QUIT')
        {
            terminate();
            quit();
            abort;
        }
        else if (resp = 'UNDO')
        {
            if (undo())
            {
                "(Undoing one command)\b";
                parserGetMe().location.lookAround(true);
                scoreStatus(global.score, global.turnsofar);
                abort;
            }
            else
                "Sorry, no undo information is available. ";
        }
    }
}


xyzzyVerb: deepverb
  sdesc = "xyzzy"
  verb = 'xyzzy'
  action( actor ) = xtext( xw )
;

xtext: function( obj ) {
  "\bThe detective stepped cautiously <<obj.dir>> into
      the small closet. <<obj.l1>> from an unseen
      source, the closet revealed a few <<obj.clothes>> clothes
      on hangers and a <<obj.toy>> or two but
      nothing remotely relevant to the case.
      Ed left the way he came, walking <<obj.dir>> back
      into the hallway.\b
      He emerged in a <<obj.l2>> <<obj.rm>> that
      smelled of <<obj.flower>> and old <<obj.old>>. Bending
      down, Ed examined a piece of <<obj.ww>>.
      \"This could come in handy,\" the detective mused as
      he picked it up.\b
      Just then, a <<obj.villain>> walked into the room from
      the <<obj.dir2>>! Ed screamed and pulled the trigger
      on his <<obj.gun>>. Too late ...\b\b";
    abort;

}


xw: object
  dir = "north"
  l1 = "Well lit"
  clothes = "rumply"
  toy = "knick-knack"
  l2 = "dimly lit"
  rm = "drawing room"
  flower = "zinnias"
  old = "dust"
  ww = "wooden wood"
  villain = "celebrity"
  dir2 = "east"
  gun = "pistol"
;

pw: object
  dir = "south"
  l1 = "Dimly lit"
  clothes = "stiff"
  toy = "toy"
  l2 = "well lit"
  rm = "sitting room"
  flower = "magnolias"
  old = "fiber"
  ww = "stone stone"
  villain = "thief"
  dir2 = "northeast"
  gun = "AK-47"
;

plughVerb: deepverb
  sdesc = "plugh"
  verb = 'plugh'
  action( actor ) = xtext( pw )
;

plw: object
  dir = "east"
  l1 = "Brightly lit"
  clothes = "swank"
  toy = "plaything"
  l2 = "creeping"
  rm = "cul-de-sac"
  flower = "cheap booze"
  old = "silverware"
  ww = "foam foam"
  villain = "pirate"
  dir2 = "south ... urr, kind of an off-south"
  gun = "glue gun"
;

ploverVerb: deepverb
  sdesc = "plover"
  verb = 'plover'
  action( actor ) = xtext( plw )
;


startroom: room
  sdesc = "Lever"
  ldesc = "The great lever stands before you, waiting to
    be pulled. This is it, the key to the Future Plane!
    If you feel unready for this change, you can
    scamper downward to the dial or upward to the Slots."
  beendown = nil
  down = {
   if ( !(self.beendown) ) {
    "\bYou scramble down the sheer plastic facade, 
      maintaining your footing by sheer strength
      of will at an angle of 90 degrees, until you arrive
      at the dial.\b";
    self.beendown := true;
   }
   return( dialroom );
  }
  up = slotsroom
  toBeIn = [
    [rBe rIn future
    rDo rPull lever2]
    
    [rBe rIn dialroom
    rDo rGo startroom]
    
    [rBe rIn slotsroom
    rDo rGo startroom]
  ]
;


rPull: rAct
 sdesc = "rGo"
 rPreDesc(a,p) =  {}

 rAction(a,p) =
 {
    p.doPull( a );
 }
;



slotsroom: room
  sdesc = "Slots"
  ldesc = "To the west lies one slot, to the
    east another. The lever can be reached by
    ambling downwards."
  down = startroom
  west = {
    "You mosey into the western slot and
      emerge under a << dial.shorteffect >>.\b";
    return( slot1 );
  }
  east = {
    "No one \(ever\) goes into the eastern slot.";
    return(nil);
  }
  toBeIn = [
    [rBe rIn startroom
     rDo rGo slotsroom]

    [rBe rIn slot1
     rDo rGo slotsroom]
  ]
;

slot1: room
  sdesc = "western slot"
  ldesc = "You stand in a narrow stone valley
    underneath a << dial.effect >>. The opening
    to Plidi's cave lies in a cliff wall
    to the northwest, while a pebble path
    down to Clebb's house descends to the southwest.
    You can also
    exit the slot to the east.
    Pebble-paved paths branch
    off to the northwest and southwest otherwise."
  east = {
    "You march out of the western slot.\b";
    return( slotsroom );
  }
  nw = {
    "You try to ignore the looming cliff above you,
       and the << dial.shorteffect >> above that,
       as you duck your head and enter Plidi's home.\b";
    return( plidiland );
  }
  sw = clebbland
  toBeIn = [
    [rBe rIn slotsroom
     rDo rGo slot1]
     
    [rBe rIn plidiland
     rDo rGo slot1]
     
    [rBe rIn clebbland
     rDo rGo slot1]
  ]
;

plidiland: room
  isclean = nil
  sdesc = "Plidi's cavern"
  thedesc = self.sdesc
  ldesc = "Vast and unadorned.
    Plidi has enormous wealth, but no one knows what
    she does with her money. The exit is to the
    northwest."
  eee = nil
  nw = {
    if ( !eee ) {
      "\nAs you turn to exit, Plidi calls after you:
        \"Hey, make sure you don't get eaten by
        God!\" You proceed out the exit, confused.\b";
      eee := true;
    }
    return(slot1);
  }
  out = self.nw
  toBeIn = [
    [rBe rIn slot1
     rDo rGo plidiland]
  ]
;

clebbland: room
  sdesc = "Clebb's home"
  thedesc = self.sdesc
  isclean = nil
  ldesc = "The home of the supplicant Clebb.
    They say that Clebb puts the \"I can't\"
    in \"supplicant\" -- he tends to bungle
    even simple duties.\b<<myrand(100)>70?"There is a small
    red button in one corner.\b":"">> A doorway in the
    southwest corner of the house leads back
    to the valley."
  sw = slot1
  out = self.sw
  toBeIn = [
    [rBe rIn slot1
     rDo rGo clebbland]
  ]
;

dialroom: room
  sdesc = "Dial"
  ldesc = {"The green dial glows quietly, waiting to
    be turned. The lever can be reached by walking upward.";
    if ( stuckgecko.location = self ) "\bA gecko is
      stuck head-first in the wall here.\n";
  }
  up = startroom
  toBeIn = [
    [rBe rIn startroom
    rDo rGo dialroom]
  ]
;

dial: fixeditem
  location = dialroom
  sdesc = "green dial"
  ldesc = "It is a green dial, presently set to << self.setting + 1 >> 
    out of 3."
  noun = 'dial'
  adjective = 'green'
  setting = 0
  verDoTurn( actor ) = {}
  doTurn( actor ) = {
    if ( Me.location = dialroom )
      "The dial turns slowly and settles into a new position.";
    self.setting++;
    if ( self.setting = 3 ) dial.setting := 0;
  }
  effect = {
    switch ( self.setting ) {
      case 0:
        "soft white sky, patterned over with tiny
          weblike connections";
        break;
      case 1:
        "light brownish sky, fading to white around
          the edges, with distinct pockmarks";
        break;
      case 2:
        "hard, crisp and dark brown sky, pitted with holes";
        break;
    }
  }
  shorteffect = {
    switch ( self.setting ) {
      case 0:
        "soft sky";
        break;
      case 1:
        "low firming sky";
        break;
      case 2:
        "hard sky";
        break;
    }
  }
;

lever: fixeditem
  location = startroom
  noun = 'lever'
  adjective = 'great' 'gray' 'grey'
  sdesc = "great lever"
  ldesc = "The lever stands grey, motionless."
  verDoPull( actor ) = {}
  doPull( actor ) = {
    actor.tofuture;
    actor.fff := true;
    actor.moveInto( future );
  }
;


future: room
  sdesc = "Future Plane"
  ldesc = "You will be in the future plane. 
    A greater lever will stand before you. Featureless
    space will spread out before you in all directions, but
    a path will lead to the east."
  up = self.futurez
  down = self.futurez
  north = self.futurez
  west = self.futurez
  south = self.futurez
  east = future2
  nw = self.futurez
  ne = self.futurez
  sw = self.futurez
  se = self.futurez
  futurez = {
    "You will be unable to go that way.";
    return( nil );
  }
  toBeIn = [
    [rBe rIn startroom
     rDo rPull lever]
     
    [rBe rIn future2
     rDo rGo future]
  ]
;

future2: room
  sdesc = "eastern seaboard of the Future plane"
  thedesc = self.sdesc
  toBeIn = [
   [rBe rIn future
    rDo rGo future2]
  ]
  isclean = nil
  ldesc = "The future plane will glow slightly in this region.
    Paths will lead east and west. The plane will be
    interrupted by a huge jagged fissure
    to the north, beyond which will stand the
    Deity Plant that all the inhabitants of this
    land will pray to."
  up = self.futurez
  down = self.futurez
  north = {
    "The chasm will be too far for you to cross.";
    return( nil );
  }
  east = future2
  south = self.futurez
  west = future
  nw = self.futurez
  ne = self.futurez
  sw = self.futurez
  se = self.futurez
  futurez = {
    "You will be unable to go that way.";
    return( nil );
  }
;

deityPlant: distantItem
  location = future2
  noun = 'plant'
  adjective = 'deity'
  sdesc = "Deity Plant"
  ldesc = "You will be barely able to make it out from
    this distance. It will reach mightily up skywards
    with fierce, nuke-green tendrils. An awesome vine."
;

lever2: fixeditem
  location = future
  noun = 'lever'
  adjective = 'greater' 'colorless'
  sdesc = "greater lever"
  ldesc = "The greater lever will stand colorless, motionless."
  verDoPull( actor ) = {}
  doPull( actor ) = {
    if ( (actor = Me) and !(Me.seenadmin) ) {
      "The Vision has not yet occurred.
        You will wait until the time is right to pull the
        greater lever.\b";
      return nil;
    }
    actor.topresent;
    actor.fff := nil;
    actor.moveInto( startroom );
  }
;

square: item
  location = os
  sdesc = "square"
  noun = 'square'
  ldesc = "It is a large square made of light. You get
    the feeling that it could do great damage in the
    right hands, but you know not how.\n"
;

sword: item
  location = os
  sdesc = "longsword"
  noun = 'sword'
  adj = 'long'
  ldesc = "Bright pink
    light << Me.fff ? "will glint":"glints">> off of it  from
    an unseen source."
;



class myActor: Actor
  thedesc = self.sdesc
  adesc = self.sdesc
  ldesc = {
    self.oldldesc;
    if ( amulet.location = self ) {
      "\b<< self.amudesc >>\n";
    }
    if ( staff.location = self ) {
      "\b<< self.staffdesc >>\n";
    }
    if ( square.location = self ) {
      "\b<< self.squaredesc >> \n";
    }
  }
  amudesc = "\^<<self.pron>> <<Me.fff? " will wear ":" wears ">> an
    amulet and is fat.\n"
  staffdesc = "\^<<self.pron>> proudly
    <<Me.fff?" will carry ":" carries ">> the Staff of Life.\n"
  squaredesc = "\^<<self.pron>> <<Me.fff?" will carry ":" carries ">> 
    a square.\n"
  pron = self.sdesc
;

 
clebb: myActor, rapper
  location = clebbland
  noun = 'clebb'
  sdesc = "Clebb"
  adesc = self.sdesc
  thedesc = self.adesc
  homewards = nil
  oddbit = nil
  animate =
  {
    if ( amulet.location = Me and amulet.isworn ) {
      if ( self.oddbit ) {
        self.rapAct(rHappy,nil);
        self.oddbit := nil;
      } else {
        self.oddbit := true;
      }
    } else {
      self.rapAct(rHappy,nil);
      if ( amulet.location = self ) {
       if ( self.oddbit ) {
        self.rapAct(rHappy,nil);
        self.oddbit := nil;
       } else {
        self.oddbit := true;
       }
      }
    }
  }
  pron = "he"
  oldldesc =  "Clebb << Me.fff? "will look":"looks">> very ordinary, except
    for the five eyes stacked one atop the
    other and the ears, made of steel and 
    vermiculite, resting comfortably in his
    hands. A hat << Me.fff? "will float": "floats">> comfortably
    over Clebb's head."
  amudesc = "He << Me.fff?"will wear": "wears">> an amulet.
    Rolls of fat << Me.will >> bulge from beneath
    his once-gaunt waistband."
  pray = {
      if (self.isVisible(Me)) {
        "Clebb will bow his head down and accidentally
        bang his head against the plane floor, then speak
        the wrong prayer to the Deity Plant.\b";
      }
      self.homewards := true;
  }
  mainGoal =  nil
  doh = {
      if (self.isVisible(Me)) {
        "Clebb smacks the side of his head.
        \"DOH!!!!\" he exclaims. \"I said
        the wrong prayer!!!\"\b";
      }
      self.homewards := nil;
  }
  mainPlans = {
    if ( self.homewards )
      return( [[rBe rIn clebbland rDo rThe doh]] );
    else
      return( [[rBe rIn future2 rDo rThe pray]]);
  }
  doAskFor( actor, iobj ) = {
    if ( iobj.location != self ) {
      "But Clebb << Me.fff ? "won't":"doesn't">> have
       <<iobj.thedesc>>!";
      return( nil );
    }
    switch( iobj ) {
      case amulet:
        if ( staff.location = self ) {
          "\"Gladly.\" Clebb whips off the amulet
            and forks it over to you. Then he
            crams the Staff of Life into his mouth and swallows it
            in one gulp. \"Aaaaahhhhh ... \"\b
            You hear the voice of Aunt Krull in your head.
            \"Now, to give Os Esker that amulet ...\"\b";
          staff.moveInto( nil );
          amulet.moveInto( Me );
        } else {
          "\"My only valuable item? Never! Not unless you
            gave me something of comparable value. The
            Staff of Life, say ... if you can get it from
            the clutches of Plidi, that is. I gotta go.\"\n";
        }
        break;
      default:
        "\"NO. I'm a beggar. It's mine.
        I take pride in my possessions!\"";
    }
  }
  ioGiveTo( actor, dobj ) = {
     "Clebb's eyes light up. \"Hey, thanks!\"\b";
     dobj.moveInto( self );
  }
;

hat: clothingItem
  isworn = true
  location = clebb
  sdesc = "hat"
  ldesc = "Clebb's hat glows a jaunty blue."
  noun = 'hat'
;

stuckgecko: fixeditem
  location = dialroom
  noun = 'gecko'
  adjective = 'stuck'
  sdesc = "stuck gecko"
  ldesc = "This gecko is stuck head-first
    in the plastic wall that you are standing on.
    Its rear legs kick wildly in the air."
  verDoPull( actor ) = {
    "It's stuck really good. You lack
      the strength to move it.";
  }
  verDoTake( actor ) = self.verDoPull( actor )
  verDoMove( actor ) = self.verDoPull( actor )
;

os: myActor, rapper
  noun = 'os'
  adjective = 'esker'
  sdesc = "Os Esker"
  adesc = self.sdesc
  thedesc = self.sdesc
  oldldesc = "Os Esker, known for being strong and slow, <<Me.fff?" will carry ":" carries ">>
    a longsword which no one <<Me.fff?" will have ":" has ">> ever seen him use and
    a cleaning rag which everyone <<Me.fff?" will have ":" has ">>seen in action."
  location = future2
  oddbit = nil
  state = 0
  augmentState = {
    self.state++;
  }
  pron = "he"
  doAskFor( actor, iobj ) = {
    switch( iobj ) {
      case square:
        "\"Sure thing.\" Os << Me.fff? "will give": "gives">> 
           it to you.\n";
        square.moveInto( Me );
        break;
      default:
        "\"Nope. Mine.\"\n";
    }
  }
  animate =
  {
    if (self.oddbit) {
      self.rapAct(rHappy,nil);
      self.oddbit := nil;
    }
    else {
      if ( amulet.location = Me and amulet.isworn ) {
        if ( myrand( 100 ) > 50 ) self.oddbit := true;
      } else {
          self.oddbit := true;
      }
    }
  }
  mainGoal = nil
  movegecko = {
    if ( self.isVisible(Me) ) "\bOs Esker grabs the
     gecko and heaves with all his might.
     The gecko breaks free, then thanks
     Os and scampers off.\b";
   stuckgecko.moveInto( nil );
   self.augmentState;
  }
  cleanRoom = {
    if ( self.isVisible(Me) ) "\bOs Esker cleans
      the room. It is bright and shiny now.\b";
    self.location.isclean := true;
    self.augmentState;
  }
  plidiClean = {
    self.cleanRoom;
    if ( self.isVisible(Me) ) "\bOs Esker turns to
      Plidi and asks, \"What now, boss?\"\b
      Plidi replies, \"Very good, Os. Please clean
      out the entrance to the slots next.\"";
  }
  talkClebb = {
    if ( self.isVisible(Me) and stuckgecko.location != nil ) 
      "\bOs Esker << Me.fff ? "will tap" :"taps">> the
      faster-moving Clebb on the shoulder before asking, \"What next?\"\b
      Clebb replies, \"Stuck gecko in dial room!\"\b
      \"I'll be on it.\"\b\"Thanks!\"";
    self.augmentState;
  }
  mainPlans = {
    local m, n, r;
    m := self.state;
    n := 7;
    r := m - n*(m/n);
    switch ( r ) {
      case 0:
        return( [[rBe rIn plidiland rDo rThe plidiClean]] );
        break;
      case 1:
        return([[rBe rIn slotsroom rDo rThe cleanRoom]]);
        break;
      case 2:
        return([[rBe rIn future rDo rThe cleanRoom]]);
        break;
      case 3:
        return([[rBe rIn clebb.location rDo rThe talkClebb]]);
        break;
      case 4:
        if (stuckgecko.location = nil)
          return([[rBe rIn dialroom rDo rThe cleanRoom]]);
        else
          return([[rBe rIn dialroom rDo rThe movegecko]]);
        break;
      case 5:
        return([[rBe rIn plidiland rDo rThe cleanRoom]]);
        break;
      case 6:
        return([[rBe rIn future2 rDo rThe cleanRoom]]);
    }
  }
  ioGiveTo( actor, dobj ) = {
    switch( dobj ) {
      case amulet:
        "The eyes of the normally stodgy Os Esker << Me.will >>
          light up. \"Wow!\" he 
          << Me.fff ? "will exclaim before taking and wearing the amulet." :
          "exclaims as he takes the amulet and puts it on." >>
          \b\bOs Esker << Me.fff ? "will swell" : "swells" >> to
          a great dimension and << Me.fff ? "will zip" : "zips" >> 
          off toward the chasm at the end of the Future Plane.
          There, he will clear the gap with a single leap and
          wrestle with the Deity Plant, eventually cutting it down
          to size with his sword.
          \b\bPress <enter> ";
        yorn();
        clearscreen();
        "Freed from the oppression of the Deity Plant, Clebb, Os
          and the others will at last feel free to learn the theology of Plidi.
          Plidi, in turn, will at last feel safe to reveal the
          object of her great expenditures: a weapon to \(KILL GOD\).\b\b
          The evil god will be killed by his sandwich, before his second slice
          of toast is done.\b\b";
         wrapup();
         break;
      default:
        "\"I'll pass.\"";
    }
  }
;

staff: item
  location = plidi
  noun = 'staff'
  sdesc = "Staff of Life"
  ldesc = "A mighty staff, capable of delivering
    life and fullness to its possessor."
  verDoEat( actor ) = {}
  doEat( actor ) = {
    "It is far too valuable for eating
      at this critical juncture.";
    return( nil );
  }
;

b1: buttonitem
  location = clebbland
  noun = 'button'
  adjective = 'red' 'small'
  sdesc = "red button"
  ldesc = "It's small. It's red. It's a button."
  doPush( actor )  = {
    "The toast is ready!\b\(* * * You have won * * *\)\b\b";
  }
;

amulet: clothingItem
  location = clebb
  isworn = true
  noun = 'amulet'
  sdesc = "Amulet of Rotund Quickness"
  ldesc = "It makes you fast, and it makes you fat."
  doWear( actor ) = {
    "You <<Me.will>> feel a surge of speed and size as you put on the amulet . . .\n";
    pass doWear;
  }
;

rag: item
  location = os
  noun = 'rag'
  sdesc = "cleaning rag"
  ldesc = "The rag << Me.fff ? "will look" : "looks" >> well-used.";
;

plidi: myActor
  location = plidiland
  noun = 'plidi'
  sdesc = "Plidi"
  pron = "she"
  oldldesc = "Plidi stands twice as tall and half as wide.
    Her smile is ordinary, as are her clothes. She refuses
    to divulge what she spends her cash on."
  doAskFor( actor, iobj ) = {
    if ( iobj.location != self ) {
      "But Plidi << Me.fff ? "won't":"doesn't">> have
       <<iobj.thedesc>>!";
      return( nil );
    }
    switch( iobj ) {
      case staff:
        if ( square.location = self ) {
          "\"A fair trade.\" Plidi hurls the Staff of
            Life at you; you instinctively reach up
            and catch it.\n";
          staff.moveInto( Me );
        } else {
          "\"No, sorry. Maybe if you gave me a square.
             My daughter needs one of those for her school
             project.\"\n";
        }
        break;
      case square:
        "It's mine now. Kelci's getting it.";
        break;
      default:
        "No dice.";
    }
  }
  ioGiveTo( actor, dobj ) = {
    switch( dobj ) {
      case square:
        "\"How lovely! Kelci and her engineers will be very
          happy.\" She accepts << square.thedesc >> graciously.\b
          Plidi seems to have forgotten any previous conversation.";
        dobj.moveInto( self );
        break;
      default:
        pass ioGiveTo;
    }
  }
;

