manualParse: function;

manualParse: function(command, tokenizeFlag)
{
	local tokenList, subTokList, tokListLen, typeList, nounList, ret, tempList;
	local pAct, pVerb, pPrep, pDO, pIO, i, z, returnType, tokIndex, pVerbVerDO, pVerbVerIO;
	local ioList, doList, objList, tmpDO, tok, pStack, tmpNum;
	// here for debugging
	pStack := global;
	// The first job is to tokenize the string.
	if(tokenizeFlag) // we are processing a string command - need to tolkenize it
	{
		tokenList := parserTokenize(command);
	}
	else // we are processing an already tokenized command from the commandStack - no need to tokenize it
	{
		tokenList := command;
	}
	tokListLen := length(tokenList);
	// Check if the command is blank, and print the pardon statement if it is, and exit.
	if(tokListLen = 0)
	{
		pardon();
		return(nil);
	}
	// Split the command into multiple commands by the
	// absolute command seperators of "then" "." "!" "?"
	tokenList := splitSeperateCommands(tokenList);
	// run through each known distinct command
	for(i := 1; i <= length(tokenList); i++)
	{
		// clear any old values out
		doList := nil;
		ioList := nil;
		pPrep := nil;
		pVerb := nil;
		pAct := nil;
		pDO := nil;
		tmpDO := nil;
		pIO := nil;
		objList := nil;
		tempList := nil;
		// first, check for an actor prefix.
		subTokList := tokenList[i];
		typeList := parserGetTokTypes(subTokList);
		if(typeList) // We have a valid typeList (just being paranoid)
		{
			// check actor
			ret := checkForActor(subTokList);
			// number return means error
			returnType := datatype(ret);
			if(returnType = 7) // we have a valid actor object (and what position the tokenlist starts at after it)
			{
				pAct := ret[2];
				// we have to strip the part that referenced the actor off the front of our tokenList and typeList
				subTokList := subList(subTokList, ret[1], length(subTokList));
				typeList := subList(typeList, ret[1], length(typeList));
				// now the first element of subTokList should be a comma - if not error
				if(car(subTokList) = ',')
				{
					subTokList := cdr(subTokList);
					typeList := cdr(typeList);
				}
				else
				{
					"There\'s no verb in that sentence. \n";
					return(1);
				}
			}
			else if(returnType = 5)  //nil
			{
				pAct := parserGetMe();
			}
			else if(returnType = 3) // We got a new command back.
			{
				ret := manualParse(ret, true);
				return(ret);
			}
			else // Something happened so we couldn't finish our check for actor
			{
				return(ret);
			}
			// next we have to get the verb.
			ret := checkForVerb(subTokList);
			returnType := datatype(ret);
			if(returnType != 7) // probably nil - no verb found
			{
				"There\'s no verb in that sentence. \n";
				return(ret);
			}
			// we didn't exit so get the verb from the return list
			pVerb := ret[2];
			// now strip the verb off of our token and type lists
			if(length(subTokList) > ret[1])
			{
				subTokList := subList(subTokList, 1 + ret[1], length(subTokList));
				typeList := subList(typeList, 1 + ret[1], length(typeList));
			}
			else // we are done with our tokenList
			{
				subTokList := [];
				typeList := [];
			}
			if(length(subTokList) >= 1)
			{
				// check if we are dealing with a special word next (could be a seperator)
				tokIndex := 1;
				if((typeList[tokIndex] & PRSTYP_SPEC) != 0)
				{
					// first check if we are dealing with a number
					tmpNum := subTokList[tokIndex];
					if(!(cvtnum(tmpNum) != 0 || tmpNum = '0'))
					{
						global.commandStack += subList(subTokList, tokIndex + 1 , length(subTokList));
						// now the rest of the command is on the command stack to be executed later so nil em out
						subTokList := [];
						typeList := [];
					}
				}				
			}
			if(length(subTokList) >= 1) // there is more of the command to do
			{
				// we are looking for a nounlist to be the direct object.
				doList := parseNounList(subTokList, typeList, 1, nil, true, nil);
				if (doList = nil)
				{
					"\b I don\'t understand the sentence. ";
					return (1);
				}
				if (length(doList) = 1)
				{
					"You see no such thing. ";
					return(1);
				}
				ret := checkNounListForNil(doList);
				if(ret != 0) // special check to see if any of our nounlists couldn't be resolved to objects 
				{
					tmpNum := subTokList[doList[ret+1][1]];
					if(cvtnum(tmpNum) != 0 || tmpNum = '0')
					{
						numObj.value := cvtnum(tmpNum);
						// replace the unknown object with numObj
						doList[ret+1][3] := numObj;
					}
					else
					{
						"I don\'t know the word \"\v<<subTokList[doList[ret+1][1]]>>\". ";
						return(1);
					}
				}
				// next if the DO didn't take up the rest of the command, check for a preposition
				tokIndex := doList[1];
				// are we at the end of subTokList?
				if(length(subTokList) >= tokIndex)
				{
					// is the next element a preposition?
					if((typeList[tokIndex] & PRSTYP_PREP) != 0)
					{
						// we have a prep - look it up
						tempList := subTokList[tokIndex];
						ret := parserDictLookup([tempList], [PRSTYP_PREP]);
						if(ret != nil)
						{
							if(length(ret) = 1)
							{
								pPrep := car(ret);
								tokIndex++;
							}
							else
							{
								// more than one prep - error???
								"I don\'t understand that sentence. ";
								return(1);
							}
						}
					}
				}
				// do we have any subTokList left?
				if(length(subTokList) >= tokIndex)
				{
					// Did getting the prep work
					if(pPrep) // yes, we have prep
					{
						// look for nounList
						ioList := parseNounList(subTokList, typeList, tokIndex, nil, true, nil);
						// Did ioList not find a nounList? - if so check for command seperator
						if(length(ioList) <= 1)
						{
							// see if next token is a command seperator
							if((typeList[tokIndex] & PRSTYP_SPEC) != 0)
							{
								// this means that the prep we have has to go with the verb
								// if it doesn't we have some kind of error
								if(global.isVerbPrep)
								{
									// The verb already has a preposition - error condition
									"\n I don\'t understand that sentence. ";
									return(1);
								}
								else
								{
									// if the prep does go with the verb then the rest of command after the index is executed as another command
									tok := global.verbString + ' ' + subTokList[tokIndex];
									ret := parserDictLookup([tok], [PRSTYP_VERB]);
									if(car(ret))
									{
										pVerb := car(ret);
										// now the rest of the command is a new command - stack it
										global.commandStack += subList(subTokList, tokIndex + 1 , length(subTokList));
										subTokList := [];
										typeList := [];
									}
									else
									{
										"\n I don\'t understand that sentence. ";
										return(1);
									}
								}
							}
							else
							{
								"\n I don\'t understand that sentence. ";
								return(1);
							}
						}
						else
						{
							// check ioList for nil enteries (unknown words)
							ret := checkNounListForNil(ioList);
							if(ret != 0) // special check to see if any of our nounlists couldn't be resolved to objects 
							{
								tmpNum := subTokList[ioList[ret+1][1]];
								if(cvtnum(tmpNum) != 0 || tmpNum = '0')
								{
									numObj.value := cvtnum(tmpNum);
									// replace the unknown object with numObj
									ioList[ret+1][3] := numObj;
								}
								else
								{
									"I don\'t know the word \"\v<<subTokList[ioList[ret+1][1]]>>\". ";
									return(1);
								}
							}
							// set new tokIndex
							tokIndex := ioList[1];
						}
					}
					else // no, no prep
					{
						// Is next token a seperator?
						if((typeList[tokIndex] & PRSTYP_SPEC) != 0) // yes, stack the command
						{
							global.commandStack += subList(subTokList, tokIndex + 1 , length(subTokList));
							subTokList := [];
							typeList := [];
						}
						else // no - error words we can't use
						{
							"\n There are words after your command that I cannot use. ";
							return(1);
						}
					}
				}
				else
				{
					// we are at the end of the command
					// do a special check to see if we got a prep, but no ioList
					// in this case the prep may go with the verb. 
					// if it doesn't we have an error
					if(pPrep)
					{
						if(ioList = nil)
						{
							// try the prep with the verb
							if(global.isVerbPrep)
							{
								// The verb already has a preposition - error condition
								"\n I don\'t understand that sentence. ";
								return(1);
							}
							else
							{
								// if the prep does go with the verb then the rest of command after the index is executed as another command
								tok := global.verbString + ' ' + subTokList[tokIndex];
								ret := parserDictLookup([tok], [PRSTYP_VERB]);
								if(car(ret))
								{
									pVerb := car(ret);
								}
								else
								{
									"\n I don\'t understand that sentence. ";
									return(1);
								}
							}
						}
					}
				}
				// is there more command to do?
				if(length(subTokList) >= tokIndex)
				{
					// has to be a seperator, or we have an error
					if((typeList[tokIndex] & PRSTYP_SPEC) != 0) // yes, stack the command
					{
						global.commandStack += subList(subTokList, tokIndex + 1 , length(subTokList));
						subTokList := [];
						typeList := [];
					}
					else
					{
						"\n There are words after your command that I could not use. ";
						return(1);
					}
				}

			}
			/* resolve and disambiguate */
			// We have doList, ioList and prep
			if(ioList && doList && pPrep)
			{
				// we are trying to execute an io verb
				tempList := verbinfo(pVerb,pPrep);
				if(tempList = nil) // prep/verb combo is bad
				{
					"\n I don\'t understand that sentence. ";
					return(1);
				}
				pVerbVerDO := tempList[1];
				pVerbVerIO := tempList[2];
				ioList := parserResolveObjects(pAct, pVerb, pPrep, nil, PRO_RESOLVE_IOBJ, pVerbVerIO, subTokList, ioList, nil);
				if(car(ioList) != PRS_SUCCESS)
				{
					return(1);
				}
				pIO := car(cdr(ioList));
				objList := parserResolveObjects(pAct, pVerb, pPrep, pIO, PRO_RESOLVE_DOBJ, pVerbVerDO, subTokList, doList, nil);
				if(car(objList) != PRS_SUCCESS)
				{
					return(1);
				}
			}
			else if(doList)
			{
				// trying to execute a verb with a DO
				// first make sure this can be done (we could have an IO only verb with no IO and prep provided)
				tempList := verbinfo(pVerb);
				if(tempList) // We have this verb info
				{
					pVerbVerDO := tempList[1];
					objList := parserResolveObjects(pAct, pVerb, pPrep, nil, PRO_RESOLVE_DOBJ, pVerbVerDO, subTokList, doList, nil);
					// check for parserResolveObjects problems
					if(car(objList) != PRS_SUCCESS)
					{
						return(1);
					}
				}
				else // tempList was nil, must be a verb that requires a prep.
				{
					ret := proptype(pVerb, &prepDefault);
					if(ret != 5)
					{
						pPrep := pVerb.prepDefault;
						tempList := verbinfo(pVerb, pPrep);
						pVerbVerDO := tempList[1];
						ioList := promptForIO(pVerb);
						ret := datatype(ioList);
						if(ret = 1)
						{
							"\n I don\'t understand that sentence. ";
							return(1);
						}
						else if(ret = 3) // new command - override current.
						{
							ret := manualParse(ioList, true);
							return(ret);
						}
						else
						{
							pVerbVerIO := tempList[2];
							ioList := parserResolveObjects(pAct, pVerb, pPrep, nil, PRO_RESOLVE_IOBJ, pVerbVerIO, subTokList, ioList, nil);
							pIO := car(cdr(ioList));
							objList := parserResolveObjects(pAct, pVerb, pPrep, pIO, PRO_RESOLVE_DOBJ, pVerbVerDO, subTokList, doList, nil);
						}
					}
					else
					{
						"\n I don\'t recognize that sentence. ";
						return(1);
					}
				}
			}
			else // only get here when we have action only - no do or io - much check to see if this should be another type of verb
			{
				ret := proptype(pVerb, &action);
				if(ret = 5) // no action - user entered a verb for which there is no action - must be either an IO or DO verb.
				{
					// First see if there is any doAction options for this verb, if so we will use that to ask for the DO.
					tempList := verbinfo(pVerb);
					if(tempList) // there is a doBlah for this verb - ask for the DO.
					{
						doList := promptForDO(pVerb);
						ret := datatype(doList);
						if(ret = 1)
						{
							"\n I don\'t understand that sentence. ";
							return(1);
						}
						else if(ret = 3) // new command - override current.
						{
							ret := manualParse(doList, true);
							return(ret);
						}
						else
						{
							pVerbVerDO := tempList[1];
							objList := parserResolveObjects(pAct, pVerb, pPrep, nil, PRO_RESOLVE_DOBJ, pVerbVerDO, subTokList, doList, nil);
						}
					}
					else // no verDO - must be a verIO thing
					{
						// first check if the verb has a default prep
						ret := proptype(pVerb, &prepDefault);
						if(ret != 5)
						{
							pPrep := pVerb.prepDefault;
							tempList := verbinfo(pVerb, pPrep);
							doList := promptForDO(pVerb);
							ret := datatype(doList);
							if(ret = 1)
							{
								"\n I don\'t understand that sentence. ";
								return(1);
							}
							else if(ret = 3) // new command - override current.
							{
								ret := manualParse(doList, true);
								return(ret);
							}
							else
							{
								pVerbVerDO := tempList[1];
								ioList := promptForIO(pVerb);
								ret := datatype(ioList);
								if(ret = 1)
								{
									"\n I don\'t understand that sentence. ";
									return(1);
								}
								else if(ret = 3) // new command - override current.
								{
									ret := manualParse(ioList, true);
									return(ret);
								}
								else
								{
									pVerbVerIO := tempList[2];
									ioList := parserResolveObjects(pAct, pVerb, pPrep, nil, PRO_RESOLVE_IOBJ, pVerbVerIO, subTokList, ioList, nil);
									pIO := car(cdr(ioList));
									objList := parserResolveObjects(pAct, pVerb, pPrep, pIO, PRO_RESOLVE_DOBJ, pVerbVerDO, subTokList, doList, nil);
								}
							}
						}
					}
				}
			}
			if(objList)
			{
				if(car(objList) = PRS_SUCCESS)
				{
					pDO := cdr(objList);
				}
			}
			if(datatype(pDO) = 7)
			{
				for(z := 1 ; z <= length(pDO) ; z++)
				{
					tmpDO := pDO[z];
					if(length(pDO) > 1)
					{
						"\^<<tmpDO.sdesc>>: ";
					}
					if(pVerb = againVerb) // Special case we must handle
					{
						tmpDO := global.lastGoodDO;
						pAct := global.lastGoodAct;
						pVerb := global.lastGoodVerb;
						pPrep := global.lastGoodPrep;
						pIO := global.lastGoodIO;
					}
					ret := execCommand(pAct, pVerb, tmpDO, pPrep, pIO);
					ret := myEndCommand(ret);
					if(ret != EC_SUCCESS)
					{
						return(1);
					}
					else	// I need to capture last good command elements to manually handle againverb
					{
						global.lastGoodDO := tmpDO;
						global.lastGoodAct := pAct;
						global.lastGoodVerb := pVerb;
						global.lastGoodPrep := pPrep;
						global.lastGoodIO := pIO;
					}
				}
			}
			else
			{
				if(pVerb = againVerb) // Special case we must handle
				{
					tmpDO := global.lastGoodDO;
					pAct := global.lastGoodAct;
					pVerb := global.lastGoodVerb;
					pPrep := global.lastGoodPrep;
					pIO := global.lastGoodIO;
				}
				ret := execCommand(pAct, pVerb, tmpDO, pPrep, pIO);
				ret := myEndCommand(ret);
				if(ret != EC_SUCCESS)
				{
					return(1);
				}
				else	// I need to capture last good command elements to manually handle againverb
				{
					global.lastGoodDO := tmpDO;
					global.lastGoodAct := pAct;
					global.lastGoodVerb := pVerb;
					global.lastGoodPrep := pPrep;
					global.lastGoodIO := pIO;
				}
			}
			if(car(global.commandStack))
			{
				tok := global.commandStack;
				global.commandStack := [];
				ret := manualParse(tok, nil);
			}

		}
	"\n ";
	}
	return(ret);
}

splitSeperateCommands: function;
splitSeperateCommands: function(tok)
{
	// Splits a command token list into multiple lists 
	// based on the absolute command seperators of "then" "." "!" "?"
	local newLine, newList, i;
	newLine := [];
	newList := [];
	for(i := 1; i <= length(tok); i++)
	{
		if(tok[i] = '.' || tok[i] = '!' || tok[i] = '?' || tok[i] = 'then')
		{
			// add this line to the list
			newList += [newLine]; 
			// clear the newLine
			newLine := [];
		}
		else
		{
			newLine += tok[i];
		}
	}
	// if(car(newLine))
	// {
		// we have the last list to include
		newList += [newLine];
	// }
	return(newList);
}

checkForActor: function;
checkForActor: function(tok)
{
	local nounList, typeList, returnList, i, actorList, nounString, tmpList, myActor, listPos, ret;
	// This function takes a tokenized command as its argument.
	// It returns a list.  If no nounlist is found at the 
	// beginning of the tokenList it returns nil.
	// If a valid actor object is found, it is returned. 
	// this function could also end up returning a new command as a string if 
	// it makes a call to myParseDisambiguate() and the user enters a new command.
	actorList := [];
	typeList := parserGetTokTypes(tok);
	if(typeList) // We have a valid typeList (just being paranoid)
	{
		// now determine if the beginning of the token list can be treated as a noun phrase.
		nounList := parseNounList(tok, typeList, 1, true, nil, true);
		// Check for the case where the beginning of this command is not a noun list.
		if(nounList) // We have a result, now determine if there was a noun phrase.
		{
			if(length(nounList) = 1)
			{
				// There is no noun phrase at the beginning 
				// or, it is a noun phrase for which no objects 
				// seem to exist, so there is no more we can do here
				// (so it can't be an actor) return nil.
				return(nil);
			}
			else
			{
				// There is a noun-list we have to figure out what objects it has returned
				// and if necessary disambiguate the actor.
				// First make sure there are no unknown words in the list.
				ret := checkNounListForNil(nounList);
				if(ret != 0) // special check to see if any of our nounlists couldn't be resolved to objects 
				{
					"I don\'t know the word \"\v<<tok[nounList[ret+1][1]]>>\". ";
					return(1);
				}
				// Keep track of the starting position of the list after the noun list
				listPos := nounList[1];
				// Remove the list of objects from the return value of parseNounList.
				nounList := nounList[2];
				// Check too see what objects in the list are visible.
				for (i := 3 ; i <= length(nounList) ; i += 2)
				{
					// Check if each object is visible.
					if(nounList[i].isVisible(parserGetMe()))
						actorList += nounList[i];
				}
				if(length(actorList) = 0) // No objects returned were visible.
				{
					nounString := buildStringFromList(tok, nounList[1], nounList[2]);
					"I don\'t see any ";
					say(nounString);
					" here. ";
					return(1); // a number return will indicate an error - drop the rest of command processing
				}
				// actorList contains visible objects, now check if they are validActor
				tmpList := actorList;
				actorList := [];
				for (i := 1 ; i <= length(tmpList) ; i += 1)
				{
					// for each object we want to check validActor
					if(tmpList[i].validActor)
						actorList += tmpList[i];
				}
				// if no valid actors then message and exit
				if(length(actorList) = 0)
				{
					"You have lost your mind. \n";
					return(1); // indicates an error - stop further command processing
				}
				// if only one object remains, then return it
				if(length(actorList) = 1)
				{
					myActor := actorList[1];
					return([listPos,myActor]);
				}
				// if multiple objects still remain, check preferred actor
				tmpList := actorList;
				actorList := [];
				for (i := 1 ; i <= length(tmpList) ; i += 1)
				{
					// for each object we want to check validActor
					if(tmpList[i].preferredActor)
						actorList += tmpList[i];
				}
				// Did we get to one valid object?
				if(length(actorList) = 1)
				{
					myActor := actorList[1];
					return([listPos,myActor]);
				}
				if(length(actorList) = 0)
				{
					// none of the validActors are preferred, so we have to go back to that list.
					actorList := tmpList;
				}
				// We have more than one result - disambiguate.
				myActor := myParseDisambig(actorList);
				return(myActor);
			}
		}
		else // This case means parseNounList encountered a syntax error.
		{
			return(1); // indicates an error condition.
		}
	}
	else
	{
		// we shouldn't get here, but just in case
		return(1); // indicates an error condition
	}	
}

checkForVerb: function;
checkForVerb: function(tokenList)
{
	// This function takes a tokenized list as an argument. 
	// It figures out what the verb is, and returns it as
	// an element in a list
	local myVerb, typeList, tok, ret;
	// initialize the verbPrep flag to nil
	global.isVerbPrep := nil;
	typeList := parserGetTokTypes(tokenList);
	if(typeList) // We have a valid typeList (just being paranoid)
	{
		tok := car(tokenList);
		if(length(tokenList) > 1)
		{
			if((car(cdr(typeList)) & PRSTYP_PREP) != 0) // next element can be a prep, so try and include it
			{
				tok := tok + ' ' + car(cdr(tokenList));
				ret := parserDictLookup([tok], [PRSTYP_VERB]);
				if(car(ret))
				{
					global.verbString := tok;
					global.isVerbPrep := true;
					myVerb := car(ret);
					return([2,myVerb]);
				}
				else // try the verb without the extra token that may have been a preposition
				{
					tok := car(tokenList);
					ret := parserDictLookup([tok], [PRSTYP_VERB]);
					if(car(ret))
					{
						global.verbString := tok;
						myVerb := car(ret);
						return([1,myVerb]);
					}
					else
					{
						return(nil);
					}
				}
			}
		}
		// we will get here if the list has only one token, or the next element could not be used as a prep.
		ret := parserDictLookup([tok], [PRSTYP_VERB]);
		if(car(ret))
		{
			global.verbString := tok;
			myVerb := car(ret);
			return([1,myVerb]);
		}
		else
		{
			return(nil);
		}
	}
}

checkForDO: function;
checkForDO: function(tok, pAct, pVerb)
{
	// Look for a noun phrase
	local nounList, typeList, ret, listPos, i, tempList;
	typeList := parserGetTokTypes(tok);
	if(typeList) // We have a valid typeList (just being paranoid)
	{
		nounList := parseNounList(tok, typeList, 1, nil, true, nil);
		if(nounList)
		{
			if(length(nounList) = 1)
			{
				// There is either no noun phrase, or 
				// There is no noun phrase at the beginning 
				// or, it is a noun phrase for which no objects 
				// seem to exist, so there is no more we can do here
				// (so it can't be an actor) return nil.
				return(car(nounList));
			}
			else
			{
				// There is a noun-list (or multiple noun lists)
				// Keep track of the starting position of the list after the noun list
				listPos := nounList[1];
				nounList := cdr(nounList);
				for(i := 1 ; i <= length(nounList) ; i++)
				{
					tempList := nounList[i];
					// now pull all of the objects 
				}
				
				// Remove the list of objects from the return value of parseNounList.
				nounList := nounList[2];
			}
		}
		else // This case means parseNounList encountered a syntax error.
		{
			return(1); // indicates an error condition.
		}
	}



}

buildStringFromList: function;
buildStringFromList: function(myList, start, end)
{
	// passed a list, a start position, and end position 
	// this returns a string of the positions concatenated
	// together with spaces between the words.
	local i, returnString;
	returnString := '';
	for(i := start ; i <= end ; i++)
	{
		returnString += myList[i] + ' ';
	}
	return(returnString);
}

myParseDisambig: function;
myParseDisambig: function(lst)
{
	// returns one of the following
	// an object that was chosen by the player
	// a string representing a new command
	// a number to indicate an error - halt processing current command
	local i, tot, cnt, str, tokenList, typeList, ret, objList, nounList;
	"Which << str >> do you mean, ";
	for (i := 1, cnt := length(lst) ; i <= cnt ; ++i)
	{
		lst[i].thedesc;
		if (i < cnt) ", ";
		if (i + 1 = cnt) "or ";
	}
	"? \n >";
	str := input();
	tokenList := parserTokenize(str);
	if(tokenList)
	{
		typeList := parserGetTokTypes(tokenList);
		ret := parseNounList(tokenList, typeList, 1, true, nil, nil);
		if(ret = nil)
			return(1); // indicate error condition
		else if(length(ret) = 1) // The player entered a line that did not begin with a noun phrase - treat as new command
			return(str);
		else // We have a list of objects to deal with 
		{
			// strip the list down to only the objects and intersect it with the disambig list
			nounList := [];
			ret := ret[2];
			for (i := 3 ; i <= length(ret) ; i += 2)
			{
				nounList += ret[i];
			}
			// now get the intersect of the objects just retrieved, and the original list we are disabiguating
			objList := intersect( nounList, lst );
			// no interecting elements - assume new command and pass it back as such
			if(length(objList) = 0)
				return(str);
			// one interecting element - this is the one picked - return it
			else if(length(objList) = 1)
			{
				objList := objList[1];
				return(objList);
			}
			else
			{
				// multi intersecting elements - call this function recurively (with message lets try this again)
				"Let\'s try this again: ";
				objList := myParseDisambig(objList);
				return(objList);
			}
		}
	}
	else
	{
		return('');  // The player entered a blank string (we will process as a new command).
	}

}

subList: function;
subList: function(lst, startPos, endPos)
{
	local len, start, end, i, retList;
	retList := [];
	len := length(lst);
	if(startPos < 1 || endPos < 1)
		return(lst);
	if(startPos > len)
		return(lst);
	if(startPos = endPos)
	{
		lst := lst[startPos];
		return([lst]);
	}
	if(startPos < endPos)
	{
		start := startPos;
		end := endPos;
	}
	else
	{
		start := endPos;
		end := startPos;
	}
	if(end > length(lst))
		end := length(lst);
	for(i := start ; i <= end ; i++)
	{
		retList += lst[i];
	}
	if(datatype(retList) != 7)
	{
		retList := [retList];
	}
	return(retList);
}

checkNounListForNil: function;
checkNounListForNil: function(doList)
{
	// check for any nils in the nounlist - indicate a word we don't know.
	local tmpList, i;
	tmpList := cdr(doList);
	for(i := 1 ; i <= length(tmpList) ; i++)
	{
		if(tmpList[i][3] = nil)
		{
			return(i);
		}
	}
	return(0);
}

promptForDO: function;
promptForDO: function(pVerb)
{
	local str, tokenList, typeList, ret;
	"\n What do you want to <<pVerb.sdesc>>? \n >";
	str := input();
	// tokenize the input string
	tokenList := parserTokenize(str);
	if(tokenList)
	{
		typeList := parserGetTokTypes(tokenList);
		ret := parseNounList(tokenList, typeList, 1, true, nil, nil);
		if(ret = nil)
		{
			return(1); // indicate error condition
		}
		else if(length(ret) = 1) // The player entered a line that did not begin with a noun phrase - treat as new command
		{
			return(str);
		}
		else // We have a list of objects to deal with 
		{
			return(ret);
		}
	}
	else
	{
		return('');  // The player entered a blank string (we will process as a new command).
	}
}

promptForIO: function;
promptForIO: function(pVerb)
{
	local str, tokenList, typeList, ret;
	"\n What do you want to <<pVerb.sdesc>> it <<pVerb.prepDefault.sdesc>>? \n >";
	str := input();
	// tokenize the input string
	tokenList := parserTokenize(str);
	if(tokenList)
	{
		typeList := parserGetTokTypes(tokenList);
		ret := parseNounList(tokenList, typeList, 1, true, nil, nil);
		if(ret = nil)
		{
			return(1); // indicate error condition
		}
		else if(length(ret) = 1) // The player entered a line that did not begin with a noun phrase - treat as new command
		{
			return(str);
		}
		else // We have a list of objects to deal with 
		{
			return(ret);
		}
	}
	else
	{
		return('');  // The player entered a blank string (we will process as a new command).
	}
}


myEndCommand: function;
myEndCommand: function(ret)
{
	if(ret = EC_SUCCESS)
	{
		if(global.abortFlag)
		{
			return(EC_ABORT);
		}
		else
		{
			rundaemons();
			runfuses();
			return(ret);
		}
	}
	else
	{
		return(ret);
	}
}

modify quitVerb
    action(actor) =
    {
        self.quitGame(actor);
	if(global.parseFlag)
	{
		global.abortFlag := true;
	}
	else
	{
	        abort;
	}
    }
;

modify verboseVerb
    action(actor) =
    {
        self.verboseMode(actor);
	if(global.parseFlag)
	{
		global.abortFlag := true;
	}
	else
	{
	        abort;
	}
    }
;

modify terseVerb
    action(actor) =
    {
        self.terseMode(actor);
	if(global.parseFlag)
	{
		global.abortFlag := true;
	}
	else
	{
	        abort;
	}
    }
;

modify scoreVerb
    action(actor) =
    {
        self.showScore(actor);
	if(global.parseFlag)
	{
		global.abortFlag := true;
	}
	else
	{
	        abort;
	}
    }
;

modify saveVerb
    action(actor) =
    {
        self.saveGame(actor);
	if(global.parseFlag)
	{
		global.abortFlag := true;
	}
	else
	{
	        abort;
	}
    }
;

modify restoreVerb
    action(actor) =
    {
        self.restoreGame(actor);
	if(global.parseFlag)
	{
		global.abortFlag := true;
	}
	else
	{
	        abort;
	}
    }
;

modify scriptVerb
    action(actor) =
    {
        self.startScripting(actor);
	if(global.parseFlag)
	{
		global.abortFlag := true;
	}
	else
	{
	        abort;
	}
    }
;

modify unscriptVerb
    action(actor) =
    {
        self.stopScripting(actor);
	if(global.parseFlag)
	{
		global.abortFlag := true;
	}
	else
	{
	        abort;
	}
    }
;

modify restartVerb
    action(actor) =
    {
        self.restartGame(actor);
	if(global.parseFlag)
	{
		global.abortFlag := true;
	}
	else
	{
	        abort;
	}
    }
;

modify versionVerb
    action(actor) =
    {
        self.showVersion(actor);
	if(global.parseFlag)
	{
		global.abortFlag := true;
	}
	else
	{
	        abort;
	}
    }
;

modify debugVerb
    action(actor) =
    {
        self.enterDebugger(actor);
	if(global.parseFlag)
	{
		global.abortFlag := true;
	}
	else
	{
	        abort;
	}
    }
;

modify undoVerb
    action(actor) =
    {
	if(global.parseFlag)
	{
		"There is no turning back now. \b";
		global.abortFlag := true;
	}
	else
	{
        	self.undoMove(actor);
	        abort;
	}
    }
;
