startroom: room
	firstLook = true
	sdesc = "Kitchen"
	ldesc = 
	{
		if(firstLook)
		{
			"Looking around your cramped kitchen you are always 
			amazed that the three time super hero of the year 
			can\'t afford to put in a breakfast nook. You can\'t 
			really complain though. The kitchen is clean and 
			comfortable, and the home to the wonderfully 
			relaxing family dinners that help you unwind 
			after a hectic day of thwarting super villains. 
			The linoleum on the counter is a little faded, and 
			the tiles on the floor are scuffed in places, 
			but it all adds up to a cozy lived-in feel. Josh, 
			your two year old, is seated at the kitchen table 
			waiting for his breakfast. \b";
			"\"Toast Dad.\", he says with a slight nod of his 
			head, \"I want toast.\" \b";
			"You take out the loaf of wonder bread and place 
			the toaster on the counter. You open the loaf of 
			bread. Uh-oh! Only one slice left. Better get it 
			right the first time. \b";
			self.firstLook := nil;
		}
		else
		{
			"The small kitchen table placed directly in the middle 
			of the room makes it hard to navigate around the kitchen. 
			The toaster sits out on the counter. ";

			"The worn tile makes a transfer to brown shag carpet where 
			the kitchen attaches to the living room to the west. ";

			if(josh.location = self)
			{
				"\n\t Josh is sitting at the kitchen table waiting 
				for his toast. ";
			}
		}
	}
	west = 
	{
		if(josh.location = self)
		{
			"You can\'t leave Josh in here alone with the toaster. ";
			return nil;
		}
		else
		{
			return livingroom;
		}
	}
	timeDaemon = 
	{
		"\b You catch a glimpse of the clock on the wall, and recoil in 
		shock. It is already 7:55 AM. If you don\'t get Josh fed, and get 
		out of the house in 5 minutes you will miss the 8:00 bus and 
		your 9:00 meeting about taking out Cheddar Man\'s secret hideout. 
		Okay, breath, calm down. You can do this. After all, 
		how long can it take to make toast for a two year old? ";
		unnotify(self, &timeDaemon);
		global.parseFlag := true;
		myParse();
	}
;

chair: chairitem
	noun = 'chair'
	plural = 'chairs'
	sdesc = "chair"
	location = startroom
	ldesc = "The simple hardwood chairs don\'t match the table, but they fit 
		in close enough not to clash. "
    	verDoSiton(actor) = 
	{
		if (actor = Me)
		{
			"You don\'t have time to sit down. You have to get everyone fed 
			so you won\'t be late for your meeting. ";
		}
		if (actor.location = self)
		{
			"%You're% already on "; self.thedesc; "! ";
		}
	}
;

table: surface
	isListed = nil
	noun = 'table'
	sdesc = "table"
	location = startroom
;

counter: surface
	isListed = nil
	noun = 'counter'
	sdesc = "counter"
	location = startroom
	ldesc = "The countertop is faded from years of use. "
;

modify Me
	ldesc = "You are \"Remote Man\", a modern day superhero with the ability to operate any remote
		controlled device with the power of your mind. You specialize in opening the garage doors 
		of super criminal\'s secret hideouts. "
;

josh: Actor
	timer = 0
	flag1 = true
	flag2 = true
	flag3 = true
	flag4 = true
	flag5 = true
	flag6 = true
	flag7 = true
	noun = 'josh' 'son' 'boy' 'child'
	sdesc = "Josh"
	ldesc = "Still dressed in his Spiderman pajamas (where\'s the loyalty), 
		he is the apple of your eye. "
	actorDesc = {}
	location = startroom
	actorAction(v, d, p, i) =
	{
		if(v != verbPlay)
		{
			"\"No.\" ";
			exit;
		}
	}
	ioGiveTo(actor, dobj) =
	{
		if(isclass(dobj, toy))
		{
			if(self.flag6 = nil && self.flag7 = true)
			{
				"You try and give Josh <<dobj.thedesc>> to distract him. He sobs one 
				final time, and then takes it. ";
				self.flag7 := nil;
				dobj.doPlaywith(josh);
			}
			else
			{
				"Josh takes the toy. ";
				dobj.doPlaywith(josh);
			}

		}
		else if(dobj = bread)
		{
			if(bread.toasted < 60)
			{
				"\"Dad, that\'s not toast yet.\", Josh says. ";
			}
			else if(bread.toasted > 180)
			{
				"Josh takes the toast and nibbles at the corner. \"Icky!\", he says. ";
				"Having no other breakfast options at this point you take Josh to catch 
				the bus. Because he is still hungry you buy him a donut at the bus station. 
				He ends up getting sick on the bus, and you get in deep trouble when your 
				wife hears all about the great advenure he had when he got to throw up 
				out the bus window. ";
				win();
			}
			else
			{
				"Josh happily munches down the toast as you usher him out the door. Josh 
				gets to daycare on time, you get to your meeting on time, and you get 
				the dad of the year award. Yay! ";
				win();
			}
		}
		else
		{
			"Josh doesn\'t want it.";
		}

	}
	joshAction = 
	{
		local promptFlag;
		promptFlag := nil;
		self.timer++;
		if(self.timer > 10 && flag1)
		{
			if(parserGetMe().location = self.location)
			{
				"\b Josh fidgets at the table. \n";
				promptFlag := true;
			}
			flag1 := nil;
		}
		else if(self.timer > 18 && flag2)
		{
			if(parserGetMe().location = self.location)
			{
				"\b Josh whines, \"I\'m hungry.\". \n";
				"You tell him you are getting breakfast ready as fast as you can. \n";
				promptFlag := true;
			}
			flag2 := nil;
		}
		else if(self.timer > 30 && flag3)
		{
			if(parserGetMe().location = self.location)
			{
				"\b Josh asks, \"When is mom coming home?\". \n";
				"\"Tomorrow,\" you answer him. \n";
				promptFlag := true;
			}
			flag3 := nil;
		}
		else if(self.timer > 50 && flag4)
		{
			if(parserGetMe().location = self.location)
			{
				if(bread.location = toaster && toastLever.leverDown)
				{
					"\b Josh says, \"That\'s not how mom makes it.\" \n";
					"\"Well, mom doesn\'t make super-toast like I do\" you reply. \n";
				}
				else
				{
					"\b Josh says, \"Dad, you have to put the bread in and push 
					the lever.\" \n";
				}
				promptFlag := true;
			}
			flag4 := nil;
		}
		else if(self.timer > 60 && flag5)
		{
			if(parserGetMe().location = self.location)
			{
				"\b Josh says, \"I\'m bored.\" \n";
				"He goes into the living room, and you can hear him playing with his toys. \n ";
				josh.travelTo(livingroom);
				promptFlag := true;
			}
			flag5 := nil;
		}
		else if(self.timer > 64 && flag6)
		{
			if(parserGetMe().location = startroom && josh.location = livingroom)
			{
				"\b You hear a crash from the living room, and Josh screams in pain. \n";
				promptFlag := true;
			}
			else
			{
				"Josh runs in circles, and then runs right into the wall stubbing his toe. 
				He crumples to the ground and begins screaming. \n";
				promptFlag := true;
			}
			flag6 := nil;
		}
		else if(self.timer > 65 && flag7)
		{
			if(parserGetMe().location = startroom && josh.location = livingroom)
			{
				"\b Josh cries out, \"Daaaad!\". \n";
				promptFlag := true;
			}
			else
			{
				"\b Josh sobs, holding his toe. \n";
				promptFlag := true;
			}
		}
		return(promptFlag);
	}
;

clock: fixeditem, floatingItem
	noun = 'clock'
	adjective = 'digital'
	sdesc = "clock"
	location = 
	{
		return(parserGetMe().location);
	}
	ldesc = 
	{
		"The organization you work for, \"The Justice League\" insists 
		that all super heroes hang these monsterous digital clocks in 
		every room of its member\'s houses. They may all fight on the 
		side of justice, but most members rely too heavily on their super 
		powers, and not enough on their brains. This policy was put in 
		place after several team members were constantly late for 
		raids on the bad guy\'s lairs which are always tightly timed 
		affairs. ";
	}
;

toaster: fixeditem, container
	noun = 'toaster'
	adjective = 'steel' 'chrome'
	sdesc = "toaster"
	location = startroom
	doPush -> toastLever
	doTurn -> toastSlide
	doTurnTo -> toastSlide
	ldesc = 
	{
		"All steel and chrome, your antique toaster is a serious piece of hardware. It has a handle on 
		one end you push down to start the hot toasting action, and a slide setting on the bottom 
		which goes from 1-6 you can set to control the darkness. ";
	}
;

toastLever: fixeditem
	leverDown = nil
	noun = 'lever' 'handle'
	adjective = 'toaster'
	location = toaster
	sdesc = "toasting lever"
	ldesc = 
	{
		if(toaster.leverUp)
		{
			"The lever on the toaster is in the up position. ";
		}
		else
		{
			"The lever on the toaster is in the down position. ";
		}
	}
	verDoPush(actor) = 
	{
		if(self.leverDown)
		{
			"The lever is already down. ";
		}
	}
	doPush(actor) = 
	{
		"You press the handle down. ";
		if(toaster.contents)
		{
			"The toaster makes a brief humming noise, and begins 
			to heat up. ";
			self.leverDown := true;
		}
		else
		{
			"The handle pops right back up. It won\'t stay down 
			unless there is bread in the toaster, some newfangled 
			safety feature. ";
		}
	}
	verDoPull(actor) = 
	{
		if(not self.leverDown)
		{
			"The lever is already up. ";
		}
	}
	doPull(actor) = 
	{
		"You pull the toaster handle back up. ";
		if(bread.location = toaster)
		{
			"The toasted bread pops sticks out the top. ";
		}
		self.leverDown := nil;
	}
;

toastSlide: dialItem, fixeditem
	minsetting = 1  // it has settings from this value...
	maxsetting = 6 // ...to this value
	setting = 1     // the current setting
	noun = 'slide' 'setting'
	adjective = 'darkness'
	location = startroom
	sdesc = "darkness setting"
	ldesc = 
	{
		"The darkness setting on the toaster is currently set to ";
		say(cvtstr(self.setting));
		". ";
	}
;

modify turnVerb
    verb = 'turn' 'rotate' 'twist' 'set' 'slide'
;

bread: item
	toasted = 0
	smell1Flag = true
	smell2Flag = true
	smell3Flag = true
	smell4Flag = true
	smell5Flag = true
	smokeFlag = true
	noun = 'bread'
	sdesc = 
	{
		if(self.toasted < 40)
		{
			"bread";
		}
		else
		{
			"toast";
		}
	}
	adesc = 
	{
		if(self.toasted < 40)
		{
			"a slice of bread";
		}
		else
		{
			"a slice of toast";
		}
	}
	location = counter
	ldesc = 
	{
		if(self.toasted = 0)
		{
			"The pastey white bread is unworthy of being considered for breakfast in its current 
			untoasty state. ";
		}
		else if(self.toasted < 20)
		{
			"The bread has just started to get warm. We still can\'t call it toast yet. ";
		}
		else if(self.toasted < 40)
		{
			"Still more bread than toast. You could maybe pass it off as toast if it 
			was smothered in peanut butter, but Josh will never accept it like this. ";
		}
		else if(self.toasted < 60)
		{
			"Okay, it can officially be called toast now, but really, only the weak and infirm 
			would eat toast this light. This is at the very edge of the toast spectrum. ";
		}
		else if(self.toasted < 80)
		{
			"Finally entering the mainstream toasting range, the toast has nice uniform light tan. 
			Like it spent the afternoon working shirtless in the sun with some SPF 15 slathered on.";
		}
		else if(self.toasted < 100)
		{
			"Captain, there be toast here. The toast has achieved a nice golden hue. ";
		}
		else if(self.toasted < 120)
		{
			"The toast is approaching optimum toastiness. A few deep brown patches have begun 
			to appear amongst the light golden color. ";
		}
		else if(self.toasted < 140)
		{
			"Now we are talking some serious toast. The deep brown color has spread all the way 
			to the edges. ";
		}
		else if(self.toasted < 160)
		{
			"We are looking at toast on the edge. It is still perfectly good toast, but the crust 
			is starting to get slightly burned around the edge. ";
		}
		else if(self.toasted < 180)
		{
			"This toast has been taken to the extreme. The crust is burned, and the surface is speckled 
			with burned splotches, however some brown is still visible. If you like burnt food you could choke it down, and 
			it could probably be salvaged by the old scraping manuever. ";
		}
		else
		{
			"Burned to a crisp. Unsalvagable. How sad. ";
		}
	}
	breadAction = 
	{
		local printFlag;
		printFlag := nil;
		if(bread.location = toaster && toastLever.leverDown)
		{
			self.toasted := self.toasted + toastSlide.setting;
			if (self.toasted > 220)
			{
				if(parserGetMe().location = startroom)
				{
					"\b The toaster suddenly bursts into flames! By the time 
					you finish putting it out, calming down Josh, and cleaning 
					the kitchen you have missed your bus. Oh well, so what if 
					you get assigned to super hero desk duty for a while. You 
					decide to skip the crime fighting for today, and decide to 
					take Josh out for waffles. ";
					win();
				}
				else
				{
					"Smoke starts pouring into the living room from the kitchen. 
					When you look into the kitchen you see flames shooting out 
					of the toaster! You rush into the kitchen to put out the fire. 
					By the time you finish putting it out, calming down Josh, and cleaning 
					the kitchen you have missed your bus. Oh well, so what if 
					you get assigned to super hero desk duty for a while. You 
					decide to skip the crime fighting for today, and decide to 
					take Josh out for waffles. ";
					win();
				}
			}
			if (self.toasted > 40)
			{
				addword(self, &noun, 'toast');
			}
			if(self.toasted > 20 && smell1Flag)
			{
				if(parserGetMe().location = startroom)
				{
					"\b You smell a wonderful toasty smell. ";
				}
				smell1Flag := nil;
				printFlag := true;
			}
			else if(self.toasted > 80 && smell2Flag)
			{
				if(parserGetMe().location = startroom)
				{
					"\b The aroma of toast grows stronger. ";
				}
				smell2Flag := nil;
				printFlag := true;
			}
			else if(self.toasted > 160 && smell3Flag)
			{
				if(parserGetMe().location = startroom)
				{
					"\b You think you smell the faintest whiff of something burning. ";
				}
				smell3Flag := nil;
				printFlag := true;
			}
			else if(self.toasted > 180 && smell4Flag)
			{
				if(parserGetMe().location = startroom)
				{
					"\b You smell something burning. ";
				}
				smell4Flag := nil;
				printFlag := true;
			}
			else if(self.toasted > 200 && smell5Flag)
			{
				if(parserGetMe().location = startroom)
				{
					"\b You smell something burning. Smoke begins to fill the room. ";
				}
				smell5Flag := nil;
				printFlag := true;
			}
		}
		return(printFlag);
	}
;

livingroom: room
	sdesc = "Living Room"
	ldesc = 
	{
		"The living room is a mess. Josh\'s toys are scattered 
		all over the floor. The television is against the west 
		wall, and the kitchen is to the east. ";
		if(josh.location = self)
		{
			if(josh.flag6 = nil && josh.flag7 = true)
			{
				"Josh is crying on the floor in pain. ";
			}
			else
			{
				"Josh is quietly playing with his toys. ";
			}
		}
	}
	east = 
	{
		if(josh.location = self && josh.flag6 = nil && josh.flag7 = true)
		{
			"You can\'t leave a crying child. ";
			return nil;
		}
		else if(josh.location = self && josh.flag5 = true)
		{
			"\"You coming?\", you ask. \n ";
			"Josh ingores you and plays with his toys. \n";
			return startroom;
		}
		else
		{
			"Josh follows you back into the kitchen. \n";
			josh.travelTo(startroom);
			return startroom;
		}
	}
;

class toy: item
;

ball: toy
	noun = 'ball'
	adjective = 'red' 'bouncy' 'rubber'
	location = livingroom
	sdesc = "red rubber ball"
	ldesc = "Almost as big as Josh\'s head, the red ball was perfect for the game 
		of dodgeball you played in the house last night. "
	doThrow(actor) = {self.doPlaywith(actor);}
	doPlaywith(actor) = 
	{
		if(actor = parserGetMe())
		{
			if(parserGetMe().location = josh.location)
			{
				if(josh.flag6 = nil && josh.flag7 = true)
				{
					pass doPlaywith;
				}
				else
				{
					"You gently toss the ball to Josh. He stands there, arms outstretched 
					and the ball hits him in the face. He laughs and picks it up. He tries 
					to throw it back at you, but his aim is off and it bounces into the corner. ";
				}
			}
			else
			{
				"You bounce the ball. ";
			}
		}
		else
		{
			if(parserGetMe().location = josh.location)
			{
				"Josh throws the ball off the wall, and it ricochets into the corner. ";
			}
		}
	}
;

figure: toy
	noun = 'figure' 'doll'
	adjective = 'action' 'super' 'hero' 'remote' 'man'
	sdesc = "action figure"
	ldesc = "You gave Josh a copy of your very own action figure hoping he would 
		fight imaginary bad guys with it while you are at work. Unfortunately, 
		his favorite game to play with it is to put Barbie\'s pink prom dress 
		on it and play tea party. "
	doPlaywith(actor) = 
	{
		if(actor = parserGetMe())
		{
			if(parserGetMe().location = josh.location)
			{
				if(josh.flag6 = nil && josh.flag7 = true)
				{
					pass doPlaywith;
				}
				else
				{
					"You pretend to make the figure fly. Josh grabs it from you 
					and says, \"No Dad, he has to walk.\" ";
				}
			}
			else
			{
				"You woosh the figure through the air, if only your super 
				powers included the gift of flight. ";
			}
		}
		else
		{
			if(parserGetMe().location = josh.location)
			{
				"Josh bends the figure\'s leg way up in the air and spins it 
				in a circle. \"Look Dad, he\'s dancing,\" he says. ";
			}
		}
	}
;

verbPlay: deepverb
	verb = 'play' 'play with'
	sdesc = "play with"
	location = livingroom
	doAction = 'Playwith'
;

