var commandHistory = []
var commandHistoryPointer = 0

var screenHistory = []
var screenHistoryPointer = 0

var autocompleteWords = []
var suspendAutocomplete
var previousValue
var importantWords = []
var forcedMove = ""

var moveLog = []
var commandLog = []

var backgrounds = {}
var background
	
var jitter = 0
var madness = 0
var drunk = 0
	
var sayTarget = undefined
	
function Keypress(e) {
	if (e.keyCode == 13) {
		if (_commandline.value == "g" && commandHistory.length > 0)
			_commandline.value = commandHistory[commandHistory.length - 1]

		//DoAutocomplete()
		suspendAutocomplete = false
		
		commandline.value = commandline.value.trim()
		
		if (_commandline.value != "" && (commandHistory.length == 0 || commandHistory[commandHistory.length - 1] != _commandline.value))
			commandHistory.push(_commandline.value)

		//Say (">" + _commandline.value)
		
		if (_commandline.value.charAt(0) == "@") {
			try {
				eval(_commandline.value.substr(1))
			} catch (e) {
				Say(e.toString(), "box error")
			}
		}

		commandLog.push (_commandline.value)
		
		Run(_commandline.value)

		commandHistoryPointer = commandHistory.length

		_commandline.value = ""
	
	} else if (e.keyCode == 32) {
		if (_commandline.value.length == 0) {
			Run()
		} else {
			DoAutocomplete()
		}
	
	} else if (e.keyCode == 9) {
		DoAutocomplete()
		_commandline.value += " "
		e.preventDefault()
	
	} else if (e.keyCode == 27) {
		suspendAutocomplete = true
		_autocomplete.value = ""
		e.preventDefault()
		
	} else if (e.keyCode == 38) {
		History(-1)
		
	} else if (e.keyCode == 40) {
		History(1)
		
	} else if (e.keyCode == 39 && _commandline.selectionStart == _commandline.value.length) {
		DoAutocomplete()
		_commandline.value += " "
		
	} else if (e.keyCode == 116) {
		//F5
	}
}

function History(dir) {
	commandHistoryPointer += dir
	if (commandHistoryPointer < 0) commandHistoryPointer = 0
	if (commandHistoryPointer > commandHistory.length) commandHistoryPointer = commandHistory.length

	if (commandHistoryPointer == commandHistory.length) {
		_commandline.value = ""
		return
	}

	_commandline.value = commandHistory[commandHistoryPointer]
}

function UpdateAutocomplete () {
	if (previousValue == _commandline.value || suspendAutocomplete) return
	previousValue = _commandline.value
	
	if (_commandline.value.charAt(0) == "@") _commandline.style.color = "red"
	//else _commandline.style.color = "white"
	
	_autocomplete.style.color = _commandline.style.color
	
	for(var i = _commandline.value.length - 1; i >= 0; i--) {
		if (_commandline.value.charCodeAt(i) == 32) break
	}
	var token = _commandline.value.slice(i + 1).toLowerCase()
	
	if (token.length > 0) {		
		for(var i = autocompleteWords.length - 1; i >= 0; i--) {
			var suggestedCompletion = autocompleteWords[i]
			
			if (suggestedCompletion.indexOf(token) == 0) {
				_autocomplete.value = _commandline.value + suggestedCompletion.slice(token.length)
				return
			}
		}
	}
		
	_autocomplete.value = ""
	
}

function DoAutocomplete () {
	if (!suspendAutocomplete && _autocomplete.value != "") {
		_commandline.value = _autocomplete.value
	}
	
	suspendAutocomplete = false
}

function MouseWheel (e) {
	if (e.wheelDelta > 1) {
		if (screenHistoryPointer == screenHistory.length) {
			_output.style.display = "none"
			_history.style.display = "block"
		}
		
		screenHistoryPointer--
		if (screenHistoryPointer < 0) screenHistoryPointer = 0
	} else {
		if (screenHistoryPointer == screenHistory.length) Run()
		
		screenHistoryPointer++
		if (screenHistoryPointer > screenHistory.length) screenHistoryPointer = screenHistory.length
		
		if (screenHistoryPointer == screenHistory.length) {
			_history.style.display = "none"
			_output.style.display = "block"
		}
	}
	
	if (screenHistoryPointer != screenHistory.length) {
		_history.innerHTML = screenHistory[screenHistoryPointer]
	}
}

function ClickAnywhere () {
	_commandline.focus()
}

function Say(text, c) {
	if (typeof text != "string") text = text.toString()
	if (!c) c = "box"
	go = false
	
/* 	if (c != "box error") {
 * 		while (inlineCommands = text.match(/\[[^\]]+\]/g)) {
 * 			for (var i = 0; i < inlineCommands.length; i++) { 
 * 				try {
 * 					var returnedValue = eval(inlineCommands[i].slice(1, -1))
 * 				} catch (e) {
 * 					text = e + "</br>" + text
 * 					c = "box error"
 * 				}
 * 				text = text.replace (inlineCommands[i], returnedValue)
 * 			}
 * 		}
 * 		
 * 		while (clickCommands = text.match(/{[^}]+}/g)) {
 * 			for (var i = 0; i < clickCommands.length; i++) {
 * 				var halves = clickCommands[i].slice(1, -1).split('|')
 * 				var returnedValue = "<span onclick='" + halves[0] + "; event.stopPropagation()' onmousedown='event.preventDefault()' class='click'>" + halves[1] + "</span>"
 * 				
 * 				text = text.replace (clickCommands[i], returnedValue)
 * 			}
 * 		}
 * 	}
 */
	
	if (turn > 30 && c != "box monospace") {
		var len = turn - 30
		if (len > text.length / 2) len = parseInt(text.length / 2)

		var str = roar (between (len / 4, len + 1))
		var cut = between (len, text.length + 1)
		
		text = text.slice(0, cut - len) + str + text.slice(cut) 
	}
	if (turn - 45 > between(0, 10)  && c != "box monospace") {
		var len = between (turn - 45, text.length)
		var cut = between(len, text.length + 1)
		text = text.slice(0, cut - len) + text.slice(cut)
	}
	
	var node=document.createElement("div")
	node.setAttribute("Class", c)
	
	var jitter = Math.max((turn - 30) / 5, 0)
	if (jitter > 0 && c != "box monospace") {
		node.style.left = (node.style.left + Math.random() * jitter * 2 - jitter) + "px"
		node.style.top = (node.style.top + Math.random() * jitter * 2 - jitter) + "px"
	}
	var madness = Math.max((turn - 40) / 2, 0)
	if (madness > 0 && c != "box monospace")
		node.style.transform = "rotate(" + (Math.random() * madness * 2 - madness) + "deg)"
	if (drunk > 0) {
		var words = text.split(' ')
		
		for (var i = 0; i < words.length; i++)
			if (Math.random() * 100 < drunk)
				words[i] = "<span style='display:inline-block; transform: scale(-1,1)'>" + words[i] + "</span>"
		
		text = words.join(' ')				
	}
	
	autocompleteWords = autocompleteWords.concat(text.replace(/[^\w\s]/g, "").toLowerCase().split(' '))
	autocompleteWords = autocompleteWords.concat(importantWords)	
	
	sayTarget.appendChild(node)
	node.innerHTML = text
	
/* 	if (_commandline.getBoundingClientRect().top < ScreenHeight() / 2)
 * 		var target = ScreenHeight()
 * 	else
 * 		var target = _commandline.getBoundingClientRect().top
 * 	
 * 	if (node.getBoundingClientRect().bottom > target) {
 * 		_output.removeChild(node)
 * 		
 * 		Clear()
 * 	
 * 		_output.appendChild(node)
 * 	}
 */
	window.scrollTo(0, 1000000);
}

function ScreenHeight () {
	 return Math.max (document.body.clientHeight, document.documentElement.clientHeight)
}

function ScreenWidth () {
	 return Math.max (document.body.clientWidth, document.documentElement.clientWidth)
}

function Fadeout () {
	var i = 0

	while (boxes[i]) {
		boxes[i].className += " grey"
		i++
	}
}

function Clear (type) {
	if (!type) type = "box"
	var elements = document.getElementsByClassName(type)
	var i = 0

	if (type == "box" && elements.length > 0) {
		while (elements[i]) {
			elements[i].className += " history"
			i++
		}
		
		screenHistory.push (_output.innerHTML)
		screenHistoryPointer = screenHistory.length
	}

	while (elements[0]) {
		elements[0].parentNode.removeChild(elements[0])
	}
}
