/*
 * Decompiled with CFR 0.152.
 */
package micromod;

import micromod.Instrument;
import micromod.LoopDecoder;
import micromod.resamplers.Resampler;

public class InstrumentPlayer {
    public static final int FIXED_POINT_SHIFT = 16;
    protected static final int FIXED_POINT_BITMASK = 65535;
    protected static final int CUSHION_BUFFER_SAMPLES = 16;
    protected static final int RESAMPLE_BUFFER_SAMPLES = 3116;
    protected int resampleFactor;
    protected int subSamplePos;
    protected short[] resampleBuffer;
    protected short[] cushionBuffer;
    protected LoopDecoder loopDecoder = new LoopDecoder();

    public InstrumentPlayer() {
        this.resampleBuffer = new short[3116];
        this.cushionBuffer = new short[16];
        this.blankCushionBuffer();
    }

    public void assignInstrument(Instrument i) {
        this.loopDecoder.assignInstrument(i);
    }

    public void setAssigned() {
        this.loopDecoder.setAssigned();
    }

    public Instrument getInstrument() {
        return this.loopDecoder.getInstrument();
    }

    public void setSamplePosition(int samplePosition) {
        this.blankCushionBuffer();
        this.loopDecoder.setSamplePosition(samplePosition);
        this.subSamplePos = 0;
    }

    public int getSamplePosition() {
        return this.loopDecoder.getSamplePosition();
    }

    public boolean hasFinished() {
        return this.loopDecoder.finishedPlaying();
    }

    public void setResampleFactor(int resampleFactor) {
        this.resampleFactor = resampleFactor;
    }

    public void getAudio(short[] buffer, int length, Resampler resampler, boolean snapBack) {
        int cushSize = resampler.getCushionSize();
        System.arraycopy(this.cushionBuffer, 0, this.resampleBuffer, 0, cushSize);
        int samplesRequired = this.getSamplesRequired(length);
        if (snapBack) {
            this.loopDecoder.output(this.resampleBuffer, cushSize, samplesRequired + cushSize + 1, true);
        } else {
            this.loopDecoder.output(this.resampleBuffer, cushSize, samplesRequired, false);
            this.loopDecoder.output(this.resampleBuffer, samplesRequired + cushSize, cushSize + 1, true);
            System.arraycopy(this.resampleBuffer, samplesRequired, this.cushionBuffer, 0, cushSize);
        }
        int step = this.resampleFactor >> 16;
        int subStep = this.resampleFactor & 0xFFFF;
        resampler.resample(this.resampleBuffer, cushSize, this.subSamplePos, step, subStep, buffer, 0, length);
        if (!snapBack) {
            this.subSamplePos = this.subSamplePos + this.resampleFactor * length & 0xFFFF;
        }
    }

    protected int getSamplesRequired(int length) {
        return this.resampleFactor * length + this.subSamplePos >> 16;
    }

    protected void blankCushionBuffer() {
        for (int n = 0; n < 16; ++n) {
            this.cushionBuffer[n] = 0;
        }
    }
}

