/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.util.xml;

import eu.irreality.age.util.xml.ArrayNodeList;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtils {
    private static Document doc = null;

    public static NodeList getDirectChildrenElementsByTagName(Node n, String name) {
        ArrayNodeList theList = new ArrayNodeList();
        if (!n.hasChildNodes()) {
            return theList;
        }
        Node current = n.getFirstChild();
        do {
            Element curElt;
            if (!(current instanceof Element) || !(curElt = (Element)current).getTagName().equals(name)) continue;
            theList.add(curElt);
        } while ((current = current.getNextSibling()) != null);
        return theList;
    }

    public static Document getXMLClipboard() {
        if (doc == null) {
            try {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                return null;
            }
        }
        return doc;
    }

    public static String nodeToString(Node n) {
        DOMSource ds = new DOMSource(n);
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(ds, sr);
        }
        catch (TransformerException te) {
            te.printStackTrace();
        }
        return sw.getBuffer().toString();
    }

    public static Node stringToNode(String s) {
        StreamSource ss = new StreamSource(new StringReader(s));
        DOMResult dr = new DOMResult();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.transform(ss, dr);
        }
        catch (TransformerException te) {
            te.printStackTrace();
            return null;
        }
        return dr.getNode().getFirstChild();
    }
}

