/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.swing.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class AGEConfiguration {
    private Properties properties = null;
    private static String FILENAME = "age.properties";
    private static Properties defaultProperties = new Properties();
    private static AGEConfiguration instance;
    private LinkedList recentFiles = new LinkedList();

    public static AGEConfiguration getInstance() {
        if (instance == null) {
            instance = new AGEConfiguration();
        }
        return instance;
    }

    private AGEConfiguration() {
        System.out.println("AGEConfiguration constructor");
        this.properties = new Properties(defaultProperties);
        try {
            this.properties.load(new FileInputStream(new File(FILENAME)));
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("AGE configuration file not found.");
        }
        catch (NullPointerException npe) {
            System.out.println("AGE configuration file not found.");
        }
        catch (IOException ioe) {
            System.out.println("Error reading AGE configuration file.");
        }
        this.updateRecentFilesListFromProperties();
    }

    public int getIntegerProperty(String key, int defaultVal) {
        try {
            return Integer.valueOf(this.properties.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public int getIntegerProperty(String key) {
        return this.getIntegerProperty(key, 0);
    }

    public boolean getBooleanProperty(String key, boolean defaultVal) {
        try {
            return Boolean.valueOf(this.properties.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(key, false);
    }

    public double getDoubleProperty(String key, double defaultVal) {
        try {
            return Double.valueOf(this.properties.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public double getDoubleProperty(String key) {
        return this.getDoubleProperty(key, 0.0);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void storeProperties() throws FileNotFoundException, IOException {
        this.updateRecentFilesPropertiesFromList();
        File f = new File(FILENAME);
        FileOutputStream fos = new FileOutputStream(f);
        System.out.println(f.getAbsolutePath());
        this.properties.store(fos, "Written by AGE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecentFilesListFromProperties() {
        LinkedList linkedList = this.recentFiles;
        synchronized (linkedList) {
            this.recentFiles.clear();
            int nRecentFiles = Integer.parseInt(this.properties.getProperty("nRecentFiles"));
            for (int i = 0; i < nRecentFiles; ++i) {
                String path = this.properties.getProperty("recentFile." + i);
                if (path == null) continue;
                this.recentFiles.addLast(path);
            }
        }
    }

    private void updateRecentFilesPropertiesFromList() {
        int i = 0;
        Iterator iter = this.recentFiles.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            this.properties.setProperty("recentFile." + i, element);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecentFile(File f) {
        int nRecentFiles = Integer.parseInt(this.properties.getProperty("nRecentFiles"));
        LinkedList linkedList = this.recentFiles;
        synchronized (linkedList) {
            String path = f.getAbsolutePath();
            if (!this.recentFiles.remove(path) && this.recentFiles.size() == nRecentFiles) {
                this.recentFiles.removeLast();
            }
            this.recentFiles.addFirst(path);
        }
    }

    public List getRecentFiles() {
        return this.recentFiles;
    }

    static {
        defaultProperties.setProperty("nRecentFiles", "5");
        defaultProperties.setProperty("sdiWindowWidth", "600");
        defaultProperties.setProperty("sdiWindowHeight", "440");
        defaultProperties.setProperty("sdiWindowMaximized", "false");
        defaultProperties.setProperty("sdiWindowLocationX", "100");
        defaultProperties.setProperty("sdiWindowLocationY", "100");
        defaultProperties.setProperty("mdiWindowWidth", "800");
        defaultProperties.setProperty("mdiWindowHeight", "600");
        defaultProperties.setProperty("mdiWindowMaximized", "true");
        defaultProperties.setProperty("mdiWindowLocationX", "0");
        defaultProperties.setProperty("mdiWindowLocationY", "0");
        defaultProperties.setProperty("mdiSubwindowWidth", "600");
        defaultProperties.setProperty("mdiSubwindowHeight", "400");
        defaultProperties.setProperty("mdiSubwindowMaximized", "true");
        defaultProperties.setProperty("mdiSubwindowLocationX", "0");
        defaultProperties.setProperty("mdiSubwindowLocationY", "0");
    }
}

