/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.Item;
import eu.irreality.age.Mobile;
import eu.irreality.age.StringMethods;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import eu.irreality.age.debug.Debug;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Wearable
extends Item {
    List wearableLimbs = new Vector();
    private String defense_damage_formula;

    public Wearable(World mundo, String itemfile) throws IOException, FileNotFoundException {
        this.constructItem(mundo, itemfile, true, "wearable");
    }

    public Wearable(World mundo, Node n) throws XMLtoWorldException {
        this.constructItem(mundo, n, true, "wearable");
    }

    public List getDamageList(Mobile defensor) {
        return this.getDamagesListFromFormula(this.defense_damage_formula, defensor);
    }

    public void readWearableSpecifics(World mundo, Node n) throws XMLtoWorldException {
        NodeList nl;
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Wearable node not Element");
        }
        Element e = (Element)n;
        NodeList singRefNamesNodes = e.getElementsByTagName("WearableLimbs");
        if (singRefNamesNodes.getLength() > 0) {
            Element singRefNamesNode = (Element)singRefNamesNodes.item(0);
            NodeList reqNodes = singRefNamesNode.getElementsByTagName("Requirement");
            for (int k = 0; k < reqNodes.getLength(); ++k) {
                Element reqNode = (Element)reqNodes.item(k);
                NodeList nameNodes = reqNode.getElementsByTagName("Name");
                String curLimbNames = "";
                for (int i = 0; i < nameNodes.getLength(); ++i) {
                    Element nameNode = (Element)nameNodes.item(i);
                    Node hijo = nameNode.getFirstChild();
                    while (!(hijo instanceof Text)) {
                        hijo = hijo.getNextSibling();
                    }
                    curLimbNames = curLimbNames + hijo.getNodeValue();
                    if (i >= nameNodes.getLength() - 1) continue;
                    curLimbNames = curLimbNames + "$";
                }
                this.wearableLimbs.add(curLimbNames);
            }
        }
        if ((nl = e.getElementsByTagName("DamageList")).getLength() > 0) {
            Element atDam = (Element)nl.item(0);
            NodeList damageElements = atDam.getElementsByTagName("Damage");
            for (int i = 0; i < damageElements.getLength(); ++i) {
                Element curDamageElement = (Element)damageElements.item(i);
                if (!curDamageElement.hasAttribute("type")) {
                    throw new XMLtoWorldException("Damage element lacking type attribute");
                }
                if (!curDamageElement.hasAttribute("formula")) {
                    throw new XMLtoWorldException("Damage element lacking formula attribute");
                }
                if (this.defense_damage_formula == null) {
                    this.defense_damage_formula = "";
                }
                if (i > 0) {
                    this.defense_damage_formula = this.defense_damage_formula + "$";
                }
                this.defense_damage_formula = this.defense_damage_formula + curDamageElement.getAttribute("type");
                this.defense_damage_formula = this.defense_damage_formula + ":";
                this.defense_damage_formula = this.defense_damage_formula + curDamageElement.getAttribute("formula");
            }
        }
    }

    public Node getXMLRepresentation(Document doc) {
        Node nodoItem = super.getXMLRepresentation(doc);
        nodoItem.appendChild(this.getWearableSpecificsXMLRepresentation(doc));
        return nodoItem;
    }

    public Node getWearableSpecificsXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("WearableSpecs");
        if (this.wearableLimbs != null) {
            Element elt = doc.createElement("WearableLimbs");
            for (int i = 0; i < this.wearableLimbs.size(); ++i) {
                String curString = (String)this.wearableLimbs.get(i);
                Element reqNode = doc.createElement("Requirement");
                StringTokenizer st = new StringTokenizer(curString, "$");
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    Element esteNombre = doc.createElement("Name");
                    Text elNombre = doc.createTextNode(tok);
                    esteNombre.appendChild(elNombre);
                    reqNode.appendChild(esteNombre);
                }
                elt.appendChild(reqNode);
            }
            suElemento.appendChild(elt);
        }
        Element defenseDamageElement = doc.createElement("DamageList");
        if (this.defense_damage_formula != null) {
            StringTokenizer st = new StringTokenizer(this.defense_damage_formula, "$");
            while (st.hasMoreTokens()) {
                String curToken = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(curToken, ":");
                String damTypeString = st2.nextToken().trim();
                String damFormulaString = st2.nextToken().trim();
                Element curDamageElement = doc.createElement("Damage");
                curDamageElement.setAttribute("type", damTypeString);
                curDamageElement.setAttribute("formula", damFormulaString);
                defenseDamageElement.appendChild(curDamageElement);
            }
        }
        suElemento.appendChild(defenseDamageElement);
        return suElemento;
    }

    public List getLimbRequirementsList() {
        return this.wearableLimbs;
    }

    public List getDamagesListFromFormula(String damage_formula, Mobile atacanteODefensor) {
        ArrayList<Integer> listaDanos = new ArrayList<Integer>();
        String ourFormula = this.getDamageFromFormula(damage_formula, atacanteODefensor);
        StringTokenizer st = new StringTokenizer(ourFormula, "$");
        while (st.hasMoreTokens()) {
            String curToken = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(curToken, ":");
            int damtype = Integer.valueOf(st2.nextToken().trim());
            int damamount = Integer.valueOf(st2.nextToken().trim());
            while (listaDanos.size() <= damtype) {
                listaDanos.add(null);
            }
            listaDanos.set(damtype, new Integer(damamount));
        }
        for (int i = 0; i < listaDanos.size(); ++i) {
            if (listaDanos.get(i) != null) continue;
            listaDanos.set(i, new Integer(0));
        }
        return listaDanos;
    }

    public String getDamageFromFormula(String damage_formula, Mobile atacanteODefensor) {
        String result = "";
        if (damage_formula == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(damage_formula, "$");
        while (st.hasMoreTokens()) {
            String curToken = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(curToken, ":");
            result = result + st2.nextToken().trim();
            result = result + ":";
            String laformula = st2.nextToken().trim();
            StringTokenizer stFormula = new StringTokenizer(laformula, "+-", true);
            boolean sumaOResta = true;
            int elResultado = 0;
            while (stFormula.hasMoreTokens()) {
                String curFormulaToken = stFormula.nextToken().trim();
                if (curFormulaToken.equals("+")) {
                    sumaOResta = true;
                    continue;
                }
                if (curFormulaToken.equals("-")) {
                    sumaOResta = false;
                    continue;
                }
                int sumando = this.processAtomicFormula(curFormulaToken, atacanteODefensor);
                if (sumaOResta) {
                    elResultado += sumando;
                    continue;
                }
                elResultado -= sumando;
            }
            result = result + String.valueOf(elResultado);
            result = result + "$";
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private int processAtomicFormula(String formula, Mobile atacanteODefensor) {
        if (formula.endsWith("FUE") || formula.endsWith("STR") || formula.endsWith("CON") || formula.endsWith("INT") || formula.endsWith("SAB") || formula.endsWith("WIS") || formula.endsWith("DES") || formula.endsWith("DEX") || formula.endsWith("CHA") || formula.endsWith("CAR") || formula.endsWith("POD") || formula.endsWith("POW")) {
            return this.processAtomicFormula(formula.substring(0, formula.length() - 3), atacanteODefensor) * atacanteODefensor.getStat(formula.substring(formula.length() - 3, formula.length()));
        }
        if (formula.equals("")) {
            return 0;
        }
        if (StringMethods.numToks(formula, 'D') > 1) {
            Random rand = this.getRandom();
            int numDados = Integer.valueOf(StringMethods.getTok(formula, 1, 'D'));
            int cantDado = Integer.valueOf(StringMethods.getTok(formula, 2, 'D'));
            int tirada = 0;
            Debug.print("-ndados" + numDados + "-");
            for (int i = 0; i < numDados; ++i) {
                Debug.print("<tir" + (tirada += Math.abs(rand.nextInt() % cantDado) + 1) + ">");
            }
            return tirada;
        }
        return Integer.valueOf(formula);
    }

    public void copyWearableFieldsTo(Wearable w) {
        this.copyItemFieldsTo(w);
        w.defense_damage_formula = this.defense_damage_formula;
        if (this.wearableLimbs != null) {
            w.wearableLimbs = new ArrayList();
            for (int i = 0; i < this.wearableLimbs.size(); ++i) {
                w.wearableLimbs.add(this.wearableLimbs.get(i));
            }
        }
    }

    public Object clone() {
        Wearable w = new Wearable();
        this.copyWearableFieldsTo(w);
        return w;
    }

    public Wearable() {
    }
}

