/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.StringMethods;
import eu.irreality.age.TelnetConstants;
import eu.irreality.age.server.PartidaEnCurso;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.List;

class SimpleTelnetClientSelector
implements TelnetConstants {
    private InputStream is;
    private OutputStream os;
    private BufferedReader in;
    private PrintWriter out;
    private Socket incoming;
    private int id;

    public SimpleTelnetClientSelector(Socket s, int id) {
        this.incoming = s;
        this.id = id;
        try {
            if (this.incoming != null) {
                this.is = this.incoming.getInputStream();
                this.in = new BufferedReader(new InputStreamReader(this.is));
                this.os = this.incoming.getOutputStream();
                this.out = new PrintWriter(new OutputStreamWriter(this.os));
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
        }
    }

    public boolean checkForANSISupport() throws IOException {
        boolean terminamos = false;
        int tries = 10;
        this.os.write(255);
        this.os.write(253);
        this.os.write(36);
        while (!terminamos) {
            System.out.println("Iteration.");
            int abyte = this.is.read();
            if (tries == 0) {
                terminamos = true;
            }
            if (abyte == -1) break;
            if (abyte != 255) continue;
            System.out.println("IAC.");
            int bbyte = this.is.read();
            switch (bbyte) {
                case 251: {
                    System.out.println("WILL.");
                    int cbyte = this.is.read();
                    if (cbyte != 36) break;
                    this.os.write(255);
                    this.os.write(250);
                    this.os.write(36);
                    this.os.write(1);
                    this.os.write(255);
                    this.os.write(240);
                    break;
                }
                case 252: {
                    System.out.println("WONT.");
                    int cbyte2 = this.is.read();
                    if (cbyte2 != 36) break;
                    System.out.println("TELOPT_TTYPE.");
                    this.escribir("Your telnet client refuses negotiating terminal types.\n");
                    terminamos = true;
                    break;
                }
                case 250: {
                    int c;
                    System.out.println("SB.");
                    int cbyte3 = this.is.read();
                    if (cbyte3 != 36) break;
                    byte[] buf = new byte[100];
                    this.is.skip(1L);
                    for (int i = 0; (c = this.is.read()) != 255 && i < 99; ++i) {
                        buf[i] = (byte)c;
                    }
                    buf[i] = 0;
                    String termTypeString = new String(buf);
                    System.out.println("TERMTYPESTRING:" + termTypeString + "\n");
                    if (termTypeString.equalsIgnoreCase("ansi") || termTypeString.equalsIgnoreCase("vt100") || termTypeString.equalsIgnoreCase("xterm") || termTypeString.equalsIgnoreCase("vt320") || termTypeString.equalsIgnoreCase("mushclient") || termTypeString.equalsIgnoreCase("zmud")) {
                        this.escribir("ANSI support detected (" + termTypeString + ")\n");
                        return true;
                    }
                    this.os.write(255);
                    this.os.write(250);
                    this.os.write(36);
                    this.os.write(1);
                    this.os.write(255);
                    this.os.write(240);
                    --tries;
                }
            }
        }
        return false;
    }

    public void escribir(String s) {
        if (this.out != null) {
            System.out.print("Systemoutprinting:" + s);
            this.out.print(StringMethods.textualSubstitution(s, "\n", "\n\r"));
            this.out.flush();
        }
    }

    public String getInput() {
        try {
            String str = this.in.readLine();
            System.out.println("INPUT GOTTEN: " + str);
            return str;
        }
        catch (IOException ioe) {
            System.out.println("Oh yeppie, en \u00c1i Ou Excepxen.\n");
            return null;
        }
    }

    public PartidaEnCurso getPartidaSelection(List partidas) {
        PartidaEnCurso pec;
        if (partidas.size() < 1) {
            this.escribir("\u00a1No hay partidas en curso!\n");
            return null;
        }
        if (partidas.size() == 1 && (pec = (PartidaEnCurso)partidas.get(0)).getPlayers() < pec.getMaxPlayers()) {
            return pec;
        }
        boolean done = false;
        while (!done) {
            this.escribir("PARTIDAS EN CURSO:\n");
            for (int i = 0; i < partidas.size(); ++i) {
                PartidaEnCurso pec2 = (PartidaEnCurso)partidas.get(i);
                this.escribir(i + 1 + ". " + pec2.getNombre() + " " + "(" + pec2.getPlayers() + "/" + pec2.getMaxPlayers() + ")");
                this.escribir("\n");
            }
            this.escribir("Introduzca el n\u00famero de la partida a la que desea jugar: ");
            String linea = this.getInput();
            if (linea == null) {
                return null;
            }
            int part = -1;
            try {
                part = Integer.valueOf(linea);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (part <= 0 || part > partidas.size()) continue;
            PartidaEnCurso p = (PartidaEnCurso)partidas.get(part - 1);
            if (p.getPlayers() < p.getMaxPlayers()) {
                return p;
            }
            this.escribir("Esa partida ha alcanzado su n\u00famero m\u00e1ximo de usuarios, no puedes entrar.\n");
        }
        return null;
    }
}

