/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.GameChoosingInternalFrame;
import eu.irreality.age.server.ServerHandler;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

class OptionChoosingPanel
extends JPanel {
    JDesktopPane thePanel;
    JCheckBox cb1 = new JCheckBox();
    JCheckBox cb2 = new JCheckBox();
    JCheckBox cb3 = new JCheckBox();
    JLabel ageLabel = new JLabel("Servidor de AGE");
    JLabel telnetLabel = new JLabel("Servidor de telnet");
    JLabel ircLabel = new JLabel("Servidor de IRC");
    JLabel infoLabel = new JLabel("<html><p>Nota: se pueden cambiar los puertos telnet y AGE en las opciones</p><p>del servidor dedicado (Servidor/Configuraci\u00f3n...)</p></html>");

    public boolean servirAGE() {
        return this.cb1.isSelected();
    }

    public boolean servirTelnet() {
        return this.cb2.isSelected();
    }

    public boolean servirIRC() {
        return this.cb3.isSelected();
    }

    public void updateServersAndPorts() {
        String agePort = String.valueOf(ServerHandler.getInstance().getServerConfigurationOptions().getPuertoAge());
        String telnetPort = String.valueOf(ServerHandler.getInstance().getServerConfigurationOptions().getPuertoTelnet());
        this.ageLabel.setText("Servidor de AGE (puerto " + agePort + ")");
        this.telnetLabel.setText("Servidor de telnet (puerto " + telnetPort + ")");
        boolean age = ServerHandler.getInstance().getServerConfigurationOptions().sirveAge();
        boolean telnet = ServerHandler.getInstance().getServerConfigurationOptions().sirveTelnet();
        boolean irc = ServerHandler.getInstance().getServerConfigurationOptions().sirveIrc();
        this.cb1.setEnabled(age);
        this.cb2.setEnabled(telnet);
        this.cb3.setEnabled(irc);
        this.ageLabel.setEnabled(age);
        this.telnetLabel.setEnabled(telnet);
        this.ircLabel.setEnabled(irc);
        if (!age) {
            this.cb1.setSelected(false);
        }
        if (!telnet) {
            this.cb2.setSelected(false);
        }
        if (!irc) {
            this.cb3.setSelected(false);
        }
        this.infoLabel.setText(this.getInfoLabelText(age, telnet, irc));
    }

    private String getInfoLabelText(boolean age, boolean telnet, boolean irc) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><p>");
        if (!(age && telnet && irc)) {
            boolean plur = false;
            if (!age && !telnet || !age && !irc || !telnet && !irc) {
                plur = true;
            }
            if (plur) {
                sb.append("Los servidores de ");
            } else {
                sb.append("El servidor de ");
            }
            sb.append(this.getDisabledServerList(age, telnet, irc));
            if (plur) {
                sb.append("\test\u00e1n deshabilitados.</p><p>Para utilizarlos, ");
            } else {
                sb.append(" est\u00e1 deshabilitado.</p><p>Para utilizarlo, ");
            }
            sb.append("deben habilitarse primero</p><p>en las opciones de servidor (Servidor/Configuraci\u00f3n...).</p>");
            sb.append("<p>En dichas opciones tambi\u00e9n se pueden</p><p>configurar los correspondientes puertos.</p>");
        } else {
            sb.append("<p>Se pueden cambiar los puertos telnet y AGE</p><p>en las opciones de servidor (Servidor/Configuraci\u00f3n...).</p>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    private String getDisabledServerList(boolean age, boolean telnet, boolean irc) {
        StringBuffer sb = new StringBuffer();
        if (!age) {
            sb.append("AGE");
        }
        if (!telnet) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("telnet");
        }
        if (!irc) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("IRC");
        }
        return sb.toString();
    }

    public OptionChoosingPanel(JInternalFrame madre) {
        JPanel pan0 = new JPanel();
        JPanel pan1 = new JPanel();
        JPanel pan2 = new JPanel();
        JPanel pan3 = new JPanel();
        JPanel pan4 = new JPanel();
        JLabel l0 = new JLabel("<html><p>Las partidas lanzadas desde esta ventana</p><p>ser\u00e1n accesibles remotamente a trav\u00e9s de:</p>");
        JLabel l1 = this.ageLabel;
        JLabel l2 = this.telnetLabel;
        JLabel l3 = this.ircLabel;
        JLabel l4 = this.infoLabel;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        pan0.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        pan0.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        l0.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        l0.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        pan1.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        pan1.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        l1.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        l1.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        pan2.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        pan2.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        l2.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        l2.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        pan3.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        pan3.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        l3.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        l3.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        pan4.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        pan4.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        l4.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        l4.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        pan0.add(l0);
        pan1.add(this.cb1);
        pan1.add(l1);
        pan2.add(this.cb2);
        pan2.add(l2);
        pan3.add(this.cb3);
        pan3.add(l3);
        pan4.add(l4);
        this.add(pan0);
        this.add(pan1);
        this.add(pan2);
        this.add(pan3);
        this.add(pan4);
    }
}

