/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.PlayerThread;
import eu.irreality.age.SoundClient;
import eu.irreality.age.debug.Debug;
import eu.irreality.age.filemanagement.URLUtils;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jlgui.basicplayer.BasicController;
import javazoom.jlgui.basicplayer.BasicPlayer;
import javazoom.jlgui.basicplayer.BasicPlayerEvent;
import javazoom.jlgui.basicplayer.BasicPlayerException;
import javazoom.jlgui.basicplayer.BasicPlayerListener;
import micromod.MicroMod;
import micromod.Module;
import micromod.ModuleLoader;
import micromod.output.JavaSoundOutputDevice;
import micromod.output.converters.SS16LEAudioFormatConverter;
import micromod.resamplers.LinearResampler;

public class AGESoundClient
implements SoundClient {
    private Sequencer seqr;
    private Sequence curseq;
    private Hashtable midiPreloaded = new Hashtable();
    private boolean on = true;
    Synthesizer synthesizer;
    Synthesizer synthDevice;
    private static final int CHANGE_VOLUME = 7;
    private Hashtable audioPreloaded = new Hashtable();
    private Map basicPlayers = Collections.synchronizedMap(new HashMap());
    PlayerThread pt;

    public boolean isOn() {
        return this.on;
    }

    public void activate() {
        this.on = true;
    }

    public void deactivate() {
        this.stopAllSound();
        this.on = false;
    }

    private Sequence getPreloadedSequence(URL u) {
        return (Sequence)this.midiPreloaded.get(u);
    }

    public void midiInit() throws MidiUnavailableException {
        this.midiClose();
        if (this.seqr == null) {
            this.seqr = MidiSystem.getSequencer();
            this.seqr.open();
        }
    }

    public void midiPreload(URL midfile) throws InvalidMidiDataException, IOException {
        Sequence seq = MidiSystem.getSequence(midfile);
        this.midiPreloaded.put(midfile, seq);
    }

    public void midiUnload(URL midfile) throws IOException {
        this.midiPreloaded.remove(midfile);
    }

    public void midiUnload(String s) throws IOException {
        this.midiUnload(URLUtils.stringToURL(s));
    }

    public void midiStart(URL midfile) throws InvalidMidiDataException, IOException, MidiUnavailableException {
        if (!this.isOn()) {
            return;
        }
        this.curseq = this.getPreloadedSequence(midfile);
        if (this.curseq == null) {
            this.curseq = MidiSystem.getSequence(midfile);
        }
        if (this.seqr.isRunning()) {
            this.seqr.stop();
        }
        this.seqr.setLoopCount(0);
        this.seqr.setSequence(this.curseq);
        this.seqr.start();
    }

    public void midiStart(String f) throws InvalidMidiDataException, IOException, MidiUnavailableException {
        if (!this.isOn()) {
            return;
        }
        this.midiStart(URLUtils.stringToURL(f));
    }

    public void midiPreload(String f) throws InvalidMidiDataException, IOException {
        this.midiPreload(URLUtils.stringToURL(f));
    }

    public void midiOpen(URL midfile) throws InvalidMidiDataException, IOException {
        this.curseq = this.getPreloadedSequence(midfile);
        if (this.curseq == null) {
            this.curseq = MidiSystem.getSequence(midfile);
        }
    }

    public void midiOpen(String f) throws InvalidMidiDataException, IOException {
        this.midiOpen(URLUtils.stringToURL(f));
    }

    public void midiLoop(int loopCount) throws InvalidMidiDataException {
        if (!this.isOn()) {
            return;
        }
        if (this.seqr.isRunning()) {
            this.seqr.stop();
        }
        this.seqr.setSequence(this.curseq);
        this.seqr.setLoopCount(loopCount);
        this.seqr.start();
    }

    public void midiLoop() throws InvalidMidiDataException {
        if (!this.isOn()) {
            return;
        }
        this.midiLoop(-1);
    }

    public void midiStart() throws InvalidMidiDataException {
        if (!this.isOn()) {
            return;
        }
        if (this.seqr.isRunning()) {
            this.seqr.stop();
        }
        this.seqr.setSequence(this.curseq);
        this.seqr.setLoopCount(0);
        this.seqr.start();
    }

    public void midiStop() {
        this.seqr.stop();
    }

    public void midiClose() {
        this.curseq = null;
        if (this.seqr != null && this.seqr.isOpen()) {
            this.seqr.close();
        }
        this.seqr = null;
    }

    public void midiResetGain(double gain) {
        if (gain < 0.0) {
            gain = 0.0;
        }
        if (gain > 1.0) {
            gain = 1.0;
        }
        int midiVolume = (int)(gain * 127.0);
        System.err.println("Vol " + midiVolume);
        if (this.synthesizer != null) {
            MidiChannel[] channels = this.synthesizer.getChannels();
            System.err.println("Channels: " + channels.length);
            for (int c = 0; channels != null && c < channels.length; ++c) {
                System.err.println("cc " + midiVolume);
                channels[c].controlChange(7, midiVolume);
            }
        } else if (this.synthDevice != null) {
            try {
                ShortMessage volumeMessage = new ShortMessage();
                for (int i = 0; i < 16; ++i) {
                    volumeMessage.setMessage(176, i, 7, midiVolume);
                    this.synthDevice.getReceiver().send(volumeMessage, -1L);
                }
            }
            catch (Exception e) {
                System.err.println("Error resetting gain on MIDI device");
                e.printStackTrace();
            }
        } else if (this.seqr != null && this.seqr instanceof micromod.Synthesizer) {
            this.synthesizer = (Synthesizer)((Object)this.seqr);
            MidiChannel[] channels = this.synthesizer.getChannels();
            for (int c = 0; channels != null && c < channels.length; ++c) {
                channels[c].controlChange(7, midiVolume);
            }
        } else {
            try {
                Receiver receiver = MidiSystem.getReceiver();
                ShortMessage volumeMessage = new ShortMessage();
                for (int c = 0; c < 16; ++c) {
                    volumeMessage.setMessage(176, c, 7, midiVolume);
                    receiver.send(volumeMessage, -1L);
                }
            }
            catch (Exception e) {
                System.err.println("Error resetting gain on MIDI device");
                e.printStackTrace();
            }
        }
    }

    public void midiFadeOut() {
        double volume = 0.6;
        while (!(volume - 0.05 < 0.0)) {
            this.midiResetGain(volume);
            System.err.println("Gain = " + volume);
            try {
                Thread.sleep(150L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            volume -= 0.025;
        }
        if (this.synthesizer != null) {
            this.synthesizer.close();
            this.synthesizer = null;
        }
        if (this.seqr != null) {
            if (this.seqr.isOpen()) {
                this.seqr.stop();
            }
            this.seqr.close();
        }
    }

    public void audioPreload(URL u) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        AudioFormat af;
        AudioInputStream aii = AudioSystem.getAudioInputStream(u);
        AudioFormat finalFormat = af = aii.getFormat();
        AudioInputStream finalStream = aii;
        if (u.getPath().toLowerCase().endsWith(".ogg") || u.getPath().toLowerCase().endsWith(".mp3")) {
            AudioFormat baseFormat = aii.getFormat();
            finalFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
            finalStream = AudioSystem.getAudioInputStream(finalFormat, aii);
        }
        Clip cl = (Clip)AudioSystem.getLine(new DataLine.Info(Clip.class, finalFormat));
        cl.open(finalStream);
        this.audioPreloaded.put(u, cl);
    }

    public void audioUnload(File afile) throws IOException {
        this.audioPreloaded.remove(afile.getCanonicalPath());
    }

    public void audioUnload(String s) throws IOException {
        this.audioUnload(new File(s));
    }

    public void audioPreload(String s) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        this.audioPreload(URLUtils.stringToURL(s));
    }

    private Clip getPreloadedClip(URL u) {
        return (Clip)this.audioPreloaded.get(u);
    }

    public void audioStartPreloaded(URL u) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        if (!this.isOn()) {
            return;
        }
        this.audioStartPreloaded(u, 0);
    }

    public void audioStartPreloaded(URL u, int loopTimes) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        if (!this.isOn()) {
            return;
        }
        Clip cl = this.getPreloadedClip(u);
        if (cl == null) {
            this.audioPreload(u);
        }
        cl = this.getPreloadedClip(u);
        cl.setFramePosition(0);
        cl.loop(loopTimes);
    }

    public void audioStopPreloaded(URL u) {
        Clip cl = this.getPreloadedClip(u);
        if (cl == null) {
            return;
        }
        cl.stop();
    }

    public void audioStartUnpreloaded(URL u) throws IOException {
        if (!this.isOn()) {
            return;
        }
        this.audioStartUnpreloaded(u, 0);
    }

    public void audioStartUnpreloaded(final URL u, final int loopTimes) throws IOException {
        if (!this.isOn()) {
            return;
        }
        try {
            Logger log = Logger.getLogger("javazoom.jlgui.basicplayer.BasicPlayer");
            log.setLevel(Level.SEVERE);
        }
        catch (SecurityException se) {
            System.err.println("Restricted security environment, will not take logs of audio issues.");
        }
        final BasicPlayer bp = new BasicPlayer();
        try {
            InputStream theStream = u.openStream();
            if (theStream.markSupported()) {
                bp.open(theStream);
            } else {
                BufferedInputStream bib = new BufferedInputStream(theStream);
                bp.open((InputStream)bib);
            }
        }
        catch (BasicPlayerException bpe) {
            bpe.printStackTrace();
            throw new IOException(bpe);
        }
        this.basicPlayers.put(u, bp);
        bp.addBasicPlayerListener(new BasicPlayerListener(){
            private int loopCount;
            {
                this.loopCount = loopTimes;
            }

            public void opened(Object arg0, Map arg1) {
            }

            public void progress(int arg0, long arg1, byte[] arg2, Map arg3) {
            }

            public void setController(BasicController arg0) {
            }

            public void stateUpdated(BasicPlayerEvent arg0) {
                if (arg0.getCode() == 8) {
                    if (this.loopCount < 0) {
                        try {
                            if (!AGESoundClient.this.isOn()) {
                                return;
                            }
                            bp.stop();
                            bp.open(u.openStream());
                            bp.play();
                        }
                        catch (BasicPlayerException bpe) {
                            bpe.printStackTrace();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    } else if (this.loopCount > 0) {
                        --this.loopCount;
                        try {
                            if (!AGESoundClient.this.isOn()) {
                                return;
                            }
                            bp.stop();
                            bp.open(u.openStream());
                            bp.play();
                        }
                        catch (BasicPlayerException bpe) {
                            bpe.printStackTrace();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    } else {
                        AGESoundClient.this.basicPlayers.remove(u);
                    }
                }
            }
        });
        try {
            bp.play();
        }
        catch (BasicPlayerException bpe) {
            bpe.printStackTrace();
            throw new IOException(bpe);
        }
    }

    public void audioStopUnpreloaded(URL u) {
        BasicPlayer bp = (BasicPlayer)this.basicPlayers.get(u);
        if (bp != null) {
            try {
                bp.stop();
            }
            catch (BasicPlayerException bpe) {
                bpe.printStackTrace();
            }
            this.basicPlayers.remove(u);
        }
    }

    public void audioStart(URL u, int loopTimes) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        Clip cl = this.getPreloadedClip(u);
        if (cl == null) {
            this.audioStartUnpreloaded(u, loopTimes);
        } else {
            this.audioStartPreloaded(u, loopTimes);
        }
    }

    public void audioStart(URL u) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        this.audioStart(u, 0);
    }

    public void audioStart(String s) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        this.audioStart(s, 0);
    }

    public void audioStart(String s, int loopTimes) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        this.audioStart(URLUtils.stringToURL(s), loopTimes);
    }

    public void audioStop(String s) {
        this.audioStopUnpreloaded(URLUtils.stringToURL(s));
    }

    public void audioFadeIn(String s, int loopTimes, double seconds, double delay) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        this.audioFadeIn(URLUtils.stringToURL(s), loopTimes, seconds, delay);
    }

    public void audioFadeOut(String s, double seconds) {
        this.audioFadeOut(URLUtils.stringToURL(s), seconds);
    }

    private double fadeOutFunction(double time) {
        return this.expFade(time);
    }

    private double fadeInFunction(double time) {
        return 1.0 - this.expFade(time);
    }

    private double cosineFade(double time) {
        double angle = time * Math.PI / 2.0;
        if (time >= 1.0) {
            return 0.0;
        }
        return Math.cos(angle);
    }

    private double expFade(double time) {
        if (time >= 1.0) {
            return 0.0;
        }
        return 1.0 / ((6.0 * time + 1.0) * (6.0 * time + 1.0));
    }

    public void audioFadeOut(final URL u, final double seconds) {
        final BasicPlayer bp = (BasicPlayer)this.basicPlayers.get(u);
        if (bp != null) {
            Thread thr = new Thread(){

                public void run() {
                    double gain = 1.0;
                    double iters = 100.0;
                    double itersDone = 0.0;
                    int sleepTime = (int)(seconds * 1000.0 / iters);
                    while (gain > 0.0) {
                        gain = AGESoundClient.this.fadeOutFunction((itersDone += 1.0) / (iters - 1.0));
                        try {
                            bp.setGain(gain);
                        }
                        catch (BasicPlayerException e1) {
                            e1.printStackTrace();
                        }
                        try {
                            2.sleep(sleepTime);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    AGESoundClient.this.audioStopUnpreloaded(u);
                }
            };
            thr.start();
        }
    }

    public void audioFadeIn(final URL u, final int loopTimes, final double seconds, final double delay) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        Thread thr = new Thread(){

            public void run() {
                try {
                    3.sleep((int)delay * 1000);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                try {
                    AGESoundClient.this.audioStart(u, loopTimes);
                }
                catch (UnsupportedAudioFileException e2) {
                    e2.printStackTrace();
                }
                catch (LineUnavailableException e2) {
                    e2.printStackTrace();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                BasicPlayer bp = (BasicPlayer)AGESoundClient.this.basicPlayers.get(u);
                double gain = 0.0;
                double iters = 100.0;
                double itersDone = 0.0;
                int sleepTime = (int)(seconds * 1000.0 / iters);
                while (gain < 1.0) {
                    gain = AGESoundClient.this.fadeInFunction((itersDone += 1.0) / (iters - 1.0));
                    try {
                        bp.setGain(gain);
                    }
                    catch (BasicPlayerException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        3.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        thr.start();
    }

    public void playMOD(File f, int iRepeat) throws Exception {
        if (!this.isOn()) {
            return;
        }
        this.playMOD(new DataInputStream(new FileInputStream(f)), iRepeat);
    }

    public void playMOD(URL u, int iRepeat) throws Exception {
        if (!this.isOn()) {
            return;
        }
        this.playMOD(new DataInputStream(u.openStream()), iRepeat);
    }

    private void playMOD(DataInput theInput, int iRepeat) throws Exception {
        if (!this.isOn()) {
            return;
        }
        JavaSoundOutputDevice out = new JavaSoundOutputDevice(new SS16LEAudioFormatConverter(), 44100, 1000);
        Module module = ModuleLoader.read(theInput);
        MicroMod microMod = new MicroMod(module, out, new LinearResampler());
        MODThread mt = new MODThread(microMod, out, iRepeat);
        this.pt = mt;
        this.pt.setVolume(65536);
        mt.start();
    }

    public void playMOD(String s, int iRepeat) throws Exception {
        if (!this.isOn()) {
            return;
        }
        this.playMOD(new File(s), iRepeat);
    }

    public void stopMOD() throws Exception {
        if (this.pt != null) {
            this.pt.stopPlaying();
        }
    }

    public void stopAllSound() {
        Iterator iterator = this.basicPlayers.values().iterator();
        while (iterator.hasNext()) {
            BasicPlayer bp = (BasicPlayer)iterator.next();
            try {
                bp.stop();
            }
            catch (BasicPlayerException bpe) {
                bpe.printStackTrace();
            }
        }
        this.basicPlayers.clear();
        if (this.seqr != null && this.seqr.isOpen()) {
            this.seqr.stop();
        }
        if (this.seqr != null) {
            this.midiClose();
        }
        try {
            this.stopMOD();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MODThread
    extends Thread
    implements PlayerThread {
        int soundId;
        boolean running;
        boolean stopped;
        JavaSoundOutputDevice out;
        MicroMod mm;
        int iRepeat;

        MODThread(MicroMod mm, JavaSoundOutputDevice out, int iRepeat) {
            this.mm = mm;
            this.out = out;
            this.iRepeat = iRepeat;
            this.running = false;
            this.stopped = false;
        }

        public synchronized void setVolume(int vol) {
            SourceDataLine l = this.out.getLine();
            FloatControl ctl = (FloatControl)l.getControl(FloatControl.Type.MASTER_GAIN);
            double gain = (double)vol / 65536.0;
            float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0);
            if (ctl != null) {
                ctl.setValue(dB);
            }
        }

        public synchronized void stopPlaying() {
            if (!this.stopped) {
                this.running = false;
                this.stopped = true;
                this.out.stop();
                this.out.close();
            }
        }

        synchronized void donePlaying() {
            AGESoundClient.this.pt = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.out.start();
            for (int i = 0; !(this.stopped || this.iRepeat != -1 && i >= this.iRepeat); ++i) {
                this.running = true;
                this.mm.setCurrentPatternPos(0);
                while (this.running && this.mm.getSequenceLoopCount() == 0) {
                    MODThread mODThread = this;
                    synchronized (mODThread) {
                        Debug.println("Real Time.");
                        this.mm.doRealTimePlayback();
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            MODThread mODThread = this;
            synchronized (mODThread) {
                if (!this.stopped) {
                    this.running = false;
                    this.out.stop();
                    this.out.close();
                    this.donePlaying();
                }
            }
        }
    }
}

