module AR
  module Game

    class Option 
      attr_accessor :ids
      attr_accessor :description
      attr_accessor :usage
      attr_accessor :chosen

      def initialize
        self.ids = []
        self.description = ""
        self.usage  = usage || "Do Somethign"

        yield self
      end

      def id
        ids.first
      end 

      def action_parameter_choice_sequence action
        return action if action.performable?
        player = action.performer

        back_choice = Option.new do |o|
          o.ids = ["b", "back"] 
          o.usage = "(b)ack"
          o.description = action.parameters.first.filled? ? "(Back)" : "(Back to Actions)"
          o.chosen = Proc.new do 
            if action.parameters.first.filled? #back should clear args
              action.parameters.each {|p| p.argument = nil} 
            else #back should go back to action menu
              action = nil     
            end
          end
        end

        until action.nil? or action.performable?
          next_param = action.next_param_to_fill
          m = AR::Game::Menu.new
          m.name = next_param.prompt_text 
          begin
            objs = (next_param.filter(player) )
          rescue StandardError => e
            puts "waring sone: #{e.to_s} #{e.backtrace}"
            objs = player.known_objects
          end

          choices = objs - action.parameters.map(&:argument)
          choices.delete player
          choices.each_with_index do |c, i|
            m.options << Option.new do |o|
              id = (i+1).to_s
              o.ids = [id] 
              o.usage = id
              o.description = c.name
              o.chosen = Proc.new do 
                next_param.argument = c
              end
            end
          end
          m.options << back_choice
          m.present
        end
        action
      end

    end


    class QuitOption < Option

      def initialize
        super do |o|
          o.description = "Quit the game"
          o.ids = ["quit","exit", "q"]
          o.usage = "(q)uit"
          o.chosen = Proc.new do
            AR.put_s "Thanks for playing!"
          end
        end
      end

    end

    class HelpOption < Option 
    end 


    class LoadGameOption < Option
      #initializes a game instance from scratch
      def initialize
        super() do |o|
          o.description  = "Load a saved game"
          o.usage = "(l)oad"
          o.ids = ["load", "l"]
          o.chosen = Proc.new do 
            AR.put_s "loading a save...."
            saves_dirname  = "saves"
            Dir.mkdir saves_dirname unless Dir.exists?(saves_dirname)

            w = AR.world_class.new
            d = File.open("#{saves_dirname}/default_world_data.yml", "r").read
            d = Psych.load(d).to_hash
            d = AR.recursive_symbolize(d)
            w.load_data d

            w.trigger AR::Events::GameStartedEvent, ({world: w})
            w.start!
            true
          end
        end
      end
    end


    class NewGameOption < Option
      #initializes a game instance from scratch
      def initialize
        super() do |o|
          o.description  = "Start a new game"
          o.usage = "(n)ew"
          o.ids = ["new", "n"]
          o.chosen = Proc.new do 
            AR.put_s "Beginning a new game...."
            #This should somehow be a variable set by the user gem consumer?
            w = AR.world_class.new
            #AR::Game::Behavior.set_world w
            w.events_engine.trigger AR::Events::GameStartedEvent, ({world: w})
            w.seed_for_new!
            w.start!
            true
          end
        end
      end
    end

    class WaitChoice < Option
      attr_accessor :player
      def initialize player
        self.player = player

        super() do |s|
          desc = "End your turn"
          s.ids =  ["wait", "w"]
          s.description = desc
          s.usage = "(w)ait" 
          s.chosen = Proc.new do
            WaitAction.new(player)
          end
        end
      end

    end



    class InspectChoice < Option
      attr_accessor :player

      def initialize player
        self.player = player
        super() do |s|
          desc = "Inspect something"
          s.ids =  ["inspect", "i"]
          s.description = desc
          s.usage = "(i)nspect" 
          s.chosen = Proc.new do
            action_parameter_choice_sequence InspectAction.new(player)
          end
        end
      end
    end
    
    class AttackChoice< Option
      attr_accessor :player

      def initialize player
        self.player = player
        super() do |s|
          desc = "Attack something"
          s.ids =  ["a", "attack"]
          s.description = desc
          s.usage = "(a)ttack" 
          s.chosen = Proc.new do
            action_parameter_choice_sequence AttackAction.new(player)
          end
        end
      end
    end
 
    class TravelChoice < Option
      attr_accessor :player

      def initialize player
        self.player = player
        super() do |s|
          desc = "Travel somewhere"
          s.ids =  ["travel", "t"]
          s.description = desc
          s.usage = "(t)ravel" 
          s.chosen = Proc.new do
            action_parameter_choice_sequence TravelAction.new(player)
          end
        end
      end
    end
 
    class GrabChoice < Option
      attr_accessor :player

      def initialize player
        self.player = player
        super() do |s|
          desc = "Get something"
          s.ids =  ["grab", "g"]
          s.description = desc
          s.usage = "(g)rab" 
          s.chosen = Proc.new do
            action_parameter_choice_sequence GrabAction.new(player)
          end
        end
      end
    end

    class TalkChoice < Option
      attr_accessor :player

      def initialize player
        self.player = player
        super() do |s|
          desc = "Talk to someone"
          s.ids =  ["talk", "ta"]
          s.description = desc
          s.usage = "(ta)lk" 
          s.chosen = Proc.new do
            action_parameter_choice_sequence TalkAction.new(player)
          end
        end
      end
    end


    class GiveChoice < Option
      attr_accessor :player

      def initialize player
        self.player = player
        super() do |s|
          desc = "Give an item away"
          s.ids =  ["give", "gi"]
          s.description = desc
          s.usage = "(gi)ve" 
          s.chosen = Proc.new do
            action_parameter_choice_sequence GiveAction.new(player)
          end
        end
      end
    end

    class PutChoice < Option
      attr_accessor :player

      def initialize player
        self.player = player
        super() do |s|
          desc = "Put an item down"
          s.ids =  ["put", "p"]
          s.description = desc
          s.usage = "(p)ut" 
          s.chosen = Proc.new do
            action_parameter_choice_sequence PutAction.new(player)
          end
        end
      end
    end










    class QuitChoice < Option
      attr_accessor :player
      def initialize player
        self.player = player
        super() do |s|
          desc = "Back to main menu"
          s.ids =  ["q"]
          s.description = desc
          s.usage = "(q)uit" 
          s.chosen = Proc.new do
            QuitAction.new(player) 
          end
        end
      end
    end


    class SaveChoice < Option
      attr_accessor :player
      def initialize player
        self.player = player 
        super() do |s|
          desc = "save your progress"
          s.ids = ["s"]
          s.description = desc
          s.usage = "(s)ave"
          s.chosen = Proc.new do 
            JournalAction.new(player)
          end
        end
      end
    end


  end
end
