module AR
  module Game
    module Inhabitant 

      def self.init ar_object
        ar_object.class.attr_serializeable :parent_id
      end

      def self.extended ar_object
        init ar_object
        ar_object.resolutions.push clear_known_on_travel
      end 

      def self.clear_known_on_travel
        AR::Events::Resolution.new event_class: AR::Events::ARObjectEnteredInhabitableEvent, as: "enterer" do |e|
          traveller = e.enterer
          results = []
          traveller.known_objects.each do |o| 
            results.push(traveller.create AR::Events::DiscoveryLostEvent, ({perceiver: traveller, undiscovered: o}))
          end
          results
        end
      end

      def placement
        return "" if parent.nil?
        parent.placement_for self
      end  

      def parent=(inhabitable)
        
        self.parent_id = (inhabitable.id rescue nil)
      end
      def parent
        world.find self.parent_id
      end

      #add more methods here

    end

  end
end
