module AR::Game::AiControl 
  #should simply have and 
  attr_accessor :desires


  #should be analogous to a story
  class Desire < Proc
    attr_accessor :agent
    attr_accessor :priority
    def initialize params 
      self.agent = params[:agent]
      self.priority = params[:priority] || 0
    end 
  end


  #should also have desire changers which are objects that listen to certain events and release a desire priority changed event or desire removed events
  #should refactor this into a behavior for persistence
  #
  #TODO: make this a behavior.
=begin
  class DesireChanger < AR::Game::ARObject
    attr_accessor agent_id
    def initialize id=nil
      super 
    end
  end
=end
 

  
  #...initialize them here
  def self.init ar_object 
    ar_object.class.attr_serializeable :desires do |desires_array, op|
      case op
      when :load
        desires_array.map{|type| Object.const_get(type) }.map(&:new)
      when :unload
        desires_array.map(&:class)
      end
    end
    d = Desire.new agent: ar_object do |obj|
      puts "basic desire running..."
    end

    ar_object.desires = []
  end


  def self.extended ar_object
    self.init ar_object
    ar_object.resolutions   << self.choose_action
  end 


  def ai_choice 
    #sort desires by priority, and run an action choice algorithm
    #example:
#    ["a","c","a","b","c", "D","d",""].sort! { |a,b| a.downcase <=> b.downcase }
#    => ["", "a", "a", "b", "b", "c", "c", "d", "D"]
    biggest_desire = desires.sort{|d1,d2| d1.priority <=> d2.priority  }.last unless desires.empty?
    choice = (biggest_desire.call(self) rescue nil)
    

    #a = AR::Game::InspectAction.new self
    #a.parameter("target").argument = self.parent

    #the default should be to wait 
    choice || AR::Game::WaitAction.new(self)
  end


  def self.choose_action 
    AR::Events::Resolution.new event_class: AR::Events::ActorTurnEvent, as: "actor" do  |e|
      actor = e.actor
      results = []
        action = nil 
        while action.nil? and actor.action_points > 0
          action = actor.last_action  = actor.last_action_this_tick = actor.ai_choice
        end
        unless action.nil?
          results.push(actor.create AR::Events::ActionBeganEvent, ({action: action}))
        else
          actor.last_action_this_tick = AR::Game::WaitAction.new actor
        end
      results
    end
  end


end
