module AR
  module Game

    class MushroomPotion < Item
      def initialize id=nil
        super 
        self.noun = "mushroom potion"
        self.article = ""
        add_behavior AR::Game::Consumable
        self.on_consumed  = Proc.new do |consumer|
          g = consumer.gauge("health")
          am = 10 
          AR::Events::GaugeChanged.new gauge: g, which: "current", gauge_owner: consumer, amount: am
        end
        self.add_story_implement StoryImplement.new

      end

      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super
          #add stories like this:
          s = Story.new when: AR::Events::ItemConsumed, as: "item" do |e|
            if e.consumer == e.consumer.world.player
              "You quaff the red, fizzy liquid, and you immediately feel its magical power beginning to close your wounds."
            end
          end
          add_story s
        end
      end


    end

  end
end
