class AR::Events::ClockTickEvent < AR::Events::Event

  attr_participant :world
  attr_accessor :actors

  def initialize params
    super params
    @actors = []
    @world = params[:world]
  end 

  def story
    "The time is now #{(world.time < 10 ? "0" : "")}#{world.time}00 hours on the #{world.day}#{ordinal_indicator(world.day)} day."
  end

  def ordinal_indicator num
    ret = ""
    case num
    when 1
      ret = "st"
    when 2
      ret = "nd"
    when 3
      ret = "rd"
    else
      ret = "th"
    end
    ret
  end

 
  def resolve!
    world.incr_time!
    self.actors.sort_by(&:initiative).map do |a| 
      #AR.put_s("makin lil sum'n sum'n for #{a.initiative} -> #{a}");
      engine.trigger_after_step(AR::Events::ActorTurnEvent, {actor: a})
    end
    world.player.printer.new_paragraph! unless world.player.nil?
    results = []
  end 

end
