module AR
  
  module Game
    class GiantBeetle < Monster 
      def initialize id=nil
        super 
        add_behavior AR::Game::DropsLoot
        self.on_death_drop_type = AR::Game::BeetleCorpse
        self.on_death_item_drop_proc do |death_evt|
          items = [] 
          items.push(AR::Game::BeetleChitin.new)
          items
        end

        self.noun = "giant beetle"
        add_story_implement StoryImplement.new
      end

      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super
          s = Story.new when: AR::Events::DiscoveryMadeEvent, as: "perceiver" do |e|
            p = e.perceiver
            d = e.discovered
            "#{p.name.capitalize}'s antennae twitch, and it pauses for moment. #{p.ownership.capitalize} body shuffles to face #{d.name}."
          end
          add_story s

          s = Story.new when: AR::Events::ActionBeganEvent, as: "performer" do |e|
            p = e.performer
            a = e.action
            t = e.primary_target
            case a.class.to_s
            when "AR::Game::AttackAction"
              "#{p.name.capitalize} scuttles toward #{t.name.downcase} aggressively; #{p.ownership} legs bend down, preparing to launch forward in attack."
            else
              ""
            end
          end
          add_story s


          s = Story.new when: AR::Events::ARObjectDied, as: "ar_object" do |e|
            "The beetle squeals in a hair-raising pitch; rapid clicking noises break up the cry.  It finally falls prone to the ground."
          end
          add_story s



          s = Story.new when: AR::Events::ActionPerformedEvent, as: "performer" do |e|
            p = e.performer
            a = e.action
            t = e.primary_target
            case a.class.to_s
            when "AR::Game::AttackAction"
              "#{p.name.capitalize} leaps toward #{t.name} at an alarming speed, with spiny, razor sharp mandibles wide open."
            when "AR::Game::DefendAction"
              "#{p.name.capitalize} shoots backward to dodge #{a.attacker.ownership} attack."
            else
              ""
            end
          end
          add_story s


          s = Story.new when: AR::Events::HitSuccess, as: "hitter" do |e|
            h = e.hitter
            he = e.hitee
            "#{h.name.capitalize}'s mandibles sink into #{he.name}."
          end
          add_story s

          s = Story.new when: AR::Events::HitSuccess, as: "hitee" do |e|
            h = e.hitter
            he = e.hitee
            " #{he.name.capitalize} shudders, and sounds a high-pitch, strange, chirp of pain."

          end
          add_story s


          s = Story.new when: AR::Events::HitFailure, as: "hitter" do |e|
            h = e.hitter
            he = e.hitee
            "#{h.name.capitalize}'s mandibles completely miss #{he.name}."
          end
          add_story s

        end

      end


    end
  end
end
