module AR
  module Game


    class Forest < Scene 
      def initialize id=nil
        super 

        self.noun = "forest"

        self.add_story_implement EnteredImplement.new
        self.add_story_implement InspectedImplement.new

      end

      class ForestImplement < AR::Game::StoryBehavior::StoryImplement
      end
      class ForestStory < AR::Game::StoryBehavior::Story
      end


      class EnteredImplement < ForestImplement
        def initialize stories=[]
          super
          story =  ForestStory.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|

            if e.enterer == e.engine.world.player

              ret = "The forest shares an uninviting mood as you enter, filled with looming trees. All around you, impossibly tall and improbably dense."
            else 
              ret = ""
            end
            
            ret 
          end

          add_story story
        end
      end


      class InspectedImplement < ForestImplement 
        def initialize stories = []
          super
          story =  ForestStory.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "As you peer into the thicket of trees, you are amazed at their apparent age. These are wide as carrigages and pochmarked as a peasant."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end
      end


    end

  end
end
