module AR::Game::HungerBehavior 
  
  #add attr_accessor properties here... 
  #if you don't need them serialized on save

  HUNGRY_DEBUFF_RATIO = 0.75
  #...initialize them here
  def self.init ar_object 
    ar_object.register_gauge "hunger"
    ar_object.after_gauges_init do |obj|
      hunger = obj.gauge("hunger")
      hunger.change_max 60
    end
    #add attr_serializeable properties here... 
    #if you do need them serialized on save
    #ar_object.attr_serializeable :prop1, :prop2, &block
  end

  def self.release_object_died_on_hunger_maxed
    AR::Events::Resolution.new event_class: AR::Events::GaugeChanged, as: "gauge_owner" do |e|
      g = e.gauge
      owner = e.gauge_owner

      if owner == owner.world.player
        ratio = hunger_ratio(g)
        results = []
        if ratio >= 1.0
          #currently the player is the only one with this gauge...
          results.push(AR::Events::NarrationEvent.new narration: "You are too malnurished to continue.")
          results.push(AR::Events::ARObjectDied.new ar_object: owner)
        elsif ratio >= 0.90
          results.push(AR::Events::NarrationEvent.new narration: "You are becoming extremely hunger now.")
        elsif ratio >= 0.75
          results.push(AR::Events::NarrationEvent.new narration: "You hear the sound of you stomach grumbling.  Best eat something.")
        end
        results
      end#player==owner
    end#resolution
  end

  def self.hunger_ratio hunger_gauge
    hunger_gauge.value.to_f / hunger_gauge.modified_max
  end

  def self.extended ar_object
    self.init ar_object
    ar_object.resolutions.push release_object_died_on_hunger_maxed    
    #add to object's event subscriptions and resolutions here...
  end 


  #add more methods here

end
