module AR
  module Game

    class Forest01 < Scene
      def initialize id=nil
        super 
        self.noun = "forest"
        #add_behavior AR::Game::SomeBehavior
        add_story_implement StoryImplement.new
      end

      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "This is the part of the forest you first landed in.  In fact, you can see a few broken tree branches above where you fell."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "All around are thick trunked trees, about 1.5 meters apart.  Dividing them in either direction is a narrow slit created by the path.  Above is a lush canopy of branches, which saved your life by breaking your descent. A wall of ivy bars your way to the south."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end
      end

    end




  end
end
