
module AR
  module Game

    class CaveSpiderCorpse < LootableThing
      def initialize id=nil
        super 
        self.noun = "cave spider corpse"
        self.add_story_implement StoryImplement.new

        r = AR::Events::Resolution.new event_class: AR::Events::Loot, as: "container" do |e|
          results = []
          results.push(AR::Events::NarrationEvent.new narration: "The corpse of the cave spider disintigrates into the cave floor, having nothing left to give...")
          results.push(AR::Events::ObjectRemovedFromGame.new ar_object: e.container)
          results
        end
        self.resolutions.push r

      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories = []
          super
          s =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "Spider leaves behind it's slimy, curled up corpse."
            else 
              ret = ""
            end
            ret 
          end
          add_story s

          s = Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              if e.discoverable.inventory_item_ids.empty?
                "All that remains are the useless bits of the fangs and legs."
              else
                "The meat of this spider might be edible."
              end
            end
          end
          add_story s

 
        end
      end

    end



  end
end

