require "./lib/apocrodentia"
require "test/unit"

module TestTypes

  attr_accessor :engine

  class Gate < AR::Game::ARObject
    def initialize id=nil
      super id
      self.add_behavior AR::Game::Gateway
    end
  end

  class Player < AR::Game::Player
  end
  
  class Traveller < AR::Game::Npc
    def initialize id=nil
      super
    end
  end
  
  class SomeItem < AR::Game::Item
    def intialize id=nil
      super
    end
  end

  class GameScene < AR::Game::Scene
    def initialize id=nil
      super
    end

  end

  class GatewayBlockingObject < AR::Game::PhysicalObject
    def initialize id=nil
      super
      add_behavior AR::Game::GatewayBlocker
    end
  end

  class Parent < AR::Game::ARObject
    def initialize id=nil
      super 
      self.add_behavior AR::Game::ParentBehavior
    end
  end
  class World < AR::Game::World
    def initialize id=nil
      super 
    end
  end

  class Printer < AR::Game::Printer

  end

end

class BaseBehaviorTestCase < Test::Unit::TestCase
  attr_accessor :world
  include TestTypes
  extend AR::Events

  def setup
    self.world = World.new
    self.world.world_name = "test"
    self.world.events_engine.test_mode = true
    AR::Game::Behavior.set_world self.world
    AR::Events::Event.set_engine self.world.events_engine
    #this needs to be triggered to test any kind of subscription out
    #objects will have their world set, but not their subscriptions
    #hooked in until this event resolved.  
    self.world.trigger AR::Events::GameStartedEvent, ({world: self.world})
  end

  def test_init_gauges
    self.world.events_engine.pipe self.world.all_gauge_managers.map{|obj| AR::Events::GaugesInitialized.new gauge_manager: obj} 
    self.world.events_engine.tick!
  end

end


