package mechanique;

 

/*    
    
    MechaniQue, the programming language for Interactive Fiction
    Copyright (C) 2007  G.J.G.T. (Gabor) de Mooij

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (highest version applies !!).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
    ---MECHANIQUESOFT/GABOR DE MOOIJ

*/
 
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.applet.*;
import java.io.Serializable;
import java.lang.Math;
;

public class SystemKeyGenerator implements Serializable,SystemKeyGeneratorInterface
{

    private KeyWalletInterface wallet;
    private String[] sysKeys = { "DICE", "ROT" };
    private int rotate = 0;
    private String[] path = {"A","B","C","D","E","F","E","D","C","B"};
    private int pathIndex = -1;
    private int time = 0;
    
    public SystemKeyGenerator(KeyWalletInterface k)
    {
        this.wallet = k;
    }
    
    public void init()
    {
        Calendar d = Calendar.getInstance();
        
        //add initial system keys
        this.wallet.add("OCC"+d.get(Calendar.MONTH)+d.get(Calendar.DATE));
        int t = (int) Math.round(Math.random()*2);
        if (t>0) this.wallet.add("TWIST"+t);
        this.generate();
    }
    
    public void generate()
    {
        //drop all old keys
        for(int j=0; j<this.sysKeys.length; j++)
        {
            for(int i=1; i<7; i++){
                this.wallet.drop(this.sysKeys[j]+""+i);
            }
        }
        
        this.wallet.drop("PATHA");
        this.wallet.drop("PATHB");
        this.wallet.drop("PATHC");
        this.wallet.drop("PATHD");
        this.wallet.drop("PATHE");
        this.wallet.drop("PATHF");
        
        //calculate new keys
        this.time ++;
        this.rotate ++;
        if (this.rotate>6) this.rotate=1;
        this.pathIndex ++;
        if (this.pathIndex>9) this.pathIndex=0;
        //add new system keys
        this.wallet.add("PATH"+this.path[this.pathIndex]);
        this.wallet.add("ROT"+this.rotate);
        this.wallet.add("DICE"+(Math.round(Math.random()*6)+1));
        
        
    }
    
    public int getTimeKey()
    {
        return this.time;
    }
}
