package mechanique;

 

/*    
    
    MechaniQue, the programming language for Interactive Fiction
    Copyright (C) 2007  G.J.G.T. (Gabor) de Mooij

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (highest version applies !!).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
    ---MECHANIQUESOFT/GABOR DE MOOIJ

*/

 
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.applet.*;
import java.io.Serializable;
import java.lang.Math;
;

public class ActionAsk extends Action implements Receiver 
{
    static private String oldInteractionKey = "_"; 
    public boolean nowait = false;
   
        
    public void execute()
    {
        this.owner.getStory().getWallet().drop(ActionAsk.oldInteractionKey);
        this.owner.getStory().interact=true;
        this.owner.getStory().getDisplayUnit().input(this);
        
        //if (this.owner.getStory().interact) return;
        
    }
    
    
    public void setWait(boolean b)
    {
        this.nowait = b;
    }
    
    
    public void receive(String raw, boolean nextIteration)
    {
        this.owner.getStory().interact=false;
        String interactionKey = 
            this.owner.getStory().getParser().parse(raw).replaceAll("\\W","");
        
        if (this.owner.getStory().getDebugFlag()) toolbox.say("ANSW=_"+interactionKey);    
        
        if (raw.equals("#save")){
            toolbox.say("PLEASE ENTER FILENAME FOR ROLL-FILE (without extension):");
            toolbox.serialize("sv_"+toolbox.ask()+".roll",this.owner.getStory());
            toolbox.say("GAME SAVED");
        }
       
        
        ActionAsk.oldInteractionKey = "_"+interactionKey;    
        this.owner.getStory().getWallet().add("_"+interactionKey);
        this.owner.getStory().getSystemKeyGenerator().generate();
        this.owner.getStory().getWallet().dropAll("ZERO");
        this.owner.getStory().getWallet().add("ZERO");
        if (nextIteration && !nowait) this.owner.getStory().doStep(); 
        if (nextIteration && nowait) return;
    }
}
