/*
 * File: AdvCommand.java
 * ---------------------
 * This file defines the general superclass of all commands in the
 * Adventure game along with a set of individual commands that
 * implement the built-in functions.
 */


/* Abstract class: AdvCommand */
/**
 * This class is the general superclass for all commands in the
 * Adventure game.  Every command has an execute method, which is
 * called by the game when that command is invoked.  This method
 * will be defined individually in each of the subclasses.
 */

public abstract class AdvCommand {

/** The predefined entry for the QUIT command */
	public static final AdvCommand QUIT = new QuitCommand();
	
/** The predefined entry for the QUIT command */
	public static final AdvCommand HELP = new HelpCommand();

/** The predefined entry for the LOOK command */
	public static final AdvCommand LOOK = new LookCommand();

/** The predefined entry for the INVENTORY command */
	public static final AdvCommand INVENTORY = new InventoryCommand();

/** The predefined entry for the TAKE command */
	public static final AdvCommand TAKE = new TakeCommand();

/** The predefined entry for the DROP command */
	public static final AdvCommand DROP = new DropCommand();
	
/* Abstract method: execute(game, obj) */
/**
 * Executes this command in the context of the specified adventure game.
 * The execute method also takes a parameter obj, which specifies the
 * object being used in the command.  This value is typically null, but
 * will be the appropriate object in the case of the TAKE and DROP
 * commands.
 *
 * @usage command.execute(game, obj);
 * @param adv The instance of the Adventure class that represents the game
 * @param obj The direct object (if any)
 */
	public abstract void execute(Adventure game, AdvObject obj);

}

/* Private class: QuitCommand */
/**
 * This class implements the QUIT command.
 */

class QuitCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeQuitCommand();
	}
}

class HelpCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeHelpCommand();
	}
}
/* Private class: LookCommand */
/**
 * This class implements the LOOK command.
 */

class LookCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeLookCommand();
	}
}

/* Private class: InventoryCommand */
/**
 * This class implements the INVENTORY command.
 */

class InventoryCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeInventoryCommand();
	}
}

/* Private class: TakeCommand */
/**
 * This class implements the TAKE command.
 */

class TakeCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeTakeCommand(obj);
	}
}

/* Private class: DropCommand */
/**
 * This class implements the DROP command.
 */

class DropCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeDropCommand(obj);
	}
}
class ExamineCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeExamineCommand(obj);
	}
}
class LaughCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeLaughCommand();
	}
}
class CryCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeCryCommand();
	}
}
class JumpCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeJumpCommand();
	}
}
class YellCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeYellCommand();
	}
}
class DanceCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeDanceCommand();
	}
}
class SleepCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeSleepCommand();
	}
}
class BreakCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeBreakCommand(obj);
	}
}
class UnlockCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeUnlockCommand(obj);
	}
}
class WearCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeWearCommand(obj);
	}
}
class GrinCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeGrinCommand();
	}
}
class SmellCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeSmellCommand(obj);
	}
}
class FrownCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeFrownCommand();
	}
}
class SingCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeSingCommand();
	}
}
class ReadCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeReadCommand(obj);
	}
}
class UseCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeUseCommand(obj);
	}
}
class GroanCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeGroanCommand();
	}
}
class ClapCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeClapCommand();
	}
}
class SitCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeSitCommand();
	}
}
class ShrugCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeShrugCommand();
	}
}
class SighCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeSighCommand();
	}
}
class CheerCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeCheerCommand();
	}
}
class BlushCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeBlushCommand();
	}
}
class NodCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeNodCommand();
	}
}
class OpenCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeOpenCommand(obj);
	}
}
class ShudderCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeShudderCommand();
	}
}
class PonderCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executePonderCommand();
	}
}
class TalkCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeTalkCommand();
	}
}
class ListenCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeListenCommand();
	}
}
class HoldCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeHoldCommand(obj);
	}
}
class LiberateCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeLiberateCommand(obj);
	}
}
class KillCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
		game.executeKillCommand(obj);
	}
}
class CutCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
//		game.executeKillCommand(obj);
	}
}

class SwimCommand extends AdvCommand {
	public void execute(Adventure game, AdvObject obj) {
//		game.executeSwimCommand();
	}
}

