/*
 * Decompiled with CFR 0.152.
 */
import acm.program.ConsoleProgram;
import acm.util.ErrorException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class AdventureStub
extends ConsoleProgram {
    private static final int INITIAL_ROOM_COUNT = 100;
    private HashMap commandTable;
    private HashMap objectTable;
    private AdvRoom[] rooms;
    private ArrayList inventory;
    private int roomNumber;
    private AdvRoom room;

    public static void main(String[] args) {
        new AdventureStub().start(args);
    }

    public void run() {
        this.println("Welcome to Adventure!");
        this.commandTable = new HashMap();
        this.objectTable = new HashMap();
        this.rooms = new AdvRoom[100];
        this.defineActionCommands();
        String name = this.readLine("Enter the name of the adventure: ");
        this.readDataFiles(name);
        this.play();
    }

    public void executeQuitCommand() {
        while (true) {
            String response;
            if ((response = this.readLine("Are you sure you want to quit now? ")).equalsIgnoreCase("yes")) {
                this.roomNumber = 0;
                this.inventory = null;
                break;
            }
            if (response.equalsIgnoreCase("no")) break;
            this.println("Please answer \"yes\" or \"no\".");
        }
    }

    public void executeHelpCommand() {
        this.println("Welcome to Adventure!");
        this.println("Somewhere nearby is Colossal Cave, where others have found fortunes in");
        this.println("treasure and gold, though it is rumored that some who enter are never");
        this.println("seen again.  Magic is said to work in the cave.  I will be your eyes");
        this.println("and hands.  Direct me with natural English commands; I don't understand");
        this.println("all of the English language, but I do a pretty good job.");
        this.println();
        this.println("It's important to remember that cave passages turn a lot, and that");
        this.println("leaving a room to the north does not guarantee entering the next from");
        this.println("the south, although it often works out that way.  You'd best make yourself");
        this.println("a map as you go along.");
        this.println();
        this.println("Much of my vocabulary describes places and is used to move you there.");
        this.println("To move, try words like IN, OUT, EAST, WEST, NORTH, SOUTH, UP, or DOWN.");
        this.println("I also know about a number of objects hidden within the cave which you");
        this.println("can TAKE or DROP.  To see what objects you're carrying, say INVENTORY.");
        this.println("To reprint the detailed description of where you are, say LOOK.  If you");
        this.println("want to end your adventure, say QUIT.");
    }

    public void executeLookCommand() {
        String[] description = this.room.getDescription();
        int i = 0;
        while (i < description.length) {
            this.println(description[i]);
            ++i;
        }
        i = 0;
        while (i < this.room.getObjectCount()) {
            AdvObject obj = this.room.getObject(i);
            this.println("There is " + obj.getDescription() + " here.");
            ++i;
        }
    }

    public void executeInventoryCommand() {
        if (this.inventory.size() == 0) {
            this.println("You are empty-handed.");
        } else {
            this.println("You are carrying:");
            int i = 0;
            while (i < this.inventory.size()) {
                AdvObject obj = (AdvObject)this.inventory.get(i);
                this.println("  " + obj.getDescription());
                ++i;
            }
        }
    }

    public void executeTakeCommand(AdvObject obj) {
        if (this.room.containsObject(obj)) {
            this.room.removeObject(obj);
            this.inventory.add(obj);
            this.println("Taken.");
        } else {
            this.println("I don't see that here.");
        }
    }

    public void executeDropCommand(AdvObject obj) {
        if (this.inventory.contains(obj)) {
            this.inventory.remove(obj);
            this.room.addObject(obj);
            this.println("Dropped.");
        } else {
            this.println("You're not carrying that.");
        }
    }

    public void executeMotionCommand(String direction) {
        int newRoom = this.tryToMove(direction);
        if (newRoom == -1) {
            this.println("There is no way to go in that direction");
        } else {
            this.roomNumber = newRoom;
        }
    }

    private void play() {
        this.inventory = new ArrayList();
        this.roomNumber = 1;
        int lastRoomNumber = 0;
        while (this.roomNumber != 0) {
            int forcedRoom;
            this.room = this.rooms[this.roomNumber];
            if (lastRoomNumber != this.roomNumber) {
                if (this.room.hasBeenVisited()) {
                    this.println(this.room.getName());
                    int i = 0;
                    while (i < this.room.getObjectCount()) {
                        AdvObject obj = this.room.getObject(i);
                        this.println("There is " + obj.getDescription() + " here.");
                        ++i;
                    }
                } else {
                    this.executeLookCommand();
                }
                lastRoomNumber = 0;
                lastRoomNumber = this.roomNumber;
            }
            if ((forcedRoom = this.tryToMove("FORCED")) == -1) {
                this.room.setVisited(true);
                this.executeCommand(this.readLine("> "));
                continue;
            }
            this.roomNumber = forcedRoom;
        }
    }

    private void executeCommand(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        String token = tokenizer.nextToken();
        AdvCommand command = (AdvCommand)this.commandTable.get(token.toUpperCase());
        if (command == null) {
            if (this.objectTable.get(token.toUpperCase()) == null) {
                this.println("I don't understand the word \"" + token + "\".");
            } else {
                this.println("You need a verb to go with the object.");
            }
        } else {
            AdvObject obj = null;
            if (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                obj = (AdvObject)this.objectTable.get(token.toUpperCase());
            }
            command.execute((Adventure)this, obj);
        }
    }

    private void defineActionCommands() {
        this.commandTable.put("QUIT", AdvCommand.QUIT);
        this.commandTable.put("LOOK", AdvCommand.LOOK);
        this.commandTable.put("INVENTORY", AdvCommand.INVENTORY);
        this.commandTable.put("TAKE", AdvCommand.TAKE);
        this.commandTable.put("DROP", AdvCommand.DROP);
    }

    private int tryToMove(String direction) {
        AdvMotionTableEntry[] motionTable = this.room.getMotionTable();
        int i = 0;
        while (i < motionTable.length) {
            AdvMotionTableEntry entry = motionTable[i];
            if (direction.equals(entry.getDirection())) {
                AdvObject key = null;
                String keyName = entry.getKeyName();
                if (keyName != null && (key = (AdvObject)this.objectTable.get(keyName)) == null) {
                    throw new ErrorException(String.valueOf(keyName) + " does not correspond to an object");
                }
                if (key == null || this.inventory.contains(key)) {
                    return entry.getDestinationRoom();
                }
            }
            ++i;
        }
        return -1;
    }

    private void readDataFiles(String prefix) {
        this.readRoomFile(String.valueOf(prefix) + "-rooms.txt");
        this.readObjectFile(String.valueOf(prefix) + "-objects.txt");
        this.readSynonymFile(String.valueOf(prefix) + "-synonyms.txt");
    }

    private void readRoomFile(String filename) {
        try {
            AdvRoom rm;
            BufferedReader rd = new BufferedReader(new FileReader(filename));
            while ((rm = new AdvRoom()).readFromFile(rd)) {
                this.defineMotionCommands(rm.getMotionTable());
                int index = rm.getRoomNumber();
                if (index >= this.rooms.length) {
                    throw new ErrorException("For now");
                }
                this.rooms[index] = rm;
            }
            rd.close();
        }
        catch (FileNotFoundException ex) {
            throw new ErrorException("Can't read the " + filename + " data file.");
        }
        catch (IOException ex) {
            throw new ErrorException((Exception)ex);
        }
    }

    private void defineMotionCommands(AdvMotionTableEntry[] motionTable) {
        int i = 0;
        while (i < motionTable.length) {
            AdvMotionTableEntry entry = motionTable[i];
            String direction = entry.getDirection();
            AdvMotionCommand command = (AdvMotionCommand)this.commandTable.get(direction);
            if (command == null) {
                this.commandTable.put(direction, new AdvMotionCommand(direction));
            }
            ++i;
        }
    }

    private void readObjectFile(String filename) {
        try {
            AdvObject obj;
            BufferedReader rd = new BufferedReader(new FileReader(filename));
            while ((obj = new AdvObject()).readFromFile(rd)) {
                this.objectTable.put(obj.getName(), obj);
                int location = obj.getInitialLocation();
                if (location == 0) {
                    this.inventory.add(obj);
                    continue;
                }
                this.rooms[location].addObject(obj);
            }
            rd.close();
        }
        catch (FileNotFoundException rd) {
        }
        catch (IOException ex) {
            throw new ErrorException((Exception)ex);
        }
    }

    private void readSynonymFile(String filename) {
        try {
            String line;
            BufferedReader rd = new BufferedReader(new FileReader(filename));
            while ((line = rd.readLine()) != null) {
                if (line.length() <= 0) continue;
                int equalSign = line.indexOf(61);
                if (equalSign == -1) {
                    throw new ErrorException("Missing = in \"" + line + "\"");
                }
                String synonym = line.substring(0, equalSign).trim().toUpperCase();
                String original = line.substring(equalSign + 1).trim().toUpperCase();
                this.defineSynonym(synonym, original);
            }
            rd.close();
        }
        catch (FileNotFoundException rd) {
        }
        catch (IOException ex) {
            throw new ErrorException((Exception)ex);
        }
    }

    private void defineSynonym(String synonym, String original) {
        Object definition = this.commandTable.get(original);
        if (definition != null) {
            this.commandTable.put(synonym, definition);
        }
        if ((definition = this.objectTable.get(original)) != null) {
            this.objectTable.put(synonym, definition);
        }
    }
}

