/*
 * Decompiled with CFR 0.152.
 */
package jurt;

import java.text.BreakIterator;
import java.util.Hashtable;
import java.util.Vector;
import jurt.Refusal;

public class Command {
    public static Hashtable PRONOUNS = new Hashtable();
    Vector vector;
    int index;
    int errx;
    String errmsg;

    public Command(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '.') {
                stringBuffer.insert(n, ' ');
                stringBuffer.insert(n + 2, ' ');
                n += 2;
            }
            ++n;
        }
        string = stringBuffer.toString();
        this.vector = new Vector();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.first();
        int n3 = breakIterator.next();
        while (n3 >= 0) {
            String string2 = string.substring(n2, n3);
            if (!Character.isWhitespace(string2.charAt(0))) {
                this.vector.addElement(string2);
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
    }

    public boolean hasMoreWords() {
        return this.index < this.vector.size();
    }

    public String getNextWord() {
        return (String)this.vector.elementAt(this.index++);
    }

    public void setMark(int n) {
        this.index = n;
    }

    public void moveMark(int n) {
        this.index += n;
    }

    public int getMark() {
        return this.index;
    }

    public String getWordAt(int n) {
        return (String)this.vector.elementAt(n);
    }

    public void clearError() {
        this.errx = -1;
        this.errmsg = null;
    }

    public void error(int n, String string) {
        if (n > this.errx) {
            this.errx = n;
            this.errmsg = string;
        }
    }

    public String getErrorMsg() {
        return this.errmsg;
    }

    public String toString() {
        return this.vector.toString();
    }

    public String parseEverything() throws Refusal {
        String string;
        if (this.hasMoreWords() && ((string = this.getNextWord()).equalsIgnoreCase("everything") || string.equalsIgnoreCase("all"))) {
            return string;
        }
        throw new Refusal();
    }

    public void parseWord(String string) throws Refusal {
        String string2;
        if (this.hasMoreWords() && (string2 = this.getNextWord()).equalsIgnoreCase(string)) {
            return;
        }
        throw new Refusal();
    }

    public void parseFactorSep() throws Refusal {
        if (this.hasMoreWords()) {
            String string = this.getNextWord();
            if (string.equalsIgnoreCase(",")) {
                if (this.hasMoreWords()) {
                    string = this.getNextWord();
                    if (string.equalsIgnoreCase("and")) {
                        return;
                    }
                    this.moveMark(-1);
                }
                return;
            }
            if (string.equalsIgnoreCase("and")) {
                return;
            }
        }
        throw new Refusal();
    }

    public void parseSentenceSep() throws Refusal {
        if (!this.hasMoreWords()) {
            return;
        }
        String string = this.getNextWord();
        if (string.equalsIgnoreCase(",") ? this.hasMoreWords() && (string = this.getNextWord()).equalsIgnoreCase("then") : string.equalsIgnoreCase(".") || string.equalsIgnoreCase("then")) {
            return;
        }
        throw new Refusal();
    }

    public void parseExcept() throws Refusal {
        if (this.hasMoreWords()) {
            String string = this.getNextWord();
            if (string.equals(",")) {
                string = null;
                if (this.hasMoreWords()) {
                    string = this.getNextWord();
                }
            }
            if (string != null) {
                if (string.equals("except")) {
                    return;
                }
                if (string.equals("but")) {
                    if (this.hasMoreWords()) {
                        string = this.getNextWord();
                        if (string.equals("not")) {
                            return;
                        }
                        --this.index;
                    }
                    return;
                }
            }
        }
        throw new Refusal();
    }

    public boolean parseYesNo() throws Refusal {
        if (this.hasMoreWords()) {
            String string = this.getNextWord();
            if (string.equals("yes") || string.equals("y")) {
                return true;
            }
            if (string.equals("no") || string.equals("n")) {
                return false;
            }
        }
        throw new Refusal();
    }

    public String parsePronoun() throws Refusal {
        String string;
        if (this.hasMoreWords() && PRONOUNS.containsKey(string = this.getNextWord())) {
            return (String)PRONOUNS.get(string);
        }
        throw new Refusal();
    }

    static {
        PRONOUNS.put("it", "it");
        PRONOUNS.put("them", "them");
        PRONOUNS.put("those", "them");
        PRONOUNS.put("those", "them");
        PRONOUNS.put("he", "him");
        PRONOUNS.put("him", "him");
        PRONOUNS.put("her", "her");
        PRONOUNS.put("she", "her");
    }
}

